/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.AbstractFileFilter;
import com.isti.util.ExtensionFileFilter;
import com.isti.util.PrefixFileFilter;
import com.isti.util.SpecificFileFilter;
import com.isti.util.WildcardFilter;
import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.Vector;

public class IstiFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    protected static final boolean DEBUG_FLAG = false;
    private final Vector filterList = new Vector();
    private String description = null;
    private String fullDescription = null;
    private boolean acceptDirctoriesFlag = true;
    private boolean useFiltersInDescription = true;
    protected static final String WC_STRING = "*";

    public IstiFileFilter() {
    }

    public IstiFileFilter(String filter) {
        this();
        if (filter != null) {
            this.addFilter(filter);
        }
        this.setAcceptDirctories(false);
    }

    public IstiFileFilter(String filter, String description) {
        this();
        if (filter != null) {
            this.addFilter(filter);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public IstiFileFilter(String[] filters, String description) {
        this();
        int i = 0;
        while (i < filters.length) {
            this.addFilter(filters[i]);
            ++i;
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean isAcceptingDirectories() {
        return this.acceptDirctoriesFlag;
    }

    public void setAcceptDirctories(boolean b) {
        this.acceptDirctoriesFlag = b;
    }

    public boolean accept(File f) {
        if (f != null) {
            if (this.acceptDirctoriesFlag && f.isDirectory()) {
                return true;
            }
            if (f != null) {
                String filename = f.getName();
                Iterator filters = this.filterList.iterator();
                while (filters.hasNext()) {
                    FileFilter filter = (FileFilter)filters.next();
                    if (!filter.accept(f)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            return s.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public static String getPrefix(String s) {
        int i = s.indexOf(46);
        if (i > 0 && i < s.length() - 1) {
            return s.substring(0, i).toLowerCase();
        }
        return null;
    }

    public void addFilter(String filter) {
        this.filterList.add(IstiFileFilter.createFileFilter(filter));
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isFilterListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Iterator filters = this.filterList.iterator();
                if (filters != null) {
                    FileFilter filter = (FileFilter)filters.next();
                    this.fullDescription = this.fullDescription + filter.toString();
                    while (filters.hasNext()) {
                        filter = (FileFilter)filters.next();
                        this.fullDescription = this.fullDescription + ", " + filter.toString();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setFilterListInDescription(boolean b) {
        this.useFiltersInDescription = b;
        this.fullDescription = null;
    }

    public boolean isFilterListInDescription() {
        return this.useFiltersInDescription;
    }

    protected static boolean hasWildcards(String filter) {
        int wc1 = filter.indexOf(WC_STRING);
        return wc1 >= 0;
    }

    protected static boolean hasMultipleWildcards(String filter) {
        int wc2;
        int wc1 = filter.indexOf(WC_STRING);
        return wc1 >= 0 && (wc2 = filter.lastIndexOf(WC_STRING)) >= 0 && wc2 != wc1;
    }

    public static FileFilter createFileFilter(String filter) {
        AbstractFileFilter fileFilter = IstiFileFilter.hasWildcards(filter = filter.toLowerCase()) ? (IstiFileFilter.hasMultipleWildcards(filter) ? new WildcardFilter(filter) : (filter.endsWith(".*") ? new PrefixFileFilter(filter) : (filter.startsWith("*.") ? new ExtensionFileFilter(filter) : new WildcardFilter(filter)))) : new SpecificFileFilter(filter);
        return fileFilter;
    }
}

