/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.IstiEpochConverter;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class IstiEpoch
implements Comparator {
    IstiEpochConverter converter = null;
    long SecsSince1970 = 0L;
    int milliSinceSec = 0;
    static String[] formatType = new String[20];
    public static final String epochFormat = "Epoch";
    public static final String defaultFormat = "AllTime";
    public static final String defaultBottomFormat = "Min:Sec.Msec";
    public static final int None = 0;
    public static final int AllTime = 1;
    public static final int YearDayHrMinSec = 2;
    public static final int YearDayHrMin = 3;
    public static final int YearDayHr = 4;
    public static final int YearDay = 5;
    public static final int DayHrMinSecMsec = 6;
    public static final int DayHrMinSec = 7;
    public static final int DayHrMin = 8;
    public static final int DayHr = 9;
    public static final int Day = 10;
    public static final int HrMinSecMSec = 11;
    public static final int HrMinSec = 12;
    public static final int HrMin = 13;
    public static final int MinSecMsec = 14;
    public static final int MinSec = 15;
    public static final int Min = 16;
    public static final int SecMsec = 17;
    public static final int Msec = 18;
    public static final int Epoch = 19;
    String[] monthNames = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

    public IstiEpoch() {
        this.init();
        this.setTime(0.0);
    }

    public IstiEpoch(double tmpDoub) {
        this.init();
        this.setTime(tmpDoub);
    }

    public IstiEpoch(IstiEpoch tmpIstiEpoch) {
        this.init();
        if (tmpIstiEpoch != null) {
            this.setTime(tmpIstiEpoch.getEpoch());
        }
    }

    public IstiEpoch(GregorianCalendar gc) {
        this.init();
        if (gc != null) {
            this.setTime(gc.getTime());
        }
    }

    public IstiEpoch(long tmpTime) {
        this.init();
        this.SecsSince1970 = tmpTime / 1000L;
        this.milliSinceSec = (int)tmpTime % 1000;
    }

    public IstiEpoch(long Sec, long milli) {
        this.init();
        this.SecsSince1970 = Sec;
        this.milliSinceSec = (int)milli;
    }

    public GregorianCalendar getGregorianCalendar() {
        GregorianCalendar tmpGC = new GregorianCalendar();
        tmpGC.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date date = new Date(this.SecsSince1970 * 1000L + (long)this.milliSinceSec);
        tmpGC.setTime(date);
        return tmpGC;
    }

    public void settoCurrentTime() {
        Date trialTime = new Date();
        this.setTime(trialTime);
    }

    public void setTimetoDay() {
        int year = this.getIntYear();
        int mon = this.getIntMonth();
        int day = this.getmDay();
        this.setTime(0.0);
        this.setYear(year);
        this.setMonth(mon);
        this.setmDay(day);
    }

    public void setTimetoDay(IstiEpoch tmpTime) {
        int year = tmpTime.getIntYear();
        int mon = tmpTime.getIntMonth();
        int day = tmpTime.getmDay();
        this.setTime(0.0);
        this.setYear(year);
        this.setMonth(mon);
        this.setmDay(day);
    }

    private void init() {
        this.converter = IstiEpochConverter.getInstance();
        int i = 0;
        IstiEpoch.formatType[i++] = "None";
        IstiEpoch.formatType[i++] = defaultFormat;
        IstiEpoch.formatType[i++] = "Year:Day:Hr:Min:Sec";
        IstiEpoch.formatType[i++] = "Year:Day:Hr:Min";
        IstiEpoch.formatType[i++] = "Year:Day:Hr";
        IstiEpoch.formatType[i++] = "Year:Day";
        IstiEpoch.formatType[i++] = "Day:Hr:Min:Sec.Msec";
        IstiEpoch.formatType[i++] = "Day:Hr:Min:Sec";
        IstiEpoch.formatType[i++] = "Day:Hr:Min";
        IstiEpoch.formatType[i++] = "Day:Hr:";
        IstiEpoch.formatType[i++] = "Day";
        IstiEpoch.formatType[i++] = "Hr:Min:Sec.MSec";
        IstiEpoch.formatType[i++] = "Hr:Min:Sec";
        IstiEpoch.formatType[i++] = "Hr:Min";
        IstiEpoch.formatType[i++] = defaultBottomFormat;
        IstiEpoch.formatType[i++] = "Min:Sec";
        IstiEpoch.formatType[i++] = "Min";
        IstiEpoch.formatType[i++] = "Sec.Msec";
        IstiEpoch.formatType[i++] = "Msec";
        IstiEpoch.formatType[i++] = epochFormat;
    }

    public void setTime(Date date) {
        long secs = date.getTime();
        this.SecsSince1970 = secs / 1000L;
        this.milliSinceSec = (int)(secs % 1000L);
    }

    public void setTime(long secs) {
        this.SecsSince1970 = secs / 1000L;
        this.milliSinceSec = (int)(secs % 1000L);
    }

    public void setTime(double dsecs) {
        this.SecsSince1970 = (long)dsecs;
        this.milliSinceSec = (int)((long)(dsecs * 1000.0) % 1000L);
    }

    public void setIntTime(double dsecs) {
        long secs = (long)dsecs * 1000L;
        this.SecsSince1970 = (long)dsecs;
        this.milliSinceSec = (int)(secs % 1000L);
    }

    public void setIntTime(int secs) {
        this.SecsSince1970 = secs;
        this.milliSinceSec = 0;
    }

    public void setTime(int secs) {
        this.SecsSince1970 = (long)secs / 1000L;
        this.milliSinceSec = secs % 1000;
    }

    public void setTime(IstiEpoch newTime) {
        double tmpDoub = newTime.getEpoch();
        this.setTime(tmpDoub);
    }

    public void add(double secs) {
        double curTime = this.getEpoch();
        this.setTime(curTime += secs);
    }

    public void minus(double secs) {
        double curTime = this.getEpoch();
        this.setTime(curTime -= secs);
    }

    public double diff(IstiEpoch newEpoch) {
        double thisTime = this.getEpoch();
        double newTime = newEpoch.getEpoch();
        return thisTime - newTime;
    }

    public int compare(Object o1, Object o2) {
        IstiEpoch first = null;
        IstiEpoch second = null;
        try {
            first = (IstiEpoch)o1;
            second = (IstiEpoch)o2;
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            return 0;
        }
        if (first.equals(second)) {
            return 0;
        }
        if (first.isBefore(second)) {
            return -1;
        }
        if (first.isAfter(second)) {
            return 1;
        }
        return 0;
    }

    public double absDiff(IstiEpoch newEpoch) {
        double newTime;
        double thisTime = this.getEpoch();
        if (thisTime > (newTime = newEpoch.getEpoch())) {
            return thisTime - newTime;
        }
        return newTime - thisTime;
    }

    public boolean inTimeRange(IstiEpoch start, IstiEpoch end) {
        double stime = start.getEpoch();
        double etime = end.getEpoch();
        double thistime = this.getEpoch();
        return thistime >= stime && thistime <= etime;
    }

    public boolean isBefore(IstiEpoch refTime) {
        double rtime = refTime.getEpoch();
        double thistime = this.getEpoch();
        return thistime < rtime;
    }

    public boolean isBeforeEqual(IstiEpoch refTime) {
        double rtime = refTime.getEpoch();
        double thistime = this.getEpoch();
        return thistime <= rtime;
    }

    public boolean isAfter(IstiEpoch refTime) {
        double rtime = refTime.getEpoch();
        double thistime = this.getEpoch();
        return thistime > rtime;
    }

    public boolean isEqualTo(IstiEpoch refTime) {
        double rtime = refTime.getEpoch();
        double thistime = this.getEpoch();
        return thistime == rtime;
    }

    public boolean isBeforeNotEqual(IstiEpoch refTime) {
        double rtime = refTime.getEpoch();
        double thistime = this.getEpoch();
        return thistime < rtime;
    }

    public boolean isAfterNotEqual(IstiEpoch refTime) {
        double rtime = refTime.getEpoch();
        double thistime = this.getEpoch();
        return thistime > rtime;
    }

    public boolean isAfterEqual(IstiEpoch refTime) {
        double rtime = refTime.getEpoch();
        double thistime = this.getEpoch();
        return thistime >= rtime;
    }

    public double getEpoch() {
        double ret = this.SecsSince1970;
        return ret += (double)this.milliSinceSec / 1000.0;
    }

    public int getIntEpoch() {
        return (int)this.SecsSince1970;
    }

    public long getIntEpochMSecs() {
        return this.SecsSince1970 * 1000L + (long)this.milliSinceSec;
    }

    public String toString() {
        String tstr = this.longformattedString();
        String extra = Double.toString(this.getEpoch());
        tstr.concat(" - " + extra);
        return tstr;
    }

    public static String toString(double tmpdouble) {
        IstiEpoch tmpE = new IstiEpoch(tmpdouble);
        String tstr = tmpE.longformattedString();
        return tstr;
    }

    public String toWaveviewerRequestString() {
        double tDoub = this.getEpoch();
        Double Doub = new Double(tDoub);
        DecimalFormat dForm = new DecimalFormat();
        dForm.setMinimumIntegerDigits(5);
        dForm.setMaximumIntegerDigits(10);
        dForm.setMaximumFractionDigits(4);
        dForm.setMinimumFractionDigits(3);
        dForm.setGroupingUsed(false);
        String tmp = dForm.format(tDoub);
        return tmp;
    }

    public String hrminsecString() {
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = hr;
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        return retStr;
    }

    public String hrminsecmsString() {
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String msec = this.getMSecond();
        String retStr = hr;
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        retStr = retStr.concat(":");
        retStr = retStr.concat(msec);
        return retStr;
    }

    public String minsecString() {
        String mn = this.getMn();
        String sec = this.getSecond();
        String msec = this.getMSecond();
        String retStr = mn;
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        if (msec == "") {
            return retStr;
        }
        retStr = retStr.concat(".");
        retStr = retStr.concat(msec);
        return retStr;
    }

    public String secString() {
        String sec = this.getSecond();
        String msec = this.getMSecond();
        String retStr = sec;
        if (msec == "") {
            return retStr;
        }
        retStr = retStr.concat(".");
        retStr = retStr.concat(msec);
        return retStr;
    }

    public String yeardayString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String retStr = year;
        retStr = retStr.concat(":");
        retStr = retStr.concat(jday);
        return retStr;
    }

    public String yearmondayString() {
        String year = this.getYear();
        String mon = this.getMonStr();
        String mday = this.getMDay();
        String retStr = year;
        retStr = retStr.concat(" ");
        retStr = retStr.concat(mon);
        retStr = retStr.concat(" ");
        retStr = retStr.concat(mday);
        return retStr;
    }

    public String yearmondayhrminString() {
        String year = this.getYear();
        String mon = this.getMonStr();
        String mday = this.getMDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String retStr = year;
        retStr = retStr.concat(" ");
        retStr = retStr.concat(mon);
        retStr = retStr.concat(" ");
        retStr = retStr.concat(mday);
        retStr = retStr.concat(" ");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        return retStr;
    }

    public String formattedString(String name) {
        int i = 0;
        while (i < formatType.length) {
            if (name.compareTo(formatType[i]) == 0) {
                return this.formattedString(i);
            }
            ++i;
        }
        return "";
    }

    public static String[] getFormattedStrings() {
        return formatType;
    }

    public String formattedString(int type) {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String msec = this.getMSecond();
        String retStr = "";
        switch (type) {
            case 1: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 2: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                break;
            }
            case 5: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                break;
            }
            case 4: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                break;
            }
            case 3: {
                retStr = year;
                retStr = retStr.concat(":");
                retStr = retStr.concat(jday);
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                break;
            }
            case 13: {
                retStr = hr;
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                break;
            }
            case 12: {
                retStr = hr;
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                break;
            }
            case 11: {
                retStr = hr;
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 15: {
                retStr = mn;
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                break;
            }
            case 16: {
                retStr = mn;
                break;
            }
            case 14: {
                retStr = mn;
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 17: {
                retStr = sec;
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 18: {
                retStr = msec;
                break;
            }
            case 19: {
                retStr = Integer.toString(this.getIntEpoch());
                break;
            }
            case 6: {
                retStr = jday;
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                retStr = retStr.concat(".");
                retStr = retStr.concat(msec);
                break;
            }
            case 7: {
                retStr = jday;
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                retStr = retStr.concat(":");
                retStr = retStr.concat(sec);
                break;
            }
            case 8: {
                retStr = jday;
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                retStr = retStr.concat(":");
                retStr = retStr.concat(mn);
                break;
            }
            case 9: {
                retStr = jday;
                retStr = retStr.concat(":");
                retStr = retStr.concat(hr);
                break;
            }
            case 10: {
                retStr = jday;
                break;
            }
            case 0: {
                retStr = "";
                break;
            }
            default: {
                retStr = "";
            }
        }
        return retStr;
    }

    public String formattedString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        retStr = retStr.concat(":");
        retStr = retStr.concat(jday);
        retStr = retStr.concat(":");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        return retStr;
    }

    public String btimeFormattedString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        retStr = retStr.concat(",");
        retStr = retStr.concat(jday);
        retStr = retStr.concat(",");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        retStr = retStr.concat(".");
        retStr = retStr.concat(this.getTenthsMillisecond());
        return retStr;
    }

    public String longformattedString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        retStr = retStr.concat(":");
        retStr = retStr.concat(jday);
        retStr = retStr.concat(":");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(":");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(":");
        retStr = retStr.concat(sec);
        retStr = retStr.concat(".");
        retStr = retStr.concat(this.getMSecond());
        return retStr;
    }

    public String labelformattedString() {
        String retStr = this.yearmondayString();
        return retStr;
    }

    public String fileFormattedString() {
        String year = this.getYear();
        String jday = this.getJDay();
        String hr = this.getHr();
        String mn = this.getMn();
        String sec = this.getSecond();
        String retStr = year;
        retStr = retStr.concat(".");
        retStr = retStr.concat(jday);
        retStr = retStr.concat(".");
        retStr = retStr.concat(hr);
        retStr = retStr.concat(".");
        retStr = retStr.concat(mn);
        retStr = retStr.concat(".");
        retStr = retStr.concat(sec);
        return retStr;
    }

    public void setTime(int year, int jday, int hr, int min, int sec) {
        this.setYear(year);
        this.setJDay(jday);
        this.setHr(hr);
        this.setMn(min);
        this.setSec(sec);
    }

    public int getIntYear() {
        return this.get(1);
    }

    public int get(int calVal) {
        return this.converter.get(this, calVal);
    }

    private void setCalendarToMyTime() {
        this.converter.setTime(this);
    }

    public Date getTime() {
        return this.converter.getTime(this);
    }

    public int getIntMonth() {
        return this.get(2);
    }

    public int getIntDOY() {
        return this.get(6);
    }

    public int getIntDOM() {
        return this.get(5);
    }

    public int getIntInt(int calendarStatic) {
        return this.get(calendarStatic);
    }

    public int getmDay() {
        return this.get(5);
    }

    public void setYear(int year) {
        this.converter.set(this, 1, year);
    }

    public void setMonth(int month) {
        this.converter.set(this, 2, month);
    }

    public void setmDay(int day) {
        this.converter.set(this, 5, day);
    }

    public void setJDay(int doy) {
        this.converter.set(this, 6, doy);
    }

    public void setHr(int hour) {
        this.converter.set(this, 11, hour);
    }

    public void setMn(int min) {
        this.converter.set(this, 12, min);
    }

    public void setSec(int sec) {
        this.setSecond(sec);
    }

    public void setSecond(int sec) {
        this.converter.set(this, 13, sec);
    }

    public void set(int year, int month, int day, int hr, int min) {
        this.setYear(year);
        this.setMonth(month);
        this.setmDay(day);
        this.setHr(hr);
        this.setMn(min);
    }

    public void setMSecond(int milli) {
        this.converter.set(this, 14, milli);
    }

    public String getYear() {
        int year = this.getIntYear();
        return Integer.toString(year);
    }

    public String getMonStr() {
        int day = this.getIntMonth();
        return this.monthNames[day];
    }

    public String getMDay() {
        String retStr = Integer.toString(this.getIntMonth());
        return this.formatInt(retStr, 2);
    }

    public String getJDay() {
        String retStr = Integer.toString(this.getIntDOY());
        return this.formatInt(retStr, 3);
    }

    public String getHr() {
        String hrStr = Integer.toString(this.getIntInt(11));
        return this.formatInt(hrStr, 2);
    }

    public String getMn() {
        String minStr = Integer.toString(this.getIntInt(12));
        return this.formatInt(minStr, 2);
    }

    public String getSecond() {
        String retStr = Integer.toString(this.getIntInt(13));
        return this.formatInt(retStr, 2);
    }

    public String getMsecond(int places) {
        String retStr = null;
        if (this.milliSinceSec == 0) {
            return "0000";
        }
        retStr = Long.toString(this.milliSinceSec);
        String rv = this.formatInt(retStr, places);
        while (retStr.endsWith("0")) {
            retStr = retStr.substring(0, retStr.length() - 1);
        }
        return rv;
    }

    public String getTenthsMillisecond() {
        String retStr = null;
        int sec = this.milliSinceSec;
        int msecs = sec % 1000;
        if (sec % 1000 == 0) {
            return "0000";
        }
        retStr = Integer.toString(sec);
        String rv = this.formatInt(retStr, 3);
        rv = new String(rv + "0");
        return rv;
    }

    public String getMSecond() {
        return this.getMsecond(3);
    }

    public boolean isEvenMinute() {
        int sec = this.getIntInt(13);
        return sec == 0;
    }

    public String formatInt(String item, int places) {
        String retString = new String(item);
        if (item.length() >= places) {
            return retString;
        }
        int needed = places - item.length();
        retString = "";
        int i = 0;
        while (i < needed) {
            retString = retString.concat("0");
            ++i;
        }
        retString = retString.concat(item);
        return retString;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone("UTC");
    }

    public void clear() {
        this.SecsSince1970 = 0L;
        this.milliSinceSec = 0;
    }
}

