/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import com.isti.util.ArchiveManager;
import com.isti.util.FileUtils;
import com.isti.util.IstiFileFilter;
import com.isti.util.UtilFns;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class FlatDailyArchiveManager
extends ArchiveManager {
    public static final String DEF_DATE_FORMAT_STR = "yyyyMMdd";
    public static final DateFormat DEF_DATE_FORMAT_OBJ = UtilFns.createDateFormatObj("yyyyMMdd", UtilFns.GMT_TIME_ZONE_OBJ);
    public static final String DEF_FNAME_DATE_SEPSTR = "_";
    protected DateFormat dateFormatObj = DEF_DATE_FORMAT_OBJ;
    protected boolean dateFormatChangedFlag = false;
    protected String fNameDateSepStr = "_";
    protected String archiveStmFileNameStr = null;
    protected SimpleDateFormat fnDateParserObj;

    public FlatDailyArchiveManager(Class classObj, String archiveRootDirName, String baseFileNameStr) throws NoSuchMethodException {
        super(classObj, archiveRootDirName, baseFileNameStr);
        this.setPurgeIntoArchiveFlag(false);
    }

    public FlatDailyArchiveManager(Class classObj, String baseFileNameStr) throws NoSuchMethodException {
        this(classObj, null, baseFileNameStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDateFormatObj(DateFormat dFormatObj) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.dateFormatObj = dFormatObj != null ? dFormatObj : DEF_DATE_FORMAT_OBJ;
            this.dateFormatChangedFlag = true;
        }
    }

    public DateFormat getDateFormatObj() {
        return this.dateFormatObj;
    }

    public void setDateFormatTimeZone(TimeZone timeZoneObj) {
        this.dateFormatObj.setTimeZone(timeZoneObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFNameDateSepStr(String sepStr) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.fNameDateSepStr = sepStr != null ? sepStr : DEF_FNAME_DATE_SEPSTR;
        }
    }

    public String getFNameDateSepStr() {
        return this.fNameDateSepStr;
    }

    protected String getArchiveFileNameForDate(Date dateObj) {
        return FileUtils.addStrToFileName(this.archiveFileNameStr, this.fNameDateSepStr + this.dateFormatObj.format(dateObj));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream getOutputStreamForItem(Archivable item) throws IOException {
        String fileNameStr = this.getArchiveFileNameForDate(item.getArchiveDate());
        Object object = this.archiveOutStmSyncObj;
        synchronized (object) {
            if (this.archiveOutStm != null) {
                if (this.archiveStmFileNameStr != null && this.archiveStmFileNameStr.equals(fileNameStr)) {
                    return this.archiveOutStm;
                }
                try {
                    this.archiveOutStm.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.archiveOutStm = null;
                this.archiveStmFileNameStr = null;
            }
            File fileObj = this.getArchiveFileForName(fileNameStr);
            this.archiveOutStm = new BufferedOutputStream(new FileOutputStream(fileObj.getPath(), true));
            this.archiveStmFileNameStr = fileNameStr;
            return this.archiveOutStm;
        }
    }

    protected Vector getArchiveFilesForDateRange(Date startDate, Date endDate) {
        Object[] fileArr = new File(this.archiveRootDirName != null ? this.archiveRootDirName : ".").listFiles(IstiFileFilter.createFileFilter(FileUtils.addStrToFileName(this.archiveFileNameStr, this.fNameDateSepStr + "*")));
        Arrays.sort(fileArr);
        DateFormat fnDateParser = this.getFileNameDateParserObj();
        long startDateMsVal = startDate != null ? startDate.getTime() : 0L;
        long endDateMsVal = endDate != null ? endDate.getTime() : 0L;
        Vector<Object> retVec = new Vector<Object>();
        int i = 0;
        while (i < fileArr.length) {
            long dateMsVal;
            Date dateObj;
            Object fileObj = fileArr[i];
            try {
                dateObj = fnDateParser.parse(((File)fileObj).getName());
                dateMsVal = dateObj.getTime();
            }
            catch (Exception ex) {
                dateObj = null;
                dateMsVal = 0L;
            }
            if (!(dateObj == null || startDate != null && dateMsVal + 86400000L <= startDateMsVal || endDate != null && dateMsVal > endDateMsVal)) {
                retVec.add(fileObj);
            }
            ++i;
        }
        return retVec;
    }

    public DateFormat getFileNameDateParserObj() {
        if (this.fnDateParserObj == null || this.dateFormatChangedFlag) {
            this.dateFormatChangedFlag = false;
            String qt = "'";
            Object obj = this.dateFormatObj.clone();
            if (obj instanceof SimpleDateFormat) {
                this.fnDateParserObj = (SimpleDateFormat)obj;
                this.fnDateParserObj.applyPattern(FileUtils.addStrToFileName("'" + this.archiveFileNameStr + "'", this.fNameDateSepStr + "'" + this.fnDateParserObj.toPattern() + "'"));
            } else {
                this.fnDateParserObj = new SimpleDateFormat(FileUtils.addStrToFileName("'" + this.archiveFileNameStr + "'", this.fNameDateSepStr + "'" + DEF_DATE_FORMAT_STR + "'"));
            }
            this.fnDateParserObj.setLenient(false);
        }
        return this.fnDateParserObj;
    }
}

