/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CallBackCompletion;
import com.isti.util.IstiFileFilter;
import com.isti.util.StreamTransferThread;
import com.isti.util.gui.IstiDialogPopup;
import com.isti.util.topleveldummy.TopLevelDummyUtil;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.jar.JarFile;

public class FileUtils {
    protected static final boolean DEBUG_FLAG = false;
    protected static Applet appletObj = null;
    protected static FileUtils fileUtilsObj = new FileUtils();
    protected static int STREAM_TRANSFER_BUFFER_SIZE = 2048;
    public static final long MS_PER_HOUR = 3600000L;
    public static final long MS_PER_DAY = 86400000L;

    private FileUtils() {
    }

    public static InputStream fileMultiOpenInputStream(String nameStr) {
        try {
            return new FileInputStream(nameStr);
        }
        catch (Exception ex) {
            InputStream stmObj;
            URL urlObj = null;
            try {
                urlObj = new URL(nameStr);
                stmObj = urlObj.openStream();
                if (stmObj != null) {
                    return stmObj;
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                stmObj = ClassLoader.getSystemResourceAsStream(nameStr);
                if (stmObj != null) {
                    return stmObj;
                }
            }
            catch (Exception ex3) {
                // empty catch block
            }
            urlObj = null;
            try {
                urlObj = ClassLoader.getSystemResource(nameStr);
                if (urlObj != null) {
                    File fileObj = new File(urlObj.getFile());
                    if (fileObj.exists()) {
                        return new FileInputStream(fileObj);
                    }
                    return urlObj.openConnection().getInputStream();
                }
            }
            catch (Exception ex4) {
                // empty catch block
            }
            try {
                int xPos = nameStr.indexOf(33);
                if (xPos > 0) {
                    int p = nameStr.indexOf(58);
                    p = p >= 0 && p < xPos ? ++p : 0;
                    JarFile jarFileObj = new JarFile(nameStr.substring(p, xPos));
                    return jarFileObj.getInputStream(jarFileObj.getJarEntry(nameStr.substring(xPos + 1)));
                }
            }
            catch (Exception ex5) {}
            return null;
        }
    }

    public static BufferedInputStream fileMultiOpenStream(String nameStr) {
        InputStream stmObj = FileUtils.fileMultiOpenInputStream(nameStr);
        return stmObj != null ? new BufferedInputStream(stmObj) : null;
    }

    public static BufferedReader fileMultiOpen(String nameStr) {
        InputStream stmObj = FileUtils.fileMultiOpenInputStream(nameStr);
        return stmObj != null ? new BufferedReader(new InputStreamReader(stmObj)) : null;
    }

    public static InputStream appletResourceOpenInputStream(Applet appletObj, String nameStr) {
        InputStream stmObj;
        try {
            URL[] codeBaseArr = new URL[]{appletObj.getCodeBase()};
            URLClassLoader loaderObj = URLClassLoader.newInstance(codeBaseArr);
            URL urlObj = loaderObj.getResource(nameStr);
            if (urlObj != null) {
                return urlObj.openConnection().getInputStream();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            stmObj = TopLevelDummyUtil.getTopLevelDummyClass().getResourceAsStream(nameStr);
            if (stmObj != null) {
                return stmObj;
            }
            stmObj = fileUtilsObj.getClass().getResourceAsStream(nameStr);
            if (stmObj != null) {
                return stmObj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        URL urlObj = null;
        try {
            urlObj = TopLevelDummyUtil.getTopLevelDummyClass().getResource(nameStr);
            if (urlObj != null || (urlObj = fileUtilsObj.getClass().getResource(nameStr)) != null) {
                File fileObj = new File(urlObj.getFile());
                if (fileObj.exists()) {
                    return new FileInputStream(fileObj);
                }
                return urlObj.openConnection().getInputStream();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            stmObj = ClassLoader.getSystemResourceAsStream(nameStr);
            if (stmObj != null) {
                return stmObj;
            }
        }
        catch (Exception ex) {}
        return null;
    }

    public static BufferedInputStream appletResourceOpenStream(Applet appletObj, String nameStr) {
        InputStream stmObj = FileUtils.appletResourceOpenInputStream(appletObj, nameStr);
        return stmObj != null ? new BufferedInputStream(stmObj) : null;
    }

    public static BufferedReader appletResourceOpen(Applet appletObj, String nameStr) {
        InputStream stmObj = FileUtils.appletResourceOpenInputStream(appletObj, nameStr);
        return stmObj != null ? new BufferedReader(new InputStreamReader(stmObj)) : null;
    }

    public static void setAppletObj(Applet appletObj) {
        FileUtils.appletObj = appletObj;
    }

    public static InputStream appResourceOpenInputStream(String nameStr) {
        return appletObj == null ? FileUtils.fileMultiOpenInputStream(nameStr) : FileUtils.appletResourceOpenInputStream(appletObj, nameStr);
    }

    public static BufferedInputStream appResourceOpenStream(String nameStr) {
        return appletObj == null ? FileUtils.fileMultiOpenStream(nameStr) : FileUtils.appletResourceOpenStream(appletObj, nameStr);
    }

    public static BufferedReader appResourceOpen(String nameStr) {
        InputStream stmObj = appletObj == null ? FileUtils.fileMultiOpenInputStream(nameStr) : FileUtils.appletResourceOpenInputStream(appletObj, nameStr);
        return stmObj != null ? new BufferedReader(new InputStreamReader(stmObj)) : null;
    }

    public static URL fileMultiOpenInputURL(String nameStr) {
        try {
            File fileObj = new File(nameStr);
            if (fileObj.isFile()) {
                return fileObj.toURL();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        URL urlObj = null;
        try {
            urlObj = new URL(nameStr);
            InputStream stmObj = urlObj.openStream();
            if (stmObj != null) {
                stmObj.close();
                return urlObj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            urlObj = ClassLoader.getSystemResource(nameStr);
            if (urlObj != null) {
                return urlObj;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            urlObj = TopLevelDummyUtil.getTopLevelDummyClass().getResource(nameStr);
            if (urlObj != null) {
                return urlObj;
            }
            urlObj = fileUtilsObj.getClass().getResource(nameStr);
            if (urlObj != null) {
                return urlObj;
            }
        }
        catch (Exception ex) {}
        return null;
    }

    public static void writeStringToFile(String fileNameStr, String dataStr, boolean appendFlag) throws IOException {
        FileWriter wtrObj = new FileWriter(fileNameStr, appendFlag);
        wtrObj.write(dataStr);
        wtrObj.close();
    }

    public static void writeStringToFile(String fileNameStr, String dataStr) throws IOException {
        FileUtils.writeStringToFile(fileNameStr, dataStr, false);
    }

    /*
     * WARNING - void declaration
     */
    public static String readStreamToString(BufferedReader rdrObj) throws IOException {
        String str;
        StringWriter strWtrObj = new StringWriter();
        PrintWriter prtWtrObj = new PrintWriter(strWtrObj);
        while ((str = rdrObj.readLine()) != null) {
            void var3_3;
            prtWtrObj.println((String)var3_3);
        }
        prtWtrObj.flush();
        return strWtrObj.toString();
    }

    public static String readFileToString(String fileNameStr) throws FileNotFoundException, IOException {
        BufferedReader rdrObj = new BufferedReader(new FileReader(fileNameStr));
        String retStr = FileUtils.readStreamToString(rdrObj);
        rdrObj.close();
        return retStr;
    }

    public static String readMultiOpenFileToString(String fileNameStr) throws FileNotFoundException, IOException {
        BufferedReader rdrObj = FileUtils.fileMultiOpen(fileNameStr);
        if (rdrObj == null) {
            throw new FileNotFoundException("Unable to open \"" + fileNameStr + "\" as file or URL");
        }
        String retStr = FileUtils.readStreamToString(rdrObj);
        rdrObj.close();
        return retStr;
    }

    public static boolean createParentDirs(File fileObj) {
        try {
            File parentFileObj;
            if (!fileObj.exists() && (parentFileObj = fileObj.getParentFile()) != null && !parentFileObj.isDirectory()) {
                return parentFileObj.mkdirs();
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean createParentDirs(String nameStr) {
        try {
            File parentFileObj;
            File fileObj = new File(nameStr);
            if (!fileObj.exists() && (parentFileObj = fileObj.getParentFile()) != null && !parentFileObj.isDirectory()) {
                return parentFileObj.mkdirs();
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static File[] listFiles(File directoryObj) {
        return directoryObj.listFiles();
    }

    public static File[] listFiles(File directoryObj, FileFilter filter) {
        return directoryObj.listFiles(filter);
    }

    public static long getFileAge(File f, long currentTime) {
        long fileTime = f.lastModified();
        long age = currentTime - fileTime;
        return age;
    }

    public static void deleteFiles(File[] fileList, int maxAge) {
        long currentTime = new Date().getTime();
        int i = 0;
        while (i < fileList.length) {
            long age = FileUtils.getFileAge(fileList[i], currentTime) / 86400000L;
            if (age > (long)maxAge) {
                fileList[i].delete();
            }
            ++i;
        }
    }

    public static void deleteOldFiles(File directoryObj, int maxAge, String filter) {
        if (maxAge > 0 && directoryObj.exists()) {
            File[] fileList = FileUtils.listFiles(directoryObj, IstiFileFilter.createFileFilter(filter));
            FileUtils.deleteFiles(fileList, maxAge);
        }
    }

    public static int getFileExtensionIndex(String fileNameStr) {
        return fileNameStr.lastIndexOf(46);
    }

    public static String getFileExtension(String fileNameStr) {
        int extIndex = fileNameStr.lastIndexOf(".");
        if (extIndex > 0 && extIndex < fileNameStr.length() - 1) {
            return fileNameStr.substring(extIndex + 1);
        }
        return null;
    }

    public static String getFileNameWithoutExtension(String fileNameStr) {
        int extIdx = FileUtils.getFileExtensionIndex(fileNameStr);
        if (extIdx >= 0) {
            fileNameStr = fileNameStr.substring(0, extIdx);
        }
        return fileNameStr;
    }

    public static String addStrToFileName(String fileNameStr, String s) {
        int extIndex = fileNameStr.lastIndexOf(".");
        fileNameStr = extIndex >= 0 ? fileNameStr.substring(0, extIndex) + s + fileNameStr.substring(extIndex, fileNameStr.length()) : fileNameStr + s;
        return fileNameStr;
    }

    public static String createBackupFileName(String fileNameStr) {
        return FileUtils.createBackupFileName(fileNameStr, null);
    }

    public static String createBackupFileName(String fileNameStr, String backupStr) {
        if (backupStr != null) {
            fileNameStr = FileUtils.addStrToFileName(fileNameStr, backupStr);
        }
        String lastNameStr = new File(fileNameStr).getName();
        lastNameStr = FileUtils.getFileNameWithoutExtension(lastNameStr).toLowerCase();
        String filterString = FileUtils.addStrToFileName(fileNameStr, "*");
        IstiFileFilter filter = new IstiFileFilter(filterString);
        File[] fileList = FileUtils.listFiles(new File(fileNameStr).getParentFile(), filter);
        int lastNameStrLength = lastNameStr.length();
        int maxBn = 0;
        int i = 0;
        while (i < fileList.length) {
            int bn;
            String fn = fileList[i].getName();
            int bnIdx = (fn = FileUtils.getFileNameWithoutExtension(fn)).toLowerCase().indexOf(lastNameStr);
            if (bnIdx >= 0 && (bn = new Integer(fn.substring(bnIdx += lastNameStrLength)).intValue()) > maxBn) {
                maxBn = bn;
            }
            ++i;
        }
        return FileUtils.addStrToFileName(fileNameStr, Integer.toString(++maxBn));
    }

    /*
     * WARNING - void declaration
     */
    public static void transferStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int b;
        byte[] buffer = new byte[STREAM_TRANSFER_BUFFER_SIZE];
        while ((b = inputStream.read(buffer, 0, STREAM_TRANSFER_BUFFER_SIZE)) >= 0) {
            void var2_3;
            outputStream.write(buffer, 0, (int)var2_3);
        }
    }

    public static void transferStream(InputStream inputStream, OutputStream outputStream, CallBackCompletion callBack) throws IOException {
        if (callBack == null) {
            FileUtils.transferStream(inputStream, outputStream);
        } else {
            new StreamTransferThread(inputStream, outputStream, callBack).start();
        }
    }

    public static void transferStream(InputStream inputStream, OutputStream outputStream, CallBackCompletion callBack, boolean showPopup) {
        block4: {
            IstiDialogPopup popupObj = showPopup ? new IstiDialogPopup(null, (Object)"Downloading ShakeMap data...", "Downloading", -1, "Close", false) : null;
            try {
                if (popupObj != null) {
                    popupObj.show();
                }
                FileUtils.transferStream(inputStream, outputStream, callBack);
                if (popupObj != null) {
                    popupObj.close();
                }
            }
            catch (Exception ex) {
                if (popupObj == null) break block4;
                String msgStr = ex.toString();
                popupObj.setMessageStr(msgStr);
                popupObj.getOptionPaneObj().setMessageType(0);
                popupObj.show();
            }
        }
    }

    public static boolean closeStream(InputStream inputStream) {
        try {
            inputStream.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean closeStream(OutputStream outputStream) {
        try {
            outputStream.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

