/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class FileToByteArray {
    private static final String EXT_STR = ".java";

    public static final void main(String[] args) {
        PrintWriter out;
        String baseName;
        String outName;
        BufferedInputStream in;
        if (args.length <= 0) {
            System.out.println("Usage:  FileToByteArray infile");
            return;
        }
        try {
            in = new BufferedInputStream(new FileInputStream(args[0]));
        }
        catch (Exception ex) {
            System.out.println("Unable to open input file \"" + args[0] + "\":  " + ex);
            return;
        }
        int p = args[0].lastIndexOf(46);
        if (p < 0) {
            p = args[0].length();
        }
        StringBuffer baseNameBuff = new StringBuffer(args[0].substring(0, p));
        p = 0;
        while (p < baseNameBuff.length()) {
            baseNameBuff.setCharAt(p, Character.toUpperCase(baseNameBuff.charAt(p)));
            p = baseNameBuff.toString().indexOf(95, p + 1);
            if (p <= 0 || p + 1 >= baseNameBuff.length()) break;
            baseNameBuff.deleteCharAt(p);
        }
        if ((outName = (baseName = baseNameBuff.toString()) + EXT_STR).equals(args[0])) {
            System.out.println("Output file name same as input file name (\"" + outName + "\"; aborting");
            try {
                in.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            return;
        }
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outName)));
        }
        catch (Exception ex) {
            System.out.println("Unable to open output file \"" + outName + "\":  " + ex);
            try {
                in.close();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        out.println("// " + outName + ":  A byte array representation of \"" + args[0] + "\"");
        out.println("//      created by the FileToByteArray.java utility.");
        out.println("//");
        out.println();
        out.println("/**");
        out.println(" * Class " + baseName + " is a byte array representation of \"" + args[0] + "\"");
        out.println(" * created by the FileToByteArray.java utility.");
        out.println(" */");
        out.println("public class " + baseName);
        out.println("{");
        out.println("  public static final byte [] dataArray = new byte []");
        out.print("  {");
        int lastVal = 0;
        int count = 0;
        boolean firstOnLineFlag = true;
        try {
            int val;
            while ((val = in.read()) >= 0) {
                ++count;
                if (firstOnLineFlag) {
                    firstOnLineFlag = false;
                    if (count > 1) {
                        out.print(",");
                    }
                    out.println();
                    out.print("    ");
                } else {
                    if (lastVal < 10) {
                        out.print(",   ");
                    } else if (lastVal < 100) {
                        out.print(",  ");
                    } else {
                        out.print(", ");
                    }
                    if (count % 6 == 0) {
                        firstOnLineFlag = true;
                    }
                }
                out.print("(byte)" + (int)ex);
                lastVal = ex;
            }
        }
        catch (Exception ex) {
            System.out.println("Error reading data from input file \"" + args[0] + "\"");
        }
        out.println();
        out.println("  };          //byte count = " + count);
        out.println("}");
        try {
            in.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        out.close();
        System.out.println("\"" + args[0] + "\" ==> \"" + outName + "\", byte count = " + count);
    }
}

