/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.UtilFns;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class FifoHashtable
implements Cloneable,
Map {
    private final HashMap hashMapObj;
    private final Vector keysVec;
    private final Vector valuesVec;
    private final Vector mapVec;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;

    public FifoHashtable(int initialCapacity, float loadFactor) {
        this(new HashMap(initialCapacity, loadFactor));
    }

    public FifoHashtable(int initialCapacity) {
        this(new HashMap(initialCapacity));
    }

    public FifoHashtable() {
        this(new HashMap());
    }

    protected FifoHashtable(HashMap hashMapObj) {
        this.hashMapObj = hashMapObj;
        this.keysVec = new Vector();
        this.valuesVec = new Vector();
        this.mapVec = new Vector();
    }

    private FifoHashtable(HashMap hMap, Vector kVec, Vector vVec, Vector mVec) {
        this.hashMapObj = hMap;
        this.keysVec = kVec;
        this.valuesVec = vVec;
        this.mapVec = mVec;
    }

    public synchronized Object put(Object key, Object value) {
        int p;
        Object oldObj = this.hashMapObj.put(key, value);
        if (oldObj != null && (p = this.keysVec.indexOf(key)) >= 0) {
            this.keysVec.removeElementAt(p);
            if (p < this.valuesVec.size()) {
                this.valuesVec.removeElementAt(p);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.removeElementAt(p);
            }
        }
        this.keysVec.add(key);
        this.valuesVec.add(value);
        this.mapVec.add(new MapEntry(key, value));
        return oldObj;
    }

    public synchronized void putAll(FifoHashtable tableObj) {
        Enumeration e = tableObj.keys();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            this.put(obj, tableObj.get(obj));
        }
    }

    public synchronized void putAll(Map mapObj) {
        Iterator i = mapObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    public synchronized Object putSort(Object key, Object value, boolean sortDirFlag) {
        Object oldObj = this.hashMapObj.put(key, value);
        if (oldObj == null) {
            int tableSize = this.keysVec.size();
            if (this.valuesVec.size() < tableSize) {
                tableSize = this.valuesVec.size();
            }
            int p = 0;
            if (key instanceof Comparable) {
                while (p < tableSize) {
                    block7: {
                        try {
                            Object obj = this.keysVec.elementAt(p);
                            if (obj == null || !(sortDirFlag ? ((Comparable)key).compareTo(obj) < 0 : ((Comparable)key).compareTo(obj) > 0)) break block7;
                            break;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    ++p;
                }
            } else {
                p = tableSize;
            }
            this.keysVec.insertElementAt(key, p);
            this.valuesVec.insertElementAt(value, p);
            this.mapVec.insertElementAt(new MapEntry(key, value), p);
        }
        return oldObj;
    }

    public synchronized Object putSort(Object key, Object value, boolean sortDirFlag, Comparator compObj) {
        if (compObj == null) {
            return this.putSort(key, value, sortDirFlag);
        }
        Object oldObj = this.hashMapObj.put(key, value);
        if (oldObj == null) {
            int tableSize = this.keysVec.size();
            if (this.valuesVec.size() < tableSize) {
                tableSize = this.valuesVec.size();
            }
            int p = 0;
            if (key instanceof Comparable) {
                while (p < tableSize) {
                    block8: {
                        try {
                            Object obj = this.keysVec.elementAt(p);
                            if (obj == null || !(sortDirFlag ? compObj.compare(key, obj) < 0 : compObj.compare(key, obj) > 0)) break block8;
                            break;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    ++p;
                }
            } else {
                p = tableSize;
            }
            this.keysVec.insertElementAt(key, p);
            this.valuesVec.insertElementAt(value, p);
            this.mapVec.insertElementAt(new MapEntry(key, value), p);
        }
        return oldObj;
    }

    public synchronized Object putSortByValue(Object key, Object value, boolean sortDirFlag) {
        int p;
        Object oldObj = this.hashMapObj.put(key, value);
        if (oldObj != null && (p = this.keysVec.indexOf(key)) >= 0) {
            this.keysVec.removeElementAt(p);
            if (p < this.valuesVec.size()) {
                this.valuesVec.removeElementAt(p);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.removeElementAt(p);
            }
        }
        int tableSize = this.keysVec.size();
        if (this.valuesVec.size() < tableSize) {
            tableSize = this.valuesVec.size();
        }
        p = 0;
        if (value instanceof Comparable) {
            while (p < tableSize) {
                block9: {
                    try {
                        Object obj = this.valuesVec.elementAt(p);
                        if (obj == null || !(sortDirFlag ? ((Comparable)value).compareTo(obj) < 0 : ((Comparable)value).compareTo(obj) > 0)) break block9;
                        break;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                ++p;
            }
        } else {
            p = tableSize;
        }
        this.keysVec.insertElementAt(key, p);
        this.valuesVec.insertElementAt(value, p);
        this.mapVec.insertElementAt(new MapEntry(key, value), p);
        return oldObj;
    }

    public synchronized Object putSortByValue(Object key, Object value, boolean sortDirFlag, Comparator compObj) {
        int p;
        if (compObj == null) {
            return this.putSortByValue(key, value, sortDirFlag);
        }
        Object oldObj = this.hashMapObj.put(key, value);
        if (oldObj != null && (p = this.keysVec.indexOf(key)) >= 0) {
            this.keysVec.removeElementAt(p);
            if (p < this.valuesVec.size()) {
                this.valuesVec.removeElementAt(p);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.removeElementAt(p);
            }
        }
        int tableSize = this.keysVec.size();
        if (this.valuesVec.size() < tableSize) {
            tableSize = this.valuesVec.size();
        }
        p = 0;
        if (value instanceof Comparable) {
            while (p < tableSize) {
                block10: {
                    try {
                        Object obj = this.valuesVec.elementAt(p);
                        if (obj == null || !(sortDirFlag ? compObj.compare(value, obj) < 0 : compObj.compare(value, obj) > 0)) break block10;
                        break;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                ++p;
            }
        } else {
            p = tableSize;
        }
        this.keysVec.insertElementAt(key, p);
        this.valuesVec.insertElementAt(value, p);
        this.mapVec.insertElementAt(new MapEntry(key, value), p);
        return oldObj;
    }

    public synchronized Object get(Object key) {
        return this.hashMapObj.get(key);
    }

    public synchronized Object remove(Object key) {
        int p;
        Object oldObj = this.hashMapObj.remove(key);
        if (oldObj != null && (p = this.keysVec.indexOf(key)) >= 0) {
            this.keysVec.removeElementAt(p);
            if (p < this.valuesVec.size()) {
                this.valuesVec.removeElementAt(p);
            }
            if (p < this.mapVec.size()) {
                this.mapVec.removeElementAt(p);
            }
        }
        return oldObj;
    }

    public synchronized Object removeValue(Object obj) {
        Object oldKeyObj;
        int p = this.valuesVec.indexOf(obj);
        if (p < 0) {
            return null;
        }
        if (p < this.keysVec.size()) {
            Object e = this.keysVec.elementAt(p);
            oldKeyObj = e;
            this.hashMapObj.remove(e);
            this.keysVec.removeElementAt(p);
        } else {
            oldKeyObj = null;
        }
        this.valuesVec.removeElementAt(p);
        this.mapVec.removeElementAt(p);
        return oldKeyObj;
    }

    public synchronized boolean removeAllKeys(Collection collObj) {
        boolean retFlag = false;
        Iterator iterObj = collObj.iterator();
        while (iterObj.hasNext()) {
            int idx = this.keysVec.indexOf(iterObj.next());
            if (idx < 0) continue;
            this.removeElementAt(idx);
            retFlag = true;
        }
        return retFlag;
    }

    public synchronized boolean removeAllValues(Collection collObj) {
        boolean retFlag = false;
        Iterator iterObj = collObj.iterator();
        while (iterObj.hasNext()) {
            int idx = this.valuesVec.indexOf(iterObj.next());
            if (idx < 0) continue;
            this.removeElementAt(idx);
            retFlag = true;
        }
        return retFlag;
    }

    public synchronized boolean containsKey(Object key) {
        return this.hashMapObj.containsKey(key);
    }

    public synchronized boolean containsValue(Object value) {
        return this.hashMapObj.containsValue(value);
    }

    public synchronized boolean contains(Object value) {
        return this.hashMapObj.containsValue(value);
    }

    public synchronized boolean isEmpty() {
        return this.hashMapObj.isEmpty();
    }

    public synchronized int size() {
        return this.hashMapObj.size();
    }

    public synchronized void clear() {
        this.hashMapObj.clear();
        this.keysVec.clear();
        this.valuesVec.clear();
        this.mapVec.clear();
    }

    public synchronized boolean equals(Object o) {
        return this.hashMapObj.equals(o);
    }

    public synchronized int hashCode() {
        return this.hashMapObj.hashCode();
    }

    public synchronized Vector getKeysVector() {
        return (Vector)this.keysVec.clone();
    }

    public synchronized Vector getKeysVector(int fromIndex, int toIndex) {
        return new Vector(this.keysVec.subList(fromIndex, toIndex));
    }

    public synchronized Vector getValuesVector() {
        return (Vector)this.valuesVec.clone();
    }

    public synchronized Vector getValuesVector(int fromIndex, int toIndex) {
        return new Vector(this.valuesVec.subList(fromIndex, toIndex));
    }

    public synchronized HashMap getHashMap() {
        return (HashMap)this.hashMapObj.clone();
    }

    public synchronized Enumeration keys() {
        return ((Vector)this.keysVec.clone()).elements();
    }

    public synchronized Enumeration elements() {
        return ((Vector)this.valuesVec.clone()).elements();
    }

    public synchronized int indexOf(Object obj) {
        return this.valuesVec.indexOf(obj);
    }

    public synchronized int indexOf(Object obj, int idx) {
        return this.valuesVec.indexOf(obj, idx);
    }

    public synchronized int lastIndexOf(Object obj) {
        return this.valuesVec.lastIndexOf(obj);
    }

    public synchronized int lastIndexOf(Object obj, int idx) {
        return this.valuesVec.lastIndexOf(obj, idx);
    }

    public synchronized int indexOfKey(Object obj) {
        return this.keysVec.indexOf(obj);
    }

    public synchronized int indexOfKey(Object obj, int idx) {
        return this.keysVec.indexOf(obj, idx);
    }

    public synchronized int lastIndexOfKey(Object obj) {
        return this.keysVec.lastIndexOf(obj);
    }

    public synchronized int lastIndexOfKey(Object obj, int idx) {
        return this.keysVec.lastIndexOf(obj, idx);
    }

    public synchronized Object elementAt(int idx) {
        return this.valuesVec.elementAt(idx);
    }

    public synchronized Object keyAt(int idx) {
        return this.keysVec.elementAt(idx);
    }

    public synchronized void setElementAt(Object obj, int idx) {
        Object keyObj = this.keyAt(idx);
        this.valuesVec.setElementAt(obj, idx);
        this.mapVec.setElementAt(new MapEntry(keyObj, obj), idx);
        this.hashMapObj.put(keyObj, obj);
    }

    public synchronized void removeElementAt(int idx) {
        Object keyObj = this.keyAt(idx);
        this.keysVec.removeElementAt(idx);
        this.valuesVec.removeElementAt(idx);
        this.mapVec.removeElementAt(idx);
        this.hashMapObj.remove(keyObj);
    }

    public synchronized boolean swapEntries(Object key1Obj, Object key2Obj) {
        try {
            int pos2;
            int pos1 = this.keysVec.indexOf(key1Obj);
            if (pos1 < 0 || (pos2 = this.keysVec.indexOf(key2Obj)) < 0) {
                return false;
            }
            this.keysVec.setElementAt(key2Obj, pos1);
            this.keysVec.setElementAt(key1Obj, pos2);
            Object obj = this.valuesVec.elementAt(pos1);
            this.valuesVec.setElementAt(this.valuesVec.elementAt(pos2), pos1);
            this.valuesVec.setElementAt(obj, pos2);
            Object mapEntry = this.mapVec.elementAt(pos1);
            this.mapVec.setElementAt(this.mapVec.elementAt(pos2), pos1);
            this.mapVec.setElementAt(mapEntry, pos2);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    public synchronized String toQuotedStrings(String sepStr, boolean quoteCharsFlag) {
        StringBuffer retBuff = new StringBuffer();
        Enumeration e = this.keysVec.elements();
        if (e.hasMoreElements()) {
            if (quoteCharsFlag) {
                while (true) {
                    Object obj;
                    if ((obj = e.nextElement()) != null) {
                        retBuff.append("\"" + UtilFns.insertQuoteChars(obj.toString(), "\"\r\n\t\\") + "\"=");
                        obj = this.hashMapObj.get(obj);
                        if (obj != null) {
                            retBuff.append("\"" + UtilFns.insertQuoteChars(obj.toString(), "\"\r\n\t\\") + "\"");
                        } else {
                            retBuff.append("(null)");
                        }
                    }
                    if (e.hasMoreElements()) {
                        retBuff.append(sepStr);
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    Object obj;
                    if ((obj = e.nextElement()) != null) {
                        retBuff.append("\"" + obj.toString() + "\"=");
                        obj = this.hashMapObj.get(obj);
                        if (obj != null) {
                            retBuff.append("\"" + obj.toString() + "\"");
                        } else {
                            retBuff.append("(null)");
                        }
                    }
                    if (!e.hasMoreElements()) break;
                    retBuff.append(sepStr);
                }
            }
        }
        return retBuff.toString();
    }

    public synchronized String toQuotedStrings(char sepChar, boolean quoteCharsFlag) {
        return this.toQuotedStrings(new String(new char[]{sepChar}), quoteCharsFlag);
    }

    public String toQuotedStrings() {
        return this.toQuotedStrings(",", true);
    }

    public static synchronized FifoHashtable quotedStringsToTable(FifoHashtable inTable, String str, char sepChar, boolean strictFlag) {
        int ePos;
        FifoHashtable retTable = inTable != null ? inTable : new FifoHashtable();
        int strLen = str.length();
        int sPos = 0;
        do {
            int q;
            int subLen;
            if ((ePos = UtilFns.findCharPos(str, sepChar, sPos)) < sPos) {
                ePos = strLen;
            }
            String subStr = str.substring(sPos, ePos);
            if (strictFlag) {
                subLen = subStr.length();
                if (subLen <= 0) break;
                if (subLen < 2 || (q = UtilFns.findCharPos(subStr, '=')) < 2 || q >= subLen - 1) {
                    return null;
                }
                if (subStr.charAt(0) != '\"' || subStr.charAt(q - 1) != '\"' || subStr.charAt(q + 1) != '\"' || subStr.charAt(subLen - 1) != '\"') {
                    return null;
                }
            } else {
                subLen = (subStr = subStr.trim()).length();
                if (subLen <= 0) break;
                if (subLen < 2 || (q = UtilFns.findCharPos(subStr, '=')) < 2 || q >= subLen - 1) {
                    return null;
                }
            }
            retTable.put(UtilFns.removeQuoteChars(subStr.substring(0, q), true), UtilFns.removeQuoteChars(subStr.substring(q + 1, subLen), true));
        } while ((sPos = ePos + 1) < strLen);
        return retTable;
    }

    public static FifoHashtable quotedStringsToTable(FifoHashtable inTable, String str, char sepChar) {
        return FifoHashtable.quotedStringsToTable(inTable, str, sepChar, true);
    }

    public static FifoHashtable quotedStringsToTable(FifoHashtable inTable, String str) {
        return FifoHashtable.quotedStringsToTable(inTable, str, ',', true);
    }

    public static FifoHashtable quotedStringsToTable(String str, char sepChar, boolean strictFlag) {
        return FifoHashtable.quotedStringsToTable(null, str, sepChar, strictFlag);
    }

    public static FifoHashtable quotedStringsToTable(String str, char sepChar) {
        return FifoHashtable.quotedStringsToTable(null, str, sepChar, true);
    }

    public static FifoHashtable quotedStringsToTable(String str) {
        return FifoHashtable.quotedStringsToTable(null, str, ',', true);
    }

    public synchronized Object clone() {
        return new FifoHashtable((HashMap)this.hashMapObj.clone(), (Vector)this.keysVec.clone(), (Vector)this.valuesVec.clone(), (Vector)this.mapVec.clone());
    }

    public synchronized String toString() {
        String nullString = "(null)";
        StringBuffer buff = new StringBuffer();
        Enumeration e = this.keysVec.elements();
        buff.append("{");
        if (e.hasMoreElements()) {
            while (true) {
                Object obj;
                if ((obj = e.nextElement()) != null) {
                    buff.append(obj.toString());
                } else {
                    buff.append("(null)");
                }
                buff.append("=");
                obj = this.hashMapObj.get(obj);
                if (obj != null) {
                    buff.append(obj.toString());
                } else {
                    buff.append("(null)");
                }
                if (!e.hasMoreElements()) break;
                buff.append(", ");
            }
        }
        buff.append("}");
        return buff.toString();
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                public Iterator iterator() {
                    return FifoHashtable.this.keysVec.iterator();
                }

                public int size() {
                    return FifoHashtable.this.keysVec.size();
                }

                public boolean contains(Object o) {
                    return FifoHashtable.this.keysVec.contains(o);
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                public Iterator iterator() {
                    return FifoHashtable.this.valuesVec.iterator();
                }

                public int size() {
                    return FifoHashtable.this.valuesVec.size();
                }

                public boolean contains(Object o) {
                    return FifoHashtable.this.valuesVec.contains(o);
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                public Iterator iterator() {
                    return FifoHashtable.this.mapVec.iterator();
                }

                public boolean contains(Object o) {
                    return FifoHashtable.this.mapVec.contains(o);
                }

                public int size() {
                    return FifoHashtable.this.mapVec.size();
                }
            };
        }
        return this.entrySet;
    }

    class MapEntry
    implements Map.Entry {
        protected Object key;
        protected Object value;

        public MapEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.getValue();
            if (value == null) {
                throw new NullPointerException();
            }
            this.setValue(value);
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

