/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FifoHashtable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;

public class FifoHashListModel
extends AbstractListModel {
    protected final FifoHashtable hashtableObj = new FifoHashtable();
    protected boolean listenersEnabledFlag = true;

    public synchronized int getSize() {
        return this.hashtableObj.size();
    }

    public synchronized Object getElementAt(int indexVal) {
        return this.hashtableObj.elementAt(indexVal);
    }

    public synchronized Object put(Object key, Object value) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.put(key, value);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public synchronized Object putSort(Object key, Object value, boolean sortDirFlag) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.putSort(key, value, sortDirFlag);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public synchronized Object putSort(Object key, Object value, boolean sortDirFlag, Comparator compObj) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.putSort(key, value, sortDirFlag, compObj);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public synchronized Object putSortByValue(Object key, Object value, boolean sortDirFlag) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.putSortByValue(key, value, sortDirFlag);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public synchronized Object putSortByValue(Object key, Object value, boolean sortDirFlag, Comparator compObj) {
        int preIdx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.putSortByValue(key, value, sortDirFlag, compObj);
        this.fireItemPut(preIdx, key);
        return retObj;
    }

    public synchronized Object get(Object key) {
        return this.hashtableObj.get(key);
    }

    public synchronized Object remove(Object key) {
        int idx = this.hashtableObj.indexOfKey(key);
        Object retObj = this.hashtableObj.remove(key);
        if (this.listenersEnabledFlag && idx >= 0) {
            this.fireIntervalRemoved(this, idx, idx);
        }
        return retObj;
    }

    public synchronized Object removeValue(Object obj) {
        int idx = this.hashtableObj.indexOf(obj);
        Object retObj = this.hashtableObj.removeValue(obj);
        if (this.listenersEnabledFlag && idx >= 0) {
            this.fireIntervalRemoved(this, idx, idx);
        }
        return retObj;
    }

    public synchronized void removeElementAt(int indexVal) {
        this.hashtableObj.removeElementAt(indexVal);
        if (this.listenersEnabledFlag) {
            this.fireIntervalRemoved(this, indexVal, indexVal);
        }
    }

    public synchronized boolean containsKey(Object key) {
        return this.hashtableObj.containsKey(key);
    }

    public synchronized boolean containsValue(Object value) {
        return this.hashtableObj.containsValue(value);
    }

    public synchronized boolean contains(Object value) {
        return this.hashtableObj.containsValue(value);
    }

    public synchronized int indexOf(Object obj) {
        return this.hashtableObj.indexOf(obj);
    }

    public synchronized int indexOf(Object obj, int idx) {
        return this.hashtableObj.indexOf(obj, idx);
    }

    public synchronized int lastIndexOf(Object obj) {
        return this.hashtableObj.lastIndexOf(obj);
    }

    public synchronized int lastIndexOf(Object obj, int idx) {
        return this.hashtableObj.lastIndexOf(obj, idx);
    }

    public synchronized int indexOfKey(Object obj) {
        return this.hashtableObj.indexOfKey(obj);
    }

    public synchronized int indexOfKey(Object obj, int idx) {
        return this.hashtableObj.indexOfKey(obj, idx);
    }

    public synchronized int lastIndexOfKey(Object obj) {
        return this.hashtableObj.lastIndexOfKey(obj);
    }

    public synchronized int lastIndexOfKey(Object obj, int idx) {
        return this.hashtableObj.lastIndexOfKey(obj, idx);
    }

    public synchronized Object keyAt(int idx) {
        return this.hashtableObj.keyAt(idx);
    }

    public synchronized void clear() {
        int sizeVal = this.hashtableObj.size();
        if (sizeVal > 0) {
            this.hashtableObj.clear();
            if (this.listenersEnabledFlag) {
                this.fireIntervalRemoved(this, 0, sizeVal - 1);
            }
        }
    }

    public synchronized Enumeration elements() {
        return this.hashtableObj.elements();
    }

    public synchronized Vector getValuesVector() {
        return this.hashtableObj.getValuesVector();
    }

    public synchronized Collection values() {
        return this.hashtableObj.values();
    }

    public synchronized void setListenersEnabled(boolean flgVal) {
        this.listenersEnabledFlag = flgVal;
    }

    public synchronized void fireContentsChanged() {
        int len = this.hashtableObj.size();
        super.fireContentsChanged(this, 0, len > 0 ? len : 0);
    }

    protected void fireItemPut(int preIdx, Object key) {
        int idx;
        if (this.listenersEnabledFlag && (idx = this.hashtableObj.indexOfKey(key)) >= 0) {
            if (preIdx >= 0) {
                if (idx == preIdx) {
                    this.fireContentsChanged(this, idx, idx);
                    return;
                }
                this.fireIntervalRemoved(this, preIdx, preIdx);
            }
            this.fireIntervalAdded(this, idx, idx);
        }
    }
}

