/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.util.Arrays;
import java.util.Vector;

public class CfgPropValidator {
    public final Comparable minValueCompObj;
    public final Comparable maxValueCompObj;
    public final Object[] validValuesArr;
    public final Vector validValuesVec;

    public CfgPropValidator(Comparable minValueCompObj, Comparable maxValueCompObj) {
        this.minValueCompObj = minValueCompObj;
        this.maxValueCompObj = maxValueCompObj;
        this.validValuesArr = null;
        this.validValuesVec = null;
    }

    public CfgPropValidator(Object[] objArr) {
        Vector<Object> vec;
        this.validValuesArr = objArr;
        if (objArr != null) {
            try {
                vec = new Vector<Object>(Arrays.asList(objArr));
            }
            catch (Exception ex) {
                vec = new Vector();
            }
        } else {
            vec = new Vector();
        }
        this.validValuesVec = vec;
        this.maxValueCompObj = null;
        this.minValueCompObj = null;
    }

    public boolean validateValue(Object valueObj) {
        if (this.validValuesVec != null) {
            return this.validValuesVec.indexOf(valueObj) >= 0;
        }
        if (valueObj == null) {
            return false;
        }
        try {
            if (this.minValueCompObj != null && this.minValueCompObj.compareTo(valueObj) > 0) {
                return false;
            }
            if (this.maxValueCompObj != null && this.maxValueCompObj.compareTo(valueObj) < 0) {
                return false;
            }
        }
        catch (ClassCastException ex) {
            return false;
        }
        return true;
    }

    public boolean isMinimumNonNegative() {
        return this.minValueCompObj instanceof Number && ((Number)((Object)this.minValueCompObj)).doubleValue() >= 0.0;
    }
}

