/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.BooleanCp;
import com.isti.util.CfgPropValidator;
import com.isti.util.DataChangedListener;
import com.isti.util.UtilFns;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class CfgPropItem
implements Comparable,
Serializable {
    public static final char SWITCH1_CHAR = '-';
    public static final char SWITCH2_CHAR = '/';
    protected final String name;
    protected Object value;
    protected Object defaultValue;
    protected boolean loadedFlag = false;
    protected boolean requiredFlag;
    protected boolean cmdLnLoadedFlag = false;
    protected final String cmdLnParamName;
    protected final String descriptionStr;
    protected final boolean cmdLnEnbFlag;
    protected boolean helpScreenFlag;
    protected final boolean cmdLnOnlyFlag;
    protected boolean ignoreItemFlag = false;
    protected CfgPropValidator validatorObj = null;
    protected final Vector listenersVec = new Vector();
    protected long lastChangeTime = 0L;
    protected Object groupSelObj = null;
    protected Object auxiliaryObj = null;
    protected boolean startupConfigFlag = false;
    private transient Map.Entry mapEntryObj = null;
    static /* synthetic */ Class class$java$lang$String;

    public CfgPropItem(String name, Object defaultValue, boolean requiredFlag, String cmdLnParamName, String descriptionStr, boolean cmdLnEnbFlag, boolean helpScreenFlag, boolean cmdLnOnlyFlag) {
        this.name = name != null ? name : "";
        this.setDefaultValue(defaultValue);
        this.value = defaultValue;
        this.requiredFlag = requiredFlag;
        if (cmdLnParamName != null && cmdLnParamName.length() > 0 && (cmdLnParamName.charAt(0) == '-' || cmdLnParamName.charAt(0) == '/')) {
            cmdLnParamName = cmdLnParamName.substring(1);
        }
        this.cmdLnParamName = cmdLnParamName;
        this.descriptionStr = descriptionStr;
        this.cmdLnEnbFlag = cmdLnEnbFlag;
        this.helpScreenFlag = helpScreenFlag;
        this.cmdLnOnlyFlag = cmdLnOnlyFlag;
    }

    public CfgPropItem(String name, Object defaultValue, boolean requiredFlag, String cmdLnParamName, String descriptionStr) {
        this(name, defaultValue, requiredFlag, cmdLnParamName, descriptionStr, true, true, false);
    }

    public CfgPropItem(String name, Object defaultValue, boolean requiredFlag) {
        this(name, defaultValue, requiredFlag, null, null, true, true, false);
    }

    public CfgPropItem(String name, Object defaultValue, String cmdLnParamName, String descriptionStr, boolean cmdLnEnbFlag, boolean helpScreenFlag) {
        this(name, defaultValue, false, cmdLnParamName, descriptionStr, cmdLnEnbFlag, helpScreenFlag, false);
    }

    public CfgPropItem(String name, Object defaultValue, String cmdLnParamName, String descriptionStr, boolean cmdLnEnbFlag, boolean helpScreenFlag, boolean cmdLnOnlyFlag) {
        this(name, defaultValue, false, cmdLnParamName, descriptionStr, cmdLnEnbFlag, helpScreenFlag, cmdLnOnlyFlag);
    }

    public CfgPropItem(String name, Object defaultValue, String cmdLnParamName, String descriptionStr) {
        this(name, defaultValue, false, cmdLnParamName, descriptionStr, true, true, false);
    }

    public CfgPropItem(String name, Object defaultValue, String cmdLnParamName) {
        this(name, defaultValue, false, cmdLnParamName, null, true, true, false);
    }

    public CfgPropItem(String name, Object defaultValue) {
        this(name, defaultValue, false, null, null, true, true, false);
    }

    public String getName() {
        return this.name;
    }

    public synchronized Object getDefaultValue() {
        return this.defaultValue;
    }

    public synchronized void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue != null ? defaultValue : "";
    }

    public synchronized Object getValue() {
        return this.value;
    }

    public synchronized boolean setValue(Object valueObj) {
        if (valueObj == null || valueObj.getClass() != this.defaultValue.getClass()) {
            return false;
        }
        if (valueObj.equals(this.value)) {
            return true;
        }
        if (this.validatorObj != null && !this.validatorObj.validateValue(valueObj)) {
            return false;
        }
        this.value = valueObj;
        this.fireDataChanged();
        return true;
    }

    public boolean setValue(int val) {
        return this.setValue(new Integer(val));
    }

    public boolean setValue(long val) {
        return this.setValue(new Long(val));
    }

    public boolean setValue(float val) {
        return this.setValue(new Float(val));
    }

    public boolean setValue(double val) {
        return this.setValue(new Double(val));
    }

    public boolean setValue(byte val) {
        return this.setValue(new Byte(val));
    }

    public boolean setValue(short val) {
        return this.setValue(new Short(val));
    }

    public boolean setValue(boolean flg) {
        return this.setValue(new Boolean(flg));
    }

    public static Object setValueString(String str, Object defValObj) {
        Object obj;
        boolean boolTypeFlag = false;
        if (str == null || defValObj == null) {
            return null;
        }
        try {
            if (defValObj instanceof Integer) {
                obj = new Integer(str);
            } else if (defValObj instanceof Long) {
                obj = new Long(str);
            } else if (defValObj instanceof Float) {
                obj = new Float(str);
            } else if (defValObj instanceof Double) {
                obj = new Double(str);
            } else if (defValObj instanceof Byte) {
                obj = new Byte(str);
            } else if (defValObj instanceof Short) {
                obj = new Short(str);
            } else if (defValObj instanceof String) {
                obj = str;
            } else if (defValObj instanceof Boolean) {
                obj = new Boolean(str);
                boolTypeFlag = true;
            } else if (defValObj instanceof BooleanCp) {
                obj = new BooleanCp(str);
                boolTypeFlag = true;
            } else if (defValObj instanceof Color) {
                obj = UtilFns.parseColor(str);
            } else {
                try {
                    Class<?> valueClass = defValObj.getClass();
                    Class[] parameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CfgPropItem.class$("java.lang.String")) : class$java$lang$String};
                    Constructor<?> c = valueClass.getConstructor(parameterTypes);
                    Object[] initargs = new Object[]{str};
                    obj = c.newInstance(initargs);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            if (boolTypeFlag && !str.equalsIgnoreCase("true") && !str.equalsIgnoreCase("false")) {
                return null;
            }
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return obj;
    }

    public synchronized boolean setValueString(String str) {
        Object obj = CfgPropItem.setValueString(str, this.defaultValue);
        if (obj == null) {
            return false;
        }
        if (obj.equals(this.value)) {
            return true;
        }
        if (this.validatorObj != null && !this.validatorObj.validateValue(obj)) {
            return false;
        }
        this.value = obj;
        this.fireDataChanged();
        return true;
    }

    public synchronized boolean compareValueString(String str) {
        Object obj = CfgPropItem.setValueString(str, this.defaultValue);
        if (obj == null) {
            return false;
        }
        try {
            return this.value.equals(obj);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public synchronized Object convertValueString(String str) {
        return CfgPropItem.setValueString(str, this.defaultValue);
    }

    public synchronized boolean checkType(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.defaultValue.getClass();
    }

    public synchronized Class getValueClass() {
        if (this.defaultValue == null) {
            return null;
        }
        return this.defaultValue.getClass();
    }

    public synchronized CfgPropItem setLoadedFlag(boolean flg) {
        this.loadedFlag = flg;
        return this;
    }

    public synchronized boolean getLoadedFlag() {
        return this.loadedFlag;
    }

    public synchronized CfgPropItem setRequiredFlag(boolean flg) {
        this.requiredFlag = flg;
        return this;
    }

    public synchronized boolean getRequiredFlag() {
        return this.requiredFlag;
    }

    public synchronized CfgPropItem setCmdLnLoadedFlag(boolean flg) {
        this.cmdLnLoadedFlag = flg;
        return this;
    }

    public synchronized boolean getCmdLnLoadedFlag() {
        return this.cmdLnLoadedFlag;
    }

    public synchronized CfgPropItem setIgnoreItemFlag(boolean flg) {
        this.ignoreItemFlag = flg;
        if (this.ignoreItemFlag) {
            this.helpScreenFlag = false;
        }
        return this;
    }

    public synchronized boolean getIgnoreItemFlag() {
        return this.ignoreItemFlag;
    }

    public synchronized CfgPropItem setHelpScreenFlag(boolean flg) {
        this.helpScreenFlag = flg;
        return this;
    }

    public synchronized String toString() {
        if (!(this.value instanceof Object[])) {
            return this.stringValue();
        }
        Object[] objArr = (Object[])this.value;
        StringBuffer buff = new StringBuffer();
        if (objArr.length > 0) {
            int i = 0;
            while (true) {
                if (objArr[i] != null) {
                    buff.append(objArr[i]);
                }
                if (++i >= objArr.length) break;
                buff.append(" ");
            }
        }
        return buff.toString();
    }

    public synchronized int hashCode() {
        return this.value.hashCode();
    }

    public synchronized boolean equals(Object obj) {
        return this.value.equals(obj);
    }

    public synchronized int intValue() {
        return this.value instanceof Number ? ((Number)this.value).intValue() : 0;
    }

    public synchronized long longValue() {
        return this.value instanceof Number ? ((Number)this.value).longValue() : 0L;
    }

    public synchronized float floatValue() {
        return this.value instanceof Number ? ((Number)this.value).floatValue() : 0.0f;
    }

    public synchronized double doubleValue() {
        return this.value instanceof Number ? ((Number)this.value).doubleValue() : 0.0;
    }

    public synchronized byte byteValue() {
        return this.value instanceof Number ? ((Number)this.value).byteValue() : (byte)0;
    }

    public synchronized short shortValue() {
        return this.value instanceof Number ? ((Number)this.value).shortValue() : (short)0;
    }

    public synchronized boolean booleanValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof BooleanCp) {
            return ((BooleanCp)this.value).booleanValue();
        }
        return false;
    }

    public synchronized String stringValue() {
        if (this.value instanceof Color) {
            return UtilFns.colorToPropertyString((Color)this.value);
        }
        if (this.value instanceof Float || this.value instanceof Double) {
            return UtilFns.floatNumberToPropertyString(this.value);
        }
        return this.value.toString();
    }

    public synchronized Color colorValue() {
        if (this.value instanceof Color) {
            return (Color)this.value;
        }
        return null;
    }

    public synchronized int compareTo(Object obj) throws ClassCastException {
        return ((Comparable)this.value).compareTo(obj);
    }

    public String getCmdLnParamName() {
        return this.cmdLnParamName;
    }

    public String getDescriptionStr() {
        return this.descriptionStr;
    }

    public boolean getCmdLnEnbFlag() {
        return this.cmdLnEnbFlag;
    }

    public boolean getHelpScreenFlag() {
        return this.helpScreenFlag;
    }

    public boolean getCmdLnOnlyFlag() {
        return this.cmdLnOnlyFlag;
    }

    public synchronized CfgPropItem duplicate() {
        CfgPropItem itemObj = new CfgPropItem(this.name, this.defaultValue, this.requiredFlag, this.cmdLnParamName, this.descriptionStr, this.cmdLnEnbFlag, this.helpScreenFlag, this.cmdLnOnlyFlag);
        itemObj.value = this.value;
        itemObj.validatorObj = this.validatorObj;
        return itemObj;
    }

    public synchronized CfgPropItem setValidator(CfgPropValidator validatorObj) {
        if (CfgPropItem.validateValue(validatorObj, this.value)) {
            this.validatorObj = validatorObj;
        }
        return this;
    }

    public synchronized CfgPropValidator getValidator() {
        return this.validatorObj;
    }

    public CfgPropItem setValidator(Comparable minValueCompObj, Comparable maxValueCompObj) {
        this.setValidator(new CfgPropValidator(minValueCompObj, maxValueCompObj));
        return this;
    }

    public synchronized CfgPropItem setValidator(Object[] objArr) {
        this.setValidator(new CfgPropValidator(objArr));
        return this;
    }

    public synchronized CfgPropItem setValidator(int minValue, int maxValue) {
        this.setValidator(new CfgPropValidator(new Integer(minValue), new Integer(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(long minValue, long maxValue) {
        this.setValidator(new CfgPropValidator(new Long(minValue), new Long(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(short minValue, short maxValue) {
        this.setValidator(new CfgPropValidator(new Short(minValue), new Short(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(byte minValue, byte maxValue) {
        this.setValidator(new CfgPropValidator(new Byte(minValue), new Byte(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(float minValue, float maxValue) {
        this.setValidator(new CfgPropValidator(new Float(minValue), new Float(maxValue)));
        return this;
    }

    public synchronized CfgPropItem setValidator(double minValue, double maxValue) {
        this.setValidator(new CfgPropValidator(new Double(minValue), new Double(maxValue)));
        return this;
    }

    public static boolean validateValue(CfgPropValidator validatorObj, Object valueObj) {
        if (validatorObj == null) {
            return true;
        }
        if (valueObj instanceof Object[]) {
            Object[] objArr = (Object[])valueObj;
            int i = 0;
            while (i < objArr.length) {
                if (!validatorObj.validateValue(objArr[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return validatorObj.validateValue(valueObj);
    }

    public synchronized boolean validateValue(Object valueObj) {
        return CfgPropItem.validateValue(this.validatorObj, valueObj);
    }

    public synchronized void addDataChangedListener(DataChangedListener listenerObj) {
        if (listenerObj != null && this.listenersVec.indexOf(listenerObj) < 0) {
            this.listenersVec.add(listenerObj);
        }
    }

    public synchronized void removeDataChangedListener(DataChangedListener listenerObj) {
        if (listenerObj != null) {
            this.listenersVec.remove(listenerObj);
        }
    }

    protected void fireDataChanged() {
        this.lastChangeTime = System.currentTimeMillis();
        Enumeration e = this.listenersVec.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof DataChangedListener)) continue;
            ((DataChangedListener)obj).dataChanged(this);
        }
    }

    public long getLastChangeTime() {
        return this.lastChangeTime;
    }

    public synchronized CfgPropItem setGroupSelObj(Object obj) {
        this.groupSelObj = obj;
        return this;
    }

    public synchronized Object getGroupSelObj() {
        return this.groupSelObj;
    }

    public synchronized CfgPropItem setAuxiliaryObj(Object obj) {
        this.auxiliaryObj = obj;
        return this;
    }

    public synchronized Object getAuxiliaryObj() {
        return this.auxiliaryObj;
    }

    public synchronized CfgPropItem setStartupConfigFlag(boolean b) {
        this.startupConfigFlag = b;
        return this;
    }

    public synchronized boolean isStartupConfigFlag() {
        return this.startupConfigFlag;
    }

    public synchronized Map.Entry getMapEntry() {
        if (this.mapEntryObj == null) {
            this.mapEntryObj = new MapEntry();
        }
        return this.mapEntryObj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MapEntry
    implements Map.Entry {
        MapEntry() {
        }

        public synchronized Object getKey() {
            return CfgPropItem.this.getName();
        }

        public synchronized Object getValue() {
            return CfgPropItem.this.getValue();
        }

        public synchronized Object setValue(Object value) {
            Object oldValue = CfgPropItem.this.getValue();
            if (value == null) {
                throw new NullPointerException();
            }
            if (value.getClass() != CfgPropItem.this.defaultValue.getClass()) {
                throw new ClassCastException();
            }
            if (!CfgPropItem.this.setValue(value)) {
                throw new IllegalArgumentException();
            }
            return oldValue;
        }

        public synchronized boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        public synchronized int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

