/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.UtilFns;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StreamTokenizer;

public class CfgFileTokenizer {
    private final StreamTokenizer sTokenizerObj;
    private static final char COMMENT_CHAR = '#';
    private static final char QUOTE_CHAR1 = '\'';
    private static final char QUOTE_CHAR2 = '\"';
    private String tokenString = null;
    public static final int TT_EOF = -1;
    public static final int TT_EOL = 10;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;

    public CfgFileTokenizer(Reader rdr, boolean wordSlashFlag, boolean commaSepFlag) {
        this.sTokenizerObj = new StreamTokenizer(rdr);
        int commaOffs = commaSepFlag ? 1 : 0;
        this.sTokenizerObj.resetSyntax();
        this.sTokenizerObj.whitespaceChars(0, 32);
        this.sTokenizerObj.wordChars(33, 34);
        this.sTokenizerObj.wordChars(36, 38);
        this.sTokenizerObj.wordChars(40, 41);
        this.sTokenizerObj.wordChars(43, 44 - commaOffs);
        if (!wordSlashFlag) {
            this.sTokenizerObj.wordChars(44 + commaOffs, 46);
            this.sTokenizerObj.wordChars(48, 59);
        } else {
            this.sTokenizerObj.wordChars(44 + commaOffs, 59);
        }
        this.sTokenizerObj.wordChars(63, 122);
        this.sTokenizerObj.wordChars(124, 124);
        this.sTokenizerObj.wordChars(126, 126);
        this.sTokenizerObj.slashSlashComments(true);
        this.sTokenizerObj.slashStarComments(true);
        this.sTokenizerObj.commentChar(35);
        this.sTokenizerObj.quoteChar(39);
        this.sTokenizerObj.quoteChar(34);
        this.sTokenizerObj.eolIsSignificant(true);
    }

    public CfgFileTokenizer(Reader rdr, boolean wordSlashFlag) {
        this(rdr, wordSlashFlag, false);
    }

    public CfgFileTokenizer(Reader rdr) {
        this(rdr, false, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextToken(boolean eolFlag) throws IOException {
        int tType;
        StringBuffer buff = null;
        if (!eolFlag) {
            tType = this.sTokenizerObj.nextToken();
            if (tType == 10) {
                int maxCount = 30000;
                while ((tType = this.sTokenizerObj.nextToken()) == 10 && --maxCount > 0) {
                }
            }
        } else {
            tType = this.sTokenizerObj.nextToken();
        }
        block7: while (true) {
            if (tType == -1) {
                return tType;
            }
            switch (tType) {
                case -3: {
                    this.tokenString = this.sTokenizerObj.sval;
                    break;
                }
                case -2: {
                    this.tokenString = Double.toString(this.sTokenizerObj.nval);
                    tType = -3;
                    break;
                }
                case 34: 
                case 39: {
                    this.tokenString = this.sTokenizerObj.sval;
                    tType = -3;
                    break;
                }
                case 10: {
                    break block7;
                }
            }
            if (!eolFlag) {
                return tType;
            }
            if (buff == null) {
                buff = new StringBuffer();
            } else {
                buff.append(' ');
            }
            if (tType == -3) {
                buff.append(this.tokenString);
            } else {
                buff.append((char)tType);
            }
            tType = this.sTokenizerObj.nextToken();
        }
        this.tokenString = buff != null ? buff.toString() : "";
        return -3;
    }

    public int nextToken() throws IOException {
        return this.nextToken(false);
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getNonNullTokenString() {
        return this.tokenString != null ? this.tokenString : "";
    }

    public Number getNumberToken() {
        return UtilFns.parseNumber(this.tokenString);
    }

    public int lineno() {
        return this.sTokenizerObj.lineno();
    }

    /*
     * WARNING - void declaration
     */
    public void dumpTokens(PrintStream out) throws IOException {
        int tType;
        while ((tType = this.sTokenizerObj.nextToken()) != -1) {
            void var2_2;
            switch (var2_2) {
                case -3: {
                    out.println("word = " + this.sTokenizerObj.sval);
                    break;
                }
                case -2: {
                    out.println("number = " + this.sTokenizerObj.nval);
                    break;
                }
                case 39: {
                    out.println("string = '" + this.sTokenizerObj.sval + "'");
                    break;
                }
                case 34: {
                    out.println("string = \"" + this.sTokenizerObj.sval + "\"");
                    break;
                }
                case 10: {
                    out.println("EOL");
                    break;
                }
                default: {
                    out.println("char = '" + (char)var2_2 + "'");
                }
            }
        }
    }
}

