/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CfgFileTokenizer;
import com.isti.util.UtilFns;
import java.io.IOException;
import java.io.Reader;

public class CfgFileParser {
    protected static final char OPEN_BRACKET_CHAR = '{';
    protected static final char CLOSE_BRACKET_CHAR = '}';
    protected CfgFileTokenizer inTokens;
    protected String errorMessage = null;

    public CfgFileParser(Reader rdr) {
        this.inTokens = new CfgFileTokenizer(rdr, false, false);
    }

    public CfgFileParser(Reader rdr, boolean wordSlashFlag) {
        this.inTokens = new CfgFileTokenizer(rdr, wordSlashFlag, false);
    }

    public CfgFileParser(Reader rdr, boolean wordSlashFlag, boolean commaSepFlag) {
        this.inTokens = new CfgFileTokenizer(rdr, wordSlashFlag, commaSepFlag);
    }

    protected String parseEqualsString() throws IOException {
        int tType = this.inTokens.nextToken();
        if (tType != -1) {
            if (tType != 61) {
                this.setIllegalCharMsg(tType);
                this.errorMessage = this.errorMessage + " ('=' expected)";
                return null;
            }
            tType = this.inTokens.nextToken();
            if (tType != -1) {
                if (tType != -3) {
                    this.setIllegalCharMsg(tType);
                    return null;
                }
                return this.inTokens.getNonNullTokenString();
            }
        }
        this.setUnexpectedEOFMsg();
        return null;
    }

    protected Number parseEqualsNumber() throws IOException {
        String str = this.parseEqualsString();
        if (str == null) {
            return null;
        }
        Number num = UtilFns.parseNumber(str);
        if (num == null) {
            this.errorMessage = "Illegal numeric value (\"" + str + "\") on line " + this.inTokens.lineno();
            return null;
        }
        return num;
    }

    protected void setIllegalCharMsg(int charVal) {
        this.errorMessage = charVal >= 32 && charVal < 127 ? "Illegal character '" + (char)charVal + "' on line " + this.inTokens.lineno() : "Illegal or missing character(s) on line " + this.inTokens.lineno();
    }

    protected void setUnexpectedEOFMsg() {
        this.errorMessage = "Unexpected end-of-file on line " + this.inTokens.lineno();
    }

    protected void setNoOpenBracketMsg() {
        this.errorMessage = "Open bracket ('{') not found on line " + this.inTokens.lineno();
    }

    protected void setNoCloseBracketMsg() {
        this.errorMessage = "Close bracket ('}') not found on line " + this.inTokens.lineno();
    }

    protected void setDupFieldMsg(String fieldName) {
        this.errorMessage = "Duplicate entry for \"" + fieldName + "\" field at line " + this.inTokens.lineno();
    }

    public String getErrorMessage() {
        return this.errorMessage != null ? this.errorMessage : "No error";
    }
}

