/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.CfgFileTokenizer;
import com.isti.util.CfgPropItem;
import com.isti.util.FifoHashtable;
import com.isti.util.UtilFns;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class BaseProperties
implements Map {
    private final Map itemsTable;
    protected String errorMessage = null;
    protected boolean errMsgSetFlag = false;
    private CfgFileTokenizer inTokens;
    protected String loadedCfgFname = null;

    public BaseProperties(Map itemsMap) {
        this.itemsTable = itemsMap == null ? new FifoHashtable() : (itemsMap instanceof BaseProperties ? ((BaseProperties)itemsMap).itemsTable : itemsMap);
    }

    public BaseProperties() {
        this((Map)null);
    }

    public BaseProperties(Vector vec) {
        this();
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof CfgPropItem)) continue;
            this.add((CfgPropItem)obj);
        }
    }

    public BaseProperties(CfgPropItem[] itemsArr) {
        this();
        int p = 0;
        while (p < itemsArr.length) {
            this.add(itemsArr[p]);
            ++p;
        }
    }

    public CfgPropItem add(CfgPropItem item) {
        if (item != null) {
            this.itemsTable.put(item.getName(), item);
        }
        return item;
    }

    public CfgPropItem add(String nameStr, Object valueObj) {
        return this.add(new CfgPropItem(nameStr, valueObj));
    }

    public CfgPropItem add(String nameStr, Object valueObj, boolean requiredFlag) {
        return this.add(new CfgPropItem(nameStr, valueObj, requiredFlag));
    }

    public CfgPropItem remove(String name) {
        Object obj = this.itemsTable.remove(name);
        if (!(obj instanceof CfgPropItem)) {
            return null;
        }
        return (CfgPropItem)obj;
    }

    public CfgPropItem get(String name) {
        Object obj = this.itemsTable.get(name);
        if (!(obj instanceof CfgPropItem)) {
            return null;
        }
        return (CfgPropItem)obj;
    }

    public boolean containsKey(String name) {
        return this.itemsTable.containsKey(name);
    }

    public Enumeration elements() {
        return new Vector(this.itemsTable.values()).elements();
    }

    public Enumeration keys() {
        return new Vector(this.itemsTable.keySet()).elements();
    }

    public void store(OutputStream outStm, String header, boolean skipUnloadedFlag, boolean showHeadersFlag, boolean showCmdLnOnlyFlag, String equalsStr, String newlineStr) throws IOException {
        String specialChars = "\"\r\n\t\\#=";
        PrintWriter out = new PrintWriter(new BufferedOutputStream(outStm));
        if (equalsStr == null || equalsStr.length() <= 0) {
            equalsStr = " = ";
        }
        if (newlineStr != null && newlineStr.length() <= 0) {
            newlineStr = null;
        }
        if (showHeadersFlag) {
            if (header != null && header.length() > 0) {
                out.println("# " + header);
            }
            out.println("# " + new Date());
            out.println();
        }
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            String valStr;
            Object obj = e.nextElement();
            if (!(obj instanceof CfgPropItem)) continue;
            CfgPropItem item = (CfgPropItem)obj;
            if (!showCmdLnOnlyFlag && item.getCmdLnOnlyFlag() || skipUnloadedFlag && !item.getLoadedFlag() || item.getIgnoreItemFlag()) continue;
            if (item.getValue() instanceof Object[]) {
                Object[] valObjArr = (Object[])item.getValue();
                if (valObjArr.length > 0) {
                    StringBuffer buff = new StringBuffer();
                    int i = 0;
                    while (true) {
                        buff.append(valObjArr[i] instanceof String ? "\"" + UtilFns.insertQuoteChars(valObjArr[i].toString(), "\"\r\n\t\\#=") + "\"" : UtilFns.insertQuoteChars(valObjArr[i].toString(), "\"\r\n\t\\#="));
                        if (++i >= valObjArr.length) break;
                        buff.append(", ");
                    }
                    valStr = buff.toString();
                } else {
                    valStr = "";
                }
            } else {
                String string = valStr = item.getValue() instanceof String ? "\"" + UtilFns.insertQuoteChars(item.stringValue(), "\"\r\n\t\\#=") + "\"" : UtilFns.insertQuoteChars(item.stringValue(), "\"\r\n\t\\#=");
            }
            if (newlineStr == null) {
                out.println(item.getName() + equalsStr + valStr);
                continue;
            }
            out.print(item.getName() + equalsStr + valStr + newlineStr);
        }
        if (out.checkError()) {
            throw new IOException();
        }
    }

    public void store(OutputStream outStm, String header, boolean skipUnloadedFlag, boolean showHeadersFlag, boolean showCmdLnOnlyFlag, String equalsStr) throws IOException {
        this.store(outStm, header, skipUnloadedFlag, showHeadersFlag, showCmdLnOnlyFlag, equalsStr, null);
    }

    public void store(OutputStream outStm, String header, boolean skipUnloadedFlag, boolean showHeadersFlag, boolean showCmdLnOnlyFlag) throws IOException {
        this.store(outStm, header, skipUnloadedFlag, showHeadersFlag, showCmdLnOnlyFlag, null, null);
    }

    public void store(OutputStream outStm, String header, boolean skipUnloadedFlag) throws IOException {
        this.store(outStm, header, skipUnloadedFlag, true, false, null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load(InputStream inStm) {
        CfgPropItem itemObj;
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Object e2 = e.nextElement();
            if (!(e2 instanceof CfgPropItem)) continue;
            ((CfgPropItem)e2).setLoadedFlag(false);
        }
        this.inTokens = new CfgFileTokenizer(new InputStreamReader(inStm));
        try {
            int tokenType;
            while ((tokenType = this.inTokens.nextToken()) != -1) {
                void var2_8;
                if (var2_8 == -3) {
                    String nameStr = this.inTokens.getNonNullTokenString();
                    itemObj = this.get(nameStr);
                    if (itemObj != null && !itemObj.getCmdLnOnlyFlag()) {
                        tokenType = this.inTokens.nextToken();
                        if (tokenType != -1) {
                            if (tokenType == 61) {
                                tokenType = this.inTokens.nextToken(true);
                                if (tokenType != -1) {
                                    if (tokenType == -3) {
                                        String valueStr = this.inTokens.getNonNullTokenString();
                                        if (itemObj.getCmdLnLoadedFlag()) continue;
                                        if (itemObj.setValueString(valueStr)) {
                                            itemObj.setLoadedFlag(true);
                                            continue;
                                        }
                                        Object object = itemObj.convertValueString(valueStr);
                                        if (object == null) {
                                            this.setErrorMessage("Error loading \"" + nameStr + "\":  Unable to convert \"" + valueStr + "\" to type " + UtilFns.shortClassString(itemObj.getValueClass()));
                                            continue;
                                        }
                                        if (!itemObj.validateValue(object)) {
                                            this.setErrorMessage("Error loading \"" + nameStr + "\":  Invalid value \"" + valueStr + "\"");
                                            continue;
                                        }
                                        this.setErrorMessage("Error loading \"" + nameStr + "\":  Unable to set value \"" + valueStr + "\"");
                                        continue;
                                    }
                                    this.setIllegalCharMsg(tokenType);
                                    continue;
                                }
                                this.setUnexpectedEOFMsg();
                                break;
                            } else {
                                this.setIllegalCharMsg(tokenType);
                                continue;
                            }
                        }
                        this.setUnexpectedEOFMsg();
                        break;
                    }
                    this.setErrorMessage("Unknown property name:  \"" + nameStr + "\"");
                    continue;
                }
                this.setIllegalCharMsg(tokenType);
            }
        }
        catch (IOException ex) {
            this.setErrorMessage(ex.toString());
        }
        if (!this.errMsgSetFlag) {
            e = this.elements();
            while (e.hasMoreElements()) {
                Object e3 = e.nextElement();
                if (!(e3 instanceof CfgPropItem) || !(itemObj = (CfgPropItem)e3).getRequiredFlag() || itemObj.getLoadedFlag() || itemObj.getCmdLnLoadedFlag() || itemObj.getCmdLnOnlyFlag()) continue;
                this.setErrorMessage("Required item not loaded:  \"" + itemObj.getName() + "\"");
                break;
            }
        }
        if (this.errMsgSetFlag) return false;
        return true;
    }

    public void setLoadedFlags(boolean flgVal) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof CfgPropItem)) continue;
            ((CfgPropItem)obj).setLoadedFlag(flgVal);
        }
    }

    protected void setErrorMessage(String str) {
        if (!this.errMsgSetFlag) {
            this.errorMessage = str;
            this.errMsgSetFlag = true;
        }
    }

    protected void setIllegalCharMsg(int charVal) {
        if (charVal >= 32 && charVal < 127) {
            this.setErrorMessage("Illegal character '" + (char)charVal + "' on line " + this.inTokens.lineno());
        } else {
            this.setErrorMessage("Illegal or missing character(s) on line " + this.inTokens.lineno());
        }
    }

    protected void setUnexpectedEOFMsg() {
        this.setErrorMessage("Unexpected end-of-file on line " + this.inTokens.lineno());
    }

    public String getErrorMessage() {
        this.errMsgSetFlag = false;
        return this.errorMessage != null ? this.errorMessage : "No error";
    }

    public String getLoadedCfgFname() {
        return this.loadedCfgFname;
    }

    public String getDisplayString() {
        ByteArrayOutputStream byteStm = new ByteArrayOutputStream();
        try {
            this.store(byteStm, "", false, false, false);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String retStr = byteStm.toString();
        int len = retStr.length();
        while (len > 1 && Character.isWhitespace(retStr.charAt(len - 1))) {
            --len;
        }
        return retStr.substring(0, len);
    }

    public int size() {
        return this.itemsTable.size();
    }

    public boolean isEmpty() {
        return this.itemsTable.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.itemsTable.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.itemsTable.containsValue(value);
    }

    public Object get(Object key) {
        return this.itemsTable.get(key);
    }

    public Object put(Object key, Object value) {
        if (value instanceof CfgPropItem) {
            return this.add((CfgPropItem)value);
        }
        return this.add(new CfgPropItem(key.toString(), value));
    }

    public Object remove(Object key) {
        return this.itemsTable.remove(key);
    }

    public void putAll(Map t) {
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.itemsTable.clear();
    }

    public void setAllToDefaults() {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof CfgPropItem)) continue;
            CfgPropItem propObj = (CfgPropItem)obj;
            propObj.setValue(propObj.getDefaultValue());
        }
    }

    public Set keySet() {
        return this.itemsTable.keySet();
    }

    public Collection values() {
        return this.itemsTable.values();
    }

    public Set entrySet() {
        return this.itemsTable.entrySet();
    }

    public boolean equals(Object o) {
        return this.itemsTable.equals(o);
    }

    public int hashCode() {
        return this.itemsTable.hashCode();
    }
}

