/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

public class Averager {
    private final long[] valuesArray;
    private final int windowSize;
    private long valuesTotal;
    private int valuesCount;
    private int valuesPos;

    public Averager(int windowSize) {
        if (windowSize <= 0) {
            throw new RuntimeException("Parameter 'windowSize' must be greater than zero");
        }
        this.windowSize = windowSize;
        this.valuesArray = new long[windowSize];
        this.clear();
    }

    public void clear() {
        int p = 0;
        while (p < this.windowSize) {
            this.valuesArray[p] = 0L;
            ++p;
        }
        this.valuesTotal = 0L;
        this.valuesPos = 0;
        this.valuesCount = 0;
    }

    public long enter(long val) {
        this.valuesTotal -= this.valuesArray[this.valuesPos];
        this.valuesArray[this.valuesPos] = val;
        this.valuesTotal += this.valuesArray[this.valuesPos];
        if (++this.valuesPos >= this.windowSize) {
            this.valuesPos = 0;
        }
        if (this.valuesCount < this.windowSize) {
            ++this.valuesCount;
        }
        return this.getAverage();
    }

    public long getAverage() {
        return this.valuesCount > 0 ? this.valuesTotal / (long)this.valuesCount : 0L;
    }
}

