/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.Archivable;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class ArchiveManager {
    protected final Constructor archivedClassConstructor;
    protected final String archiveRootDirName;
    protected final String archiveFileNameStr;
    protected OutputStream archiveOutStm = null;
    protected final Object archiveOutStmSyncObj = new Object();
    protected boolean archiveClosedFlag = false;
    protected String archivedItemDelimiter = "\n";
    protected boolean assumeNewlineFlag = true;
    protected boolean purgeIntoArchiveFlag = true;
    protected String archivedFormPrefixStr = null;
    protected final Object archiveAccessSyncObj = new Object();
    protected Vector filesForDateRangeVec = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$isti$util$Archivable$Marker;

    public ArchiveManager(Class classObj, String archiveRootDirName, String archiveFileNameStr) throws NoSuchMethodException {
        this.archiveRootDirName = archiveRootDirName;
        this.archiveFileNameStr = archiveFileNameStr;
        this.archivedClassConstructor = classObj.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ArchiveManager.class$("java.lang.String")) : class$java$lang$String, class$com$isti$util$Archivable$Marker == null ? (class$com$isti$util$Archivable$Marker = ArchiveManager.class$("com.isti.util.Archivable$Marker")) : class$com$isti$util$Archivable$Marker);
        if (archiveRootDirName != null) {
            new File(archiveRootDirName).mkdirs();
        }
    }

    public ArchiveManager(Class classObj, String archiveFileNameStr) throws NoSuchMethodException {
        this(classObj, null, archiveFileNameStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPurgeIntoArchiveFlag(boolean flgVal) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.purgeIntoArchiveFlag = flgVal;
        }
    }

    public boolean getPurgeIntoArchiveFlag() {
        return this.purgeIntoArchiveFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArchivedItemDelimiter(String str) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.archivedItemDelimiter = str != null ? str : "\n";
            this.assumeNewlineFlag = this.archivedItemDelimiter.equals("\n");
        }
    }

    public String getArchivedItemDelimiter() {
        return this.archivedItemDelimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setArchivedFormPrefixStr(String str) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            this.archivedFormPrefixStr = str != null && str.length() > 0 ? str : null;
        }
    }

    public String getArchivedFormPrefixStr() {
        return this.archivedFormPrefixStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void archiveItem(Archivable item) throws IOException {
        if (!this.archiveClosedFlag) {
            Object object = this.archiveAccessSyncObj;
            synchronized (object) {
                OutputStream outStm = this.getOutputStreamForItem(item);
                this.writeItemToFile(item, outStm);
                outStm.flush();
            }
        }
    }

    protected void writeItemToFile(Archivable item, OutputStream outStm) throws IOException {
        outStm.write(item.toArchivedForm().getBytes());
        outStm.write(this.archivedItemDelimiter.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void processArchivedItems(Date startDate, Date endDate, ProcessCallBack callBackObj) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            Enumeration inputFiles = this.getArchiveFilesForDateRange(startDate, endDate).elements();
            BufferedReader rdrObj = null;
            boolean firstFileFlag = true;
            boolean moreElementsFlag = inputFiles.hasMoreElements();
            while (!this.archiveClosedFlag && moreElementsFlag) {
                String itemDataStr;
                BufferedInputStream inStmObj;
                try {
                    inStmObj = new BufferedInputStream(new FileInputStream((File)inputFiles.nextElement()));
                }
                catch (FileNotFoundException e) {
                    inStmObj = null;
                }
                moreElementsFlag = inputFiles.hasMoreElements();
                if (inStmObj == null) continue;
                if (this.assumeNewlineFlag) {
                    rdrObj = new BufferedReader(new InputStreamReader(inStmObj));
                }
                while (!this.archiveClosedFlag && (itemDataStr = this.assumeNewlineFlag ? this.getNextLineFromFile(rdrObj) : this.getNextItemDataFromFile(inStmObj)) != null) {
                    void var6_9;
                    Archivable itemObj = this.convertStringToArchivable((String)var6_9);
                    if (itemObj == null) continue;
                    if (!moreElementsFlag && endDate != null && itemObj.getArchiveDate().after(endDate)) break;
                    if (firstFileFlag) {
                        firstFileFlag = false;
                        if (startDate != null && itemObj.getArchiveDate().before(startDate)) continue;
                    }
                    if (!callBackObj.procArchivedItem(itemObj, (String)var6_9)) break;
                }
                try {
                    ((InputStream)inStmObj).close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
    }

    public Enumeration getArchivedItems(Date startDate, Date endDate) {
        final Vector retVec = new Vector();
        this.processArchivedItems(startDate, endDate, new ProcessCallBack(){

            public boolean procArchivedItem(Archivable itemObj, String archivedFormStr) {
                retVec.add(itemObj);
                return true;
            }
        });
        return retVec.elements();
    }

    protected String getNextItemDataFromFile(InputStream stmObj) {
        int itemSizeVal;
        StringBuffer archivedFormBuff = new StringBuffer();
        try {
            do {
                int val;
                if ((val = stmObj.read()) < 0) {
                    return null;
                }
                archivedFormBuff.append((char)val);
            } while ((itemSizeVal = archivedFormBuff.length() - this.archivedItemDelimiter.length()) < 0 || !this.archivedItemDelimiter.equals(archivedFormBuff.substring(itemSizeVal)));
        }
        catch (Exception ex) {
            return null;
        }
        return archivedFormBuff.substring(0, itemSizeVal);
    }

    protected String getNextLineFromFile(BufferedReader rdrObj) {
        try {
            return rdrObj.readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected Archivable convertStringToArchivable(String str) {
        if (str != null && (str = str.trim()).length() > 0) {
            int p;
            if (this.archivedFormPrefixStr != null) {
                p = str.indexOf(this.archivedFormPrefixStr);
                if (p < 0) {
                    return null;
                }
            } else {
                p = 0;
            }
            try {
                return (Archivable)this.archivedClassConstructor.newInstance(str.substring(p), null);
            }
            catch (Exception ex) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean purgeArchive(Date cutoffDate) {
        Object object = this.archiveAccessSyncObj;
        synchronized (object) {
            boolean retFlag = true;
            File cutoffFileObj = this.getArchiveFileForName(this.getArchiveFileNameForDate(cutoffDate));
            if (!cutoffFileObj.exists()) {
                cutoffFileObj = null;
            }
            BufferedReader rdrObj = null;
            Enumeration e = this.getArchiveFilesForDateRange(null, cutoffDate).elements();
            boolean moreElementsFlag = e.hasMoreElements();
            while (moreElementsFlag) {
                File inFileObj = (File)e.nextElement();
                moreElementsFlag = e.hasMoreElements();
                if (!moreElementsFlag && cutoffFileObj != null && cutoffFileObj.equals(inFileObj)) {
                    if (!this.purgeIntoArchiveFlag) continue;
                    try {
                        String itemDataStr;
                        File tmpFileObj = this.getArchiveFileForName("t" + System.currentTimeMillis() + ".tmp");
                        BufferedOutputStream outStmObj = new BufferedOutputStream(new FileOutputStream(tmpFileObj));
                        BufferedInputStream inStmObj = new BufferedInputStream(new FileInputStream(inFileObj));
                        if (this.assumeNewlineFlag) {
                            rdrObj = new BufferedReader(new InputStreamReader(inStmObj));
                        }
                        boolean skippedFlag = false;
                        while ((itemDataStr = this.assumeNewlineFlag ? this.getNextLineFromFile(rdrObj) : this.getNextItemDataFromFile(inStmObj)) != null) {
                            void var6_9;
                            Archivable itemObj = this.convertStringToArchivable((String)var6_9);
                            if (itemObj == null) continue;
                            if (!itemObj.getArchiveDate().before(cutoffDate)) {
                                this.writeItemToFile(itemObj, outStmObj);
                                continue;
                            }
                            skippedFlag = true;
                        }
                        try {
                            ((OutputStream)outStmObj).flush();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        try {
                            ((OutputStream)outStmObj).close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        try {
                            ((InputStream)inStmObj).close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                        if (skippedFlag) {
                            File fileObj = new File(inFileObj.getAbsolutePath());
                            inFileObj.delete();
                            tmpFileObj.renameTo(fileObj);
                            continue;
                        }
                        tmpFileObj.delete();
                        continue;
                    }
                    catch (Exception ex) {
                        retFlag = false;
                        break;
                    }
                }
                try {
                    inFileObj.delete();
                }
                catch (Exception ex) {
                    retFlag = false;
                    break;
                }
            }
            return retFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeArchive() {
        this.archiveClosedFlag = true;
        Object object = this.archiveOutStmSyncObj;
        synchronized (object) {
            if (this.archiveOutStm != null) {
                try {
                    this.archiveOutStm.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.archiveOutStm = null;
            }
        }
    }

    public boolean isArchiveClosed() {
        return this.archiveClosedFlag;
    }

    public File getNewestArchiveFile() {
        int i;
        Vector vec = this.getArchiveFilesForDateRange(null, null);
        if (vec != null && (i = vec.size()) > 0) {
            do {
                Object obj;
                if (!((obj = vec.elementAt(--i)) instanceof File)) continue;
                return (File)obj;
            } while (i > 0);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Archivable getNewestItemInArchiveFile(File fileObj) {
        String itemDataStr;
        BufferedInputStream inStmObj;
        if (fileObj == null) {
            return null;
        }
        int bufferSize = 25;
        String[] buff = new String[25];
        int pos = 0;
        int itemCount = 0;
        Archivable itemObj = null;
        try {
            inStmObj = new BufferedInputStream(new FileInputStream(fileObj));
        }
        catch (Exception ex) {
            return null;
        }
        BufferedReader rdrObj = null;
        if (this.assumeNewlineFlag) {
            rdrObj = new BufferedReader(new InputStreamReader(inStmObj));
        }
        while ((itemDataStr = this.assumeNewlineFlag ? this.getNextLineFromFile(rdrObj) : this.getNextItemDataFromFile(inStmObj)) != null) {
            void var6_10;
            if (this.archivedFormPrefixStr != null && var6_10.indexOf(this.archivedFormPrefixStr) < 0) continue;
            buff[pos] = var6_10;
            if (++pos >= 25) {
                pos = 0;
            }
            ++itemCount;
        }
        if (itemCount > 25) {
            itemCount = 25;
        }
        while (--itemCount > 0) {
            if (--pos < 0) {
                pos = 24;
            }
            if ((itemObj = this.convertStringToArchivable(buff[pos])) != null) break;
        }
        return itemObj;
    }

    public Archivable getNewestItemInEntireArchive() {
        return this.getNewestItemInArchiveFile(this.getNewestArchiveFile());
    }

    protected Vector getArchiveFilesForDateRange(Date startDate, Date endDate) {
        if (this.filesForDateRangeVec == null) {
            this.filesForDateRangeVec = new Vector();
            this.filesForDateRangeVec.add(this.getArchiveFileForName(this.archiveFileNameStr));
        }
        return this.filesForDateRangeVec;
    }

    protected String getArchiveFileNameForDate(Date dateObj) {
        return this.archiveFileNameStr;
    }

    protected File getArchiveFileForName(String fNameStr) {
        return new File(this.archiveRootDirName, fNameStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream getOutputStreamForItem(Archivable item) throws IOException {
        Object object = this.archiveOutStmSyncObj;
        synchronized (object) {
            if (this.archiveOutStm == null) {
                this.archiveOutStm = new BufferedOutputStream(new FileOutputStream(this.getArchiveFileForName(this.archiveFileNameStr).getPath(), true));
            }
            return this.archiveOutStm;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ProcessCallBack {
        public boolean procArchivedItem(Archivable var1, String var2);
    }
}

