/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedRef;
import EDU.oswego.cs.dl.util.concurrent.WaitableInt;
import EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.PCTestLoop;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;
import EDU.oswego.cs.dl.util.concurrent.misc.SynchronizationTimer;
import EDU.oswego.cs.dl.util.concurrent.misc.TestLoop;
import EDU.oswego.cs.dl.util.concurrent.misc.Threads;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class SynchronizationTimer {
    static final int[] nthreadsChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    static final int BLOCK_MODE = 0;
    static final int TIMEOUT_MODE = 1;
    static final int[] syncModes = new int[]{0, 1};
    static final int PRECISION = 10;
    static final int headerRows = 1;
    static final int classColumn = 0;
    static final int headerColumns = 1;
    final ThreadInfo[] threadInfo = new ThreadInfo[nthreadsChoices.length];
    final int tableRows = TestedClass.classes.length + 1;
    final int tableColumns = nthreadsChoices.length + 1;
    final JComponent[][] resultTable_ = new JComponent[this.tableRows][this.tableColumns];
    final SynchronizedInt nextClassIdx_ = new SynchronizedInt(0);
    final SynchronizedInt nextThreadIdx_ = new SynchronizedInt(0);
    ClockDaemon timeDaemon = new ClockDaemon();
    private final SynchronizedRef contention_ = new SynchronizedRef(null);
    private final SynchronizedInt loopsPerTest_ = new SynchronizedInt(0);
    private final SynchronizedBoolean echoToSystemOut = new SynchronizedBoolean(false);
    private final JButton startstop_ = new JButton("Start");
    private WaitableInt testNumber_ = new WaitableInt(1);
    private SynchronizedBoolean running_ = new SynchronizedBoolean(false);
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$AClongRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$SemRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$FifoRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$MutexRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$RlockRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$LinkedQueue;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$WaitFreeQueue;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$BoundedBuffer;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$CVBuffer;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$Slot;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$SynchronousChannel;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Times per call in microseconds");
        jFrame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        jFrame.getContentPane().add(new SynchronizationTimer().mainPanel());
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    static String modeToString(int n) {
        String string = n == 0 ? "block" : (n == 1 ? "timeout" : "No such mode");
        return string;
    }

    static String biasToString(int n) {
        String string = n < 0 ? "slower producer" : (n == 0 ? "balanced prod/cons rate" : (n > 0 ? "slower consumer" : "No such bias"));
        return string;
    }

    static String p2ToString(int n) {
        String string = "";
        if (n >= 1024) {
            string = "K";
            if ((n /= 1024) >= 1024) {
                n /= 1024;
                string = "M";
            }
        }
        return n + string;
    }

    static String formatTime(long l, boolean bl) {
        long l2 = l / 10L;
        long l3 = l % 10L;
        if (!bl) {
            if (l3 >= 5L) {
                ++l2;
            }
            return Long.toString(l2);
        }
        String string = Long.toString(l2);
        String string2 = Long.toString(l3);
        if (l3 == 0L) {
            int n = 10;
            while (n > 10) {
                string2 = "0" + string2;
                n /= 10;
            }
        }
        String string3 = string + "." + string2;
        return string3;
    }

    boolean threadEnabled(int n) {
        return this.threadInfo[n].getEnabled();
    }

    JPanel resultPanel() {
        JCheckBox jCheckBox;
        int n;
        JPanel[] jPanelArray = new JPanel[this.tableColumns];
        int n2 = 0;
        while (n2 < this.tableColumns) {
            jPanelArray[n2] = new JPanel();
            jPanelArray[n2].setLayout(new GridLayout(this.tableRows, 1));
            if (n2 != 0) {
                jPanelArray[n2].setBackground(Color.white);
            }
            ++n2;
        }
        Color color = jPanelArray[0].getBackground();
        LineBorder lineBorder = new LineBorder(color);
        Font font = new Font("Dialog", 0, 12);
        Dimension dimension = new Dimension(40, 16);
        Dimension dimension2 = new Dimension(154, 16);
        JLabel jLabel = new JLabel(" Classes      \\      Threads");
        jLabel.setMinimumSize(dimension2);
        jLabel.setPreferredSize(dimension2);
        jLabel.setFont(font);
        this.resultTable_[0][0] = jLabel;
        jPanelArray[0].add(jLabel);
        int n3 = 1;
        while (n3 < this.tableColumns) {
            n = n3 - 1;
            jCheckBox = new JCheckBox(this.threadInfo[n].name, true);
            jCheckBox.addActionListener(new ActionListener(this, n){
                private final /* synthetic */ SynchronizationTimer this$0;
                private final /* synthetic */ int val$nthreads;

                public final void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.threadInfo[this.val$nthreads].toggleEnabled();
                }
                {
                    this.val$nthreads = n;
                    this.this$0 = synchronizationTimer;
                    this.constructor$0(synchronizationTimer);
                }

                private final void constructor$0(SynchronizationTimer synchronizationTimer) {
                }
            });
            jCheckBox.setMinimumSize(dimension);
            jCheckBox.setPreferredSize(dimension);
            jCheckBox.setFont(font);
            jCheckBox.setBackground(color);
            this.resultTable_[0][n3] = jCheckBox;
            jPanelArray[n3].add(jCheckBox);
            ++n3;
        }
        n3 = 1;
        while (n3 < this.tableRows) {
            n = n3 - 1;
            jCheckBox = new JCheckBox(TestedClass.classes[n].name, true);
            jCheckBox.addActionListener(new ActionListener(this, n){
                private final /* synthetic */ SynchronizationTimer this$0;
                private final /* synthetic */ int val$cls;

                public final void actionPerformed(ActionEvent actionEvent) {
                    TestedClass.classes[this.val$cls].toggleEnabled();
                }
                {
                    this.val$cls = n;
                    this.this$0 = synchronizationTimer;
                    this.constructor$0(synchronizationTimer);
                }

                private final void constructor$0(SynchronizationTimer synchronizationTimer) {
                }
            });
            this.resultTable_[n3][0] = jCheckBox;
            jCheckBox.setMinimumSize(dimension2);
            jCheckBox.setPreferredSize(dimension2);
            jCheckBox.setFont(font);
            jPanelArray[0].add(jCheckBox);
            int n4 = 1;
            while (n4 < this.tableColumns) {
                int n5 = n4 - 1;
                JLabel jLabel2 = new JLabel("");
                this.resultTable_[n3][n4] = jLabel2;
                jLabel2.setMinimumSize(dimension);
                jLabel2.setPreferredSize(dimension);
                jLabel2.setBorder(lineBorder);
                jLabel2.setFont(font);
                jLabel2.setBackground(Color.white);
                jLabel2.setForeground(Color.black);
                jLabel2.setHorizontalAlignment(4);
                jPanelArray[n4].add(jLabel2);
                ++n4;
            }
            ++n3;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        n = 0;
        while (n < this.tableColumns) {
            jPanel.add(jPanelArray[n]);
            ++n;
        }
        return jPanel;
    }

    void setTime(long l, int n, int n2) {
        int n3 = n + 1;
        int n4 = n2 + 1;
        JLabel jLabel = (JLabel)this.resultTable_[n3][n4];
        SwingUtilities.invokeLater(new Runnable(this, l, jLabel){
            private final /* synthetic */ SynchronizationTimer this$0;
            private final /* synthetic */ long val$ns;
            private final /* synthetic */ JLabel val$cell;

            public final void run() {
                this.val$cell.setText(SynchronizationTimer.formatTime(this.val$ns, true));
            }
            {
                this.val$ns = l;
                this.val$cell = jLabel;
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
    }

    void clearTable() {
        int n = 1;
        while (n < this.tableRows) {
            int n2 = 1;
            while (n2 < this.tableColumns) {
                ((JLabel)this.resultTable_[n][n2]).setText("");
                ++n2;
            }
            ++n;
        }
    }

    void setChecks(boolean bl) {
        int n = 0;
        while (n < TestedClass.classes.length) {
            TestedClass.classes[n].setEnabled(new Boolean(bl));
            ((JCheckBox)this.resultTable_[n + 1][0]).setSelected(bl);
            ++n;
        }
    }

    JPanel mainPanel() {
        new PrintStart();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3));
        this.startstop_.addActionListener(new ActionListener(this){
            private final /* synthetic */ SynchronizationTimer this$0;

            public final void actionPerformed(ActionEvent actionEvent) {
                if (SynchronizationTimer.access$60(this.this$0).get()) {
                    this.this$0.cancel();
                } else {
                    try {
                        SynchronizationTimer synchronizationTimer = this.this$0;
                        if (synchronizationTimer == null) {
                            throw null;
                        }
                        this.this$0.startTestSeries(synchronizationTimer.new TestSeries());
                    }
                    catch (InterruptedException interruptedException) {
                        this.this$0.endTestSeries();
                    }
                }
            }
            {
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        jPanel.add(this.startstop_);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("Continue");
        jButton.addActionListener(new ActionListener(this){
            private final /* synthetic */ SynchronizationTimer this$0;

            public final void actionPerformed(ActionEvent actionEvent) {
                if (!SynchronizationTimer.access$60(this.this$0).get()) {
                    try {
                        SynchronizationTimer synchronizationTimer = this.this$0;
                        if (synchronizationTimer == null) {
                            throw null;
                        }
                        this.this$0.startTestSeries(synchronizationTimer.new TestSeries(this.this$0.nextClassIdx_.get(), this.this$0.nextThreadIdx_.get()));
                    }
                    catch (InterruptedException interruptedException) {
                        this.this$0.endTestSeries();
                    }
                }
            }
            {
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("Clear cells");
        jButton2.addActionListener(new ActionListener(this){
            private final /* synthetic */ SynchronizationTimer this$0;

            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.clearTable();
            }
            {
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        jPanel3.add(jButton2);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        JButton jButton3 = new JButton("All classes");
        jButton3.addActionListener(new ActionListener(this){
            private final /* synthetic */ SynchronizationTimer this$0;

            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.setChecks(true);
            }
            {
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        jPanel4.add(jButton3);
        JButton jButton4 = new JButton("No classes");
        jButton4.addActionListener(new ActionListener(this){
            private final /* synthetic */ SynchronizationTimer this$0;

            public final void actionPerformed(ActionEvent actionEvent) {
                this.this$0.setChecks(false);
            }
            {
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        jPanel4.add(jButton4);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JCheckBox jCheckBox = new JCheckBox("Console echo");
        jCheckBox.addItemListener(new ItemListener(this){
            private final /* synthetic */ SynchronizationTimer this$0;

            public final void itemStateChanged(ItemEvent itemEvent) {
                SynchronizationTimer.access$61(this.this$0).complement();
            }
            {
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        JLabel jLabel = new JLabel("Active threads:      0");
        jPanel5.add(jLabel);
        jPanel5.add(jCheckBox);
        jPanel.add(jPanel5);
        jPanel.add(this.contentionBox());
        jPanel.add(this.itersBox());
        jPanel.add(this.cloopBox());
        jPanel.add(this.barrierBox());
        jPanel.add(this.exchangeBox());
        jPanel.add(this.biasBox());
        jPanel.add(this.capacityBox());
        jPanel.add(this.timeoutBox());
        jPanel.add(this.syncModePanel());
        jPanel.add(this.producerSyncModePanel());
        jPanel.add(this.consumerSyncModePanel());
        this.startPoolStatus(jLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JPanel jPanel7 = this.resultPanel();
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel);
        return jPanel6;
    }

    JComboBox syncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < syncModes.length) {
            String string = "Locks: " + SynchronizationTimer.modeToString(syncModes[n]);
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this){
            private final /* synthetic */ SynchronizationTimer this$0;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.syncMode.set(syncModes[n]);
            }
            {
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        RNG.syncMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox producerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < syncModes.length) {
            String string = "Producers: " + SynchronizationTimer.modeToString(syncModes[n]);
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this){
            private final /* synthetic */ SynchronizationTimer this$0;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.producerMode.set(syncModes[n]);
            }
            {
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        RNG.producerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox consumerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < syncModes.length) {
            String string = "Consumers: " + SynchronizationTimer.modeToString(syncModes[n]);
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this){
            private final /* synthetic */ SynchronizationTimer this$0;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.consumerMode.set(syncModes[n]);
            }
            {
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        RNG.consumerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox contentionBox() {
        Fraction[] fractionArray = new Fraction[]{new Fraction(0L, 1L), new Fraction(1L, 16L), new Fraction(1L, 8L), new Fraction(1L, 4L), new Fraction(1L, 2L), new Fraction(1L, 1L)};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < fractionArray.length) {
            String string = fractionArray[n].asDouble() * 100.0 + "% contention/sharing";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this, fractionArray){
            private final /* synthetic */ SynchronizationTimer this$0;
            private final /* synthetic */ Fraction[] val$contentionChoices;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                SynchronizationTimer.access$62(this.this$0).set(this.val$contentionChoices[n]);
            }
            {
                this.val$contentionChoices = fractionArray;
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        this.contention_.set(fractionArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox itersBox() {
        int[] nArray = new int[]{1, 16, 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " calls per thread per test";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this, nArray){
            private final /* synthetic */ SynchronizationTimer this$0;
            private final /* synthetic */ int[] val$loopsPerTestChoices;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                SynchronizationTimer.access$63(this.this$0).set(this.val$loopsPerTestChoices[n]);
            }
            {
                this.val$loopsPerTestChoices = nArray;
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        this.loopsPerTest_.set(nArray[8]);
        jComboBox.setSelectedIndex(8);
        return jComboBox;
    }

    JComboBox cloopBox() {
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " computations per call";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this, nArray){
            private final /* synthetic */ SynchronizationTimer this$0;
            private final /* synthetic */ int[] val$computationsPerCallChoices;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.computeLoops.set(this.val$computationsPerCallChoices[n]);
            }
            {
                this.val$computationsPerCallChoices = nArray;
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        RNG.computeLoops.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox barrierBox() {
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " iterations per barrier";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this, nArray){
            private final /* synthetic */ SynchronizationTimer this$0;
            private final /* synthetic */ int[] val$itersPerBarrierChoices;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.itersPerBarrier.set(this.val$itersPerBarrierChoices[n]);
            }
            {
                this.val$itersPerBarrierChoices = nArray;
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        RNG.itersPerBarrier.set(nArray[13]);
        jComboBox.setSelectedIndex(13);
        return jComboBox;
    }

    JComboBox exchangeBox() {
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " max threads per barrier";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this, nArray){
            private final /* synthetic */ SynchronizationTimer this$0;
            private final /* synthetic */ int[] val$exchangerChoices;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.exchangeParties.set(this.val$exchangerChoices[n]);
            }
            {
                this.val$exchangerChoices = nArray;
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        RNG.exchangeParties.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox biasBox() {
        int[] nArray = new int[]{-1, 0, 1};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.biasToString(nArray[n]);
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this, nArray){
            private final /* synthetic */ SynchronizationTimer this$0;
            private final /* synthetic */ int[] val$biasChoices;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.bias.set(this.val$biasChoices[n]);
            }
            {
                this.val$biasChoices = nArray;
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        RNG.bias.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox capacityBox() {
        int[] nArray = new int[]{1, 4, 64, 256, 1024, 4096, 16384, 65536, 262144, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < nArray.length) {
            String string = SynchronizationTimer.p2ToString(nArray[n]) + " element bounded buffers";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this, nArray){
            private final /* synthetic */ SynchronizationTimer this$0;
            private final /* synthetic */ int[] val$bufferCapacityChoices;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                DefaultChannelCapacity.set(this.val$bufferCapacityChoices[n]);
            }
            {
                this.val$bufferCapacityChoices = nArray;
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        DefaultChannelCapacity.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox timeoutBox() {
        long[] lArray = new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 100000L};
        JComboBox<String> jComboBox = new JComboBox<String>();
        int n = 0;
        while (n < lArray.length) {
            String string = lArray[n] + " msec timeouts";
            jComboBox.addItem(string);
            ++n;
        }
        jComboBox.addItemListener(new ItemListener(this, lArray){
            private final /* synthetic */ SynchronizationTimer this$0;
            private final /* synthetic */ long[] val$timeoutChoices;

            public final void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n = jComboBox.getSelectedIndex();
                RNG.timeout.set(this.val$timeoutChoices[n]);
            }
            {
                this.val$timeoutChoices = lArray;
                this.this$0 = synchronizationTimer;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        });
        RNG.timeout.set(lArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    void startPoolStatus(JLabel jLabel) {
        Runnable runnable = new Runnable(this, jLabel){
            int lastps;
            private final /* synthetic */ SynchronizationTimer this$0;
            private /* synthetic */ JLabel val$status;

            public final void run() {
                int n = Threads.activeThreads.get();
                if (this.lastps != n) {
                    this.lastps = n;
                    SwingUtilities.invokeLater(new Runnable(this, n, this.val$status){
                        private final /* synthetic */ 22 this$0;
                        private final /* synthetic */ int val$ps;
                        private final /* synthetic */ JLabel val$status;

                        public final void run() {
                            this.val$status.setText("Active threads: " + this.val$ps);
                        }
                        {
                            this.val$ps = n;
                            this.val$status = jLabel;
                            this.this$0 = var1_1;
                            this.constructor$0(var1_1);
                        }

                        private final void constructor$0(22 var1_1) {
                        }
                    });
                }
            }
            {
                this.val$status = jLabel;
                this.this$0 = synchronizationTimer;
                this.lastps = 0;
                this.constructor$0(synchronizationTimer);
            }

            private final void constructor$0(SynchronizationTimer synchronizationTimer) {
            }
        };
        this.timeDaemon.executePeriodically(250L, runnable, false);
    }

    private final void runOneTest(Runnable runnable) throws InterruptedException {
        int n = this.testNumber_.get();
        Threads.pool.execute(runnable);
        this.testNumber_.whenNotEqual(n, null);
    }

    private final void endOneTest() {
        this.testNumber_.increment();
    }

    void cancel() {
        Object object = RNG.constructionLock;
        synchronized (object) {
            try {
                Threads.pool.interruptAll();
            }
            catch (Exception exception) {
                System.out.println("\nException during cancel:\n" + exception);
                return;
            }
        }
    }

    void startTestSeries(Runnable runnable) throws InterruptedException {
        this.running_.set(true);
        this.startstop_.setText("Stop");
        Threads.pool.execute(runnable);
    }

    void endTestSeries() {
        this.running_.set(false);
        SwingUtilities.invokeLater(new PrintStart());
    }

    static /* synthetic */ SynchronizedBoolean access$60(SynchronizationTimer synchronizationTimer) {
        return synchronizationTimer.running_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SynchronizationTimer() {
        int n = 0;
        while (n < this.threadInfo.length) {
            this.threadInfo[n] = new ThreadInfo(nthreadsChoices[n]);
            ++n;
        }
    }

    static class TestedClass {
        static final TestedClass dummy;
        static final TestedClass[] classes;
        final String name;
        final Class cls;
        final boolean multipleOK;
        final boolean singleOK;
        final Class buffCls;
        Boolean enabled_ = new Boolean(true);

        synchronized void setEnabled(Boolean bl) {
            this.enabled_ = bl;
        }

        synchronized Boolean getEnabled() {
            return this.enabled_;
        }

        synchronized void toggleEnabled() {
            boolean bl = this.enabled_;
            this.enabled_ = new Boolean(!bl);
        }

        synchronized boolean isEnabled(int n, Fraction fraction) {
            boolean bl = this.enabled_;
            if (!bl) {
                return false;
            }
            if (!this.singleOK && n <= 1) {
                return false;
            }
            return this.multipleOK || n <= 1 || fraction.compareTo(0L) <= 0;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = null;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2, Class clazz2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = clazz2;
        }

        static {
            Class clazz;
            Class clazz2;
            Class clazz3;
            Class clazz4;
            Class clazz5;
            Class clazz6;
            Class clazz7;
            Class clazz8;
            Class clazz9;
            Class clazz10;
            Class clazz11;
            Class clazz12;
            Class clazz13;
            Class clazz14;
            Class clazz15;
            Class clazz16;
            Class clazz17;
            Class clazz18;
            Class clazz19;
            Class clazz20;
            Class clazz21;
            Class clazz22;
            Class clazz23;
            Class clazz24;
            Class clazz25;
            Class clazz26;
            Class clazz27;
            Class clazz28;
            Class clazz29;
            Class clazz30;
            Class clazz31;
            Class clazz32;
            Class clazz33;
            Class clazz34;
            Class clazz35;
            Class clazz36;
            Class clazz37;
            dummy = new TestedClass("", null, false, false);
            TestedClass[] testedClassArray = new TestedClass[29];
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG != null) {
                clazz37 = class$LEDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG;
            } else {
                Class clazz38 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.NoSynchRNG");
                clazz37 = clazz38;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG = clazz38;
            }
            testedClassArray[0] = new TestedClass("NoSynchronization", clazz37, false, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG != null) {
                clazz36 = class$LEDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG;
            } else {
                Class clazz39 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PublicSynchRNG");
                clazz36 = clazz39;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG = clazz39;
            }
            testedClassArray[1] = new TestedClass("PublicSynchronization", clazz36, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG != null) {
                clazz35 = class$LEDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG;
            } else {
                Class clazz40 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.AllSynchRNG");
                clazz35 = clazz40;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG = clazz40;
            }
            testedClassArray[2] = new TestedClass("NestedSynchronization", clazz35, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG != null) {
                clazz34 = class$LEDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG;
            } else {
                Class clazz41 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SDelegatedRNG");
                clazz34 = clazz41;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG = clazz41;
            }
            testedClassArray[3] = new TestedClass("SDelegated", clazz34, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG != null) {
                clazz33 = class$LEDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG;
            } else {
                Class clazz42 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SynchLongRNG");
                clazz33 = clazz42;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG = clazz42;
            }
            testedClassArray[4] = new TestedClass("SynchLongUsingSet", clazz33, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$AClongRNG != null) {
                clazz32 = class$LEDU$oswego$cs$dl$util$concurrent$misc$AClongRNG;
            } else {
                Class clazz43 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.AClongRNG");
                clazz32 = clazz43;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$AClongRNG = clazz43;
            }
            testedClassArray[5] = new TestedClass("SynchLongUsingCommit", clazz32, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$SemRNG != null) {
                clazz31 = class$LEDU$oswego$cs$dl$util$concurrent$misc$SemRNG;
            } else {
                Class clazz44 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SemRNG");
                clazz31 = clazz44;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$SemRNG = clazz44;
            }
            testedClassArray[6] = new TestedClass("Semaphore", clazz31, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG != null) {
                clazz30 = class$LEDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG;
            } else {
                Class clazz45 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.WpSemRNG");
                clazz30 = clazz45;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG = clazz45;
            }
            testedClassArray[7] = new TestedClass("WaiterPrefSemaphore", clazz30, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$FifoRNG != null) {
                clazz29 = class$LEDU$oswego$cs$dl$util$concurrent$misc$FifoRNG;
            } else {
                Class clazz46 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.FifoRNG");
                clazz29 = clazz46;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$FifoRNG = clazz46;
            }
            testedClassArray[8] = new TestedClass("FIFOSemaphore", clazz29, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG != null) {
                clazz28 = class$LEDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG;
            } else {
                Class clazz47 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG");
                clazz28 = clazz47;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG = clazz47;
            }
            testedClassArray[9] = new TestedClass("PrioritySemaphore", clazz28, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$MutexRNG != null) {
                clazz27 = class$LEDU$oswego$cs$dl$util$concurrent$misc$MutexRNG;
            } else {
                Class clazz48 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.MutexRNG");
                clazz27 = clazz48;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$MutexRNG = clazz48;
            }
            testedClassArray[10] = new TestedClass("Mutex", clazz27, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$RlockRNG != null) {
                clazz26 = class$LEDU$oswego$cs$dl$util$concurrent$misc$RlockRNG;
            } else {
                Class clazz49 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.RlockRNG");
                clazz26 = clazz49;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$RlockRNG = clazz49;
            }
            testedClassArray[11] = new TestedClass("ReentrantLock", clazz26, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG != null) {
                clazz25 = class$LEDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG;
            } else {
                Class clazz50 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.WpRWlockRNG");
                clazz25 = clazz50;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG = clazz50;
            }
            testedClassArray[12] = new TestedClass("WriterPrefRWLock", clazz25, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG != null) {
                clazz24 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG;
            } else {
                Class clazz51 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ReaderPrefRWlockRNG");
                clazz24 = clazz51;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG = clazz51;
            }
            testedClassArray[13] = new TestedClass("ReaderPrefRWLock", clazz24, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG != null) {
                clazz23 = class$LEDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG;
            } else {
                Class clazz52 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.FIFORWlockRNG");
                clazz23 = clazz52;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG = clazz52;
            }
            testedClassArray[14] = new TestedClass("FIFORWLock", clazz23, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG != null) {
                clazz22 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG;
            } else {
                Class clazz53 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ReentrantRWlockRNG");
                clazz22 = clazz53;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG = clazz53;
            }
            testedClassArray[15] = new TestedClass("ReentrantRWL", clazz22, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG != null) {
                clazz21 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
            } else {
                Class clazz54 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                clazz21 = clazz54;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = clazz54;
            }
            if (class$LEDU$oswego$cs$dl$util$concurrent$LinkedQueue != null) {
                clazz20 = class$LEDU$oswego$cs$dl$util$concurrent$LinkedQueue;
            } else {
                Class clazz55 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.LinkedQueue");
                clazz20 = clazz55;
                class$LEDU$oswego$cs$dl$util$concurrent$LinkedQueue = clazz55;
            }
            testedClassArray[16] = new TestedClass("LinkedQueue", clazz21, true, true, clazz20);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG != null) {
                clazz19 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
            } else {
                Class clazz56 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                clazz19 = clazz56;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = clazz56;
            }
            if (class$LEDU$oswego$cs$dl$util$concurrent$WaitFreeQueue != null) {
                clazz18 = class$LEDU$oswego$cs$dl$util$concurrent$WaitFreeQueue;
            } else {
                Class clazz57 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue");
                clazz18 = clazz57;
                class$LEDU$oswego$cs$dl$util$concurrent$WaitFreeQueue = clazz57;
            }
            testedClassArray[17] = new TestedClass("WaitFreeQueue", clazz19, true, true, clazz18);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG != null) {
                clazz17 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
            } else {
                Class clazz58 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                clazz17 = clazz58;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = clazz58;
            }
            if (class$LEDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue != null) {
                clazz16 = class$LEDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue;
            } else {
                Class clazz59 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue");
                clazz16 = clazz59;
                class$LEDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue = clazz59;
            }
            testedClassArray[18] = new TestedClass("BoundedLinkedQueue", clazz17, true, true, clazz16);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG != null) {
                clazz15 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
            } else {
                Class clazz60 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                clazz15 = clazz60;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = clazz60;
            }
            if (class$LEDU$oswego$cs$dl$util$concurrent$BoundedBuffer != null) {
                clazz14 = class$LEDU$oswego$cs$dl$util$concurrent$BoundedBuffer;
            } else {
                Class clazz61 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedBuffer");
                clazz14 = clazz61;
                class$LEDU$oswego$cs$dl$util$concurrent$BoundedBuffer = clazz61;
            }
            testedClassArray[19] = new TestedClass("BoundedBuffer", clazz15, true, true, clazz14);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG != null) {
                clazz13 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
            } else {
                Class clazz62 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                clazz13 = clazz62;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = clazz62;
            }
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$CVBuffer != null) {
                clazz12 = class$LEDU$oswego$cs$dl$util$concurrent$misc$CVBuffer;
            } else {
                Class clazz63 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.CVBuffer");
                clazz12 = clazz63;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$CVBuffer = clazz63;
            }
            testedClassArray[20] = new TestedClass("CondVarBoundedBuffer", clazz13, true, true, clazz12);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG != null) {
                clazz11 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
            } else {
                Class clazz64 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                clazz11 = clazz64;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = clazz64;
            }
            if (class$LEDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue != null) {
                clazz10 = class$LEDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue;
            } else {
                Class clazz65 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue");
                clazz10 = clazz65;
                class$LEDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue = clazz65;
            }
            testedClassArray[21] = new TestedClass("BoundedPriorityQueue", clazz11, true, true, clazz10);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG != null) {
                clazz9 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
            } else {
                Class clazz66 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                clazz9 = clazz66;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = clazz66;
            }
            if (class$LEDU$oswego$cs$dl$util$concurrent$Slot != null) {
                clazz8 = class$LEDU$oswego$cs$dl$util$concurrent$Slot;
            } else {
                Class clazz67 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.Slot");
                clazz8 = clazz67;
                class$LEDU$oswego$cs$dl$util$concurrent$Slot = clazz67;
            }
            testedClassArray[22] = new TestedClass("Slot", clazz9, true, true, clazz8);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG != null) {
                clazz7 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
            } else {
                Class clazz68 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG");
                clazz7 = clazz68;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = clazz68;
            }
            if (class$LEDU$oswego$cs$dl$util$concurrent$SynchronousChannel != null) {
                clazz6 = class$LEDU$oswego$cs$dl$util$concurrent$SynchronousChannel;
            } else {
                Class clazz69 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.SynchronousChannel");
                clazz6 = clazz69;
                class$LEDU$oswego$cs$dl$util$concurrent$SynchronousChannel = clazz69;
            }
            testedClassArray[23] = new TestedClass("SynchronousChannel", clazz7, true, false, clazz6);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG != null) {
                clazz5 = class$LEDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG;
            } else {
                Class clazz70 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.DirectExecutorRNG");
                clazz5 = clazz70;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG = clazz70;
            }
            testedClassArray[24] = new TestedClass("DirectExecutor", clazz5, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG != null) {
                clazz4 = class$LEDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG;
            } else {
                Class clazz71 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.LockedSemRNG");
                clazz4 = clazz71;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG = clazz71;
            }
            testedClassArray[25] = new TestedClass("SemaphoreLckExecutor", clazz4, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG != null) {
                clazz3 = class$LEDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG;
            } else {
                Class clazz72 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.QueuedExecutorRNG");
                clazz3 = clazz72;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG = clazz72;
            }
            testedClassArray[26] = new TestedClass("QueuedExecutor", clazz3, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG != null) {
                clazz2 = class$LEDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG;
            } else {
                Class clazz73 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ThreadedExecutorRNG");
                clazz2 = clazz73;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG = clazz73;
            }
            testedClassArray[27] = new TestedClass("ThreadedExecutor", clazz2, true, true);
            if (class$LEDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG != null) {
                clazz = class$LEDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG;
            } else {
                Class clazz74 = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PooledExecutorRNG");
                clazz = clazz74;
                class$LEDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG = clazz74;
            }
            testedClassArray[28] = new TestedClass("PooledExecutor", clazz, true, true);
            classes = testedClassArray;
        }
    }

    static class ThreadInfo {
        final String name;
        final int number;
        Boolean enabled;

        synchronized Boolean getEnabled() {
            return this.enabled;
        }

        synchronized void setEnabled(Boolean bl) {
            this.enabled = bl;
        }

        synchronized void toggleEnabled() {
            this.enabled = new Boolean(this.enabled == false);
        }

        ThreadInfo(int n) {
            this.number = n;
            this.name = SynchronizationTimer.p2ToString(n);
            this.enabled = new Boolean(true);
        }
    }

    class PrintStart
    implements Runnable {
        public void run() {
            SynchronizationTimer.this.startstop_.setText("Start");
        }

        PrintStart() {
        }
    }

    class TestSeries
    implements Runnable {
        final int firstclass;
        final int firstnthreads;

        public void run() {
            Thread.currentThread().setPriority(5);
            try {
                try {
                    int n = this.firstnthreads;
                    int n2 = this.firstclass;
                    if (n < nthreadsChoices.length && n2 < TestedClass.classes.length) {
                        while (true) {
                            if (SynchronizationTimer.this.threadEnabled(n)) {
                                TestedClass testedClass = TestedClass.classes[n2];
                                int n3 = nthreadsChoices[n];
                                int n4 = SynchronizationTimer.this.loopsPerTest_.get();
                                Fraction fraction = (Fraction)SynchronizationTimer.this.contention_.get();
                                if (testedClass.isEnabled(n3, fraction)) {
                                    SynchronizationTimer synchronizationTimer = SynchronizationTimer.this;
                                    if (synchronizationTimer == null) {
                                        throw null;
                                    }
                                    SynchronizationTimer.this.runOneTest(synchronizationTimer.new OneTest(n2, n));
                                }
                            }
                            if (++n2 >= TestedClass.classes.length) {
                                n2 = 0;
                                if (++n >= nthreadsChoices.length) break;
                            }
                            SynchronizationTimer.this.nextClassIdx_.set(n2);
                            SynchronizationTimer.this.nextThreadIdx_.set(n);
                        }
                    }
                    Object var2_8 = null;
                    SynchronizationTimer.this.endTestSeries();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    Object var2_9 = null;
                    SynchronizationTimer.this.endTestSeries();
                }
            }
            catch (Throwable throwable) {
                Object var2_10 = null;
                SynchronizationTimer.this.endTestSeries();
                throw throwable;
            }
        }

        TestSeries() {
            this.firstclass = 0;
            this.firstnthreads = 0;
        }

        TestSeries(int n, int n2) {
            this.firstclass = n;
            this.firstnthreads = n2;
        }
    }

    static class BarrierTimer
    implements Runnable {
        private long startTime_ = 0L;
        private long endTime_ = 0L;

        public synchronized long getTime() {
            return this.endTime_ - this.startTime_;
        }

        public synchronized void run() {
            long l = System.currentTimeMillis();
            if (this.startTime_ == 0L) {
                this.startTime_ = l;
            } else {
                this.endTime_ = l;
            }
        }

        BarrierTimer() {
        }
    }

    class OneTest
    implements Runnable {
        final int clsIdx;
        final int nthreadsIdx;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Color color;
            JLabel jLabel;
            boolean bl;
            block24: {
                block23: {
                    boolean bl2;
                    block22: {
                        Thread.currentThread().setPriority(2);
                        bl = false;
                        TestedClass testedClass = TestedClass.classes[this.clsIdx];
                        jLabel = (JLabel)SynchronizationTimer.this.resultTable_[this.clsIdx + 1][this.nthreadsIdx + 1];
                        color = jLabel.getForeground();
                        try {
                            block25: {
                                try {
                                    if (Thread.interrupted()) {
                                        Object var6_5 = null;
                                        bl2 = bl;
                                        break block22;
                                    }
                                    if (!SynchronizationTimer.this.threadEnabled(this.nthreadsIdx)) {
                                        break block23;
                                    }
                                    int n = nthreadsChoices[this.nthreadsIdx];
                                    int n2 = SynchronizationTimer.this.loopsPerTest_.get();
                                    Fraction fraction = (Fraction)SynchronizationTimer.this.contention_.get();
                                    if (!testedClass.isEnabled(n, fraction)) {
                                        break block24;
                                    }
                                    BarrierTimer barrierTimer = new BarrierTimer();
                                    CyclicBarrier cyclicBarrier = new CyclicBarrier(n + 1, barrierTimer);
                                    Class clazz = testedClass.cls;
                                    Class clazz2 = testedClass.buffCls;
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(this, jLabel){
                                            private final /* synthetic */ OneTest this$0;
                                            private final /* synthetic */ JLabel val$cell;

                                            public final void run() {
                                                this.val$cell.setForeground(Color.blue);
                                                this.val$cell.setText("RUN");
                                                this.val$cell.repaint();
                                            }
                                            {
                                                this.val$cell = jLabel;
                                                this.this$0 = oneTest;
                                                this.constructor$0(oneTest);
                                            }

                                            private final void constructor$0(OneTest oneTest) {
                                            }
                                        });
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        invocationTargetException.printStackTrace();
                                        System.exit(-1);
                                    }
                                    Object object = RNG.constructionLock;
                                    synchronized (object) {
                                        Object object2;
                                        RNG.reset(n);
                                        if (clazz2 == null) {
                                            object2 = (RNG)clazz.newInstance();
                                            int n3 = 0;
                                            while (n3 < n) {
                                                RNG rNG = (RNG)clazz.newInstance();
                                                TestLoop testLoop = new TestLoop((RNG)object2, rNG, fraction, n2, cyclicBarrier);
                                                Threads.pool.execute(testLoop.testLoop());
                                                ++n3;
                                            }
                                        } else {
                                            object2 = (Channel)clazz2.newInstance();
                                            if (n == 1) {
                                                ChanRNG chanRNG = (ChanRNG)clazz.newInstance();
                                                chanRNG.setSingle(true);
                                                PCTestLoop pCTestLoop = new PCTestLoop(chanRNG.getDelegate(), chanRNG, fraction, n2, cyclicBarrier, (Channel)object2, (Channel)object2);
                                                Threads.pool.execute(pCTestLoop.testLoop(true));
                                            } else {
                                                if (n % 2 != 0) {
                                                    throw new Error("Must have even number of threads!");
                                                }
                                                int n4 = n / 2;
                                                int n5 = 0;
                                                while (n5 < n4) {
                                                    ChanRNG chanRNG = (ChanRNG)clazz.newInstance();
                                                    chanRNG.setSingle(false);
                                                    Channel channel = (Channel)clazz2.newInstance();
                                                    PCTestLoop pCTestLoop = new PCTestLoop(chanRNG.getDelegate(), chanRNG, fraction, n2, cyclicBarrier, (Channel)object2, channel);
                                                    Threads.pool.execute(pCTestLoop.testLoop(false));
                                                    Threads.pool.execute(pCTestLoop.testLoop(true));
                                                    ++n5;
                                                }
                                            }
                                        }
                                        if (SynchronizationTimer.this.echoToSystemOut.get()) {
                                            System.out.print(testedClass.name + " " + n + "T " + fraction + "S " + RNG.computeLoops.get() + "I " + RNG.syncMode.get() + "Lm " + RNG.timeout.get() + "TO " + RNG.producerMode.get() + "Pm " + RNG.consumerMode.get() + "Cm " + RNG.bias.get() + "B " + DefaultChannelCapacity.get() + "C " + RNG.exchangeParties.get() + "Xp " + RNG.itersPerBarrier.get() + "Ib : ");
                                        }
                                    }
                                    cyclicBarrier.barrier();
                                    cyclicBarrier.barrier();
                                    long l = barrierTimer.getTime();
                                    long l2 = n * n2;
                                    double d = (double)l * 1000.0 * 10.0 / (double)l2;
                                    long l3 = Math.round(d);
                                    SynchronizationTimer.this.setTime(l3, this.clsIdx, this.nthreadsIdx);
                                    if (!SynchronizationTimer.this.echoToSystemOut.get()) break block25;
                                    System.out.println(SynchronizationTimer.formatTime(l3, true));
                                }
                                catch (BrokenBarrierException brokenBarrierException) {
                                    bl = true;
                                    Object var6_9 = null;
                                    boolean bl3 = bl;
                                    SwingUtilities.invokeLater(new Runnable(this, bl3, jLabel, color){
                                        private final /* synthetic */ OneTest this$0;
                                        private final /* synthetic */ boolean val$clear;
                                        private final /* synthetic */ JLabel val$cell;
                                        private final /* synthetic */ Color val$oldfg;

                                        public final void run() {
                                            if (this.val$clear) {
                                                this.val$cell.setText("");
                                            }
                                            this.val$cell.setForeground(this.val$oldfg);
                                            this.val$cell.repaint();
                                        }
                                        {
                                            this.val$clear = bl;
                                            this.val$cell = jLabel;
                                            this.val$oldfg = color;
                                            this.this$0 = oneTest;
                                            this.constructor$0(oneTest);
                                        }

                                        private final void constructor$0(OneTest oneTest) {
                                        }
                                    });
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                                catch (InterruptedException interruptedException) {
                                    bl = true;
                                    Thread.currentThread().interrupt();
                                    Object var6_10 = null;
                                    boolean bl4 = bl;
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    System.out.println("Construction Exception?");
                                    System.exit(-1);
                                    Object var6_11 = null;
                                    boolean bl5 = bl;
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                            }
                            Object var6_8 = null;
                            boolean bl6 = bl;
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            Thread.currentThread().setPriority(5);
                            SynchronizationTimer.this.endOneTest();
                            return;
                        }
                        catch (Throwable throwable) {
                            Object var6_12 = null;
                            boolean bl7 = bl;
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            Thread.currentThread().setPriority(5);
                            SynchronizationTimer.this.endOneTest();
                            throw throwable;
                        }
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    Thread.currentThread().setPriority(5);
                    SynchronizationTimer.this.endOneTest();
                    return;
                }
                Object var6_6 = null;
                boolean bl8 = bl;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                Thread.currentThread().setPriority(5);
                SynchronizationTimer.this.endOneTest();
                return;
            }
            Object var6_7 = null;
            boolean bl9 = bl;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            Thread.currentThread().setPriority(5);
            SynchronizationTimer.this.endOneTest();
        }

        OneTest(int n, int n2) {
            this.clsIdx = n;
            this.nthreadsIdx = n2;
        }
    }
}

