/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import EDU.oswego.cs.dl.util.concurrent.TimedCallable;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import EDU.oswego.cs.dl.util.concurrent.misc.SwingWorker;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class SwingWorker
extends ThreadFactoryUser
implements Runnable {
    private static final ThreadFactory FACTORY = new 1();
    private final FutureResult result = new FutureResult();
    private final long timeout;
    private Thread thread;

    protected abstract Object construct() throws Exception;

    protected void finished() {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void run() {
        Callable callable = new Callable(this){
            private final /* synthetic */ SwingWorker this$0;

            public final Object call() throws Exception {
                return this.this$0.construct();
            }
            {
                this.this$0 = swingWorker;
                this.constructor$0(swingWorker);
            }

            private final void constructor$0(SwingWorker swingWorker) {
            }
        };
        Runnable runnable = new Runnable(this){
            private final /* synthetic */ SwingWorker this$0;

            public final void run() {
                this.this$0.finished();
            }
            {
                this.this$0 = swingWorker;
                this.constructor$0(swingWorker);
            }

            private final void constructor$0(SwingWorker swingWorker) {
            }
        };
        long l = this.getTimeout();
        if (l != 0L) {
            TimedCallable timedCallable = new TimedCallable(callable, l);
            timedCallable.setThreadFactory(this.getThreadFactory());
            callable = timedCallable;
        }
        this.result.setter(callable).run();
        SwingUtilities.invokeLater(runnable);
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = this.getThreadFactory().newThread(this);
        }
        this.thread.start();
    }

    public synchronized void interrupt() {
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.result.setException(new InterruptedException());
    }

    public Object get() throws InterruptedException, InvocationTargetException {
        return this.result.get();
    }

    public Object timedGet(long l) throws TimeoutException, InterruptedException, InvocationTargetException {
        return this.result.timedGet(l);
    }

    public InvocationTargetException getException() {
        return this.result.getException();
    }

    public boolean isReady() {
        return this.result.isReady();
    }

    public SwingWorker() {
        this(FACTORY, 0L);
    }

    public SwingWorker(long l) {
        this(FACTORY, l);
    }

    protected SwingWorker(ThreadFactory threadFactory, long l) {
        this.setThreadFactory(threadFactory);
        if (l < 0L) {
            throw new IllegalArgumentException("timeout=" + l);
        }
        this.timeout = l;
    }
}

