/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.misc.NoSynchRNG;

class RWLockRNG
extends NoSynchRNG {
    protected final ReadWriteLock lock_;

    protected final void acquireR() throws InterruptedException {
        if (this.smode == 0) {
            this.lock_.readLock().acquire();
        } else {
            while (!this.lock_.readLock().attempt(this.waitTime)) {
            }
        }
    }

    protected final void acquireW() throws InterruptedException {
        if (this.smode == 0) {
            this.lock_.writeLock().acquire();
        } else {
            while (!this.lock_.writeLock().attempt(this.waitTime)) {
            }
        }
    }

    public long next() {
        long l = 0L;
        try {
            this.acquireR();
            l = this.current_;
            this.lock_.readLock().release();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return 0L;
        }
        l = this.compute(l);
        try {
            this.acquireW();
            this.set(l);
            this.lock_.writeLock().release();
            return l;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return 0L;
        }
    }

    public long get() {
        try {
            this.acquireR();
            long l = this.current_;
            this.lock_.readLock().release();
            return l;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return 0L;
        }
    }

    public void update() {
        long l = 0L;
        try {
            this.acquireR();
            l = this.current_;
            this.lock_.readLock().release();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
        l = this.compute(l);
        try {
            this.acquireW();
            this.set(l);
            this.lock_.writeLock().release();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public RWLockRNG(ReadWriteLock readWriteLock) {
        this.lock_ = readWriteLock;
    }
}

