/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.Rendezvous;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import EDU.oswego.cs.dl.util.concurrent.misc.UpdateCommand;
import java.io.Serializable;

abstract class RNG
implements Serializable,
Comparable {
    static final int firstSeed = 4321;
    static final int rmod = Integer.MAX_VALUE;
    static final int rmul = 16807;
    static int lastSeed = 4321;
    static final int smod = 32749;
    static final int smul = 3125;
    static final Object constructionLock = class$LEDU$oswego$cs$dl$util$concurrent$misc$RNG != null ? class$LEDU$oswego$cs$dl$util$concurrent$misc$RNG : (class$LEDU$oswego$cs$dl$util$concurrent$misc$RNG = RNG.class$("EDU.oswego.cs.dl.util.concurrent.misc.RNG"));
    static final SynchronizedInt computeLoops = new SynchronizedInt(16, constructionLock);
    static final SynchronizedInt syncMode = new SynchronizedInt(0, constructionLock);
    static final SynchronizedInt producerMode = new SynchronizedInt(0, constructionLock);
    static final SynchronizedInt consumerMode = new SynchronizedInt(0, constructionLock);
    static final SynchronizedInt bias = new SynchronizedInt(0, constructionLock);
    static final SynchronizedLong timeout = new SynchronizedLong(100L, constructionLock);
    static final SynchronizedInt exchangeParties = new SynchronizedInt(1, constructionLock);
    static final SynchronizedInt sequenceNumber = new SynchronizedInt(0, constructionLock);
    static final SynchronizedInt itersPerBarrier = new SynchronizedInt(0, constructionLock);
    static Rendezvous[] exchangers_;
    final int cloops = computeLoops.get();
    final int pcBias = bias.get();
    final int smode = syncMode.get();
    final int pmode = producerMode.get();
    final int cmode = consumerMode.get();
    final long waitTime = timeout.get();
    Rendezvous exchanger_ = null;
    private static /* synthetic */ Class class$LEDU$oswego$cs$dl$util$concurrent$misc$RNG;

    static void reset(int n) {
        Object object = constructionLock;
        synchronized (object) {
            sequenceNumber.set(-1);
            int n2 = exchangeParties.get();
            if (n < n2) {
                n2 = n;
            }
            if (n % n2 != 0) {
                throw new Error("need even multiple of parties");
            }
            exchangers_ = new Rendezvous[n / n2];
            int n3 = 0;
            while (n3 < exchangers_.length) {
                RNG.exchangers_[n3] = new Rendezvous(n2);
                ++n3;
            }
        }
    }

    static long nextSeed() {
        Object object = constructionLock;
        synchronized (object) {
            long l = lastSeed;
            lastSeed = lastSeed * 3125 % 32749;
            if (lastSeed == 0) {
                lastSeed = (int)System.currentTimeMillis();
            }
            return l;
        }
    }

    synchronized Rendezvous getExchanger() {
        if (this.exchanger_ == null) {
            Object object = constructionLock;
            synchronized (object) {
                int n = sequenceNumber.increment();
                this.exchanger_ = exchangers_[n % exchangers_.length];
            }
        }
        return this.exchanger_;
    }

    public void exchange() throws InterruptedException {
        Rendezvous rendezvous = this.getExchanger();
        Runnable runnable = (Runnable)rendezvous.rendezvous(new UpdateCommand(this));
        if (runnable != null) {
            runnable.run();
        }
    }

    public int compareTo(Object object) {
        int n;
        int n2 = this.hashCode();
        if (n2 < (n = object.hashCode())) {
            return -1;
        }
        if (n2 > n) {
            return 1;
        }
        return 0;
    }

    protected final long compute(long l) {
        int n = (int)((l & Integer.MAX_VALUE) % (long)(this.cloops * 2)) + 1;
        int n2 = 0;
        while (n2 < n) {
            l = l * 16807L % Integer.MAX_VALUE;
            ++n2;
        }
        return l == 0L ? 4321L : l;
    }

    protected abstract void set(long var1);

    protected abstract long internalGet();

    protected abstract void internalUpdate();

    public long get() {
        return this.internalGet();
    }

    public void update() {
        this.internalUpdate();
    }

    public long next() {
        this.internalUpdate();
        return this.internalGet();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    RNG() {
    }
}

