/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;

public class WaitableInt
extends SynchronizedInt {
    public int set(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.set(n);
        }
    }

    public boolean commit(int n, int n2) {
        Object object = this.lock_;
        synchronized (object) {
            boolean bl = super.commit(n, n2);
            if (bl) {
                this.lock_.notifyAll();
            }
            return bl;
        }
    }

    public int increment() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.increment();
        }
    }

    public int decrement() {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.decrement();
        }
    }

    public int add(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.add(n);
        }
    }

    public int subtract(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.subtract(n);
        }
    }

    public int multiply(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.multiply(n);
        }
    }

    public int divide(int n) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.divide(n);
        }
    }

    public void whenEqual(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenNotEqual(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLessEqual(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ > n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLess(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ >= n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreaterEqual(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ < n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreater(int n, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ <= n) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public WaitableInt(int n) {
        super(n);
    }

    public WaitableInt(int n, Object object) {
        super(n, object);
    }
}

