/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedFloat;

public class WaitableFloat
extends SynchronizedFloat {
    public float set(float f) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.set(f);
        }
    }

    public boolean commit(float f, float f2) {
        Object object = this.lock_;
        synchronized (object) {
            boolean bl = super.commit(f, f2);
            if (bl) {
                this.lock_.notifyAll();
            }
            return bl;
        }
    }

    public float add(float f) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.add(f);
        }
    }

    public float subtract(float f) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.subtract(f);
        }
    }

    public float multiply(float f) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.multiply(f);
        }
    }

    public float divide(float f) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.divide(f);
        }
    }

    public void whenEqual(float f, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != f) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenNotEqual(float f, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == f) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLessEqual(float f, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ <= f)) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLess(float f, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ < f)) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreaterEqual(float f, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ >= f)) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreater(float f, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ > f)) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public WaitableFloat(float f) {
        super(f);
    }

    public WaitableFloat(float f, Object object) {
        super(f, object);
    }
}

