/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedDouble;

public class WaitableDouble
extends SynchronizedDouble {
    public double set(double d) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.set(d);
        }
    }

    public boolean commit(double d, double d2) {
        Object object = this.lock_;
        synchronized (object) {
            boolean bl = super.commit(d, d2);
            if (bl) {
                this.lock_.notifyAll();
            }
            return bl;
        }
    }

    public double add(double d) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.add(d);
        }
    }

    public double subtract(double d) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.subtract(d);
        }
    }

    public double multiply(double d) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.multiply(d);
        }
    }

    public double divide(double d) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.divide(d);
        }
    }

    public void whenEqual(double d, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != d) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenNotEqual(double d, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == d) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLessEqual(double d, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ <= d)) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLess(double d, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ < d)) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreaterEqual(double d, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ >= d)) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreater(double d, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (!(this.value_ > d)) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public WaitableDouble(double d) {
        super(d);
    }

    public WaitableDouble(double d, Object object) {
        super(d, object);
    }
}

