/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedChar;

public class WaitableChar
extends SynchronizedChar {
    public char set(char c) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.set(c);
        }
    }

    public boolean commit(char c, char c2) {
        Object object = this.lock_;
        synchronized (object) {
            boolean bl = super.commit(c, c2);
            if (bl) {
                this.lock_.notifyAll();
            }
            return bl;
        }
    }

    public char add(char c) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.add(c);
        }
    }

    public char subtract(char c) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.subtract(c);
        }
    }

    public char multiply(char c) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.multiply(c);
        }
    }

    public char divide(char c) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.divide(c);
        }
    }

    public void whenEqual(char c, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != c) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenNotEqual(char c, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == c) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLessEqual(char c, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ > c) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenLess(char c, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ >= c) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreaterEqual(char c, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ < c) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public void whenGreater(char c, Runnable runnable) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ <= c) {
                this.lock_.wait();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    public WaitableChar(char c) {
        super(c);
    }

    public WaitableChar(char c, Object object) {
        super(c, object);
    }
}

