/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedFloat
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected float value_;

    public final float get() {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_;
        }
    }

    public float set(float f) {
        Object object = this.lock_;
        synchronized (object) {
            float f2 = this.value_;
            this.value_ = f;
            return f2;
        }
    }

    public boolean commit(float f, float f2) {
        Object object = this.lock_;
        synchronized (object) {
            boolean bl;
            boolean bl2 = bl = f == this.value_;
            if (bl) {
                this.value_ = f2;
            }
            return bl;
        }
    }

    public float swap(SynchronizedFloat synchronizedFloat) {
        if (synchronizedFloat == this) {
            return this.get();
        }
        SynchronizedFloat synchronizedFloat2 = this;
        SynchronizedFloat synchronizedFloat3 = synchronizedFloat;
        if (System.identityHashCode(synchronizedFloat2) > System.identityHashCode(synchronizedFloat3)) {
            synchronizedFloat2 = synchronizedFloat;
            synchronizedFloat3 = this;
        }
        Object object = synchronizedFloat2.lock_;
        synchronized (object) {
            Object object2 = synchronizedFloat3.lock_;
            synchronized (object2) {
                synchronizedFloat2.set(synchronizedFloat3.set(synchronizedFloat2.get()));
                return this.get();
            }
        }
    }

    public float add(float f) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ += f;
        }
    }

    public float subtract(float f) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ -= f;
        }
    }

    public synchronized float multiply(float f) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ *= f;
        }
    }

    public float divide(float f) {
        Object object = this.lock_;
        synchronized (object) {
            return this.value_ /= f;
        }
    }

    public int compareTo(float f) {
        float f2 = this.get();
        return f2 < f ? -1 : (f2 == f ? 0 : 1);
    }

    public int compareTo(SynchronizedFloat synchronizedFloat) {
        return this.compareTo(synchronizedFloat.get());
    }

    public int compareTo(Object object) {
        return this.compareTo((SynchronizedFloat)object);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SynchronizedFloat) {
            return this.get() == ((SynchronizedFloat)object).get();
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.get());
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    public SynchronizedFloat(float f) {
        this.value_ = f;
    }

    public SynchronizedFloat(float f, Object object) {
        super(object);
        this.value_ = f;
    }
}

