/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.Collection;
import java.util.Iterator;

public class SyncCollection
implements Collection {
    protected final Collection c_;
    protected final Sync rd_;
    protected final Sync wr_;
    protected final SynchronizedLong syncFailures_ = new SynchronizedLong(0L);

    public Sync readerSync() {
        return this.rd_;
    }

    public Sync writerSync() {
        return this.wr_;
    }

    public long syncFailures() {
        return this.syncFailures_.get();
    }

    protected boolean beforeRead() {
        try {
            this.rd_.acquire();
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.syncFailures_.increment();
            return true;
        }
    }

    protected void afterRead(boolean bl) {
        if (bl) {
            Thread.currentThread().interrupt();
        } else {
            this.rd_.release();
        }
    }

    public int size() {
        boolean bl = this.beforeRead();
        try {
            int n = this.c_.size();
            Object var3_3 = null;
            this.afterRead(bl);
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    public boolean isEmpty() {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.isEmpty();
            Object var3_3 = null;
            this.afterRead(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    public boolean contains(Object object) {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.contains(object);
            Object var4_4 = null;
            this.afterRead(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    public Object[] toArray() {
        boolean bl = this.beforeRead();
        try {
            Object[] objectArray = this.c_.toArray();
            Object var3_3 = null;
            this.afterRead(bl);
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    public Object[] toArray(Object[] objectArray) {
        boolean bl = this.beforeRead();
        try {
            Object[] objectArray2 = this.c_.toArray(objectArray);
            Object var4_4 = null;
            this.afterRead(bl);
            return objectArray2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    public boolean containsAll(Collection collection) {
        boolean bl = this.beforeRead();
        try {
            boolean bl2 = this.c_.containsAll(collection);
            Object var4_4 = null;
            this.afterRead(bl);
            return bl2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    public boolean add(Object object) {
        try {
            this.wr_.acquire();
            try {
                boolean bl = this.c_.add(object);
                Object var3_3 = null;
                this.wr_.release();
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    public boolean remove(Object object) {
        try {
            this.wr_.acquire();
            try {
                boolean bl = this.c_.remove(object);
                Object var3_3 = null;
                this.wr_.release();
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    public boolean addAll(Collection collection) {
        try {
            this.wr_.acquire();
            try {
                boolean bl = this.c_.addAll(collection);
                Object var3_3 = null;
                this.wr_.release();
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    public boolean removeAll(Collection collection) {
        try {
            this.wr_.acquire();
            try {
                boolean bl = this.c_.removeAll(collection);
                Object var3_3 = null;
                this.wr_.release();
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    public boolean retainAll(Collection collection) {
        try {
            this.wr_.acquire();
            try {
                boolean bl = this.c_.retainAll(collection);
                Object var3_3 = null;
                this.wr_.release();
                return bl;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.wr_.release();
                throw throwable;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    public void clear() {
        try {
            this.wr_.acquire();
            try {
                this.c_.clear();
            }
            finally {
                Object var2_1 = null;
                this.wr_.release();
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    public Iterator unprotectedIterator() {
        boolean bl = this.beforeRead();
        try {
            Iterator iterator = this.c_.iterator();
            Object var3_3 = null;
            this.afterRead(bl);
            return iterator;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    public Iterator iterator() {
        boolean bl = this.beforeRead();
        try {
            SyncCollectionIterator syncCollectionIterator = new SyncCollectionIterator(this.c_.iterator());
            Object var3_3 = null;
            this.afterRead(bl);
            return syncCollectionIterator;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.afterRead(bl);
            throw throwable;
        }
    }

    public SyncCollection(Collection collection, Sync sync) {
        this(collection, sync, sync);
    }

    public SyncCollection(Collection collection, ReadWriteLock readWriteLock) {
        this(collection, readWriteLock.readLock(), readWriteLock.writeLock());
    }

    public SyncCollection(Collection collection, Sync sync, Sync sync2) {
        this.c_ = collection;
        this.rd_ = sync;
        this.wr_ = sync2;
    }

    public class SyncCollectionIterator
    implements Iterator {
        protected final Iterator baseIterator_;

        public boolean hasNext() {
            boolean bl = SyncCollection.this.beforeRead();
            try {
                boolean bl2 = this.baseIterator_.hasNext();
                Object var3_3 = null;
                SyncCollection.this.afterRead(bl);
                return bl2;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                SyncCollection.this.afterRead(bl);
                throw throwable;
            }
        }

        public Object next() {
            boolean bl = SyncCollection.this.beforeRead();
            try {
                Object e = this.baseIterator_.next();
                Object var3_3 = null;
                SyncCollection.this.afterRead(bl);
                return e;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                SyncCollection.this.afterRead(bl);
                throw throwable;
            }
        }

        public void remove() {
            try {
                SyncCollection.this.wr_.acquire();
                try {
                    this.baseIterator_.remove();
                }
                finally {
                    Object var2_1 = null;
                    SyncCollection.this.wr_.release();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }

        SyncCollectionIterator(Iterator iterator) {
            this.baseIterator_ = iterator;
        }
    }
}

