/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Barrier;
import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import EDU.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected int entries_ = 0;
    protected long departures_ = 0L;
    protected final Semaphore entryGate_;
    protected final Object[] slots_;
    protected RendezvousFunction rendezvousFunction_;

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction rendezvousFunction) {
        RendezvousFunction rendezvousFunction2 = this.rendezvousFunction_;
        this.rendezvousFunction_ = rendezvousFunction;
        return rendezvousFunction2;
    }

    public int parties() {
        return this.parties_;
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entries_ == 0) {
                    this.broken_ = false;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public Object rendezvous(Object object) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(object, false, 0L);
    }

    public Object attemptRendezvous(Object object, long l) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(object, true, l);
    }

    /*
     * Unable to fully structure code
     */
    protected Object doRendezvous(Object var1_1, boolean var2_2, long var3_3) throws InterruptedException, TimeoutException, BrokenBarrierException {
        if (var2_2) {
            var5_4 = System.currentTimeMillis();
            if (!this.entryGate_.attempt(var3_3)) {
                throw new TimeoutException(var3_3);
            }
        } else {
            var5_4 = 0L;
            this.entryGate_.acquire();
        }
        var7_5 = this;
        synchronized (var7_5) {
            block22: {
                block21: {
                    block20: {
                        var10_6 = null;
                        var11_7 = this.entries_++;
                        this.slots_[var11_7] = var1_1;
                        try {
                            if (this.entries_ != this.parties_) ** GOTO lbl43
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            try {
                                if (!this.broken_ && this.rendezvousFunction_ != null) {
                                    this.rendezvousFunction_.rendezvousFunction(this.slots_);
                                }
                                break block20;
                            }
                            catch (RuntimeException var16_8) {
                                this.broken_ = true;
                            }
                            break block20;
lbl-1000:
                            // 1 sources

                            {
                                var16_9 = 0L;
                                if (var2_2 && (var16_9 = var3_3 - (System.currentTimeMillis() - var5_4)) <= 0L) {
                                    this.broken_ = true;
                                    this.departures_ = this.entries_;
                                    this.notifyAll();
                                    throw new TimeoutException(var3_3);
                                }
                                try {
                                    this.wait(var16_9);
                                }
                                catch (InterruptedException var18_10) {
                                    if (this.broken_ || this.departures_ > 0L) {
                                        Thread.currentThread().interrupt();
                                        break block20;
                                    }
                                    this.broken_ = true;
                                    this.departures_ = this.entries_;
                                    this.notifyAll();
                                    throw var18_10;
                                }
lbl43:
                                // 2 sources

                                if (this.broken_) break block20;
                                ** while (this.departures_ < 1L)
                            }
                        }
                        catch (Throwable var12_15) {
                            var13_12 = null;
                            var10_6 = this.slots_[var11_7];
                            if (--this.departures_ > 0L) break block21;
                            var15_14 = 0;
                            ** while (var15_14 < this.slots_.length)
                        }
lbl45:
                        // 1 sources

                    }
                    var13_11 = null;
                    var10_6 = this.slots_[var11_7];
                    if (--this.departures_ <= 0L) {
                        var15_13 = 0;
                        while (var15_13 < this.slots_.length) {
                            this.slots_[var15_13] = null;
                            ++var15_13;
                        }
                        this.entryGate_.release(this.entries_);
                        this.entries_ = 0;
                    }
                    break block22;
lbl-1000:
                    // 1 sources

                    {
                        this.slots_[var15_14] = null;
                        ++var15_14;
                        continue;
                    }
lbl68:
                    // 1 sources

                    this.entryGate_.release(this.entries_);
                    this.entries_ = 0;
                }
                throw var12_15;
            }
            if (this.broken_) {
                throw new BrokenBarrierException(var11_7);
            }
            return var10_6;
        }
    }

    public Rendezvous(int n) {
        this(n, new Rotator());
    }

    public Rendezvous(int n, RendezvousFunction rendezvousFunction) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = n;
        this.rendezvousFunction_ = rendezvousFunction;
        this.entryGate_ = new WaiterPreferenceSemaphore(n);
        this.slots_ = new Object[n];
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1);
    }

    public static class Rotator
    implements RendezvousFunction {
        public void rendezvousFunction(Object[] objectArray) {
            int n = objectArray.length - 1;
            Object object = objectArray[0];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = objectArray[n2 + 1];
                ++n2;
            }
            objectArray[n] = object;
        }
    }
}

