/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class ReentrantLock
implements Sync {
    protected Thread owner_ = null;
    protected long holds_ = 0L;

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread thread = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (thread == this.owner_) {
                ++this.holds_;
            } else {
                try {
                    while (this.owner_ != null) {
                        this.wait();
                    }
                    this.owner_ = thread;
                    this.holds_ = 1L;
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
    }

    public boolean attempt(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread thread = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            if (thread == this.owner_) {
                ++this.holds_;
                return true;
            }
            if (this.owner_ == null) {
                this.owner_ = thread;
                this.holds_ = 1L;
                return true;
            }
            if (l <= 0L) {
                return false;
            }
            long l2 = l;
            long l3 = System.currentTimeMillis();
            try {
                do {
                    this.wait(l2);
                    if (thread == this.owner_) {
                        ++this.holds_;
                        return true;
                    }
                    if (this.owner_ != null) continue;
                    this.owner_ = thread;
                    this.holds_ = 1L;
                    return true;
                } while ((l2 = l - (System.currentTimeMillis() - l3)) > 0L);
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.notify();
                throw interruptedException;
            }
        }
    }

    public synchronized void release() {
        if (Thread.currentThread() != this.owner_) {
            throw new Error("Illegal Lock usage");
        }
        if (--this.holds_ == 0L) {
            this.owner_ = null;
            this.notify();
        }
    }

    public synchronized void release(long l) {
        if (Thread.currentThread() != this.owner_ || l > this.holds_) {
            throw new Error("Illegal Lock usage");
        }
        this.holds_ -= l;
        if (this.holds_ == 0L) {
            this.owner_ = null;
            this.notify();
        }
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.owner_) {
            return 0L;
        }
        return this.holds_;
    }
}

