/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CopyOnWriteArrayList
implements List,
Cloneable,
Serializable {
    protected transient Object[] array_;

    protected synchronized Object[] array() {
        return this.array_;
    }

    public synchronized void copyIn(Object[] objectArray, int n, int n2) {
        this.array_ = new Object[n2];
        System.arraycopy(objectArray, n, this.array_, 0, n2);
    }

    public int size() {
        return this.array().length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        int n;
        Object[] objectArray = this.array();
        return CopyOnWriteArrayList.indexOf(object, objectArray, n = objectArray.length) >= 0;
    }

    public int indexOf(Object object) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        return CopyOnWriteArrayList.indexOf(object, objectArray, n);
    }

    protected static int indexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2] == null) {
                    return n2;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                if (object.equals(objectArray[n3])) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    public int indexOf(Object object, int n) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        if (object == null) {
            int n3 = n;
            while (n3 < n2) {
                if (objectArray[n3] == null) {
                    return n3;
                }
                ++n3;
            }
        } else {
            int n4 = n;
            while (n4 < n2) {
                if (object.equals(objectArray[n4])) {
                    return n4;
                }
                ++n4;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, n);
    }

    protected static int lastIndexOf(Object object, Object[] objectArray, int n) {
        if (object == null) {
            int n2 = n - 1;
            while (n2 >= 0) {
                if (objectArray[n2] == null) {
                    return n2;
                }
                --n2;
            }
        } else {
            int n3 = n - 1;
            while (n3 >= 0) {
                if (object.equals(objectArray[n3])) {
                    return n3;
                }
                --n3;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object, int n) {
        Object[] objectArray = this.array();
        if (object == null) {
            int n2 = n;
            while (n2 >= 0) {
                if (objectArray[n2] == null) {
                    return n2;
                }
                --n2;
            }
        } else {
            int n3 = n;
            while (n3 >= 0) {
                if (object.equals(objectArray[n3])) {
                    return n3;
                }
                --n3;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            Object[] objectArray = this.array();
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
            copyOnWriteArrayList.array_ = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, copyOnWriteArrayList.array_, 0, objectArray.length);
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object[] toArray() {
        Object[] objectArray = this.array();
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2 = this.array();
        if (objectArray.length < objectArray2.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray2.length);
        }
        System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
        if (objectArray.length > objectArray2.length) {
            objectArray[objectArray2.length] = null;
        }
        return objectArray;
    }

    public Object get(int n) {
        Object[] objectArray = this.array();
        this.rangeCheck(n, objectArray.length);
        return objectArray[n];
    }

    public synchronized Object set(int n, Object object) {
        boolean bl;
        int n2 = this.array_.length;
        this.rangeCheck(n, n2);
        Object object2 = this.array_[n];
        boolean bl2 = bl = object2 == object || object != null && object.equals(object2);
        if (!bl) {
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.array_, 0, objectArray, 0, n2);
            objectArray[n] = object;
            this.array_ = objectArray;
        }
        return object2;
    }

    public synchronized boolean add(Object object) {
        int n = this.array_.length;
        Object[] objectArray = new Object[n + 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        objectArray[n] = object;
        this.array_ = objectArray;
        return true;
    }

    public synchronized void add(int n, Object object) {
        int n2 = this.array_.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        Object[] objectArray = new Object[n2 + 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        objectArray[n] = object;
        System.arraycopy(this.array_, n, objectArray, n + 1, n2 - n);
        this.array_ = objectArray;
    }

    public synchronized Object remove(int n) {
        int n2 = this.array_.length;
        this.rangeCheck(n, n2);
        Object object = this.array_[n];
        Object[] objectArray = new Object[n2 - 1];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        int n3 = n2 - n - 1;
        if (n3 > 0) {
            System.arraycopy(this.array_, n + 1, objectArray, n, n3);
        }
        this.array_ = objectArray;
        return object;
    }

    public synchronized boolean remove(Object object) {
        int n = this.array_.length;
        if (n == 0) {
            return false;
        }
        int n2 = n - 1;
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        while (n3 < n2) {
            if (object == this.array_[n3] || object != null && object.equals(this.array_[n3])) {
                int n4 = n3 + 1;
                while (n4 < n) {
                    objectArray[n4 - 1] = this.array_[n4];
                    ++n4;
                }
                this.array_ = objectArray;
                return true;
            }
            objectArray[n3] = this.array_[n3];
            ++n3;
        }
        if (object == this.array_[n2] || object != null && object.equals(this.array_[n2])) {
            this.array_ = objectArray;
            return true;
        }
        return false;
    }

    public synchronized void removeRange(int n, int n2) {
        int n3 = this.array_.length;
        if (n < 0 || n >= n3 || n2 > n3 || n2 < n) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n3 - n2;
        int n5 = n3 - (n2 - n);
        Object[] objectArray = new Object[n5];
        System.arraycopy(this.array_, 0, objectArray, 0, n);
        System.arraycopy(this.array_, n2, objectArray, n, n4);
        this.array_ = objectArray;
    }

    public synchronized boolean addIfAbsent(Object object) {
        int n = this.array_.length;
        Object[] objectArray = new Object[n + 1];
        int n2 = 0;
        while (n2 < n) {
            if (object == this.array_[n2] || object != null && object.equals(this.array_[n2])) {
                return false;
            }
            objectArray[n2] = this.array_[n2];
            ++n2;
        }
        objectArray[n] = object;
        this.array_ = objectArray;
        return true;
    }

    public boolean containsAll(Collection collection) {
        Object[] objectArray = this.array();
        int n = objectArray.length;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(iterator.next(), objectArray, n) >= 0) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeAll(Collection collection) {
        Object[] objectArray = this.array_;
        int n = objectArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object object = objectArray[n3];
            if (!collection.contains(object)) {
                objectArray2[n2++] = object;
            }
            ++n3;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray3 = new Object[n2];
        System.arraycopy(objectArray2, 0, objectArray3, 0, n2);
        this.array_ = objectArray3;
        return true;
    }

    public synchronized boolean retainAll(Collection collection) {
        Object[] objectArray = this.array_;
        int n = objectArray.length;
        if (n == 0) {
            return false;
        }
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Object object = objectArray[n3];
            if (collection.contains(object)) {
                objectArray2[n2++] = object;
            }
            ++n3;
        }
        if (n2 == n) {
            return false;
        }
        Object[] objectArray3 = new Object[n2];
        System.arraycopy(objectArray2, 0, objectArray3, 0, n2);
        this.array_ = objectArray3;
        return true;
    }

    public synchronized int addAllAbsent(Collection collection) {
        Object object;
        int n = collection.size();
        if (n == 0) {
            return 0;
        }
        Object[] objectArray = this.array_;
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n];
        int n3 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (CopyOnWriteArrayList.indexOf(object, objectArray, n2) >= 0 || CopyOnWriteArrayList.indexOf(object, objectArray2, n3) >= 0) continue;
            objectArray2[n3++] = object;
        }
        if (n3 == 0) {
            return 0;
        }
        object = new Object[n2 + n3];
        System.arraycopy(objectArray, 0, object, 0, n2);
        System.arraycopy(objectArray2, 0, object, n2, n3);
        this.array_ = object;
        return n3;
    }

    public synchronized void clear() {
        this.array_ = new Object[0];
    }

    public synchronized boolean addAll(Collection collection) {
        int n = collection.size();
        if (n == 0) {
            return false;
        }
        int n2 = this.array_.length;
        Object[] objectArray = new Object[n2 + n];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        Iterator iterator = collection.iterator();
        int n3 = 0;
        while (n3 < n) {
            objectArray[n2++] = iterator.next();
            ++n3;
        }
        this.array_ = objectArray;
        return true;
    }

    public synchronized boolean addAll(int n, Collection collection) {
        int n2 = this.array_.length;
        if (n > n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        Object[] objectArray = new Object[n2 + n3];
        System.arraycopy(this.array_, 0, objectArray, 0, n2);
        int n4 = n2 - n;
        if (n4 > 0) {
            System.arraycopy(this.array_, n, objectArray, n + n3, n4);
        }
        Iterator iterator = collection.iterator();
        int n5 = 0;
        while (n5 < n3) {
            objectArray[n++] = iterator.next();
            ++n5;
        }
        this.array_ = objectArray;
        return true;
    }

    protected void rangeCheck(int n, int n2) {
        if (n >= n2 || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.array();
        objectOutputStream.writeInt(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            objectOutputStream.writeObject(objectArray[n]);
            ++n;
        }
    }

    private final synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < objectArray.length) {
            objectArray[n2] = objectInputStream.readObject();
            ++n2;
        }
        this.array_ = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.iterator();
        stringBuffer.append("[");
        int n = this.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(String.valueOf(iterator.next()));
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            Object e2 = listIterator2.next();
            if (e == null ? e2 == null : e.equals(e2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    public Iterator iterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator() {
        return new COWIterator(this.array(), 0);
    }

    public ListIterator listIterator(int n) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("Index: " + n);
        }
        return new COWIterator(this.array(), n);
    }

    public synchronized List subList(int n, int n2) {
        int n3 = this.array_.length;
        if (n < 0 || n2 > n3 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, n, n2);
    }

    public CopyOnWriteArrayList() {
        this.array_ = new Object[0];
    }

    public CopyOnWriteArrayList(Collection collection) {
        this.array_ = new Object[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.array_[n++] = iterator.next();
        }
    }

    public CopyOnWriteArrayList(Object[] objectArray) {
        this.copyIn(objectArray, 0, objectArray.length);
    }

    protected static class COWIterator
    implements ListIterator {
        protected final Object[] array;
        protected int cursor;

        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        public Object next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public Object previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        public int nextIndex() {
            return this.cursor;
        }

        public int previousIndex() {
            return this.cursor - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }

        protected COWIterator(Object[] objectArray, int n) {
            this.array = objectArray;
            this.cursor = n;
        }
    }

    protected static class COWSubList
    extends AbstractList {
        protected final CopyOnWriteArrayList l;
        protected final int offset;
        protected int size;
        protected Object[] expectedArray;

        protected void checkForComodification() {
            if (this.l.array_ != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        protected void rangeCheck(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ",Size: " + this.size);
            }
        }

        public Object set(int n, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                Object object2 = this.l.set(n + this.offset, object);
                this.expectedArray = this.l.array_;
                return object2;
            }
        }

        public Object get(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                return this.l.get(n + this.offset);
            }
        }

        public int size() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        public void add(int n, Object object) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n + this.offset, object);
                this.expectedArray = this.l.array_;
                ++this.size;
            }
        }

        public Object remove(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n);
                this.checkForComodification();
                Object object = this.l.remove(n + this.offset);
                this.expectedArray = this.l.array_;
                --this.size;
                return object;
            }
        }

        public Iterator iterator() {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(0);
            }
        }

        public ListIterator listIterator(int n) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
                }
                return new COWSubListIterator(n);
            }
        }

        public List subList(int n, int n2) {
            CopyOnWriteArrayList copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList(this.l, n + this.offset, n2 + this.offset);
            }
        }

        protected COWSubList(CopyOnWriteArrayList copyOnWriteArrayList, int n, int n2) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = this.l.array();
            this.offset = n;
            this.size = n2 - n;
        }

        protected class COWSubListIterator
        implements ListIterator {
            protected final ListIterator i;
            protected final int index;

            public boolean hasNext() {
                return this.nextIndex() < COWSubList.this.size;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.i.next();
                }
                throw new NoSuchElementException();
            }

            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            public Object previous() {
                if (this.hasPrevious()) {
                    return this.i.previous();
                }
                throw new NoSuchElementException();
            }

            public int nextIndex() {
                return this.i.nextIndex() - COWSubList.this.offset;
            }

            public int previousIndex() {
                return this.i.previousIndex() - COWSubList.this.offset;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object object) {
                throw new UnsupportedOperationException();
            }

            public void add(Object object) {
                throw new UnsupportedOperationException();
            }

            protected COWSubListIterator(int n) {
                this.index = n;
                this.i = COWSubList.this.l.listIterator(n + COWSubList.this.offset);
            }
        }
    }
}

