/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    protected static final int CONCURRENCY_LEVEL = 32;
    protected static final int SEGMENT_MASK = 31;
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 32;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient Entry[] table;
    protected final Segment[] segments = new Segment[32];
    protected final float loadFactor;
    protected int threshold;
    protected volatile transient int votesForResize;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;

    protected static int bitcount(int n) {
        n -= (0xAAAAAAAA & n) >>> 1;
        n = (n & 0x33333333) + (n >>> 2 & 0x33333333);
        n = n + (n >>> 4) & 0xF0F0F0F;
        n += n >>> 8;
        n += n >>> 16;
        return n & 0xFF;
    }

    private final int p2capacity(int n) {
        int n2;
        int n3 = n;
        if (n3 > 0x40000000 || n3 < 0) {
            n2 = 0x40000000;
        } else {
            n2 = 32;
            while (n2 < n3) {
                n2 <<= 1;
            }
        }
        return n2;
    }

    protected static int hash(Object object) {
        int n = object.hashCode();
        return (n << 7) - n + (n >>> 9) + (n >>> 17);
    }

    protected boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected Entry[] newTable(int n) {
        this.threshold = (int)((float)n * this.loadFactor / 32.0f) + 1;
        return new Entry[n];
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.segments.length) {
            n += this.segments[n2].getCount();
            ++n2;
        }
        return n;
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.segments.length) {
            if (this.segments[n].getCount() != 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Object get(Object object) {
        Object object2;
        Entry entry;
        int n = ConcurrentHashMap.hash(object);
        Entry[] entryArray = this.table;
        int n2 = n & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n2];
        while (entry2 != null) {
            if (entry2.hash == n && this.eq(object, entry2.key)) {
                object2 = entry2.value;
                if (object2 == null) break;
                return object2;
            }
            entry2 = entry2.next;
        }
        object2 = this.segments[n & 0x1F];
        Segment segment = object2;
        synchronized (segment) {
            entryArray = this.table;
            n2 = n & entryArray.length - 1;
            Entry entry3 = entryArray[n2];
            if (entry2 != null || entry != entry3) {
                entry2 = entry3;
                while (entry2 != null) {
                    if (entry2.hash == n && this.eq(object, entry2.key)) {
                        return entry2.value;
                    }
                    entry2 = entry2.next;
                }
            }
            return null;
        }
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public Object put(Object object, Object object2) {
        int n;
        int n2;
        Entry[] entryArray;
        Segment segment;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n3 = ConcurrentHashMap.hash(object);
        Segment segment2 = segment = this.segments[n3 & 0x1F];
        synchronized (segment2) {
            Entry entry;
            entryArray = this.table;
            int n4 = n3 & entryArray.length - 1;
            Entry entry2 = entry = entryArray[n4];
            while (entry2 != null) {
                if (entry2.hash == n3 && this.eq(object, entry2.key)) {
                    Object object3 = entry2.value;
                    entry2.value = object2;
                    return object3;
                }
                entry2 = entry2.next;
            }
            entryArray[n4] = entry2 = new Entry(n3, object, object2, entry);
            n2 = ++segment.count;
            if (segment.count < this.threshold) {
                return null;
            }
            n = this.votesForResize;
            int n5 = 1 << (n3 & 0x1F);
            if ((n & n5) == 0) {
                n = this.votesForResize |= n5;
            }
        }
        if (ConcurrentHashMap.bitcount(n) >= 8 || n2 > this.threshold * 32) {
            this.resize(0, entryArray);
        }
        return null;
    }

    protected void resize(int n, Entry[] entryArray) {
        Segment segment;
        Segment segment2 = segment = this.segments[n];
        synchronized (segment2) {
            if (entryArray == this.table) {
                int n2 = n + 1;
                if (n2 < this.segments.length) {
                    this.resize(n2, entryArray);
                } else {
                    this.rehash();
                }
            }
        }
    }

    protected void rehash() {
        this.votesForResize = 0;
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        if (n >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n2 = n << 1;
        Entry[] entryArray2 = this.newTable(n2);
        int n3 = n2 - 1;
        int n4 = 0;
        while (n4 < n) {
            Entry entry = entryArray[n4];
            if (entry != null) {
                int n5 = entry.hash & n3;
                Entry entry2 = entry.next;
                if (entry2 == null) {
                    entryArray2[n5] = entry;
                } else {
                    int n6;
                    Entry entry3 = entry;
                    int n7 = n5;
                    Entry entry4 = entry2;
                    while (entry4 != null) {
                        n6 = entry4.hash & n3;
                        if (n6 != n7) {
                            n7 = n6;
                            entry3 = entry4;
                        }
                        entry4 = entry4.next;
                    }
                    entryArray2[n7] = entry3;
                    entry4 = entry;
                    while (entry4 != entry3) {
                        n6 = entry4.hash & n3;
                        entryArray2[n6] = new Entry(entry4.hash, entry4.key, entry4.value, entryArray2[n6]);
                        entry4 = entry4.next;
                    }
                }
            }
            ++n4;
        }
        this.table = entryArray2;
    }

    public Object remove(Object object) {
        return this.remove(object, null);
    }

    protected Object remove(Object object, Object object2) {
        Segment segment;
        int n = ConcurrentHashMap.hash(object);
        Segment segment2 = segment = this.segments[n & 0x1F];
        synchronized (segment2) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n2 = n & entryArray.length - 1;
            Entry entry2 = entry = entryArray[n2];
            while (true) {
                if (entry2 == null) {
                    return null;
                }
                if (entry2.hash == n && this.eq(object, entry2.key)) break;
                entry2 = entry2.next;
            }
            Object object3 = entry2.value;
            if (object2 != null && !object2.equals(object3)) {
                return null;
            }
            entry2.value = null;
            Entry entry3 = entry2.next;
            Entry entry4 = entry;
            while (entry4 != entry2) {
                entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                entry4 = entry4.next;
            }
            entryArray[n2] = entry3;
            --segment.count;
            return object3;
        }
    }

    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = 0;
        while (n < this.segments.length) {
            Entry[] entryArray;
            Segment segment;
            Segment segment2 = segment = this.segments[n];
            synchronized (segment2) {
                entryArray = this.table;
            }
            int n2 = n;
            while (n2 < entryArray.length) {
                Entry entry = entryArray[n2];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
                n2 += this.segments.length;
            }
            ++n;
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public void putAll(Map map) {
        Object object;
        int n = map.size();
        if (n == 0) {
            return;
        }
        while (true) {
            int n2;
            Segment segment = this.segments[0];
            synchronized (segment) {
                object = this.table;
                n2 = this.threshold * 32;
            }
            if (n < n2) break;
            this.resize(0, (Entry[])object);
        }
        object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.segments.length) {
            Segment segment;
            Segment segment2 = segment = this.segments[n];
            synchronized (segment2) {
                Entry[] entryArray = this.table;
                int n2 = n;
                while (n2 < entryArray.length) {
                    Entry entry = entryArray[n2];
                    while (entry != null) {
                        entry.value = null;
                        entry = entry.next;
                    }
                    entryArray[n2] = null;
                    segment.count = 0;
                    n2 += this.segments.length;
                }
            }
            ++n;
        }
    }

    public Object clone() {
        return new ConcurrentHashMap(this);
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    public Enumeration keys() {
        return new KeyIterator(this);
    }

    public Enumeration elements() {
        return new ValueIterator(this);
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.defaultWriteObject();
        Segment segment = this.segments[0];
        synchronized (segment) {
            n = this.table.length;
        }
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < this.segments.length) {
            Entry[] entryArray;
            Segment segment2;
            Segment segment3 = segment2 = this.segments[n2];
            synchronized (segment3) {
                entryArray = this.table;
            }
            int n3 = n2;
            while (n3 < entryArray.length) {
                Entry entry = entryArray[n3];
                while (entry != null) {
                    objectOutputStream.writeObject(entry.key);
                    objectOutputStream.writeObject(entry.value);
                    entry = entry.next;
                }
                n3 += this.segments.length;
            }
            ++n2;
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = this.newTable(n);
        int n2 = 0;
        while (n2 < this.segments.length) {
            this.segments[n2] = new Segment();
            ++n2;
        }
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, object2);
        }
    }

    public ConcurrentHashMap(int n, float f) {
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f);
        }
        this.loadFactor = f;
        int n2 = 0;
        while (n2 < this.segments.length) {
            this.segments[n2] = new Segment();
            ++n2;
        }
        n2 = this.p2capacity(n);
        this.table = this.newTable(n2);
    }

    public ConcurrentHashMap(int n) {
        this(n, 0.75f);
    }

    public ConcurrentHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public ConcurrentHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(map);
    }

    protected static final class Segment {
        protected int count;

        protected final synchronized int getCount() {
            return this.count;
        }

        protected final synchronized void synch() {
        }

        Segment() {
        }
    }

    private class KeySet
    extends AbstractSet {
        public Iterator iterator() {
            ConcurrentHashMap concurrentHashMap = ConcurrentHashMap.this;
            if (concurrentHashMap == null) {
                throw null;
            }
            return new KeyIterator(concurrentHashMap);
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return ConcurrentHashMap.this.remove(object) != null;
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        KeySet() {
        }
    }

    private class Values
    extends AbstractCollection {
        public Iterator iterator() {
            ConcurrentHashMap concurrentHashMap = ConcurrentHashMap.this;
            if (concurrentHashMap == null) {
                throw null;
            }
            return new ValueIterator(concurrentHashMap);
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsValue(object);
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        Values() {
        }
    }

    private class EntrySet
    extends AbstractSet {
        public Iterator iterator() {
            ConcurrentHashMap concurrentHashMap = ConcurrentHashMap.this;
            if (concurrentHashMap == null) {
                throw null;
            }
            return concurrentHashMap.new HashIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = ConcurrentHashMap.this.get(entry.getKey());
            return object2 != null && object2.equals(entry.getValue());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentHashMap.this.remove(entry.getKey(), entry.getValue()) != null;
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }

        EntrySet() {
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final Object key;
        protected volatile Object value;
        protected final int hash;
        protected final Entry next;

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.key.equals(entry.getKey()) && this.value.equals(entry.getValue());
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        Entry(int n, Object object, Object object2, Entry entry) {
            this.value = object2;
            this.hash = n;
            this.key = object;
            this.next = entry;
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected int index;
        protected Entry entry = null;
        protected Object currentKey;
        protected Object currentValue;
        protected Entry lastReturned = null;

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object object = this.entry.value;
                    if (object != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = object;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return object;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }

        protected HashIterator() {
            Segment segment = ConcurrentHashMap.this.segments[0];
            synchronized (segment) {
                this.tab = ConcurrentHashMap.this.table;
            }
            int n = 1;
            while (n < ConcurrentHashMap.this.segments.length) {
                ConcurrentHashMap.this.segments[n].synch();
                ++n;
            }
            this.index = this.tab.length - 1;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        private final /* synthetic */ ConcurrentHashMap this$0;

        protected Object returnValueOfNext() {
            return this.currentKey;
        }

        KeyIterator(ConcurrentHashMap concurrentHashMap) {
            ConcurrentHashMap concurrentHashMap2 = concurrentHashMap;
            if (concurrentHashMap2 == null) {
                throw null;
            }
            this.this$0 = concurrentHashMap;
        }
    }

    protected class ValueIterator
    extends HashIterator {
        private final /* synthetic */ ConcurrentHashMap this$0;

        protected Object returnValueOfNext() {
            return this.currentValue;
        }

        ValueIterator(ConcurrentHashMap concurrentHashMap) {
            ConcurrentHashMap concurrentHashMap2 = concurrentHashMap;
            if (concurrentHashMap2 == null) {
                throw null;
            }
            this.this$0 = concurrentHashMap;
        }
    }
}

