/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.Heap;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.Date;

public class ClockDaemon
extends ThreadFactoryUser {
    protected final Heap heap_ = new Heap(DefaultChannelCapacity.get());
    protected Thread thread_;
    protected final RunLoop runLoop_ = new RunLoop();

    public Object executeAt(Date date, Runnable runnable) {
        TaskNode taskNode = new TaskNode(date.getTime(), runnable);
        this.heap_.insert(taskNode);
        this.restart();
        return taskNode;
    }

    public Object executeAfterDelay(long l, Runnable runnable) {
        long l2 = System.currentTimeMillis() + l;
        TaskNode taskNode = new TaskNode(l2, runnable);
        this.heap_.insert(taskNode);
        this.restart();
        return taskNode;
    }

    public Object executePeriodically(long l, Runnable runnable, boolean bl) {
        if (l <= 0L) {
            throw new IllegalArgumentException();
        }
        long l2 = System.currentTimeMillis();
        if (!bl) {
            l2 += l;
        }
        TaskNode taskNode = new TaskNode(l2, runnable, l);
        this.heap_.insert(taskNode);
        this.restart();
        return taskNode;
    }

    public static void cancel(Object object) {
        ((TaskNode)object).setCancelled();
    }

    public synchronized Thread getThread() {
        return this.thread_;
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public synchronized void restart() {
        if (this.thread_ == null) {
            this.thread_ = this.threadFactory_.newThread(this.runLoop_);
            this.thread_.start();
        } else {
            this.notify();
        }
    }

    public synchronized void shutDown() {
        this.heap_.clear();
        if (this.thread_ != null) {
            this.thread_.interrupt();
        }
        this.thread_ = null;
    }

    protected synchronized TaskNode nextTask() {
        try {
            while (!Thread.interrupted()) {
                TaskNode taskNode = (TaskNode)this.heap_.peek();
                if (taskNode == null) {
                    this.wait();
                    continue;
                }
                long l = System.currentTimeMillis();
                long l2 = taskNode.getTimeToRun();
                if (l2 > l) {
                    this.wait(l2 - l);
                    continue;
                }
                taskNode = (TaskNode)this.heap_.extract();
                if (taskNode.getCancelled()) continue;
                if (taskNode.period > 0L) {
                    taskNode.setTimeToRun(l + taskNode.period);
                    this.heap_.insert(taskNode);
                }
                return taskNode;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected static class TaskNode
    implements Comparable {
        final Runnable command;
        final long period;
        private long timeToRun_;
        private boolean cancelled_ = false;

        synchronized void setCancelled() {
            this.cancelled_ = true;
        }

        synchronized boolean getCancelled() {
            return this.cancelled_;
        }

        synchronized void setTimeToRun(long l) {
            this.timeToRun_ = l;
        }

        synchronized long getTimeToRun() {
            return this.timeToRun_;
        }

        public int compareTo(Object object) {
            long l;
            long l2 = this.getTimeToRun();
            return l2 < (l = ((TaskNode)object).getTimeToRun()) ? -1 : (l2 == l ? 0 : 1);
        }

        TaskNode(long l, Runnable runnable, long l2) {
            this.timeToRun_ = l;
            this.command = runnable;
            this.period = l2;
        }

        TaskNode(long l, Runnable runnable) {
            this(l, runnable, -1L);
        }
    }

    protected class RunLoop
    implements Runnable {
        public void run() {
            try {
                TaskNode taskNode;
                while ((taskNode = ClockDaemon.this.nextTask()) != null) {
                    taskNode.command.run();
                }
                Object var2_2 = null;
                ClockDaemon.this.clearThread();
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                ClockDaemon.this.clearThread();
                throw throwable;
            }
        }

        RunLoop() {
        }
    }
}

