/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;

public class BoundedBuffer
implements BoundedChannel {
    protected final Object[] array_;
    protected int takePtr_ = 0;
    protected int putPtr_ = 0;
    protected int usedSlots_ = 0;
    protected int emptySlots_;
    protected final Object putMonitor_ = new Object();

    public synchronized int size() {
        return this.usedSlots_;
    }

    public int capacity() {
        return this.array_.length;
    }

    protected void incEmptySlots() {
        Object object = this.putMonitor_;
        synchronized (object) {
            ++this.emptySlots_;
            this.putMonitor_.notify();
        }
    }

    protected synchronized void incUsedSlots() {
        ++this.usedSlots_;
        this.notify();
    }

    protected final void insert(Object object) {
        --this.emptySlots_;
        this.array_[this.putPtr_] = object;
        if (++this.putPtr_ >= this.array_.length) {
            this.putPtr_ = 0;
        }
    }

    protected final Object extract() {
        --this.usedSlots_;
        Object object = this.array_[this.takePtr_];
        this.array_[this.takePtr_] = null;
        if (++this.takePtr_ >= this.array_.length) {
            this.takePtr_ = 0;
        }
        return object;
    }

    public Object peek() {
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            if (this.usedSlots_ > 0) {
                return this.array_[this.takePtr_];
            }
            return null;
        }
    }

    public void put(Object object) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object2 = this.putMonitor_;
        synchronized (object2) {
            while (this.emptySlots_ <= 0) {
                try {
                    this.putMonitor_.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.putMonitor_.notify();
                    throw interruptedException;
                }
            }
            this.insert(object);
        }
        this.incUsedSlots();
    }

    public boolean offer(Object object, long l) throws InterruptedException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object2 = this.putMonitor_;
        synchronized (object2) {
            long l2 = l <= 0L ? 0L : System.currentTimeMillis();
            long l3 = l;
            while (this.emptySlots_ <= 0) {
                if (l3 <= 0L) {
                    return false;
                }
                try {
                    this.putMonitor_.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    this.putMonitor_.notify();
                    throw interruptedException;
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            this.insert(object);
        }
        this.incUsedSlots();
        return true;
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = null;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            while (this.usedSlots_ <= 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
            object = this.extract();
        }
        this.incEmptySlots();
        return object;
    }

    public Object poll(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = null;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            long l2 = l <= 0L ? 0L : System.currentTimeMillis();
            long l3 = l;
            while (this.usedSlots_ <= 0) {
                if (l3 <= 0L) {
                    return null;
                }
                try {
                    this.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
                l3 = l - (System.currentTimeMillis() - l2);
            }
            object = this.extract();
        }
        this.incEmptySlots();
        return object;
    }

    public BoundedBuffer(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.array_ = new Object[n];
        this.emptySlots_ = n;
    }

    public BoundedBuffer() {
        this(DefaultChannelCapacity.get());
    }
}

