/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.MiniSeedRead;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MultiFileMSeedRead
extends MiniSeedRead {
    int numReadTotal = 0;
    int currentIndex = 0;
    File[] files;
    MiniSeedRead current;
    int current_record = 0;
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$seisFile$mseed$MultiFileMSeedRead == null ? (class$edu$sc$seis$seisFile$mseed$MultiFileMSeedRead = MultiFileMSeedRead.class$("edu.sc.seis.seisFile.mseed.MultiFileMSeedRead")) : class$edu$sc$seis$seisFile$mseed$MultiFileMSeedRead));
    static /* synthetic */ Class class$edu$sc$seis$seisFile$mseed$MultiFileMSeedRead;

    public MultiFileMSeedRead(File[] files) throws IOException {
        this.files = files;
        this.initNextFile();
    }

    public void close() throws IOException {
        if (this.current != null) {
            this.current.close();
        }
        this.currentIndex = this.files.length;
    }

    public DataRecord getNextRecord() throws SeedFormatException, IOException {
        if (this.current == null) {
            throw new EOFException("Cannot read past end of file list");
        }
        try {
            DataRecord d = this.current.getNextRecord();
            ++this.numReadTotal;
            return d;
        }
        catch (EOFException e) {
            this.initNextFile();
            DataRecord d = this.current.getNextRecord();
            ++this.numReadTotal;
            return d;
        }
    }

    public int getNumRecordsRead() {
        return this.numReadTotal;
    }

    protected void initNextFile() throws IOException {
        if (this.currentIndex < this.files.length) {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
            logger.debug((Object)("Loading next mseed file: " + this.currentIndex + " of " + this.files.length + " " + this.files[this.currentIndex].getName()));
            this.current = new MiniSeedRead(new DataInputStream(new BufferedInputStream(new FileInputStream(this.files[this.currentIndex]))));
            ++this.currentIndex;
        } else {
            logger.debug((Object)("Last loaded " + this.currentIndex));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

