/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.BlocketteUnknown;
import edu.sc.seis.seisFile.mseed.ControlHeader;
import edu.sc.seis.seisFile.mseed.DataBlockette;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;

public class DataRecord
extends SeedRecord
implements Serializable {
    protected byte[] data;
    byte ZERO_BYTE = 0;
    int RECORD_SIZE = 4096;

    public DataRecord(DataHeader header) {
        super(header);
    }

    public void addBlockette(Blockette b) throws SeedFormatException {
        if (b == null) {
            throw new IllegalArgumentException("Blockette cannot be null");
        }
        if (b instanceof DataBlockette) {
            super.addBlockette(b);
            this.getHeader().setNumBlockettes((byte)(this.getHeader().getNumBlockettes() + 1));
        } else if (b instanceof BlocketteUnknown) {
            System.out.println("BlockettUnknown added: " + b.getType());
        } else {
            throw new SeedFormatException("Cannot add non-data blockettes to a DataRecord " + b.getType());
        }
        this.recheckDataOffset();
    }

    protected void recheckDataOffset() throws SeedFormatException {
        int size = this.getHeader().getSize();
        Blockette[] blocks = this.getBlockettes();
        for (int i = 0; i < blocks.length; ++i) {
            size += blocks[i].getSize();
        }
        if (this.data != null) {
            size += this.data.length;
        }
        if (size > this.RECORD_SIZE) {
            throw new SeedFormatException("Can't fit blockettes and data in record " + size);
        }
        if (this.data != null) {
            this.getHeader().setDataOffset((short)(this.RECORD_SIZE - this.data.length));
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) throws SeedFormatException {
        this.data = data;
        this.recheckDataOffset();
    }

    public int getDataSize() {
        return this.data.length;
    }

    public DataHeader getHeader() {
        return (DataHeader)this.header;
    }

    public void write(DataOutputStream dos) throws IOException {
        Blockette[] blockettes = this.getBlockettes();
        this.getHeader().setNumBlockettes((byte)blockettes.length);
        if (blockettes.length != 0) {
            this.getHeader().setDataBlocketteOffset((short)48);
        }
        this.getHeader().write(dos);
        short s = this.getHeader().getSize();
        for (int i = 0; i < blockettes.length; ++i) {
            short s2;
            DataBlockette dataB = (DataBlockette)blockettes[i];
            s2 = (short)(s2 + (short)dataB.getSize());
            if (i != blockettes.length - 1) {
                dos.write(dataB.toBytes(s2));
                continue;
            }
            dos.write(dataB.toBytes((short)0));
        }
        boolean zero = false;
        for (void i = s2; i < this.getHeader().getDataOffset(); ++i) {
            dos.write(this.ZERO_BYTE);
        }
        dos.write(this.data);
        int remainBytes = this.RECORD_SIZE - this.getHeader().getDataOffset() - this.data.length;
        for (int i = 0; i < remainBytes; ++i) {
            dos.write(this.ZERO_BYTE);
        }
    }

    public static DataRecord read(DataInputStream inStream) throws IOException, SeedFormatException {
        ControlHeader header = ControlHeader.read(inStream);
        if (header instanceof DataHeader) {
            return DataRecord.readDataRecord(inStream, (DataHeader)header);
        }
        throw new SeedFormatException("Found a control header in a miniseed file");
    }

    protected static DataRecord readDataRecord(DataInputStream inStream, DataHeader header) throws IOException, SeedFormatException {
        Blockette[] allBs;
        byte[] garbage = new byte[header.getDataBlocketteOffset() - header.getSize()];
        DataRecord dataRec = new DataRecord(header);
        if (garbage.length != 0) {
            inStream.readFully(garbage);
        }
        int currOffset = header.getDataBlocketteOffset();
        for (int i = 0; i < header.getNumBlockettes(); ++i) {
            byte hibyteType = inStream.readByte();
            byte lowbyteType = inStream.readByte();
            int type = Utility.uBytesToInt(hibyteType, lowbyteType, false);
            byte hibyteOffset = inStream.readByte();
            byte lowbyteOffset = inStream.readByte();
            int nextOffset = Utility.uBytesToInt(hibyteOffset, lowbyteOffset, false);
            byte[] blocketteBytes = nextOffset != 0 ? new byte[nextOffset - currOffset] : (header.getDataOffset() > currOffset ? new byte[header.getDataOffset() - (currOffset += 4)] : new byte[]{});
            inStream.readFully(blocketteBytes);
            currOffset = nextOffset != 0 ? nextOffset : (currOffset += blocketteBytes.length);
            byte[] fullBlocketteBytes = new byte[blocketteBytes.length + 4];
            System.arraycopy(blocketteBytes, 0, fullBlocketteBytes, 4, blocketteBytes.length);
            fullBlocketteBytes[0] = hibyteType;
            fullBlocketteBytes[1] = lowbyteType;
            fullBlocketteBytes[2] = hibyteOffset;
            fullBlocketteBytes[3] = lowbyteOffset;
            Blockette b = Blockette.parseBlockette(type, fullBlocketteBytes);
            dataRec.addBlockette(b);
            if (nextOffset == 0) break;
        }
        if ((allBs = dataRec.getBlockettes(1000)).length == 0) {
            throw new SeedFormatException("no blockette 1000");
        }
        if (allBs.length > 1) {
            throw new SeedFormatException("Multiple blockette 1000s in the volume. " + allBs.length);
        }
        Blockette1000 b1000 = (Blockette1000)allBs[0];
        byte[] timeseries = header.getDataOffset() == 0 ? new byte[b1000.getDataRecordLength() - currOffset] : new byte[b1000.getDataRecordLength() - header.getDataOffset()];
        inStream.readFully(timeseries);
        dataRec.setData(timeseries);
        return dataRec;
    }

    public String toString() {
        String s = "Data " + super.toString();
        s = s + "\n" + this.data.length + " bytes of data read.";
        return s;
    }

    public void writeASCII(Writer out) throws IOException {
        out.write("DataRecord\n");
        this.getHeader().writeASCII(out);
        Blockette[] b = this.getBlockettes();
        for (int i = 0; i < b.length; ++i) {
            b[i].writeASCII(out);
        }
        out.write("End DataRecord\n");
    }
}

