/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.DataBlockette;
import java.io.IOException;
import java.io.Writer;

public class Blockette1000
extends DataBlockette {
    public static final int B1000_SIZE = 8;

    public Blockette1000() {
        super(8);
    }

    public Blockette1000(byte[] info) {
        super(info);
        this.trimToSize(8);
    }

    public int getSize() {
        return 8;
    }

    public int getType() {
        return 1000;
    }

    public String getName() {
        return "Data Only SEED Blockette";
    }

    public byte getEncodingFormat() {
        return this.info[4];
    }

    public void setEncodingFormat(byte v) {
        this.info[4] = v;
    }

    public byte getWordOrder() {
        return this.info[5];
    }

    public void setWordOrder(byte v) {
        this.info[5] = v;
    }

    public boolean isBigEndian() {
        return this.info[5] == 1;
    }

    public boolean isLittleEndian() {
        return !this.isBigEndian();
    }

    public byte getDataRecordLengthByte() {
        return this.info[6];
    }

    public int getDataRecordLength() {
        if (this.getDataRecordLengthByte() < 31) {
            return 1 << this.getDataRecordLengthByte();
        }
        throw new RuntimeException("Data Record Length exceeds size of int");
    }

    public void setDataRecordLength(byte v) {
        this.info[6] = v;
    }

    public byte getReserved() {
        return this.info[7];
    }

    public void setReserved(byte v) {
        this.info[7] = v;
    }

    public void writeASCII(Writer out) throws IOException {
        out.write("Blockette1000 " + this.getEncodingFormat() + " " + this.getWordOrder() + " " + this.getDataRecordLengthByte());
    }

    public String toString() {
        return super.toString() + "  format=" + this.getEncodingFormat();
    }
}

