package edu.sc.seis.TauP;


import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class SvgUtil {
    public static void xyplotScriptBeginning(PrintWriter out, String toolName, String[] cmdLineArgs, float mapWidth, int plotOffset) {
        xyplotScriptBeginning( out,  toolName,  cmdLineArgs,  mapWidth,  plotOffset, "");
    }

    public static void xyplotScriptBeginning(PrintWriter out,
                                             String toolName, String[] cmdLineArgs,
                                             float mapWidth, int plotOffset,
                                             String extraCSS) {
        float pixelWidth =  (72.0f*mapWidth);
        out.println("<svg version=\"1.1\" baseProfile=\"full\" xmlns=\"http://www.w3.org/2000/svg\"  viewBox=\"0 0 "+(pixelWidth)+" "+(pixelWidth)+"\">");
        SvgUtil.cmdLineArgAsComment(out, toolName, cmdLineArgs);
        out.println("<!--\n Generated by The TauP Toolkit, www.seis.sc.edu/taup\n -->");
        out.println("<defs>");
        out.println("    <style type=\"text/css\"><![CDATA[");
        out.println(extraCSS);
        out.println("        text.title {");
        out.println("            text-anchor: middle;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("        circle {");
        out.println("            vector-effect: non-scaling-stroke;");
        out.println("            stroke: grey;");
        out.println("            fill: transparent;");
        out.println("        }");
        out.println("        .xtick {");
        out.println("            text-anchor: middle;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("        .ytick {");
        out.println("            text-anchor: end;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("        line.legend {");
        out.println("            text-anchor: end;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("        text.legend {");
        out.println("            text-anchor: start;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("        line.tick {");
        out.println("            vector-effect: non-scaling-stroke;");
        out.println("            stroke: black;");
        out.println("            fill: transparent;");
        out.println("        }");
        out.println("        .xlabel {");
        out.println("            text-anchor: middle;");
        out.println("        }");
        out.println("        .ylabel {");
        out.println("            text-anchor: middle;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("        .phaselabel {");
        out.println("            text-anchor: end;");
        out.println("            dominant-baseline: middle;");
        out.println("        }");
        out.println("        polyline {");
        out.println("            vector-effect: non-scaling-stroke;");
        //out.println("            stroke: black;");
        out.println("            fill: transparent;");
        out.println("        }");
        out.println("        polyline.tick {");
        out.println("            stroke: black;");
        out.println("        }");
        out.println("        polyline.sourcedepth {");
        out.println("            stroke: lightgrey;");
        out.println("        }");
        out.println("        polyline.receiverdepth {");
        out.println("            stroke: lightgrey;");
        out.println("        }");
        out.println("        polyline.scattererdepth {");
        out.println("            stroke: lightgrey;");
        out.println("        }");
        out.println("        polyline.swave {");
        out.println("            stroke: red;");
        out.println("        }");
        out.println("        polyline.pwave {");
        out.println("            stroke: blue;");
        out.println("        }");
        out.println("        circle.discontinuity {");
        out.println("            vector-effect: non-scaling-stroke;");
        out.println("            stroke: grey;");
        out.println("            fill: none;");
        out.println("        }");
        out.println("        circle.discontinuity.surface {");
        out.println("            fill: lightgoldenrodyellow;");
        out.println("        }");
        out.println("        circle.discontinuity.moho {");
        out.println("            fill: blanchedalmond;");
        out.println("        }");
        out.println("        circle.discontinuity.cmb {");
        out.println("            fill: lemonchiffon;");
        out.println("        }");
        out.println("        circle.discontinuity.iocb {");
        out.println("            fill: burlywood;");
        out.println("        }");
        out.println("        .Rpp {");
        out.println("            stroke: blue;");
        out.println("        }");
        out.println("        .Rps {");
        out.println("            stroke: green;");
        out.println("        }");
        out.println("        .Rsp {");
        out.println("            stroke: red;");
        out.println("        }");
        out.println("        .Rss {");
        out.println("            stroke: orange;");
        out.println("        }");
        out.println("        .Rshsh {");
        out.println("            stroke: mediumslateblue;");
        out.println("        }");
        out.println("        .Tpp {");
        out.println("            stroke: cyan;");
        out.println("        }");
        out.println("        .Tps {");
        out.println("            stroke: gold;");
        out.println("        }");
        out.println("        .Tsp {");
        out.println("            stroke: magenta;");
        out.println("        }");
        out.println("        .Tss {");
        out.println("            stroke: grey;");
        out.println("        }");
        out.println("        .Tshsh {");
        out.println("            stroke: violet;");
        out.println("        }");
        createCSSColors( out, "g.autocolor", List.of("stroke"), DEFAULT_COLORS);
        createCSSColors( out, ".autocolor.phaselabel", List.of("fill"), DEFAULT_COLORS);
        out.println("    ]]></style>");
        out.println("</defs>");
        out.println("<g transform=\"translate("+plotOffset+","+plotOffset+")\" >");
        out.println("<!-- draw axis and label distances.-->");
        out.println();

    }

    public static void cmdLineArgAsComment(PrintWriter out, String cmd, String[] args) {
        out.println("<!-- ");
        out.println("   created with TauP "+ BuildVersion.getVersion());
        out.print("    "+cmd+" ");
        for (String s : args) {
            if (s.startsWith("--")) {
                s = "&#45;&#45;"+s.substring(2);
            }
            out.print(s+" ");
        }
        out.println();
        out.println("-->");
    }

    public static void createXYAxes(PrintWriter out,
                                    double minX, double maxX, int numXTicks, boolean xEndFixed,
                                    double minY, double maxY, int numYTicks, boolean yEndFixed,
                                    float pixelWidth, float margin,
                                    String title, String xLabel, String yLabel) {
        float plotWidth = pixelWidth - margin;
        float tick_length = 10;
        float text_height = 12; // guess text font height to shift x-axis tick labels
        ArrayList<Double> xTicks = PlotTicks.getTicks(minX, maxX, numXTicks);
        ArrayList<Double> yTicks = PlotTicks.getTicks(minY, maxY, numYTicks);
        out.println("<text class=\"title\" x=\""+(pixelWidth/2-margin)+"\" y=\""+(-1*margin)+"\">"+title+"</text>");
        out.println("<g> <!-- y axis -->");
        int yLabel_y = Math.round(plotWidth / 2);
        int yLabel_x = Math.round(-1 * 1.8f*margin );
        out.println("<g  >");
        out.println("  <text font-size=\"14\" transform=\"translate("+yLabel_x+", "+yLabel_y+") rotate(-90 )\" dy=\".75em\" text-anchor=\"middle\" class=\"ylabel\" >" + yLabel + "</text>");
        out.println("</g>");
        out.println("<line  class=\"tick\" x1=\"0\" y1=\"0\" x2=\"0\" y2=\""+(plotWidth)+"\" />");
        for (double tick: yTicks) {
            // Y axis
            double tick_pixel;
            if (maxY > minY) {
                tick_pixel = (tick-minY ) / (maxY-minY) * plotWidth;
            } else {
                tick_pixel = (minY-tick) / (minY-maxY) * plotWidth;
            }
            String tick_text = ""+((float)tick);
            out.println("<text class=\"ytick\" font-size=\"12\" x=\"" + (-1 * tick_length - 2) + "\" y=\"" + (plotWidth - tick_pixel) + "\">" + tick_text + "</text>");
            out.println("<line class=\"tick\" x1=\"0\" y1=\"" + (plotWidth - tick_pixel) + "\" x2=\"-" + tick_length + "\" y2=\"" + (plotWidth - tick_pixel) + "\" />");
        }
        out.println("</g> <!-- y axis end-->");
        out.println("<g> <!-- x axis -->");
        out.println("<text class=\"xlabel\" font-size=\"14\" x=\"" + (plotWidth / 2) + "\" y=\"" + (2.2*text_height + tick_length + plotWidth) + "\">" + xLabel + "</text>");
        out.println("<line class=\"tick\" x1=\"0\" y1=\""+(plotWidth)+"\" x2=\""+(plotWidth)+"\" y2=\""+(plotWidth)+"\" />");
        for (double tick: xTicks) {
            // X axis
            double tick_pixel;
            if (maxX > minX) {
                tick_pixel = (tick-minX) / (maxX-minX) * plotWidth;
            } else {
                tick_pixel = (minX-tick) / (minX-maxX) * plotWidth;
            }
            String tick_text = ""+((float)tick);
            out.println("<text class=\"xtick\" font-size=\"12\" x=\"" + tick_pixel + "\" y=\"" + (text_height + tick_length + plotWidth) + "\">" + tick_text + "</text>");
            out.println("<line class=\"tick\" x1=\"" + tick_pixel + "\" y1=\"" + (plotWidth) + "\" x2=\"" + tick_pixel + "\" y2=\"" + (plotWidth + tick_length) + "\" />");

        }
        out.println("</g> <!-- x axis end-->");

    }

    public static void createLegend(PrintWriter out, List<String> labels, List<String> labelClasses) {
        int lineLength = 10;
        int font_size = 14;
        int yoffset = font_size+2;
        out.println("<g> <!-- legend -->");
        for (int i = 0; i < labels.size(); i++) {
            String labelCSS = "tick";
            int y = i*yoffset;
            if (i < labelClasses.size()) { labelCSS = labelClasses.get(i);}
            out.println("<line class=\"legend "+labelCSS+"\" x1=\"0\" y1=\"" + (y) + "\" x2=\"" + lineLength + "\" y2=\"" + (y) + "\" />");
            out.println("<text class=\"legend\" font-size=\""+font_size+"\" x=\"" + lineLength + "\" y=\"" + (y) + "\">" + labels.get(i) + "</text>");
        }
        out.println("</g> <!-- legend end-->");
    }

    public static void createCSSColors(PrintWriter out, String selector, List<String> cssAttrList, List<String> colors) {
        for (int i = 0; i < colors.size(); i++) {
            out.println("        "+selector+":nth-child("+colors.size()+"n+"+(i+1)+") {");
            for (String cssAttr : cssAttrList) {
                out.println("            " + cssAttr + ": " + colors.get(i) + ";");
            }
            out.println("        }");
        }
    }

    public static List<String> DEFAULT_COLORS = List.of(
            "skyblue",
            "olivedrab",
            "goldenrod",
            "firebrick",
            "darkcyan",
            "chocolate",
            "darkmagenta",
            "mediumvioletred",
            "sienna",
            "rebeccapurple");
}
