package edu.sc.seis.TauP;

import javax.swing.DefaultListModel;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;
import javax.swing.SwingUtilities;

/*
 * The TauP Toolkit: Flexible Seismic Travel-Time and Raypath Utilities.
 * Copyright (C) 1998-2000 University of South Carolina
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 * The current version can be found at <A
 * HREF="www.seis.sc.edu">http://www.seis.sc.edu</A>
 * 
 * Bug reports and comments should be directed to H. Philip Crotwell,
 * crotwell@seis.sc.edu or Tom Owens, owens@seis.sc.edu
 * 
 */

public class PhaseDialog extends javax.swing.JDialog {

    /** Initializes the Form */
    public PhaseDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        phaseListModel = new DefaultListModel();
        phaseList.setModel(phaseListModel);
        pack();
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the FormEditor.
     */
    private void initComponents() {// GEN-BEGIN:initComponents
        // This code was developed using a non-commercially licensed version of
        // NetBeans Developer 2.x.
        // For details, see http://www.netbeans.com/non_commercial.html
        setBackground(new java.awt.Color(192, 192, 192));
        addWindowListener(new java.awt.event.WindowAdapter() {

            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        getContentPane().setLayout(new java.awt.BorderLayout());
        jLabel1 = new javax.swing.JLabel();
        jLabel1.setText("Choose Phases");
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        getContentPane().add(jLabel1, "North");
        jPanel1 = new javax.swing.JPanel();
        jPanel1.setLayout(new java.awt.FlowLayout());
        jLabel2 = new javax.swing.JLabel();
        jLabel2.setText("Add new");
        jPanel1.add(jLabel2);
        addPhaseTextField = new javax.swing.JTextField();
        addPhaseTextField.setPreferredSize(new java.awt.Dimension(100, 21));
        addPhaseTextField.setMinimumSize(new java.awt.Dimension(100, 21));
        addPhaseTextField.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addPhaseActionPerformed(evt);
            }
        });
        jPanel1.add(addPhaseTextField);
        closeButton = new javax.swing.JButton();
        closeButton.setText("Close");
        closeButton.setActionCommand("ClosePhaseDialog");
        closeButton.addActionListener(new java.awt.event.ActionListener() {

            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeActionPerformed(evt);
            }
        });
        jPanel1.add(closeButton);
        getContentPane().add(jPanel1, "South");
        jPanel2 = new javax.swing.JPanel();
        jPanel2.setLayout(new java.awt.BorderLayout());
        jScrollPane1 = new javax.swing.JScrollPane();
        phaseList = new javax.swing.JList();
        phaseList.addKeyListener(new java.awt.event.KeyAdapter() {

            public void keyTyped(java.awt.event.KeyEvent evt) {
                phaseListKeyTyped(evt);
            }
        });
        jScrollPane1.add(phaseList);
        jScrollPane1.setViewportView(phaseList);
        jPanel2.add(jScrollPane1, "Center");
        getContentPane().add(jPanel2, "Center");
    }// GEN-END:initComponents

    private void phaseListKeyTyped(java.awt.event.KeyEvent evt) {// GEN-FIRST:event_phaseListKeyTyped
        // Add your handling code here:
        String areaText = addPhaseTextField.getText();
        if(evt.getKeyChar() != java.awt.event.KeyEvent.VK_ENTER) {
            areaText += evt.getKeyChar();
            addPhaseTextField.setText(areaText);
        } else {
            addPhaseActionPerformed(new java.awt.event.ActionEvent(this,
                                                                   0,
                                                                   areaText));
        }
    }// GEN-LAST:event_phaseListKeyTyped

    private void addPhaseActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_addPhaseActionPerformed
        // Add your handling code here:
        phaseListModel.addElement(evt.getActionCommand());
        ListSelectionModel sel = phaseList.getSelectionModel();
        sel.addSelectionInterval(phaseListModel.getSize() - 1,
                                 phaseListModel.getSize() - 1);
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                phaseList.ensureIndexIsVisible(phaseListModel.getSize() - 1);
            }
        });
    }// GEN-LAST:event_addPhaseActionPerformed

    private void closeActionPerformed(java.awt.event.ActionEvent evt) {// GEN-FIRST:event_closeActionPerformed
        // Add your handling code here:
        setVisible(false);
    }// GEN-LAST:event_closeActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {// GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }// GEN-LAST:event_closeDialog

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;

    private javax.swing.JPanel jPanel1;

    private javax.swing.JPanel jPanel2;

    private javax.swing.JLabel jLabel2;

    private javax.swing.JTextField addPhaseTextField;

    private javax.swing.JButton closeButton;

    private javax.swing.JScrollPane jScrollPane1;

    private javax.swing.JList phaseList;

    // End of variables declaration//GEN-END:variables
    private DefaultListModel phaseListModel;

    public String[] getPhases() {
        int[] selected = phaseList.getSelectedIndices();
        String[] phases = new String[selected.length];
        for(int i = 0; i < selected.length; i++) {
            phases[i] = (String)phaseListModel.elementAt(selected[i]);
        }
        return phases;
    }

    public void setPhases(String[] phases) {
        phaseListModel.removeAllElements();
        for(int i = 0; i < phases.length; i++) {
            phaseListModel.addElement(phases[i]);
        }
        ListSelectionModel sel = phaseList.getSelectionModel();
        sel.addSelectionInterval(0, phaseListModel.getSize() - 1);
    }

    public void setSelectedPhases(String[] phases) {
        ListSelectionModel sel = phaseList.getSelectionModel();
        sel.clearSelection();
        for(int i = 0; i < phases.length; i++) {
            for(int j = 0; j < phaseListModel.size(); j++) {
                if(phases[i].equals(phaseListModel.elementAt(j))) {
                    sel.addSelectionInterval(j, j);
                }
            }
        }
    }
}
