/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class TauP_VelocityMerge
extends TauP_Tool {
    String modelName;
    String modelType;
    String overlayModelName = null;
    String overlayModelType = null;
    boolean smoothTop = false;
    boolean smoothBottom = false;
    float elevation = 0.0f;
    public static final String ND = "nd";
    public static final String TVEL = "tvel";

    public TauP_VelocityMerge() {
        this.setOutFileExtension(ND);
        this.setDefaultOutputFormat();
    }

    @Override
    public void start() throws SlownessModelException, TauModelException, VelocityModelException, IOException {
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelName + ", tried internally and from file");
        }
        VelocityModel outVMod = vMod;
        if (this.overlayModelName != null) {
            if (DEBUG) {
                System.out.println("base model: " + vMod.modelName);
                System.out.println("merge model: " + this.overlayModelName);
            }
            VelocityModel overlayVMod = TauModelLoader.loadVelocityModel(this.overlayModelName, this.overlayModelType);
            outVMod = vMod.replaceLayers(overlayVMod.getLayers(), overlayVMod.getModelName(), this.smoothTop, this.smoothBottom);
            outVMod.setModelName(vMod.modelName + "_" + overlayVMod.getModelName());
        } else if (DEBUG) {
            System.out.println("base model: " + vMod.modelName);
            System.out.println("no merge model requested.");
        }
        if (this.elevation != 0.0f) {
            outVMod = outVMod.elevationLayer(this.elevation, this.overlayModelName);
        }
        try {
            PrintWriter dos;
            if (this.getOutFile() == "stdout") {
                dos = new PrintWriter(new OutputStreamWriter(System.out));
            } else {
                if (DEBUG) {
                    System.out.println("Save to " + this.getOutFile());
                }
                dos = new PrintWriter(new BufferedWriter(new FileWriter(this.getOutFile())));
            }
            if (this.getOutputFormat() == ND || this.getOutputFormat() == "text") {
                outVMod.writeToND(dos);
            } else {
                if (this.getOutputFormat() == TVEL) {
                    throw new RuntimeException("tvel output not yet implemented");
                }
                if (this.getOutputFormat() == "json") {
                    dos.write(outVMod.asJSON(true, ""));
                }
            }
            dos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = super.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_VelocityMerge.dashEquals("smtop", args[i])) {
                this.smoothTop = true;
                continue;
            }
            if (TauP_VelocityMerge.dashEquals("smbot", args[i])) {
                this.smoothBottom = true;
                continue;
            }
            if (TauP_VelocityMerge.dashEquals("json", args[i])) {
                this.setOutputFormat("json");
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals(ND, args[i])) {
                this.modelName = args[i + 1];
                this.modelType = ND;
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals(TVEL, args[i])) {
                this.modelName = args[i + 1];
                this.modelType = TVEL;
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals("mod", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = null;
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals("ndmerge", args[i])) {
                this.overlayModelName = args[i + 1];
                this.overlayModelType = ND;
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals("tvelmerge", args[i])) {
                this.overlayModelName = args[i + 1];
                this.overlayModelType = TVEL;
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityMerge.dashEquals("elevation", args[i])) {
                this.elevation = args[i + 1].endsWith("m") ? Float.parseFloat(args[i + 1].substring(0, args[i + 1].length() - 1)) / 1000.0f : Float.parseFloat(args[i + 1]);
                ++i;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void validateArguments() throws TauModelException {
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public String getUsage() {
        return TauP_Tool.getStdUsageHead(this.getClass()) + "-mod[el] modelname -- base velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n\n-nd modelfile       -- base \"named discontinuities\" velocity file\n-tvel modelfile     -- base \".tvel\" velocity file, ala ttimes\n\n-ndmerge modelfile       -- \"named discontinuities\" velocity file to merge\n-tvelmerge modelfile     -- \".tvel\" velocity file to merge, ala ttimes\n\n-smtop              -- smooth merge at top\n-smbot              -- smooth merge at bottom\n\n--elevation         -- expand top layer for station at elevation\n                       may append m for meters, otherwise kilometers\n                       updates radius of earth\n--json             -- output model as json\n\n" + TauP_Tool.getStdUsageTail();
    }

    @Override
    public String[] allowedOutputFormats() {
        String[] formats = new String[]{"text", "json", ND};
        return formats;
    }

    @Override
    public void setDefaultOutputFormat() {
        this.setOutputFormat(ND);
    }
}

