/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Create;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.TauP_VelocityPlot;
import edu.sc.seis.TauP.VelocityModel;
import java.io.IOException;
import java.io.PrintWriter;

public class TauP_SlownessPlot
extends TauP_VelocityPlot {
    public static final String DEFAULT_OUTFILE = "taup_slownessmodel";

    public TauP_SlownessPlot() {
        this.setOutFileBase(DEFAULT_OUTFILE);
        this.setDefaultOutputFormat();
    }

    @Override
    public String[] allowedOutputFormats() {
        String[] formats = new String[]{"svg", "gmt", "csv", "json"};
        return formats;
    }

    @Override
    public void setDefaultOutputFormat() {
        this.setOutputFormat("svg");
    }

    @Override
    public String getUsage() {
        return TauP_Tool.getStdUsageHead(this.getClass()) + "-nd modelfile       -- \"named discontinuities\" velocity file\n-tvel modelfile     -- \".tvel\" velocity file, ala ttimes\n\n" + TauP_SlownessPlot.getModDepthUsage() + "--json               -- output as JSON\n--svg               -- output as SVG\n--csv               -- outputs a CSV ascii table\n\n\n" + TauP_Tool.getStdUsageTail();
    }

    @Override
    public void printResult(PrintWriter out) throws TauPException, IOException {
        System.err.println("Slowness plot printResult " + this.getOutputFormat());
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelName + ", tried internally and from file");
        }
        TauP_Create taup_create = new TauP_Create();
        TauModel tMod = taup_create.createTauModel(vMod);
        if (this.getOutputFormat().equals("svg")) {
            this.printSVG(out, tMod.getSlownessModel());
        } else if (this.getOutputFormat().equals("csv")) {
            this.printCSV(out, tMod.getSlownessModel());
        } else if (this.getOutputFormat().equals("gmt")) {
            tMod.getSlownessModel().printGMT(this.getOutFile());
        } else if (this.getOutputFormat().equals("json")) {
            out.write(tMod.getSlownessModel().asJSON().toString(2));
        } else {
            tMod.getSlownessModel().printGMT(this.getOutFile());
        }
        out.flush();
    }

    @Override
    public void start() throws TauPException, IOException {
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelName + ", tried internally and from file");
        }
        if (this.getOutFileBase() == DEFAULT_OUTFILE) {
            this.setOutFileBase(vMod.modelName + "_slow");
        }
        TauP_Create taup_create = new TauP_Create();
        TauModel tMod = taup_create.createTauModel(vMod);
        this.printResult(this.getWriter());
    }

    public double calcMaxRP(SlownessModel sMod) {
        double maxRP = 0.0;
        for (SlownessLayer sLayer : sMod.getAllSlownessLayers(true)) {
            if (sLayer.getTopP() > maxRP) {
                maxRP = sLayer.getTopP();
            }
            if (!(sLayer.getBotP() > maxRP)) continue;
            maxRP = sLayer.getBotP();
        }
        for (SlownessLayer sLayer : sMod.getAllSlownessLayers(false)) {
            if (sLayer.getTopP() > maxRP) {
                maxRP = sLayer.getTopP();
            }
            if (!(sLayer.getBotP() > maxRP)) continue;
            maxRP = sLayer.getBotP();
        }
        return maxRP;
    }

    public void printSVG(PrintWriter out, SlownessModel sMod) {
        double maxRP = this.calcMaxRP(sMod);
        double minRP = 0.0;
        maxRP *= 1.05;
        int numXTicks = 5;
        double maxY = sMod.vMod.maxRadius;
        double minY = 0.0;
        int numYTicks = 10;
        boolean xEndFixed = false;
        boolean yEndFixed = false;
        float pixelWidth = 72.0f * this.mapWidth - (float)this.plotOffset;
        float margin = 40.0f;
        float plotWidth = pixelWidth - margin;
        String title = sMod.vMod.modelName;
        this.printSVGBeginning(out);
        SvgUtil.createXYAxes(out, minRP, maxRP, numXTicks, xEndFixed, maxY, minY, numYTicks, yEndFixed, pixelWidth, margin, title, "Slowness (s/deg)", "Depth (km)");
        out.println("<g transform=\"scale(1,-1) translate(0, -" + plotWidth + ")\">");
        out.println("<g transform=\"scale(" + (double)plotWidth / maxRP + "," + (double)plotWidth / maxY + ")\" >");
        out.println("<!-- P velocity");
        out.println(" -->");
        out.println("<polyline class=\"pwave\" points=\"");
        SlownessLayer prev = null;
        for (SlownessLayer sLayer : sMod.getAllSlownessLayers(true)) {
            if (prev == null || prev.getBotP() != sLayer.getTopP()) {
                out.println((float)sLayer.getTopP() + " " + (maxY - (double)((float)sLayer.getTopDepth())) + " ");
            }
            out.println((float)sLayer.getBotP() + " " + (maxY - (double)((float)sLayer.getBotDepth())) + " ");
            prev = sLayer;
        }
        out.println("\" />");
        out.println("<!-- S velocity");
        out.println(" -->");
        out.println("<polyline class=\"swave\" points=\"");
        prev = null;
        for (SlownessLayer sLayer : sMod.getAllSlownessLayers(false)) {
            if (prev == null || prev.getBotP() != sLayer.getTopP()) {
                out.println((float)sLayer.getTopP() + " " + (maxY - (double)((float)sLayer.getTopDepth())) + " ");
            }
            out.println((float)sLayer.getBotP() + " " + (maxY - (double)((float)sLayer.getBotDepth())) + " ");
            prev = sLayer;
        }
        out.println("\" />");
        out.println("</g>");
        out.println("</g>");
        out.println("</g>");
        out.println("</svg>");
        out.flush();
        this.closeWriter();
    }

    public void printCSV(PrintWriter out, SlownessModel sMod) {
        double maxY = sMod.vMod.maxRadius;
        double maxRP = this.calcMaxRP(sMod);
        out.println("Slowness,Depth,Wavetype");
        for (boolean wavetype : new boolean[]{false, true}) {
            String wavename = wavetype ? "P" : "S";
            SlownessLayer prev = null;
            for (SlownessLayer sLayer : sMod.getAllSlownessLayers(wavetype)) {
                if (prev == null || prev.getBotP() != sLayer.getTopP()) {
                    out.println((float)sLayer.getTopP() + "," + (float)sLayer.getTopDepth() + "," + wavename);
                }
                out.println((float)sLayer.getBotP() + "," + (float)sLayer.getBotDepth() + "," + wavename);
                prev = sLayer;
            }
        }
        out.flush();
    }
}

