/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.CalcReflTranFunction;
import edu.sc.seis.TauP.ReflTrans;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TauP_ReflTransPlot
extends TauP_Tool {
    public static final String DEFAULT_OUTFILE = "taup_refltrans";
    float mapWidth = 6.0f;
    int plotOffset = 80;
    String modelName;
    String modelType;
    protected double depth = -1.0;
    double topVp;
    double topVs;
    double topDensity;
    double botVp = 0.0;
    double botVs;
    double botDensity;
    protected double angleStep = 1.0;
    protected double rayparamStep = 0.001;
    protected double step = -1.0;
    protected boolean indown = true;
    protected boolean inpwave = false;
    protected boolean inswave = false;
    protected boolean inshwave = false;
    protected boolean linearRayParam = false;
    protected boolean absolute = false;
    protected String onlyPlotCoef = null;

    public TauP_ReflTransPlot() {
        this.setOutFileBase(DEFAULT_OUTFILE);
        this.setDefaultOutputFormat();
    }

    @Override
    public String[] allowedOutputFormats() {
        return new String[]{"svg"};
    }

    @Override
    public void setDefaultOutputFormat() {
        this.setOutputFormat("svg");
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) throws IOException {
        this.setOutputFormat("svg");
        this.setOutFileExtension("svg");
        String[] args = super.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            double topDensity;
            double topVs;
            double topVp;
            if (TauP_ReflTransPlot.dashEquals("pwave", args[i])) {
                this.setIncidentPWave(true);
                continue;
            }
            if (TauP_ReflTransPlot.dashEquals("swave", args[i])) {
                this.setIncidentSWave(true);
                continue;
            }
            if (TauP_ReflTransPlot.dashEquals("shwave", args[i])) {
                this.setIncidentShWave(true);
                continue;
            }
            if (TauP_ReflTransPlot.dashEquals("down", args[i])) {
                this.setIncidentDown(true);
                continue;
            }
            if (TauP_ReflTransPlot.dashEquals("up", args[i])) {
                this.setIncidentDown(false);
                continue;
            }
            if (TauP_ReflTransPlot.dashEquals("linrayparam", args[i])) {
                this.setLinearRayParam(true);
                continue;
            }
            if (TauP_ReflTransPlot.dashEquals("abs", args[i])) {
                this.setAbsolute(true);
                continue;
            }
            if (TauP_ReflTransPlot.dashEquals("svg", args[i])) {
                this.setOutputFormat("svg");
                this.setOutFileExtension("svg");
                continue;
            }
            if (TauP_ReflTransPlot.dashEquals("csv", args[i])) {
                this.setOutputFormat("csv");
                this.setOutFileExtension("csv");
                continue;
            }
            if (i < args.length - 1 && TauP_ReflTransPlot.dashEquals("nd", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "nd";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_ReflTransPlot.dashEquals("tvel", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "tvel";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_ReflTransPlot.dashEquals("mod", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = null;
                ++i;
                continue;
            }
            if (TauP_ReflTransPlot.dashEquals("depth", args[i])) {
                this.setDepth(Double.parseDouble(args[i + 1]));
                ++i;
                continue;
            }
            if (i < args.length - 3 && TauP_ReflTransPlot.dashEquals("inlayer", args[i])) {
                topVp = Double.parseDouble(args[i + 1]);
                topVs = Double.parseDouble(args[i + 2]);
                topDensity = Double.parseDouble(args[i + 3]);
                this.setLayerParams(topVp, topVs, topDensity, this.botVp, this.botVs, this.botDensity);
                i += 3;
                continue;
            }
            if (i < args.length - 3 && TauP_ReflTransPlot.dashEquals("trlayer", args[i])) {
                double botVp = Double.parseDouble(args[i + 1]);
                double botVs = Double.parseDouble(args[i + 2]);
                double botDensity = Double.parseDouble(args[i + 3]);
                this.setLayerParams(this.topVp, this.topVs, this.topDensity, botVp, botVs, botDensity);
                i += 3;
                continue;
            }
            if (i < args.length - 6 && TauP_ReflTransPlot.dashEquals("layer", args[i])) {
                topVp = Double.parseDouble(args[i + 1]);
                topVs = Double.parseDouble(args[i + 2]);
                topDensity = Double.parseDouble(args[i + 3]);
                double botVp = Double.parseDouble(args[i + 4]);
                double botVs = Double.parseDouble(args[i + 5]);
                double botDensity = Double.parseDouble(args[i + 6]);
                this.setLayerParams(topVp, topVs, topDensity, botVp, botVs, botDensity);
                i += 6;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (!(this.inpwave || this.inswave || this.inshwave)) {
            this.setIncidentPWave(true);
            this.setIncidentSWave(true);
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void start() throws IOException, TauModelException, TauPException {
        double step = this.linearRayParam ? this.rayparamStep : this.angleStep;
        if (this.modelName != null && this.modelName.length() > 0) {
            VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
            if (vMod == null) {
                throw new TauPException("Unable to find model " + this.modelName);
            }
            this.printSVG(this.getWriter(), vMod, this.depth, this.indown, this.inpwave, this.inswave, this.inshwave, this.linearRayParam, step);
        } else {
            this.printSVG(this.getWriter(), this.topVp, this.topVs, this.topDensity, this.botVp, this.botVs, this.botDensity, this.indown, this.inpwave, this.inswave, this.inshwave, this.linearRayParam, step);
        }
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public String getUsage() {
        return TauP_ReflTransPlot.getStdUsageHead(TauP_ReflTransPlot.class) + TauP_ReflTransPlot.getStdUsageTail();
    }

    @Override
    public void validateArguments() throws TauModelException {
    }

    public void printSVGBeginning(PrintWriter out) {
        SvgUtil.xyplotScriptBeginning(out, TauP_ReflTransPlot.toolNameFromClass(this.getClass()), this.cmdLineArgs, this.mapWidth, this.plotOffset);
    }

    public void printSVG(PrintWriter out, VelocityModel vMod, double depth, boolean downgoing, boolean inpwave, boolean inswave, boolean inshwave, boolean linearRayParam, double angleStep) throws VelocityModelException {
        if (!vMod.isDisconDepth(depth)) {
            System.err.println("Depth is not a discontinuity in " + vMod.getModelName() + ": " + depth);
        }
        ReflTrans reflTranCoef = vMod.calcReflTransCoef(depth, downgoing);
        String title = vMod.modelName + " at ";
        title = this.botVp == 0.0 ? title + " surface, " : title + depth + ", ";
        title = title + this.createTitle(reflTranCoef, inpwave, inswave) + " " + (downgoing ? "downgoing" : "upgoing");
        this.printSVG(out, reflTranCoef, inpwave, inswave, inshwave, linearRayParam, angleStep, title);
    }

    public void printSVG(PrintWriter out, double topVp, double topVs, double topDensity, double botVp, double botVs, double botDensity, boolean downgoing, boolean inpwave, boolean inswave, boolean inshwave, boolean linearRayParam, double angleStep) throws VelocityModelException {
        ReflTrans reflTranCoef = VelocityModel.calcReflTransCoef(topVp, topVs, topDensity, botVp, botVs, botDensity, downgoing);
        String title = this.createTitle(reflTranCoef, inpwave, inswave);
        this.printSVG(out, reflTranCoef, inpwave, inswave, inshwave, linearRayParam, angleStep, title);
    }

    public String createTitle(ReflTrans reflTransCoef, boolean inpwave, boolean inswave) {
        String title;
        if (reflTransCoef.botVp == 0.0) {
            title = "Free surface: " + reflTransCoef.topVp + "," + reflTransCoef.topVs + "," + reflTransCoef.topDensity + " ";
        } else {
            title = reflTransCoef.topVs == 0.0 ? "In Fluid: " + reflTransCoef.topVp + "," + reflTransCoef.topVs + "," + reflTransCoef.topDensity + " " : "In Solid: " + reflTransCoef.topVp + "," + reflTransCoef.topVs + "," + reflTransCoef.topDensity + " ";
            title = reflTransCoef.botVs == 0.0 ? title + "to Fluid: " + reflTransCoef.botVp + "," + reflTransCoef.botVs + "," + reflTransCoef.botDensity + ": " : title + "to Solid: " + reflTransCoef.botVp + "," + reflTransCoef.botVs + "," + reflTransCoef.botDensity + ": ";
        }
        title = title + (String)(inpwave ? "P at " + reflTransCoef.topVp + " " : "");
        title = title + (String)(inswave ? "S at " + reflTransCoef.topVs + " " : "");
        return title;
    }

    public void printSVG(PrintWriter out, ReflTrans reflTranCoef, boolean inpwave, boolean inswave, boolean inshwave, boolean linearRayParam, double step, String title) throws VelocityModelException {
        double oneOverV;
        double invel;
        double minX = 0.0;
        double maxX = 90.0;
        boolean xEndFixed = true;
        boolean yEndFixed = true;
        if (linearRayParam) {
            maxX = 1.0 / (inswave ? reflTranCoef.topVs : reflTranCoef.topVp);
        }
        int numXTicks = 5;
        double maxY = 2.0;
        double minY = -1.0;
        if (this.isAbsolute()) {
            minY = 0.0;
        }
        int numYTicks = 8;
        float pixelWidth = 72.0f * this.mapWidth - (float)this.plotOffset;
        float margin = 40.0f;
        float plotWidth = pixelWidth - margin;
        this.printSVGBeginning(out);
        SvgUtil.createXYAxes(out, minX, maxX, numXTicks, xEndFixed, minY, maxY, numYTicks, yEndFixed, pixelWidth, margin, title, linearRayParam ? "Horiz. Slowness (s/km)" : "Angle (deg)", "Amp Factor");
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<String> labelClass = new ArrayList<String>();
        out.println("<g transform=\"scale(1,-1) translate(0, -" + plotWidth + ")\">");
        out.println("<g transform=\"scale(" + (double)plotWidth / maxX + "," + (double)plotWidth / (maxY - minY) + ")\" >");
        out.println("<g transform=\"translate(0," + -1.0 * minY + ")\" >");
        String label = "";
        if (inpwave) {
            invel = reflTranCoef.topVp;
            oneOverV = 1.0 / invel;
            label = "Rpp";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getRpp);
            label = "Tpp";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getTpp);
            label = "Rps";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getRps);
            label = "Tps";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getTps);
        }
        if (inswave) {
            invel = reflTranCoef.topVs;
            oneOverV = 1.0 / invel;
            label = "Rsp";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getRsp);
            label = "Tsp";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getTsp);
            label = "Rss";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getRss);
            label = "Tss";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getTss);
        }
        if (inshwave) {
            invel = reflTranCoef.topVs;
            oneOverV = 1.0 / invel;
            label = "Rshsh";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getRshsh);
            label = "Tshsh";
            this.processType(out, reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, label, labels, labelClass, reflTranCoef::getTshsh);
        }
        out.println("</g>");
        out.println("</g>");
        out.println("</g>");
        out.println("<g transform=\"translate(" + 0.75 * (double)plotWidth + ", " + 0.1 * (double)plotWidth + ")\">");
        SvgUtil.createLegend(out, labels, labelClass);
        out.println("</g>");
        out.println("</g>");
        out.println("</svg>");
        out.flush();
        this.closeWriter();
    }

    protected void processType(PrintWriter out, ReflTrans reflTranCoef, double minX, double maxX, double step, boolean linearRayParam, double oneOverV, String label, List<String> labels, List<String> labelClass, CalcReflTranFunction<Double, Double> calcFn) throws VelocityModelException {
        double rayParam;
        double i;
        if (this.onlyPlotCoef != null && !this.onlyPlotCoef.equalsIgnoreCase(label)) {
            return;
        }
        try {
            double d = calcFn.apply(0.0);
        }
        catch (VelocityModelException e) {
            return;
        }
        out.print("<polyline class=\"" + label + "\" points=\"");
        double[] critSlownesses = reflTranCoef.calcCriticalRayParams();
        for (i = minX; i <= maxX; i += step) {
            double nextrayParam;
            if (linearRayParam) {
                rayParam = i;
                nextrayParam = rayParam + step;
            } else {
                rayParam = oneOverV * Math.sin(i * (Math.PI / 180));
                nextrayParam = oneOverV * Math.sin((i + step) * (Math.PI / 180));
            }
            double val = calcFn.apply(rayParam);
            if (this.isAbsolute()) {
                val = Math.abs(val);
            }
            out.print((float)i + " " + (float)val + " ");
            for (int critIdx = 0; critIdx < critSlownesses.length; ++critIdx) {
                if (!(rayParam < critSlownesses[critIdx]) || !(nextrayParam > critSlownesses[critIdx])) continue;
                double criti = critSlownesses[critIdx];
                double xval = linearRayParam ? criti : Math.asin(criti / oneOverV) * 57.29577951308232;
                val = calcFn.apply(criti);
                if (this.isAbsolute()) {
                    val = Math.abs(val);
                }
                out.print((float)xval + " " + (float)val + " ");
            }
        }
        if (i < maxX + step) {
            rayParam = linearRayParam ? maxX : oneOverV * Math.sin(maxX * (Math.PI / 180));
            double val = calcFn.apply(rayParam);
            if (this.isAbsolute()) {
                val = Math.abs(val);
            }
            out.print((float)maxX + " " + (float)val + " ");
        }
        out.println("\" />");
        labels.add(label);
        labelClass.add(label);
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public void setLayerParams(double topVp, double topVs, double topDensity, double botVp, double botVs, double botDensity) {
        this.topVp = topVp;
        this.topVs = topVs;
        this.topDensity = topDensity;
        this.botVp = botVp;
        this.botVs = botVs;
        this.botDensity = botDensity;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setIncidentDown(boolean indown) {
        this.indown = indown;
    }

    public void setIncidentPWave(boolean inpwave) {
        this.inpwave = inpwave;
    }

    public void setIncidentSWave(boolean inswave) {
        this.inswave = inswave;
    }

    public void setIncidentShWave(boolean inshwave) {
        this.inshwave = inshwave;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public boolean isLinearRayParam() {
        return this.linearRayParam;
    }

    public boolean isInpwave() {
        return this.inpwave;
    }

    public void setInpwave(boolean inpwave) {
        this.inpwave = inpwave;
    }

    public boolean isInswave() {
        return this.inswave;
    }

    public boolean isInshwave() {
        return this.inshwave;
    }

    public void setInswave(boolean inswave) {
        this.inswave = inswave;
    }

    public void setLinearRayParam(boolean linearRayParam) {
        this.linearRayParam = linearRayParam;
    }

    public void setAngleStep(double angleStep) {
        this.angleStep = angleStep;
    }

    public double getAngleStep() {
        return this.angleStep;
    }
}

