/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import java.util.Properties;

public class Outputs {
    protected static String depthFormat = "%8.1f";
    protected static String distanceFormat = "%8.2f";
    protected static String timeFormat = "%8.2f";
    protected static String distanceFormatNoPad = "%.2f";
    protected static String timeFormatNoPad = "%.2f";
    protected static String rayParamFormat = "%8.3f";
    protected static String latLonFormat = "%8.2f";
    protected static String ampFactorFormat = "%.1e";

    public static void configure(Properties props) {
        depthFormat = "%8." + props.getProperty("taup.depth.precision", "1") + "f";
        distanceFormat = "%8." + props.getProperty("taup.distance.precision", "2") + "f";
        timeFormat = "%8." + props.getProperty("taup.time.precision", "2") + "f";
        distanceFormatNoPad = "%." + props.getProperty("taup.distance.precision", "2") + "f";
        timeFormatNoPad = "%." + props.getProperty("taup.time.precision", "2") + "f";
        rayParamFormat = "%8." + props.getProperty("taup.rayparam.precision", "3") + "f";
        latLonFormat = "%8." + props.getProperty("taup.latlon.precision", "2") + "f";
        ampFactorFormat = "%." + props.getProperty("taup.amplitude.precision", "1") + "e";
    }

    public static String formatDepth(double depth) {
        return String.format(depthFormat, depth);
    }

    public static String formatDistance(double distance) {
        return String.format(distanceFormat, distance);
    }

    public static String formatTime(double time) {
        return String.format(timeFormat, time);
    }

    public static String formatDistanceNoPad(double distance) {
        return String.format(distanceFormatNoPad, distance);
    }

    public static String formatTimeNoPad(double time) {
        return String.format(timeFormat, time);
    }

    public static String formatRayParam(double rayParam) {
        return String.format(rayParamFormat, rayParam);
    }

    public static String formatLatLon(double latlon) {
        return String.format(latLonFormat, latlon);
    }

    public static String formatAmpFactor(double ampFactor) {
        String space = " ";
        if (ampFactor < 0.0) {
            space = "";
        }
        if (ampFactor == 0.0) {
            return space + String.format(ampFactorFormat, 0.0);
        }
        return space + String.format(ampFactorFormat, ampFactor);
    }
}

