/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.PhaseSymbols;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.ToolRun;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LegPuller {
    public static final String number = "((([0-9]*[.])?[0-9]+)|([0-9]*[.]))";
    public static final String travelSuffix = "((diff)|(ed)|n|g)";
    public static final String headDiffRE = "(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n))";
    public static final String travelLeg = "(([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n)))";
    public static final String interactPrefix = "[vV^]";
    public static final String interactPointsRE = "(([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))))";
    public static final String surfaceWave = "(((([0-9]*[.])?[0-9]+)|([0-9]*[.]))kmps)";
    public static final String bodyWave = "(([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))))?(([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n))))*";
    public static final String scatterWave = "((([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))))?(([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n))))*)([oO])((([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))))?(([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n))))*)";
    public static final Pattern phaseRegEx = Pattern.compile("^((((([0-9]*[.])?[0-9]+)|([0-9]*[.]))kmps)|((([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))))?(([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n))))*)([oO])((([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))))?(([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n))))*)|(([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n)))((([vV^])?([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.]))))?(([PpSsKkIyJj]((diff)|(ed)|n|g)?)|(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n))))*)$");

    public static boolean regExCheck(String name) {
        Matcher m = phaseRegEx.matcher(name);
        return m.matches();
    }

    protected static ArrayList<String> legPuller(String name) throws TauModelException {
        if (!LegPuller.regExCheck(name)) {
            if (ToolRun.DEBUG) {
                throw new TauModelException("Do not understand Phase " + name + " doesn't match phase regex: " + phaseRegEx);
            }
            throw new TauModelException("Do not understand Phase " + name + ", skipping.");
        }
        int offset = 0;
        ArrayList<String> legs = new ArrayList<String>();
        if (name.endsWith("kmps")) {
            legs.add(name);
        } else {
            while (offset < name.length()) {
                if (offset + 2 < name.length() && name.startsWith("ed", offset + 1) && !PhaseSymbols.isDowngoingSymbol(name, offset)) {
                    throw new TauModelException("Invalid phase name:\n" + name.charAt(offset) + " cannot be followed by ed in " + name);
                }
                if (PhaseSymbols.isUpgoingSymbol(name, offset)) {
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (name.charAt(offset) == 'm') {
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (name.charAt(offset) == 'c' || name.charAt(offset) == 'i') {
                    if (offset == name.length() - 1) {
                        throw new TauModelException("Invalid phase name:\n" + name.charAt(offset) + " cannot be last char in " + name);
                    }
                    if (name.charAt(offset + 1) == 'x') {
                        legs.add(name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (name.charAt(offset) == 'I' || name.charAt(offset) == 'J') {
                    if (offset + 1 == name.length() || name.charAt(offset + 1) == 'c' || PhaseSymbols.isDowngoingSymbol(name, offset + 1) || PhaseSymbols.isReflectSymbol(name, offset + 1) || PhaseSymbols.isScatterSymbol(name, offset + 1) || PhaseSymbols.isUpgoingSymbol(name, offset + 1) && !PhaseSymbols.isInnerCoreLeg(name, offset + 1)) {
                        legs.add(name.substring(offset, offset + 1));
                        ++offset;
                        continue;
                    }
                    if (name.length() >= offset + 3 && PhaseSymbols.isExclusiveDowngoingSymbol(name, offset)) {
                        legs.add(name.substring(offset, offset + 3));
                        offset += 3;
                        continue;
                    }
                    if (PhaseSymbols.isBoundary(name, offset + 1)) {
                        offset = LegPuller.extractPhaseBoundaryInteraction(name, offset, 1, legs);
                        continue;
                    }
                    throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
                }
                if (name.charAt(offset) == 'P' || name.charAt(offset) == 'S') {
                    if (offset + 1 == name.length() || PhaseSymbols.isDowngoingSymbol(name, offset + 1) || PhaseSymbols.isReflectSymbol(name, offset + 1) || PhaseSymbols.isScatterSymbol(name, offset + 1) || name.charAt(offset + 1) == 'm' || name.charAt(offset + 1) == 'c') {
                        legs.add(name.substring(offset, offset + 1));
                        ++offset;
                        continue;
                    }
                    if (PhaseSymbols.isBoundary(name, offset + 1)) {
                        offset = LegPuller.extractPhaseBoundaryInteraction(name, offset, 1, legs);
                        continue;
                    }
                    if (PhaseSymbols.isUpgoingSymbol(name, offset + 1)) {
                        throw new TauModelException("Invalid phase name:\n" + name.charAt(offset) + " cannot be followed by upgoing phase" + name.charAt(offset + 1) + " in " + name);
                    }
                    if (name.charAt(offset + 1) == 'g' || name.charAt(offset + 1) == 'b' || PhaseSymbols.isHead(name, offset)) {
                        legs.add(name.substring(offset, offset + 2));
                        offset += 2;
                        continue;
                    }
                    if (PhaseSymbols.isExclusiveDowngoingSymbol(name, offset)) {
                        if (name.length() > offset + 3 && PhaseSymbols.isBoundary(name, offset + 3)) {
                            offset = LegPuller.extractPhaseBoundaryInteraction(name, offset, 3, legs);
                            continue;
                        }
                        legs.add(name.substring(offset, offset + 3));
                        offset += 3;
                        continue;
                    }
                    if (PhaseSymbols.isDiffracted(name, offset)) {
                        String diffLeg = name.substring(offset, name.indexOf("diff", offset + 1) + "diff".length());
                        legs.add(diffLeg);
                        offset += diffLeg.length();
                        continue;
                    }
                    throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
                }
                if (name.charAt(offset) == 'K') {
                    if (offset + 1 == name.length() || PhaseSymbols.isDowngoingSymbol(name, offset + 1) || PhaseSymbols.isUpgoingSymbol(name, offset + 1) && PhaseSymbols.isCrustMantleLeg(name, offset + 1) || PhaseSymbols.isReflectSymbol(name, offset + 1) || PhaseSymbols.isScatterSymbol(name, offset + 1) || name.charAt(offset + 1) == 'c' || name.charAt(offset + 1) == 'i') {
                        legs.add(name.substring(offset, offset + 1));
                        ++offset;
                        continue;
                    }
                    if (PhaseSymbols.isBoundary(name, offset + 1)) {
                        offset = LegPuller.extractPhaseBoundaryInteraction(name, offset, 1, legs);
                        continue;
                    }
                    if (PhaseSymbols.isExclusiveDowngoingSymbol(name, offset)) {
                        legs.add(name.substring(offset, offset + 3));
                        offset += 3;
                        continue;
                    }
                    if (PhaseSymbols.isDiffracted(name, offset)) {
                        String diffLeg = name.substring(offset, name.indexOf("diff", offset + 1) + "diff".length());
                        legs.add(diffLeg);
                        offset += diffLeg.length();
                        continue;
                    }
                    throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
                }
                if (PhaseSymbols.isScatterSymbol(name, offset)) {
                    legs.add(name.substring(offset, offset + 1));
                    ++offset;
                    continue;
                }
                if (PhaseSymbols.isReflectSymbol(name, offset)) {
                    if (offset == name.length() - 1) {
                        throw new TauModelException("Invalid phase name:\n" + name.charAt(offset) + " reflection cannot be last char in " + name);
                    }
                    int criticalOffset = 0;
                    if (name.charAt(offset + 1) == 'x') {
                        criticalOffset = 1;
                    }
                    if (name.charAt(offset + criticalOffset + 1) == 'm' || name.charAt(offset + criticalOffset + 1) == 'c' || name.charAt(offset + criticalOffset + 1) == 'i') {
                        legs.add(name.substring(offset, offset + criticalOffset + 2));
                        offset = offset + criticalOffset + 2;
                        continue;
                    }
                    if (PhaseSymbols.isBoundary(name, offset + criticalOffset + 1)) {
                        String prefix = name.substring(offset, offset + criticalOffset + 1);
                        String boundId = LegPuller.extractBoundaryId(name, offset + criticalOffset + 1, false);
                        legs.add(prefix + boundId);
                        if ((offset += prefix.length() + boundId.length()) != name.length()) continue;
                        throw new TauModelException("Invalid phase name:\n" + prefix + " followed by " + boundId + " cannot be last in " + name);
                    }
                    throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
                }
                if (PhaseSymbols.isBoundary(name, offset)) {
                    String boundId = LegPuller.extractBoundaryId(name, offset, false);
                    legs.add(boundId);
                    if ((offset += boundId.length()) != name.length()) continue;
                    throw new TauModelException("Invalid phase name:\n" + boundId + " cannot be last in " + name);
                }
                throw new TauModelException("Invalid phase name:\n" + name.substring(offset) + " in " + name);
            }
        }
        legs.add("END");
        String validationMsg = LegPuller.phaseValidate(legs);
        if (validationMsg != null) {
            throw new TauModelException("Phase failed validation: " + name + "  " + validationMsg);
        }
        return legs;
    }

    public static int extractPhaseBoundaryInteraction(String name, int offset, int phaseCharLength, List<String> legs) throws TauModelException {
        int idx = offset;
        String phaseChar = name.substring(offset, offset + phaseCharLength);
        String boundId = LegPuller.extractBoundaryId(name, idx += phaseCharLength, true);
        if (boundId.length() == 0) {
            throw new TauModelException("Got empty boundary from extractBoundaryId() in phaseBoundary " + phaseChar + " " + offset + " in " + name);
        }
        if (boundId.endsWith("diff") || boundId.endsWith(String.valueOf('n'))) {
            legs.add(phaseChar + boundId);
            idx += boundId.length();
        } else {
            if (offset + phaseChar.length() + boundId.length() == name.length()) {
                throw new TauModelException("Invalid phase name: " + phaseChar + " cannot be followed by " + boundId + " in " + name);
            }
            legs.add(phaseChar);
            legs.add(boundId);
            idx += boundId.length();
        }
        return idx;
    }

    public static String extractBoundaryId(String name, int offset, boolean allowHeadDiff) throws TauModelException {
        int idx;
        if (offset == name.length() - 1) {
            throw new TauModelException("Invalid phase name:\n" + name.charAt(offset) + " cannot be last char in " + name);
        }
        String numString = "";
        for (idx = offset; idx < name.length() && PhaseSymbols.isBoundary(name, idx); ++idx) {
        }
        if (allowHeadDiff && name.length() >= idx + 4 && name.startsWith("diff", idx)) {
            idx += 4;
        } else if (allowHeadDiff && idx < name.length() && name.charAt(idx) == 'n') {
            ++idx;
        }
        if (idx == offset) {
            throw new TauModelException("Attempt to extract boundary but empty starting at " + offset + " in " + name);
        }
        return name.substring(offset, idx);
    }

    public static boolean isBoundary(String leg) {
        if (leg.equals(Character.valueOf('m')) || leg.equals(Character.valueOf('c')) || leg.equals(Character.valueOf('i'))) {
            return true;
        }
        try {
            double d = Double.parseDouble(leg);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static int closestBranchToDepth(TauModel tMod, String depthString) {
        if (depthString.equals("m")) {
            return tMod.getMohoBranch();
        }
        if (depthString.equals("c")) {
            return tMod.getCmbBranch();
        }
        if (depthString.equals("i")) {
            return tMod.getIocbBranch();
        }
        int disconBranch = -1;
        double disconMax = Double.MAX_VALUE;
        double disconDepth = Double.valueOf(depthString);
        for (int i = 0; i < tMod.getNumBranches(); ++i) {
            TauBranch tBranch = tMod.getTauBranch(i, true);
            if (!(Math.abs(disconDepth - tBranch.getTopDepth()) < disconMax) || tMod.isNoDisconDepth(tBranch.getTopDepth())) continue;
            disconBranch = i;
            disconMax = Math.abs(disconDepth - tBranch.getTopDepth());
        }
        return disconBranch;
    }

    public static String createPuristName(TauModel tMod, List<String> legs) {
        StringBuilder puristName = new StringBuilder();
        String currLeg = legs.get(0);
        if (legs.size() == 2 && currLeg.endsWith("kmps")) {
            puristName.append(legs.get(0));
            return puristName.toString();
        }
        Pattern reflectDepthPattern = Pattern.compile("[Vv^][0-9\\.]+");
        for (int legNum = 0; legNum < legs.size() - 1; ++legNum) {
            int intLegDepth;
            double legDepth;
            int disconBranch;
            currLeg = legs.get(legNum);
            Matcher m = reflectDepthPattern.matcher(currLeg);
            if (m.matches()) {
                puristName.append(currLeg.substring(0, 1));
                disconBranch = LegPuller.closestBranchToDepth(tMod, currLeg.substring(1));
                if (disconBranch == tMod.getMohoBranch()) {
                    puristName.append(m);
                    continue;
                }
                if (disconBranch == tMod.getCmbBranch()) {
                    puristName.append('c');
                    continue;
                }
                if (disconBranch == tMod.getIocbBranch()) {
                    puristName.append('i');
                    continue;
                }
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    puristName.append(intLegDepth);
                    continue;
                }
                puristName.append(legDepth);
                continue;
            }
            try {
                legDepth = Double.parseDouble(currLeg);
                disconBranch = LegPuller.closestBranchToDepth(tMod, currLeg);
                legDepth = tMod.getTauBranch(disconBranch, true).getTopDepth();
                if (legDepth == Math.rint(legDepth)) {
                    intLegDepth = (int)legDepth;
                    puristName.append(intLegDepth);
                    continue;
                }
                puristName.append(legDepth);
                continue;
            }
            catch (NumberFormatException e) {
                puristName.append(currLeg);
            }
        }
        return puristName.toString();
    }

    public static String phaseValidate(ArrayList<String> legs) {
        String currToken = legs.get(0);
        String nextToken = "";
        boolean prevIsReflect = false;
        if (legs.size() == 2 && (PhaseSymbols.isDiffracted(currToken, 0) || PhaseSymbols.isSurfaceWave(currToken, 0)) && legs.get(1).equals("END")) {
            return null;
        }
        Pattern headDiffRegEx = Pattern.compile("[PSKIJ]?(([PSIJK]([mci]|((([0-9]*[.])?[0-9]+)|([0-9]*[.])))?)((diff)|n))");
        if (!(currToken.equals("Pg") || currToken.equals("Pb") || currToken.equals("Pn") || currToken.equals("Pdiff") || currToken.equals("Sg") || currToken.equals("Sb") || currToken.equals("Sn") || currToken.equals("Sdiff") || currToken.equals("Ped") || currToken.equals("Sed") || currToken.equals("P") || currToken.equals("S") || currToken.equals("p") || currToken.equals("s") || currToken.equals("K") || currToken.equals("Ked") || currToken.equals("k") || currToken.equals("I") || currToken.equals("J") || currToken.equals("y") || currToken.equals("j") || headDiffRegEx.matcher(currToken).matches())) {
            String validationFailMessage = "First leg (" + currToken + ") must be one of Pg, Pb, Pn, Pdiff, Sg, Sb, Sn, Sdiff, P, S, p, s, k, K, Ked, I, J, y, j,  or like P410diff or P410n";
            return validationFailMessage;
        }
        for (int i = 1; i < legs.size(); ++i) {
            String prevToken = currToken;
            currToken = legs.get(i);
            if (currToken.length() == 0) {
                return "currToken is empty, after " + prevToken + " " + i + "/" + legs.size();
            }
            nextToken = i < legs.size() - 1 ? legs.get(i + 1) : "";
            if (PhaseSymbols.isReflectSymbol(currToken, 0) || currToken.equals("m") || currToken.equals("c") || currToken.equals("i")) {
                if (prevIsReflect) {
                    return "Two reflections or depths with no leg in between: " + prevToken + ", " + currToken;
                }
                prevIsReflect = true;
            } else {
                prevIsReflect = false;
            }
            if (prevToken.equals("END")) {
                return "Legs ended but more tokens exist: " + currToken;
            }
            if (PhaseSymbols.isUpgoingSymbol(prevToken, 0) && PhaseSymbols.isUpgoingSymbol(currToken, 0)) {
                if (PhaseSymbols.isCrustMantleLeg(prevToken, 0) && PhaseSymbols.isCrustMantleLeg(currToken, 0)) {
                    return "Two upgoing depth phase legs in a row: " + prevToken + " " + currToken;
                }
                if (PhaseSymbols.isOuterCoreLeg(prevToken, 0) && PhaseSymbols.isOuterCoreLeg(currToken, 0)) {
                    return "Two upgoing depth phase legs in a row: " + prevToken + " " + currToken;
                }
                if (PhaseSymbols.isInnerCoreLeg(prevToken, 0) && PhaseSymbols.isInnerCoreLeg(currToken, 0)) {
                    return "Two upgoing depth phase legs in a row: " + prevToken + " " + currToken;
                }
            }
            if (!(!prevToken.startsWith("Ped") && !prevToken.startsWith("Sed") || currToken.equals("END") || currToken.equals("Pdiff") || currToken.equals("Sdiff") || currToken.equals("P") || currToken.equals("S") || currToken.equals("K") || currToken.equals("Ked") || currToken.startsWith("v") || currToken.startsWith("V") || currToken.equals("c") || currToken.equals("m") || currToken.equals("o") || currToken.equals("O") || LegPuller.isBoundary(currToken))) {
                return "'Ped' or 'Sed' can only be before Pdiff,P,S,Sdiff,K,c,v,V,m or token immediately before END:  " + prevToken + " " + currToken;
            }
            if ((prevToken.startsWith("k") || prevToken.startsWith("K")) && (currToken.startsWith("P") || currToken.startsWith("S") || currToken.startsWith("p") || currToken.startsWith("s")) && (nextToken.startsWith("k") || nextToken.startsWith("K"))) {
                return "Cannot have P,S,p,s preceeded and followed by K,k:  " + prevToken + ", " + currToken + ", " + nextToken;
            }
            if ((prevToken.startsWith("I") || prevToken.startsWith("J")) && (currToken.startsWith("K") || currToken.startsWith("k")) && (nextToken.startsWith("I") || nextToken.startsWith("J"))) {
                return "Cannot have K,k preceeded and followed by I,J:  " + prevToken + ", " + currToken + ", " + nextToken;
            }
            if ((prevToken.startsWith("p") || prevToken.startsWith("s") || prevToken.equals("m") || prevToken.equals("c")) && (currToken.equals("I") || currToken.equals("J") || currToken.equals("i"))) {
                return "Cannot have P,S,p,s,m,c followed by I,J,i: " + prevToken + ", " + currToken;
            }
            if ((prevToken.equals("I") || prevToken.equals("J") || prevToken.equals("i")) && (currToken.equals("m") || currToken.equals("c"))) {
                return "Cannot have I,J,i followed by  m,c: " + prevToken + ", " + currToken;
            }
            if ((prevToken.equals("m") || prevToken.equals("c")) && (currToken.equals("K") || currToken.equals("I") || currToken.equals("J") || currToken.equals("i"))) {
                return "Cannot have m,c followed by K,I,i,J";
            }
            if ((currToken.equals("c") || currToken.equals("i")) && (prevToken.equals("p") || prevToken.equals("s"))) {
                return "Cannot have p,s followed by c,i " + prevToken + " " + currToken;
            }
            if (currToken.equals("i") && prevToken.equals("k")) {
                return "Cannot have i followed by k";
            }
            if (!currToken.equals("i") || !prevToken.equals("k")) continue;
            return "Cannot have i followed by k";
        }
        if (!currToken.equals("END")) {
            return "Last token must be END";
        }
        return null;
    }
}

