/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.ScatteredSeismicPhase;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONWriter;

public class Arrival {
    private SeismicPhase phase;
    private double time;
    private double dist;
    private double rayParam;
    private int rayParamIndex;
    private double dRPdDist;
    private double searchDist;
    private double searchDistDeg;
    private String name;
    private String puristName;
    private double sourceDepth;
    private double receiverDepth;
    private TimeDist[] pierce;
    private TimeDist[] path;
    private double incidentAngle;
    private double takeoffAngle;
    private Arrival relativeToArrival = null;
    public static final double MANY_LAPS_PLUS_180 = 36180.0;
    protected static final double TWOPI = Math.PI * 2;
    protected static final double DtoR = Math.PI / 180;
    protected static final double RtoD = 57.29577951308232;

    public Arrival(SeismicPhase phase, double time, double dist, double rayParam, int rayParamIndex, double dRPdDist) {
        this(phase, time, dist, rayParam, rayParamIndex, dist, phase.getName(), phase.getPuristName(), phase.getSourceDepth(), phase.getReceiverDepth(), phase.calcTakeoffAngle(rayParam), phase.calcIncidentAngle(rayParam), dRPdDist);
    }

    public Arrival(SeismicPhase phase, double time, double dist, double rayParam, int rayParamIndex, double searchDist, String name, String puristName, double sourceDepth, double receiverDepth, double takeoffAngle, double incidentAngle, double dRPdDist) {
        if (Double.isNaN(time)) {
            throw new IllegalArgumentException("Time cannot be NaN");
        }
        if (rayParamIndex < 0) {
            throw new IllegalArgumentException("rayParamIndex cannot be negative: " + rayParamIndex);
        }
        this.phase = phase;
        this.time = time;
        this.dist = dist;
        this.rayParam = rayParam;
        this.rayParamIndex = rayParamIndex;
        this.searchDist = searchDist;
        this.searchDistDeg = searchDist * 57.29577951308232;
        this.name = name;
        this.puristName = puristName;
        this.sourceDepth = sourceDepth;
        this.receiverDepth = receiverDepth;
        this.takeoffAngle = takeoffAngle;
        this.incidentAngle = incidentAngle;
        this.dRPdDist = dRPdDist;
    }

    public SeismicPhase getPhase() {
        return this.phase;
    }

    public double getTime() {
        return this.time;
    }

    public Duration getDuration() {
        return Duration.ofNanos(Math.round(this.getTime() * 1.0E9));
    }

    public double getDist() {
        return this.dist;
    }

    public double getDistDeg() {
        return 57.29577951308232 * this.getDist();
    }

    public double getModuloDist() {
        double moduloDist = this.getDist() % (Math.PI * 2);
        if (moduloDist > Math.PI) {
            moduloDist = Math.PI * 2 - moduloDist;
        }
        return moduloDist;
    }

    public double getModuloDistDeg() {
        return SeismicPhase.distanceTrim180(this.getDistDeg());
    }

    public void setSearchDistDeg(double searchDistDeg) {
        this.searchDistDeg = searchDistDeg;
    }

    public double getSearchDistDeg() {
        return this.searchDistDeg;
    }

    public double getModuloSearchDistDeg() {
        return SeismicPhase.distanceTrim180(this.getSearchDistDeg());
    }

    public boolean isLongWayAround() {
        double shortWay = (36180.0 + this.getSearchDistDeg() - this.getDistDeg()) % 360.0 - 180.0;
        double longWay = (36180.0 + this.getSearchDistDeg() - (360.0 - this.getDistDeg())) % 360.0 - 180.0;
        return Math.abs(longWay) < Math.abs(shortWay);
    }

    public double getRayParam() {
        return this.rayParam;
    }

    public double getRayParamDeg() {
        return this.getRayParam() / 57.29577951308232;
    }

    public double getDRayParamDDelta() {
        return this.dRPdDist;
    }

    public double getDRayParamDDeltaDeg() {
        return this.dRPdDist / 57.29577951308232 / 57.29577951308232;
    }

    public double getGeometricSpreadingFactor() throws TauModelException {
        double rofE = this.getPhase().getTauModel().getRadiusOfEarth();
        double sourceRadius = rofE - this.getSourceDepth();
        double recRadius = rofE - this.getReceiverDepth();
        double rpFactor = this.rayParam;
        double sinFactor = Math.sin(this.getModuloDist());
        if (this.getModuloDist() == 0.0 || this.getModuloDist() == 180.0) {
            return Double.POSITIVE_INFINITY;
        }
        Arrival neighbor = this.getRayParamIndex() == 0 ? this.getPhase().createArrivalAtIndex(this.getRayParamIndex() + 1) : this.getPhase().createArrivalAtIndex(this.getRayParamIndex() - 1);
        if (neighbor.getDist() == this.getDist()) {
            throw new TauModelException("Neighbor ray has same dist: " + this.getPhase().getName() + " " + this.getDistDeg());
        }
        double dtakeoff_ddelta = (this.getTakeoffAngle() - neighbor.getTakeoffAngle()) * (Math.PI / 180) / (this.getDist() - neighbor.getDist());
        double geoSpread = Math.sin(this.getTakeoffAngle()) / (recRadius * recRadius) * 1.0 / Math.cos(this.getIncidentAngle() * (Math.PI / 180)) * (1.0 / Math.sin(this.getModuloDist())) * Math.abs(dtakeoff_ddelta);
        return geoSpread;
    }

    public double getReflTrans() throws VelocityModelException, SlownessModelException {
        return this.getPhase().calcReflTran(this);
    }

    public double getAmplitudeFactor() throws TauModelException, VelocityModelException, SlownessModelException {
        double refltran = this.getReflTrans();
        double geoSpread = this.getGeometricSpreadingFactor();
        double densityVelocity = 1.0 / Math.sqrt(this.getPhase().velocityAtReceiver() * this.getPhase().densityAtReceiver());
        double ampFactor = densityVelocity * refltran * geoSpread;
        return ampFactor;
    }

    public double getIncidentAngle() {
        return this.incidentAngle;
    }

    public double getTakeoffAngle() {
        return this.takeoffAngle;
    }

    public double velocityAtSource() {
        return this.getPhase().velocityAtSource();
    }

    public double radialSlownessAtSource() {
        double srcVel = this.velocityAtSource();
        double rofE = this.getPhase().getTauModel().getRadiusOfEarth();
        double srcRadius = rofE - this.getSourceDepth();
        double radSlow = Math.sqrt(1.0 / (srcVel * srcVel) - this.getRayParam() * this.getRayParam() / (srcRadius * srcRadius));
        if (!Double.isFinite(radSlow) && Math.abs(1.0 / (srcVel * srcVel) - this.getRayParam() * this.getRayParam() / (srcRadius * srcRadius)) < 1.0E-6) {
            System.err.println("rad slow: " + 1.0 / (srcVel * srcVel) + " - " + this.getRayParam() * this.getRayParam() / (srcRadius * srcRadius));
            System.err.println(srcVel + " " + this.getRayParam() + " " + srcRadius);
            radSlow = 0.0;
        }
        return radSlow;
    }

    public double velocityAtReceiver() {
        return this.getPhase().velocityAtReceiver();
    }

    public double radialSlownessAtReceiver() {
        double recVel = this.velocityAtReceiver();
        double rofE = this.getPhase().getTauModel().getRadiusOfEarth();
        double recRadius = rofE - this.getReceiverDepth();
        return Math.sqrt(1.0 / (recVel * recVel) - this.getRayParam() * this.getRayParam() / (recRadius * recRadius));
    }

    public int getRayParamIndex() {
        return this.rayParamIndex;
    }

    public String getName() {
        return this.name;
    }

    public String getPuristName() {
        return this.puristName;
    }

    public double getSourceDepth() {
        return this.sourceDepth;
    }

    public double getReceiverDepth() {
        return this.receiverDepth;
    }

    public TimeDist[] getPierce() {
        if (this.pierce == null) {
            this.pierce = this.getPhase().calcPierceTimeDist(this).toArray(new TimeDist[0]);
        }
        return this.pierce;
    }

    public TimeDist[] getPath() {
        if (this.path == null) {
            this.path = this.getPhase().calcPathTimeDist(this).toArray(new TimeDist[0]);
        }
        return this.path;
    }

    public Arrival negateDistance() {
        Arrival neg = new Arrival(this.phase, this.time, -1.0 * this.dist, this.rayParam, this.rayParamIndex, this.searchDist, this.name, this.puristName, this.sourceDepth, this.receiverDepth, this.takeoffAngle, this.incidentAngle, this.dRPdDist);
        neg.setSearchDistDeg(this.getSearchDistDeg());
        return neg;
    }

    public boolean isRelativeToArrival() {
        return this.relativeToArrival != null;
    }

    public Arrival getRelativeToArrival() {
        return this.relativeToArrival;
    }

    public void setRelativeToArrival(Arrival relativeToArrival) {
        this.relativeToArrival = relativeToArrival;
    }

    public String toString() {
        double moduloDistDeg = this.getModuloDistDeg();
        if (this.getSearchDistDeg() < 0.0) {
            moduloDistDeg *= -1.0;
        }
        String desc = Outputs.formatDistance(moduloDistDeg) + Outputs.formatDepth(this.getSourceDepth()) + "   " + this.getName() + "  " + Outputs.formatTime(this.getTime()) + "  " + Outputs.formatRayParam(Math.PI / 180 * this.getRayParam()) + "  " + Outputs.formatDistance(this.getTakeoffAngle()) + " " + Outputs.formatDistance(this.getIncidentAngle()) + " " + Outputs.formatDistance(this.getDistDeg()) + " " + this.getRayParamIndex();
        desc = this.getName().equals(this.getPuristName()) ? desc + "   = " : desc + "   * ";
        desc = desc + this.getPuristName();
        return desc;
    }

    public int getNumPiercePoints() {
        if (this.pierce != null) {
            return this.pierce.length;
        }
        return 0;
    }

    public int getNumPathPoints() {
        if (this.path != null) {
            return this.path.length;
        }
        return 0;
    }

    public TimeDist getPiercePoint(int i) {
        return this.pierce[i];
    }

    public TimeDist getFirstPiercePoint(double depth) {
        for (int i = 0; i < this.pierce.length; ++i) {
            if (this.pierce[i].getDepth() != depth) continue;
            return this.pierce[i];
        }
        throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
    }

    public TimeDist getLastPiercePoint(double depth) {
        TimeDist piercepoint = null;
        for (int i = 0; i < this.pierce.length; ++i) {
            if (this.pierce[i].getDepth() != depth) continue;
            piercepoint = this.pierce[i];
        }
        if (piercepoint == null) {
            throw new ArrayIndexOutOfBoundsException("No Pierce point found for depth " + depth);
        }
        return piercepoint;
    }

    public TimeDist getPathPoint(int i) {
        return this.path[i];
    }

    public static Arrival getEarliestArrival(List<Arrival> arrivals) {
        double soonest = Double.MAX_VALUE;
        Arrival soonestArrival = null;
        for (Arrival a : arrivals) {
            if (!(a.getTime() < soonest)) continue;
            soonestArrival = a;
            soonest = a.getTime();
        }
        return soonestArrival;
    }

    public static Arrival getLatestArrival(List<Arrival> arrivals) {
        double latest = Double.MAX_VALUE;
        Arrival latestArrival = null;
        for (Arrival a : arrivals) {
            if (!(a.getTime() < latest)) continue;
            latestArrival = a;
            latest = a.getTime();
        }
        return latestArrival;
    }

    public void writeJSON(PrintWriter pw, String indent) throws IOException {
        String NL = "\n";
        pw.write(indent + "{" + NL);
        String innerIndent = indent + "  ";
        pw.write(innerIndent + JSONWriter.valueToString((Object)"distdeg") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)this.getModuloDistDeg())) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"phase") + ": " + JSONWriter.valueToString((Object)this.getName()) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"time") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)this.getTime())) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"rayparam") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)(Math.PI / 180 * this.getRayParam()))) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"takeoff") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)this.getTakeoffAngle())) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"incident") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)this.getIncidentAngle())) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"puristdist") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)this.getDistDeg())) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"puristname") + ": " + JSONWriter.valueToString((Object)this.getPuristName()) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"amp") + ": {" + NL);
        try {
            double geospread = this.getGeometricSpreadingFactor();
            if (Double.isFinite(geospread)) {
                pw.write(innerIndent + "  " + JSONWriter.valueToString((Object)"factor") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)this.getAmplitudeFactor())) + "," + NL);
                pw.write(innerIndent + "  " + JSONWriter.valueToString((Object)"geospread") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)geospread)) + "," + NL);
            } else {
                pw.write(innerIndent + "  " + JSONWriter.valueToString((Object)"error") + ": " + JSONWriter.valueToString((Object)"geometrical speading not finite") + "," + NL);
            }
            pw.write(innerIndent + "  " + JSONWriter.valueToString((Object)"refltran") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)this.getReflTrans())) + NL);
            pw.write(innerIndent + "}");
        }
        catch (TauPException e) {
            throw new RuntimeException(e);
        }
        if (this.getPhase() instanceof ScatteredSeismicPhase) {
            pw.write("," + NL);
            ScatteredSeismicPhase scatPhase = (ScatteredSeismicPhase)this.getPhase();
            pw.write(innerIndent + JSONWriter.valueToString((Object)"scatter") + ": {" + NL);
            pw.write(innerIndent + "  " + JSONWriter.valueToString((Object)"depth") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)scatPhase.getScattererDepth())) + "," + NL);
            pw.write(innerIndent + "  " + JSONWriter.valueToString((Object)"distdeg") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)scatPhase.getScattererDistanceDeg())) + "," + NL);
            pw.write(innerIndent + "}");
        }
        if (this.isRelativeToArrival()) {
            pw.write("," + NL);
            Arrival relArrival = this.getRelativeToArrival();
            pw.write(innerIndent + JSONWriter.valueToString((Object)"relative") + ": {" + NL);
            pw.write(innerIndent + "  " + JSONWriter.valueToString((Object)"difference") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)(this.getTime() - relArrival.getTime()))) + "," + NL);
            pw.write(innerIndent + "  " + JSONWriter.valueToString((Object)"arrival") + ": " + NL);
            relArrival.writeJSON(pw, innerIndent + "    ");
            pw.write(innerIndent + "}");
        }
        if (this.pierce != null) {
            TimeDist[] tdArray;
            pw.write("," + NL);
            pw.write(innerIndent + JSONWriter.valueToString((Object)"pierce") + ": [" + NL);
            for (TimeDist td : tdArray = this.getPierce()) {
                pw.write(innerIndent + "  [ " + JSONWriter.valueToString((Object)Float.valueOf((float)td.getDistDeg())) + ", " + JSONWriter.valueToString((Object)Float.valueOf((float)td.getDepth())) + ", " + JSONWriter.valueToString((Object)Float.valueOf((float)td.getTime())) + " ]," + NL);
            }
            pw.write(innerIndent + "]");
        }
        if (this.path != null) {
            pw.write("," + NL);
            pw.write(innerIndent + JSONWriter.valueToString((Object)"path") + ": [" + NL);
            TimeDist[] tdArray = this.getPath();
            for (TimeDist td : tdArray) {
                pw.write(innerIndent + "  [ " + JSONWriter.valueToString((Object)Float.valueOf((float)td.getDistDeg())) + ", " + JSONWriter.valueToString((Object)Float.valueOf((float)td.getDepth())) + ", " + JSONWriter.valueToString((Object)Float.valueOf((float)td.getTime())) + " ]," + NL);
            }
            pw.write(innerIndent + "]");
        }
        pw.write(NL);
        pw.write(indent + "}");
    }

    public JSONObject asJSONObject() {
        JSONObject a = new JSONObject();
        a.put("distdeg", (float)this.getModuloDistDeg());
        a.put("phase", (Object)this.getName());
        a.put("time", (float)this.getTime());
        a.put("rayparam", (float)(Math.PI / 180 * this.getRayParam()));
        a.put("takeoff", (float)this.getTakeoffAngle());
        a.put("incident", (float)this.getIncidentAngle());
        a.put("puristdist", (float)this.getDistDeg());
        a.put("puristname", (Object)this.getPuristName());
        JSONObject ampObj = new JSONObject();
        a.put("amp", (Object)ampObj);
        try {
            double geospread = this.getGeometricSpreadingFactor();
            if (Double.isFinite(geospread)) {
                ampObj.put("factor", (float)this.getAmplitudeFactor());
                ampObj.put("geospread", (float)geospread);
            } else {
                ampObj.put("error", (Object)"geometrical speading not finite");
            }
            ampObj.put("refltran", (float)this.getReflTrans());
        }
        catch (TauPException e) {
            throw new RuntimeException(e);
        }
        if (this.getPhase() instanceof ScatteredSeismicPhase) {
            ScatteredSeismicPhase scatPhase = (ScatteredSeismicPhase)this.getPhase();
            a.put("scatterdepth", (float)scatPhase.getScattererDepth());
            a.put("scatterdistdeg", scatPhase.getScattererDistanceDeg());
        }
        if (this.isRelativeToArrival()) {
            Arrival relArrival = this.getRelativeToArrival();
            JSONObject relA = new JSONObject();
            a.put("relative", (Object)relA);
            relA.put("difference", (float)(this.getTime() - relArrival.getTime()));
            relA.put("arrival", (Object)relArrival.asJSONObject());
        }
        if (this.pierce != null || this.path != null) {
            TimeDist[] tdArray;
            JSONArray points = new JSONArray();
            a.put("pierce", (Object)points);
            boolean first = true;
            TimeDist[] timeDistArray = tdArray = this.getPierce();
            int n = timeDistArray.length;
            for (int i = 0; i < n; ++i) {
                TimeDist td = timeDistArray[i];
                JSONArray tdItems = new JSONArray();
                points.put((Object)tdItems);
                tdItems.put(td.getDistDeg());
                tdItems.put(td.getDepth());
                tdItems.put(td.getTime());
            }
        }
        if (this.path != null) {
            TimeDist[] tdArray;
            JSONArray points = new JSONArray();
            a.put("path", (Object)points);
            for (TimeDist td : tdArray = this.getPath()) {
                JSONArray tdItems = new JSONArray();
                points.put((Object)tdItems);
                tdItems.put(td.getDistDeg());
                tdItems.put(td.getDepth());
                tdItems.put(td.getTime());
            }
        }
        return a;
    }
}

