/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Path;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.ToolRun;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TauP_Wavefront
extends TauP_Path {
    int numRays = 30;
    float timeStep = 100.0f;
    boolean separateFilesByTime = false;
    boolean negDistance = false;
    boolean doInteractive = true;
    Map<SeismicPhase, Map<Float, List<TimeDist>>> result;

    public TauP_Wavefront() {
        this.setOutFileBase("taup_wavefront");
        this.setDefaultOutputFormat();
    }

    public TauP_Wavefront(String modelName, String outFileBase) throws TauModelException {
        super(modelName, outFileBase);
        this.setDefaultOutputFormat();
    }

    public TauP_Wavefront(String modelName) throws TauModelException {
        super(modelName);
        this.setOutFileBase("taup_wavefront");
        this.setDefaultOutputFormat();
    }

    public TauP_Wavefront(TauModel tMod, String outFileBase) throws TauModelException {
        super(tMod, outFileBase);
        this.setDefaultOutputFormat();
    }

    public TauP_Wavefront(TauModel tMod) throws TauModelException {
        super(tMod);
        this.setOutFileBase("taup_wavefront");
        this.setDefaultOutputFormat();
    }

    @Override
    public List<Arrival> calculate(List<Double> degreesList) throws TauModelException {
        this.result = this.calcIsochron();
        return new ArrayList<Arrival>();
    }

    @Override
    public String getStdUsage() {
        return this.getStdUsageHead() + this.getPhaseUsage();
    }

    @Override
    public String getLimitUsage() {
        return "--gmt             -- outputs path as a complete GMT script.\n--svg             -- outputs path as a complete SVG file.\n--mapwidth        -- sets map width for GMT script.\n";
    }

    @Override
    public String getUsage() {
        return this.getStdUsage() + this.getLimitUsage() + "--rays  num      -- number of raypaths/distances to sample.\n--timestep  num  -- steps in time (seconds) for output.\n--timefiles      -- outputs each time into a separate .ps file within the gmt script.\n--negdist        -- outputs negative distance as well so wavefronts are in both halves.\n" + TauP_Wavefront.getStdUsageTail();
    }

    @Override
    public void printScriptBeginning(PrintWriter out) throws IOException {
        if (this.outputFormat.equals("json")) {
            throw new RuntimeException("JSON output for TauP_Path not yet supported.");
        }
        if (this.outputFormat.equals("svg")) {
            this.printScriptBeginningSVG(out);
        } else if (this.gmtScript) {
            if (this.getOutFile().equals("stdout")) {
                this.psFile = "taup_wavefront.ps";
            }
            super.printScriptBeginning(out);
        }
    }

    @Override
    public void printResult(PrintWriter out) throws IOException {
        if (this.outputFormat.equals("svg")) {
            this.printResultSVG(out);
        } else {
            this.printResultGMT(out);
        }
        out.flush();
    }

    @Override
    public void printResultSVG(PrintWriter out) throws IOException {
        HashSet<Float> keySet = new HashSet<Float>();
        for (SeismicPhase phase : this.result.keySet()) {
            Map<Float, List<TimeDist>> phaseResult = this.result.get(phase);
            keySet.addAll(phaseResult.keySet());
        }
        if (keySet.size() == 0) {
            System.err.println("taup wavefront, no phases successful...");
            return;
        }
        ArrayList<Float> keys = new ArrayList<Float>();
        keys.addAll(keySet);
        Collections.sort(keys);
        Float lastTime = (Float)keys.get(keys.size() - 1);
        int numDigits = 1;
        Object formatStr = "0";
        while (Math.pow(10.0, numDigits) < (double)lastTime.floatValue()) {
            ++numDigits;
            formatStr = (String)formatStr + "0";
        }
        if (lastTime.floatValue() < 1.0f) {
            formatStr = (String)formatStr + ".0";
            int fracDigits = 0;
            while (Math.pow(10.0, fracDigits) > (double)lastTime.floatValue()) {
                --fracDigits;
                formatStr = (String)formatStr + "0";
            }
        }
        DecimalFormat format = new DecimalFormat((String)formatStr, new DecimalFormatSymbols(Locale.US));
        PrintWriter timeOut = out;
        ArrayList<SeismicPhase> phasekeys = new ArrayList<SeismicPhase>();
        phasekeys.addAll(this.result.keySet());
        Collections.sort(phasekeys, new Comparator<SeismicPhase>(){

            @Override
            public int compare(SeismicPhase arg0, SeismicPhase arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        for (SeismicPhase phase : phasekeys) {
            timeOut.println("<g class=\"autocolor\" >");
            for (Float time : keys) {
                Object timeStr = "time_" + time;
                timeStr = ((String)timeStr).replace('.', '_');
                this.printResultPhaseAtTime(timeOut, phase, time, (String)timeStr);
            }
            timeOut.println("</g> <!-- end " + phase.getName() + " -->");
        }
        out.println("</g> <!-- end translate -->");
        out.println("  </g> ");
        out.println("  </g> ");
        out.println("</svg>");
        timeOut.flush();
        out.flush();
    }

    public void printResultGMT(PrintWriter out) throws IOException {
        Object byTimePsFile = this.psFile;
        double radiusOfEarth = this.getTauModel().getRadiusOfEarth();
        HashSet<Float> keySet = new HashSet<Float>();
        for (SeismicPhase phase : this.result.keySet()) {
            Map<Float, List<TimeDist>> phaseResult = this.result.get(phase);
            keySet.addAll(phaseResult.keySet());
        }
        if (keySet.size() == 0) {
            System.err.println("taup wavefront, no phases successful...");
            return;
        }
        ArrayList<Float> keys = new ArrayList<Float>();
        keys.addAll(keySet);
        Collections.sort(keys);
        Float lastTime = (Float)keys.get(keys.size() - 1);
        int numDigits = 1;
        Object formatStr = "0";
        while (Math.pow(10.0, numDigits) < (double)lastTime.floatValue()) {
            ++numDigits;
            formatStr = (String)formatStr + "0";
        }
        if (lastTime.floatValue() < 1.0f) {
            formatStr = (String)formatStr + ".0";
            int fracDigits = 0;
            while (Math.pow(10.0, fracDigits) > (double)lastTime.floatValue()) {
                --fracDigits;
                formatStr = (String)formatStr + "0";
            }
        }
        DecimalFormat format = new DecimalFormat((String)formatStr, new DecimalFormatSymbols(Locale.US));
        PrintWriter timeOut = out;
        for (Float time : keys) {
            Object timeStr = "time_" + time;
            timeStr = ((String)timeStr).replace('.', '_');
            if (this.separateFilesByTime) {
                String psFileBase = this.psFile;
                if (this.gmtScript && this.psFile.endsWith(".ps")) {
                    psFileBase = this.psFile.substring(0, this.psFile.length() - 3);
                }
                String timeExt = "_" + format.format(time);
                byTimePsFile = psFileBase + timeExt + ".ps";
                String timeOutName = this.getOutFileBase() + timeExt;
                if (this.getOutFile().endsWith(".gmt")) {
                    timeOutName = this.getOutFile().substring(0, this.getOutFile().length() - 4) + timeExt + ".gmt";
                }
                if (timeOut != null && timeOut != out) {
                    timeOut.close();
                }
                timeOut = new PrintWriter(new BufferedWriter(new FileWriter(timeOutName)));
                if (this.gmtScript) {
                    this.printScriptBeginning(timeOut, (String)byTimePsFile);
                }
            }
            if (this.gmtScript) {
                timeOut.println("# timestep = " + time);
                timeOut.println("gmt psxy -P -R -K -O -Wblue -JP -m -A >> " + (String)byTimePsFile + " <<END");
            }
            ArrayList<SeismicPhase> phasekeys = new ArrayList<SeismicPhase>();
            phasekeys.addAll(this.result.keySet());
            Collections.sort(phasekeys, new Comparator<SeismicPhase>(){

                @Override
                public int compare(SeismicPhase arg0, SeismicPhase arg1) {
                    return arg0.getName().compareTo(arg1.getName());
                }
            });
            for (SeismicPhase phase : phasekeys) {
                this.printResultPhaseAtTime(timeOut, phase, time, (String)timeStr);
            }
            if (!this.gmtScript || !this.separateFilesByTime) continue;
            timeOut.println("# end postscript");
            timeOut.println("gmt psxy -P -R -O -JP -m -A -T >> " + (String)byTimePsFile);
            timeOut.println("# convert ps to pdf, clean up .ps file");
            timeOut.println("gmt psconvert -P -Tf  " + (String)byTimePsFile + " && rm " + (String)byTimePsFile);
            timeOut.println("# clean up after gmt...");
            timeOut.println("/bin/rm gmt.history");
        }
        if (this.gmtScript && !this.separateFilesByTime) {
            out.println("# end postscript");
            out.println("gmt psxy -P -R -O -JP -m -A -T >> " + (String)byTimePsFile);
            out.println("# convert ps to pdf, clean up .ps file");
            out.println("gmt psconvert -P -Tf  " + (String)byTimePsFile + " && rm " + (String)byTimePsFile);
            out.println("# clean up after gmt...");
            out.println("rm gmt.history");
        } else if (this.outputFormat.equals("svg")) {
            out.println("</g> <!-- end translate -->");
            out.println("  </g> ");
            out.println("  </g> ");
            out.println("</svg>");
        }
        timeOut.flush();
        out.flush();
    }

    public void printResultPhaseAtTime(PrintWriter timeOut, SeismicPhase phase, Float time, String timeStr) throws IOException {
        Map<Float, List<TimeDist>> phaseResult = this.result.get(phase);
        List<TimeDist> wavefront = phaseResult.get(time);
        if (wavefront == null || wavefront.size() == 0) {
            return;
        }
        if (this.outputFormat.equals("gmt")) {
            timeOut.println("> " + phase.getName() + " at " + time + " seconds");
        } else if (this.outputFormat.equals("svg")) {
            timeOut.println("<!-- " + phase.getName() + " at " + time + " seconds");
            timeOut.println(" -->");
            timeOut.println("<polyline class=\"wavefront " + phase.getName() + " " + timeStr + "\" points=\"");
        }
        Collections.sort(wavefront, new Comparator<TimeDist>(){

            @Override
            public int compare(TimeDist arg0, TimeDist arg1) {
                return Double.valueOf(arg0.getP()).compareTo(arg1.getP());
            }
        });
        double radiusOfEarth = this.getTauModel().getRadiusOfEarth();
        for (TimeDist td : wavefront) {
            if (this.outputFormat.equals("gmt")) {
                timeOut.println(Outputs.formatDistance(td.getDistDeg()) + "  " + Outputs.formatDepth(radiusOfEarth - td.getDepth()) + " " + Outputs.formatTime(time.floatValue()) + " " + Outputs.formatRayParam(td.getP()));
                continue;
            }
            if (!this.outputFormat.equals("svg")) continue;
            this.printDistRadiusAsXY(timeOut, td.getDistDeg(), radiusOfEarth - td.getDepth());
            timeOut.println();
        }
        if (this.outputFormat.equals("svg")) {
            timeOut.println("\" />");
        }
        if (this.isNegDistance()) {
            if (this.outputFormat.equals("gmt")) {
                timeOut.write("> " + phase.getName() + " at " + time + " seconds (neg distance)\n");
            } else if (this.outputFormat.equals("svg")) {
                timeOut.println("<!-- " + phase.getName() + " at " + time + " seconds (neg distance)");
                timeOut.println(" -->");
                timeOut.println("<polyline class=\"wavefront " + phase.getName() + " " + timeStr + "\" points=\"");
            }
            for (TimeDist td : wavefront) {
                if (this.outputFormat.equals("gmt")) {
                    timeOut.println(Outputs.formatDistance(-1.0 * td.getDistDeg()) + "  " + Outputs.formatDepth(radiusOfEarth - td.getDepth()) + " " + Outputs.formatTime(time.floatValue()) + " " + Outputs.formatRayParam(td.getP()));
                    continue;
                }
                if (!this.outputFormat.equals("svg")) continue;
                this.printDistRadiusAsXY(timeOut, -1.0 * td.getDistDeg(), radiusOfEarth - td.getDepth());
                timeOut.println();
            }
            if (this.outputFormat.equals("svg")) {
                timeOut.println("\" />");
            }
        }
        if (!this.outputFormat.equals("svg") && this.gmtScript) {
            timeOut.println("END");
        }
    }

    public Map<SeismicPhase, Map<Float, List<TimeDist>>> calcIsochron() throws TauModelException {
        this.depthCorrect();
        HashMap<SeismicPhase, Map<Float, List<TimeDist>>> resultOut = new HashMap<SeismicPhase, Map<Float, List<TimeDist>>>();
        this.clearArrivals();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
            SeismicPhase phase = phaseList.get(phaseNum);
            if (this.verbose) {
                System.out.println("Work on " + phase.getName());
            }
            double minDist = phase.getMinDistanceDeg();
            double maxDist = phase.getMaxDistanceDeg();
            double deltaDist = (maxDist - minDist) / (double)(this.numRays - 1);
            double degrees = minDist;
            ArrayList<Arrival> allArrival = new ArrayList<Arrival>();
            for (int r = 0; r < this.getNumRays(); ++r) {
                degrees = minDist + (double)r * deltaDist;
                List<Arrival> phaseArrivals = phase.calcTimeExactDistanceDeg(degrees);
                allArrival.addAll(phaseArrivals);
            }
            HashMap<Float, ArrayList<TimeDist>> out = new HashMap<Float, ArrayList<TimeDist>>();
            resultOut.put(phase, out);
            boolean done = false;
            float timeVal = 0.0f;
            while (!done) {
                done = true;
                timeVal += this.timeStep;
                if (this.verbose) {
                    System.out.println("Time " + timeVal + " for " + phase.getName() + " " + allArrival.size());
                }
                Arrival prevArrival = null;
                for (Arrival arrival : allArrival) {
                    if (arrival.getTime() >= (double)timeVal) {
                        TimeDist[] path = arrival.getPath();
                        if (prevArrival != null && prevArrival.getTime() < (double)timeVal) {
                            double distConnect = TauP_Wavefront.linearInterp(prevArrival.getTime(), prevArrival.getDist(), arrival.getTime(), arrival.getDist(), timeVal);
                            double raypConnect = TauP_Wavefront.linearInterp(prevArrival.getTime(), prevArrival.getRayParam(), arrival.getTime(), arrival.getRayParam(), timeVal);
                            TimeDist interp = new TimeDist(raypConnect, timeVal, distConnect, arrival.getReceiverDepth());
                            ArrayList<TimeDist> tdList = (ArrayList<TimeDist>)out.get(Float.valueOf(timeVal));
                            if (tdList == null) {
                                tdList = new ArrayList<TimeDist>();
                                out.put(Float.valueOf(timeVal), tdList);
                            }
                            tdList.add(interp);
                        }
                        for (int i = 0; i < path.length; ++i) {
                            if (!(path[i].getTime() <= (double)timeVal) || i >= path.length - 1 || !((double)timeVal < path[i + 1].getTime())) continue;
                            TimeDist interp = this.interp(path[i], path[i + 1], timeVal);
                            ArrayList<TimeDist> tdList = (ArrayList<TimeDist>)out.get(Float.valueOf(timeVal));
                            if (tdList == null) {
                                tdList = new ArrayList<TimeDist>();
                                out.put(Float.valueOf(timeVal), tdList);
                            }
                            tdList.add(interp);
                            done = false;
                            break;
                        }
                    }
                    prevArrival = arrival;
                }
            }
        }
        return resultOut;
    }

    TimeDist interp(TimeDist x, TimeDist y, float t) {
        double distInterp = TauP_Wavefront.linearInterp(x.getTime(), x.getDistRadian(), y.getTime(), y.getDistRadian(), t);
        double depthInterp = TauP_Wavefront.linearInterp(x.getTime(), x.getDepth(), y.getTime(), y.getDepth(), t);
        return new TimeDist(x.getP(), t, distInterp, depthInterp);
    }

    public void setNumRays(int numRays) {
        this.numRays = numRays;
    }

    public int getNumRays() {
        return this.numRays;
    }

    public float getTimeStep() {
        return this.timeStep;
    }

    public void setTimeStep(float timeStep) {
        this.timeStep = timeStep;
    }

    public boolean isSeparateFilesByTime() {
        return this.separateFilesByTime;
    }

    public void setSeparateFilesByTime(boolean separateFilesByTime) {
        this.separateFilesByTime = separateFilesByTime;
    }

    public boolean isNegDistance() {
        return this.negDistance;
    }

    public void setNegDistance(boolean negDistance) {
        this.negDistance = negDistance;
    }

    @Override
    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int i = 0;
        int numNoComprendoArgs = 0;
        for (int j = 0; j < args.length; ++j) {
            if (!TauP_Wavefront.dashEquals("h", args[j])) continue;
            this.doInteractive = false;
        }
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        while (i < leftOverArgs.length) {
            if (TauP_Wavefront.dashEquals("gmt", leftOverArgs[i])) {
                this.gmtScript = true;
            } else if (TauP_Wavefront.dashEquals("timefiles", leftOverArgs[i])) {
                this.separateFilesByTime = true;
            } else if (TauP_Wavefront.dashEquals("negdist", leftOverArgs[i])) {
                this.negDistance = true;
            } else if (TauP_Wavefront.dashEquals("rays", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setNumRays(Integer.parseInt(leftOverArgs[i + 1]));
                ++i;
            } else if (TauP_Wavefront.dashEquals("timestep", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setTimeStep(Float.parseFloat(leftOverArgs[i + 1]));
                ++i;
            } else if (TauP_Wavefront.dashEquals("mapwidth", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setMapWidth(Float.parseFloat(leftOverArgs[i + 1]));
                ++i;
            } else {
                noComprendoArgs[numNoComprendoArgs++] = TauP_Wavefront.dashEquals("help", leftOverArgs[i]) ? leftOverArgs[i] : leftOverArgs[i];
            }
            ++i;
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void init() throws TauPException {
        super.init();
    }

    @Override
    public void start() throws IOException, TauModelException, TauPException {
        if (this.doInteractive) {
            super.start();
        } else {
            this.calculate(new ArrayList<Double>());
            this.printResult(this.getWriter());
        }
    }

    public static void main(String[] args) throws IOException {
        ToolRun.legacyRunTool(ToolRun.WAVEFRONT, args);
    }
}

