/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.Theta;
import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.MSeed3Record;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class TauP_WKBJ
extends TauP_Time {
    protected double deltaT = 0.05;
    protected int numSamples = 1000;
    protected double startTime = 0.0;

    public TauP_WKBJ() {
    }

    public TauP_WKBJ(TauModel tMod) throws TauModelException {
        super(tMod);
    }

    public TauP_WKBJ(String modelName) throws TauModelException {
        super(modelName);
    }

    public double getDeltaT() {
        return this.deltaT;
    }

    public void setDeltaT(double v) {
        this.deltaT = v;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public void setNumSamples(int v) {
        this.numSamples = v;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double v) {
        this.startTime = v;
    }

    @Override
    public List<Arrival> calculate(List<Double> degreesList) throws TauPException {
        try {
            List<Arrival> arrivals = this.calcWKBJ(degreesList);
            return this.sortArrivals(arrivals);
        }
        catch (IOException e) {
            throw new TauPException(e);
        }
    }

    @Override
    public List<Arrival> calcEventStation(Double[] evloc, List<Double[]> staloc) throws TauPException {
        this.setEventLatLon(evloc[0], evloc[1]);
        ArrayList<Arrival> out = new ArrayList<Arrival>();
        for (Double[] sta : staloc) {
            this.clearArrivals();
            this.setEventLatLon(evloc[0], evloc[1]);
            this.setStationLatLon(sta[0], sta[1]);
            this.degreesList.add(SphericalCoords.distance(sta[0], sta[1], evloc[0], evloc[1]));
            this.azimuth = SphericalCoords.azimuth(evloc[0], evloc[1], sta[0], sta[1]);
            this.backAzimuth = SphericalCoords.azimuth(sta[0], sta[1], evloc[0], evloc[1]);
            out.addAll(this.calculate(this.degreesList));
        }
        this.arrivals = this.sortArrivals(out);
        return this.arrivals;
    }

    public List<Arrival> calcWKBJ(List<Double> degreesList) throws TauPException, IOException {
        this.validateArguments();
        this.depthCorrect();
        this.clearArrivals();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        ArrayList<Arrival> allArrivals = new ArrayList<Arrival>();
        File outMSeed3File = new File("taup_wkbj.ms3");
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outMSeed3File)));
        for (double degrees : degreesList) {
            System.out.println("In calcWKBJ for " + degrees + " degrees.");
            float[] seismogramPoints = new float[this.numSamples];
            for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
                SeismicPhase phase = phaseList.get(phaseNum);
                List<Arrival> phaseArrivals = phase.calcTime(degrees);
                allArrivals.addAll(phaseArrivals);
                for (Arrival arrival : phaseArrivals) {
                    double reflTrans = arrival.getReflTrans();
                    Theta thetaAtX = new Theta(phase, arrival.getDist());
                    System.out.println("Got Theta");
                    double minRayParam = phase.getMinRayParam();
                    double rayParam = thetaAtX.getMaxRayParam();
                    System.out.println("Got ray param");
                    double theta = thetaAtX.getTheta(rayParam);
                    System.out.println("Got theta for ray param");
                    this.setStartTime(320.0);
                    double nextRayParam = thetaAtX.getStepRayParam(rayParam, this.getDeltaT());
                    double nextTheta = thetaAtX.getTheta(nextRayParam);
                    int n = 0;
                    try {
                        while (nextRayParam >= minRayParam) {
                            n = (int)Math.round((theta - this.getStartTime()) / this.getDeltaT());
                            if (n >= 0 && n < seismogramPoints.length) {
                                int n2 = n;
                                seismogramPoints[n2] = seismogramPoints[n2] + (float)(Math.sqrt(rayParam) * reflTrans * (rayParam - nextRayParam));
                                System.out.println(n + "  " + seismogramPoints[n]);
                            }
                            rayParam = nextRayParam;
                            theta = nextTheta;
                            nextRayParam = thetaAtX.getStepRayParam(rayParam, this.getDeltaT());
                            nextTheta = thetaAtX.getTheta(nextRayParam);
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new TauPException(e);
                    }
                }
            }
            MSeed3Record ms3Rec = new MSeed3Record();
            ms3Rec.setSourceId(new FDSNSourceId("XX", ("D" + degrees).substring(8), "00", "B", "X", "Z"));
            ms3Rec.setNumSamples(this.numSamples);
            ms3Rec.setSampleRate(this.getDeltaT());
            ms3Rec.setTimeseries(seismogramPoints);
            ms3Rec.write((OutputStream)dos);
        }
        dos.close();
        return allArrivals;
    }
}

