/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import java.io.IOException;
import java.io.PrintWriter;

public class TauP_VelocityPlot
extends TauP_Tool {
    public static final String DEFAULT_OUTFILE = "taup_velocitymodel";
    float mapWidth = 6.0f;
    int plotOffset = 80;
    float margin = 40.0f;
    String modelName;
    String modelType;
    String overlayModelName = null;
    String overlayModelType = null;
    protected double depth = 0.0;
    protected double receiverDepth = 0.0;
    protected double scattererDepth = 0.0;

    public TauP_VelocityPlot() {
        this.setOutFileBase(DEFAULT_OUTFILE);
        this.setDefaultOutputFormat();
    }

    @Override
    public void start() throws TauPException, IOException {
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelName + ", tried internally and from file");
        }
        if (this.getOutFileBase() == DEFAULT_OUTFILE) {
            this.setOutFileBase(vMod.modelName + "_vel");
        }
        this.printResult(this.getWriter());
    }

    public void printSVG(PrintWriter out, VelocityModel vMod) {
        double maxVel = 0.0;
        for (VelocityLayer vLayer : vMod.layer) {
            if (vLayer.getTopPVelocity() > maxVel) {
                maxVel = vLayer.getTopPVelocity();
            }
            if (vLayer.getBotPVelocity() > maxVel) {
                maxVel = vLayer.getBotPVelocity();
            }
            if (vLayer.getTopSVelocity() > maxVel) {
                maxVel = vLayer.getTopSVelocity();
            }
            if (!(vLayer.getBotSVelocity() > maxVel)) continue;
            maxVel = vLayer.getBotSVelocity();
        }
        double minVel = 0.0;
        maxVel *= 1.05;
        int numXTicks = 5;
        double maxY = vMod.maxRadius;
        double minY = 0.0;
        int numYTicks = 10;
        boolean xEndFixed = false;
        boolean yEndFixed = false;
        float pixelWidth = 72.0f * this.mapWidth - (float)this.plotOffset;
        float plotWidth = pixelWidth - this.margin;
        String title = vMod.modelName;
        this.printSVGBeginning(out);
        SvgUtil.createXYAxes(out, minVel, maxVel, numXTicks, xEndFixed, maxY, minY, numYTicks, yEndFixed, pixelWidth, this.margin, title, "Velocity (km/s)", "Depth (km)");
        out.println("<g transform=\"scale(1,-1) translate(0, -" + plotWidth + ")\">");
        out.println("<g transform=\"scale(" + (double)plotWidth / maxVel + "," + (double)plotWidth / maxY + ")\" >");
        if (this.getSourceDepth() != 0.0) {
            out.print("<polyline class=\"sourcedepth\" points=\"0 " + (maxY - this.getSourceDepth()) + " " + maxVel + " " + (maxY - this.getSourceDepth()) + "\"/>");
        }
        if (this.getReceiverDepth() != 0.0) {
            out.print("<polyline class=\"receiverdepth\" points=\"0 " + (maxY - this.getReceiverDepth()) + " " + maxVel + " " + (maxY - this.getReceiverDepth()) + "\"/>");
        }
        if (this.getScattererDepth() != 0.0) {
            out.print("<polyline class=\"scattererdepth\" points=\"0 " + (maxY - this.getScattererDepth()) + " " + maxVel + " " + (maxY - this.getScattererDepth()) + "\"/>");
        }
        out.println("<!-- P velocity");
        out.println(" -->");
        out.println("<polyline class=\"pwave\" points=\"");
        VelocityLayer prev = null;
        for (VelocityLayer vlay : vMod.layer) {
            if (prev == null || prev.getBotPVelocity() != vlay.getTopPVelocity()) {
                out.println((float)vlay.getTopPVelocity() + " " + (maxY - (double)((float)vlay.getTopDepth())) + " ");
            }
            out.println((float)vlay.getBotPVelocity() + " " + (maxY - (double)((float)vlay.getBotDepth())) + " ");
            prev = vlay;
        }
        out.println("\" />");
        out.println("<!-- S velocity");
        out.println(" -->");
        out.println("<polyline class=\"swave\" points=\"");
        prev = null;
        for (VelocityLayer vlay : vMod.layer) {
            if (prev == null || prev.getBotSVelocity() != vlay.getTopSVelocity()) {
                out.println((float)vlay.getTopSVelocity() + " " + (maxY - (double)((float)vlay.getTopDepth())) + " ");
            }
            out.println((float)vlay.getBotSVelocity() + " " + (maxY - (double)((float)vlay.getBotDepth())) + " ");
            prev = vlay;
        }
        out.println("\" />");
        out.println("</g>");
        out.println("</g>");
        out.println("</g>");
        out.println("</svg>");
        out.flush();
        this.closeWriter();
    }

    @Override
    public String[] allowedOutputFormats() {
        String[] formats = new String[]{"text", "json", "svg", "csv"};
        return formats;
    }

    @Override
    public void setDefaultOutputFormat() {
        this.setOutputFormat("svg");
    }

    public void printResult(PrintWriter out) throws TauPException, IOException {
        VelocityModel vMod = TauModelLoader.loadVelocityModel(this.modelName, this.modelType);
        if (vMod == null) {
            throw new IOException("Velocity model file not found: " + this.modelName + ", tried internally and from file");
        }
        if (this.getOutputFormat().equals("svg")) {
            this.printSVG(out, vMod);
        } else if (this.getOutputFormat().equals("csv")) {
            this.printCSV(out, vMod);
        } else if (this.getOutputFormat().equals("json")) {
            out.write(vMod.asJSON(true, ""));
        } else if (this.getOutputFormat().equals("text")) {
            vMod.writeToND(out);
        }
        out.flush();
    }

    public void printSVGBeginning(PrintWriter out) {
        SvgUtil.xyplotScriptBeginning(out, TauP_VelocityPlot.toolNameFromClass(this.getClass()), this.cmdLineArgs, this.mapWidth, this.plotOffset);
    }

    public void printCSV(PrintWriter out, VelocityModel vMod) {
        double maxY = vMod.maxRadius;
        VelocityLayer prev = null;
        out.println("Depth,P Velocity,S Velocity");
        for (VelocityLayer vLayer : vMod.getLayers()) {
            if (prev == null || prev.getBotPVelocity() != vLayer.getTopPVelocity() || prev.getBotSVelocity() != vLayer.getTopSVelocity()) {
                out.println((float)vLayer.getTopDepth() + "," + (float)vLayer.getTopPVelocity() + "," + (float)vLayer.getTopSVelocity());
            }
            out.println((float)vLayer.getBotDepth() + "," + (float)vLayer.getBotPVelocity() + "," + (float)vLayer.getBotSVelocity());
            prev = vLayer;
        }
        out.flush();
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = super.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_VelocityPlot.dashEquals("svg", args[i])) {
                this.setOutputFormat("svg");
                this.setOutFileExtension("svg");
                continue;
            }
            if (TauP_VelocityPlot.dashEquals("csv", args[i])) {
                this.setOutputFormat("csv");
                this.setOutFileExtension("csv");
                continue;
            }
            if (TauP_VelocityPlot.dashEquals("json", args[i])) {
                this.setOutputFormat("json");
                this.setOutFileExtension(".json");
                continue;
            }
            if (TauP_VelocityPlot.dashEquals("text", args[i])) {
                this.setOutputFormat("text");
                this.setOutFileExtension("nd");
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("nd", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "nd";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("tvel", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = "tvel";
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("mod", args[i])) {
                this.modelName = args[i + 1];
                this.modelType = null;
                ++i;
                continue;
            }
            if (i < args.length - 1 && TauP_VelocityPlot.dashEquals("overlay", args[i])) {
                this.overlayModelName = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-h")) {
                this.toolProps.put("taup.source.depth", args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("--stadepth")) {
                this.setReceiverDepth(Double.parseDouble(args[i + 1]));
                ++i;
                continue;
            }
            if (i < args.length - 2 && (args[i].equalsIgnoreCase("--scat") || args[i].equalsIgnoreCase("--scatter"))) {
                double scatterDepth = Double.valueOf(args[i + 1]);
                double scatterDistDeg = Double.valueOf(args[i + 2]);
                this.setScattererDepth(scatterDepth);
                i += 2;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    public void init() throws TauPException {
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauModelException {
    }

    public double getSourceDepth() {
        return this.depth;
    }

    public void setSourceDepth(double depth) {
        this.depth = depth;
    }

    public double getReceiverDepth() {
        return this.receiverDepth;
    }

    public void setReceiverDepth(double receiverDepth) {
        this.receiverDepth = receiverDepth;
    }

    public double getScattererDepth() {
        return this.scattererDepth;
    }

    public void setScattererDepth(double depth) {
        this.scattererDepth = depth;
    }

    @Override
    public String getUsage() {
        return TauP_Tool.getStdUsageHead(this.getClass()) + "-nd modelfile       -- \"named discontinuities\" velocity file\n-tvel modelfile     -- \".tvel\" velocity file, ala ttimes\n\n" + TauP_VelocityPlot.getModDepthUsage() + "--text               -- output as named discontinuities text\n--json               -- output as JSON\n--svg               -- output as SVG\n--csv               -- outputs a CSV ascii table\n\n\n" + TauP_Tool.getStdUsageTail();
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }
}

