/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.ScatterArrivalFailException;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.ToolRun;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.StreamTokenizer;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;

public class TauP_Time
extends TauP_Tool {
    protected String modelName = "iasp91";
    protected TauModel tMod;
    protected transient TauModel tModDepth;
    private List<SeismicPhase> phases = null;
    protected List<PhaseName> phaseNames = new ArrayList<PhaseName>();
    protected double depth = 0.0;
    protected double receiverDepth = 0.0;
    protected List<Double> degreesList = new ArrayList<Double>();
    protected double scattererDepth = 0.0;
    protected double scattererDistDeg = 0.0;
    protected List<Double> distKilometersList = new ArrayList<Double>();
    protected double azimuth = Double.MAX_VALUE;
    protected double backAzimuth = Double.MAX_VALUE;
    protected double takeoffAngle = Double.MAX_VALUE;
    protected double shootRayp = Double.MAX_VALUE;
    protected double stationLat = Double.MAX_VALUE;
    protected double stationLon = Double.MAX_VALUE;
    protected double eventLat = Double.MAX_VALUE;
    protected double eventLon = Double.MAX_VALUE;
    protected List<Arrival> arrivals = new ArrayList<Arrival>();
    protected boolean GUI = false;
    protected boolean onlyPrintRayP = false;
    protected boolean onlyPrintTime = false;
    protected boolean onlyFirst = false;
    protected String relativePhaseName = "";
    public static final String DEFAULT_PHASES = "p,s,P,S,Pn,Sn,PcP,ScS,Pdiff,Sdiff,PKP,SKS,PKiKP,SKiKS,PKIKP,SKIKS";

    public TauP_Time() {
        this.setDefaultOutputFormat();
    }

    public TauP_Time(TauModel tMod) {
        this.setDefaultOutputFormat();
        this.setTauModel(tMod);
    }

    public TauP_Time(String modelName) throws TauModelException {
        try {
            this.loadTauModel(modelName);
        }
        catch (FileNotFoundException e) {
            throw new TauModelException("FileNotFoundException:" + e.getMessage(), e);
        }
        catch (InvalidClassException e) {
            throw new TauModelException("InvalidClassException:" + e.getMessage(), e);
        }
        catch (StreamCorruptedException e) {
            throw new TauModelException("StreamCorruptedException:" + e.getMessage(), e);
        }
        catch (OptionalDataException e) {
            throw new TauModelException("OptionalDataException:" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new TauModelException("IOException:" + e.getMessage(), e);
        }
        this.setDefaultOutputFormat();
    }

    @Override
    public String[] allowedOutputFormats() {
        String[] formats = new String[]{"text", "json"};
        return formats;
    }

    @Override
    public void setDefaultOutputFormat() {
        this.setOutputFormat("text");
    }

    public String[] getPhaseNames() {
        String[] phases = new String[this.phaseNames.size()];
        for (int i = 0; i < this.phaseNames.size(); ++i) {
            phases[i] = this.phaseNames.get(i).getName();
        }
        return phases;
    }

    public String getPhaseNameString() {
        if (this.getNumPhases() == 0) {
            return "";
        }
        Object phases = this.phaseNames.get(0).getName();
        for (int i = 1; i < this.getNumPhases(); ++i) {
            phases = (String)phases + "," + this.phaseNames.get(i).getName();
        }
        return phases;
    }

    public void setPhaseNames(String[] phaseNames) throws TauModelException {
        this.clearPhaseNames();
        for (int i = 0; i < phaseNames.length; ++i) {
            this.appendPhaseName(phaseNames[i]);
        }
    }

    public void setPhaseNames(PhaseName[] phaseNames) {
        this.clearPhaseNames();
        for (int i = 0; i < phaseNames.length; ++i) {
            this.phaseNames.add(phaseNames[i]);
        }
    }

    public static List<String> getPhaseNames(String phaseName) {
        return TauP_Time.extractPhaseNames(phaseName);
    }

    public static List<String> extractPhaseNames(String phaseNames) {
        ArrayList<String> names = new ArrayList<String>();
        for (String phaseName : TauP_Time.splitPhaseNameList(phaseNames)) {
            if (phaseName.equalsIgnoreCase("ttp") || phaseName.equalsIgnoreCase("tts") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttall")) {
                if (phaseName.equalsIgnoreCase("ttp") || phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("p");
                    names.add("P");
                    names.add("Pn");
                    names.add("Pdiff");
                    names.add("PKP");
                    names.add("PKiKP");
                    names.add("PKIKP");
                }
                if (phaseName.equalsIgnoreCase("tts") || phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("s");
                    names.add("S");
                    names.add("Sn");
                    names.add("Sdiff");
                    names.add("SKS");
                    names.add("SKIKS");
                }
                if (phaseName.equalsIgnoreCase("ttp+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("PcP");
                    names.add("pP");
                    names.add("pPdiff");
                    names.add("pPKP");
                    names.add("pPKIKP");
                    names.add("pPKiKP");
                    names.add("sP");
                    names.add("sPdiff");
                    names.add("sPKP");
                    names.add("sPKIKP");
                    names.add("sPKiKP");
                }
                if (phaseName.equalsIgnoreCase("tts+") || phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("sS");
                    names.add("sSdiff");
                    names.add("sSKS");
                    names.add("sSKIKS");
                    names.add("ScS");
                    names.add("pS");
                    names.add("pSdiff");
                    names.add("pSKS");
                    names.add("pSKIKS");
                }
                if (phaseName.equalsIgnoreCase("ttbasic") || phaseName.equalsIgnoreCase("ttall")) {
                    names.add("ScP");
                    names.add("SKP");
                    names.add("SKIKP");
                    names.add("PKKP");
                    names.add("PKIKKIKP");
                    names.add("SKKP");
                    names.add("SKIKKIKP");
                    names.add("PP");
                    names.add("PKPPKP");
                    names.add("PKIKPPKIKP");
                }
                if (!phaseName.equalsIgnoreCase("ttall")) continue;
                names.add("SKiKP");
                names.add("PP");
                names.add("ScS");
                names.add("PcS");
                names.add("PKS");
                names.add("PKIKS");
                names.add("PKKS");
                names.add("PKIKKIKS");
                names.add("SKKS");
                names.add("SKIKKIKS");
                names.add("SKSSKS");
                names.add("SKIKSSKIKS");
                names.add("SS");
                names.add("SP");
                names.add("PS");
                continue;
            }
            names.add(phaseName);
        }
        return names;
    }

    public synchronized void appendPhaseName(String phaseName) throws TauModelException {
        Iterator<String> it = TauP_Time.extractPhaseNames(phaseName).iterator();
        while (it.hasNext()) {
            this.appendPhaseName(new PhaseName(it.next()));
        }
    }

    public synchronized void appendPhaseName(PhaseName phaseName) {
        boolean unique = true;
        if (phaseName.name == null || phaseName.name.length() == 0) {
            return;
        }
        for (int i = 0; i < this.phaseNames.size(); ++i) {
            if (!this.phaseNames.get(i).equals(phaseName)) continue;
            unique = false;
            return;
        }
        if (unique) {
            this.phaseNames.add(phaseName);
        }
    }

    public int getNumPhases() {
        return this.phaseNames.size();
    }

    public void clearPhaseNames() {
        this.phases = null;
        this.phaseNames.clear();
    }

    public double getSourceDepth() {
        return Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
    }

    public void setSourceDepth(double depth) {
        this.depth = depth;
        this.toolProps.put("taup.source.depth", Double.toString(depth));
        this.clearPhases();
    }

    public double getReceiverDepth() {
        return this.receiverDepth;
    }

    public void setReceiverDepth(double receiverDepth) {
        if (this.receiverDepth != receiverDepth) {
            this.clearPhases();
        }
        this.receiverDepth = receiverDepth;
    }

    public double getScattererDepth() {
        return this.scattererDepth;
    }

    public void setScattererDepth(double depth) {
        if (this.getScattererDepth() != depth) {
            this.clearPhases();
        }
        this.scattererDepth = depth;
    }

    public double getScattererDistDeg() {
        return this.scattererDistDeg;
    }

    public void setScattererDistDeg(double distDeg) {
        if (distDeg > 180.0 || distDeg <= -180.0) {
            distDeg = (180.0 + distDeg) % 360.0 - 180.0;
        }
        if (distDeg == -180.0) {
            distDeg = 180.0;
        }
        if (this.getScattererDistDeg() != distDeg) {
            this.clearPhases();
        }
        this.scattererDistDeg = distDeg;
    }

    public void setScatterer(double depth, double degrees) {
        this.setScattererDepth(depth);
        this.setScattererDistDeg(degrees);
    }

    public void setEventLatLon(double lat, double lon) {
        this.eventLat = lat;
        this.eventLon = lon;
    }

    public void setStationLatLon(double lat, double lon) {
        this.stationLat = lat;
        this.stationLon = lon;
    }

    public String getTauModelName() {
        return this.modelName;
    }

    public TauModel getTauModel() {
        return this.tMod;
    }

    public TauModel getTauModelDepthCorrected() throws TauModelException {
        if (this.tModDepth == null) {
            this.depthCorrect();
        }
        return this.tModDepth;
    }

    public void setTauModel(TauModel tMod) {
        this.clearPhases();
        this.tMod = tMod;
        this.tModDepth = null;
        this.modelName = tMod.getModelName();
        this.toolProps.put("taup.model.name", this.modelName);
        if (this.verbose) {
            Alert.info("Model set to " + tMod.getModelName() + " with moho=" + tMod.getMohoDepth() + " cmb=" + tMod.getCmbDepth() + " iocb=" + tMod.getIocbDepth() + " radius=" + tMod.getRadiusOfEarth());
        }
    }

    public void loadTauModel(String modelName) throws FileNotFoundException, InvalidClassException, IOException, StreamCorruptedException, OptionalDataException, TauModelException {
        this.modelName = modelName;
        this.readTauModel();
        this.modelName = this.tMod.getModelName();
    }

    public double[] getDisconDepths() {
        return this.tMod.getVelocityModel().getDisconDepths();
    }

    public void clearPhases() {
        this.clearArrivals();
        this.phases = null;
    }

    public void clearArrivals() {
        this.arrivals = new ArrayList<Arrival>();
    }

    public int getNumArrivals() {
        return this.arrivals.size();
    }

    public Arrival getArrival(int i) {
        return this.arrivals.get(i);
    }

    public List<Arrival> getArrivals() {
        return Collections.unmodifiableList(this.arrivals);
    }

    public List<SeismicPhase> getSeismicPhases() {
        if (this.phases == null) {
            this.recalcPhases();
        }
        return Collections.unmodifiableList(this.phases);
    }

    protected void readTauModel() throws TauModelException {
        TauModel tModLoad = TauModelLoader.load(this.modelName, this.toolProps.getProperty("taup.model.path"), this.verbose);
        if (tModLoad == null) {
            throw new TauModelException("Unable to load " + this.modelName);
        }
        this.setTauModel(tModLoad);
    }

    protected void readPhaseFile(String filename) throws IOException {
        FileReader fileIn = new FileReader(filename);
        StreamTokenizer tokenIn = new StreamTokenizer(fileIn);
        tokenIn.commentChar(35);
        tokenIn.slashStarComments(true);
        tokenIn.slashSlashComments(true);
        tokenIn.wordChars(94, 94);
        tokenIn.wordChars(48, 57);
        tokenIn.wordChars(46, 46);
        tokenIn.wordChars(91, 91);
        tokenIn.wordChars(93, 93);
        while (tokenIn.nextToken() != -1) {
            if (tokenIn.sval != null) {
                this.parsePhaseList(tokenIn.sval);
                continue;
            }
            if (!DEBUG) continue;
            Alert.info("Token.sval was null! nval=" + tokenIn.nval);
        }
    }

    public void parsePhaseList(String phaseList) {
        String phaseEntry = "";
        String[] namesInList = TauP_Time.splitPhaseNameList(phaseList);
        for (int i = 0; i < namesInList.length; ++i) {
            String[] phaseAndHeader = namesInList[i].split("-");
            try {
                if (phaseAndHeader.length == 1) {
                    this.appendPhaseName(phaseAndHeader[0]);
                    continue;
                }
                int startHeaderRange = -9;
                int endHeaderRange = -9;
                PhaseName sacPhase = new PhaseName(phaseAndHeader[0], phaseAndHeader[1]);
                this.appendPhaseName(sacPhase);
                continue;
            }
            catch (TauModelException e) {
                Alert.warning("Problem with phase=" + phaseEntry + " " + e.getMessage(), "Skipping this phase: ");
                if (!this.verbose && !DEBUG) continue;
                e.printStackTrace();
            }
        }
    }

    public static String[] splitPhaseNameList(String phaseList) {
        String phaseEntry = "";
        phaseList = phaseList.trim();
        phaseList = phaseList.replace(' ', ',');
        if ((phaseList = phaseList.replaceAll(",,+", ",")).startsWith(",")) {
            phaseList = phaseList.substring(1);
        }
        if (phaseList.length() == 0) {
            return new String[0];
        }
        if (phaseList.charAt(phaseList.length() - 1) == ',') {
            phaseList = phaseList.substring(0, phaseList.length() - 1);
        }
        String[] namesInList = phaseList.split(",");
        return namesInList;
    }

    public static List<Double> parseDegreeList(String degList) {
        degList = degList.trim();
        while (degList.startsWith(",")) {
            degList = degList.substring(1);
        }
        while (degList.endsWith(",")) {
            degList = degList.substring(0, degList.length() - 1);
        }
        String[] split = degList.trim().split(",");
        ArrayList<Double> degreesFound = new ArrayList<Double>(split.length);
        for (int i = 0; i < split.length; ++i) {
            try {
                degreesFound.add(Double.parseDouble(split[i].trim()));
                continue;
            }
            catch (NumberFormatException e) {
                System.err.println("can't parse '" + split[i] + "' as number, skipping.");
            }
        }
        return degreesFound;
    }

    protected String[] parseSourceModelCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = super.parseCommonCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        boolean cmdLineArgPhase = false;
        boolean cmdLineArgPhaseFile = false;
        for (int i = 0; i < args.length; ++i) {
            if (i < args.length - 1) {
                if (TauP_Time.dashEquals("mod", args[i]) || TauP_Time.dashEquals("model", args[i])) {
                    this.toolProps.put("taup.model.name", args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-h")) {
                    this.toolProps.put("taup.source.depth", args[i + 1]);
                    ++i;
                    continue;
                }
                if (args[i].equalsIgnoreCase("--stadepth")) {
                    this.setReceiverDepth(Double.parseDouble(args[i + 1]));
                    ++i;
                    continue;
                }
                if (i < args.length - 2 && (args[i].equalsIgnoreCase("--scat") || args[i].equalsIgnoreCase("--scatter"))) {
                    double scatterDepth = Double.valueOf(args[i + 1]);
                    double scatterDistDeg = Double.valueOf(args[i + 2]);
                    this.setScatterer(scatterDepth, scatterDistDeg);
                    i += 2;
                    continue;
                }
                if (TauP_Time.dashEquals("ph", args[i])) {
                    if (cmdLineArgPhase) {
                        this.toolProps.put("taup.phase.list", this.toolProps.getProperty("taup.phase.list", "") + "," + args[i + 1]);
                    } else {
                        this.toolProps.put("taup.phase.list", args[i + 1]);
                    }
                    cmdLineArgPhase = true;
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("pf", args[i])) {
                    cmdLineArgPhaseFile = true;
                    this.toolProps.put("taup.phase.file", args[i + 1]);
                    ++i;
                    continue;
                }
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (cmdLineArgPhaseFile || cmdLineArgPhase) {
            if (cmdLineArgPhaseFile && !cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.list");
            }
            if (!cmdLineArgPhaseFile && cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.file");
            }
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    @Override
    protected String[] parseCmdLineArgs(String[] origArgs) throws IOException {
        String[] args = this.parseSourceModelCmdLineArgs(origArgs);
        String[] noComprendoArgs = new String[args.length];
        int numNoComprendoArgs = 0;
        boolean cmdLineArgPhase = false;
        boolean cmdLineArgPhaseFile = false;
        for (int i = 0; i < args.length; ++i) {
            if (TauP_Time.dashEquals("json", args[i])) {
                this.outputFormat = "json";
                continue;
            }
            if (TauP_Time.dashEquals("gui", args[i])) {
                this.GUI = true;
                continue;
            }
            if (TauP_Time.dashEquals("rayp", args[i])) {
                this.onlyPrintRayP = true;
                this.onlyPrintTime = false;
                continue;
            }
            if (TauP_Time.dashEquals("time", args[i])) {
                this.onlyPrintTime = true;
                this.onlyPrintRayP = false;
                continue;
            }
            if (TauP_Time.dashEquals("first", args[i])) {
                this.onlyFirst = true;
                continue;
            }
            if (i < args.length - 1) {
                if (TauP_Time.dashEquals("deg", args[i])) {
                    this.degreesList = TauP_Time.parseDegreeList(args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("km", args[i])) {
                    this.distKilometersList = TauP_Time.parseDegreeList(args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("az", args[i])) {
                    this.azimuth = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("baz", args[i])) {
                    this.backAzimuth = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("takeoff", args[i])) {
                    this.takeoffAngle = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("shootray", args[i])) {
                    this.shootRayp = Double.valueOf(args[i + 1]);
                    ++i;
                    continue;
                }
                if (TauP_Time.dashEquals("rel", args[i])) {
                    this.relativePhaseName = args[i + 1];
                    ++i;
                    continue;
                }
                if (i < args.length - 2) {
                    if (args[i].equalsIgnoreCase("-sta") || args[i].equalsIgnoreCase("-station")) {
                        this.setStationLatLon(Double.valueOf(args[i + 1]), Double.valueOf(args[i + 2]));
                        i += 2;
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-evt") || args[i].equalsIgnoreCase("-event")) {
                        this.setEventLatLon(Double.valueOf(args[i + 1]), Double.valueOf(args[i + 2]));
                        i += 2;
                        continue;
                    }
                    noComprendoArgs[numNoComprendoArgs++] = args[i];
                    continue;
                }
                noComprendoArgs[numNoComprendoArgs++] = args[i];
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = args[i];
        }
        if (cmdLineArgPhaseFile || cmdLineArgPhase) {
            if (cmdLineArgPhaseFile && !cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.list");
            }
            if (!cmdLineArgPhaseFile && cmdLineArgPhase) {
                this.toolProps.remove("taup.phase.file");
            }
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public synchronized List<Arrival> sortArrivals(List<Arrival> arrivals) {
        Collections.sort(arrivals, new Comparator<Arrival>(){

            @Override
            public int compare(Arrival o1, Arrival o2) {
                return Double.compare(o1.getTime(), o2.getTime());
            }
        });
        return arrivals;
    }

    public List<Arrival> calculate(double degrees) throws TauPException {
        List<Double> dList = Arrays.asList(degrees);
        return this.calculate(dList);
    }

    public List<Arrival> calculate(List<Double> degreesList) throws TauPException {
        List<Arrival> arrivals = this.calcTime(degreesList);
        return this.sortArrivals(arrivals);
    }

    public List<Arrival> calcEventStation(Double[] evloc, List<Double[]> staloc) throws TauPException {
        this.setEventLatLon(evloc[0], evloc[1]);
        ArrayList<Arrival> out = new ArrayList<Arrival>();
        for (Double[] sta : staloc) {
            this.clearArrivals();
            this.setEventLatLon(evloc[0], evloc[1]);
            this.setStationLatLon(sta[0], sta[1]);
            this.degreesList.add(SphericalCoords.distance(sta[0], sta[1], evloc[0], evloc[1]));
            this.azimuth = SphericalCoords.azimuth(evloc[0], evloc[1], sta[0], sta[1]);
            this.backAzimuth = SphericalCoords.azimuth(sta[0], sta[1], evloc[0], evloc[1]);
            out.addAll(this.calculate(this.degreesList));
        }
        this.arrivals = this.sortArrivals(out);
        return this.arrivals;
    }

    public Arrival calculateRelativeArrival(double degrees) throws TauModelException {
        Arrival relativeArrival = null;
        if (this.relativePhaseName != "") {
            ArrayList<SeismicPhase> relPhases = new ArrayList<SeismicPhase>();
            List<String> splitNames = TauP_Time.extractPhaseNames(this.relativePhaseName);
            for (String sName : splitNames) {
                try {
                    List<SeismicPhase> calcRelPhaseList = SeismicPhaseFactory.createSeismicPhases(sName, this.getTauModelDepthCorrected(), this.getSourceDepth(), this.getReceiverDepth(), this.getScattererDepth(), this.getScattererDistDeg(), DEBUG);
                    relPhases.addAll(calcRelPhaseList);
                }
                catch (ScatterArrivalFailException e) {
                    Alert.warning(e.getMessage(), "    Skipping this relative phase");
                    if (!this.verbose && !DEBUG) continue;
                    e.printStackTrace();
                }
            }
            relativeArrival = SeismicPhase.getEarliestArrival(relPhases, degrees);
        }
        return relativeArrival;
    }

    @Override
    public void validateArguments() throws TauModelException {
        if (this.getTauModel() == null) {
            throw new TauModelException("Model for '" + this.getTauModelName() + "' is null, unable to calculate.");
        }
        if (this.getTauModel().getRadiusOfEarth() < this.getSourceDepth()) {
            throw new TauModelException("Source depth of " + this.getSourceDepth() + " in '" + this.getTauModelName() + "' is greater than radius of earth, " + this.getTauModel().getRadiusOfEarth() + ", unable to calculate.");
        }
        if (this.getTauModel().getRadiusOfEarth() < this.getReceiverDepth()) {
            throw new TauModelException("Receiver depth of " + this.getReceiverDepth() + " in '" + this.getTauModelName() + "' is greater than radius of earth, " + this.getTauModel().getRadiusOfEarth() + ", unable to calculate.");
        }
        if (this.getTauModel().getRadiusOfEarth() < this.getScattererDepth()) {
            throw new TauModelException("Scatterer depth of " + this.getScattererDepth() + " in '" + this.getTauModelName() + "' is greater than radius of earth, " + this.getTauModel().getRadiusOfEarth() + ", unable to calculate.");
        }
    }

    public List<Arrival> calcTime(double degrees) throws TauModelException {
        List<Double> dList = Arrays.asList(degrees);
        return this.calcTime(dList);
    }

    public List<Arrival> calcTime(List<Double> degreesList) throws TauModelException {
        this.validateArguments();
        this.depthCorrect();
        this.clearArrivals();
        this.clearArrivals();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        for (double degrees : degreesList) {
            for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
                SeismicPhase phase = phaseList.get(phaseNum);
                List<Arrival> phaseArrivals = phase.calcTime(degrees);
                Arrival relativeArrival = this.calculateRelativeArrival(degrees);
                for (Arrival arrival : phaseArrivals) {
                    arrival.setRelativeToArrival(relativeArrival);
                }
                if (!this.onlyFirst) {
                    for (Arrival arrival : phaseArrivals) {
                        this.arrivals.add(arrival);
                    }
                    continue;
                }
                if (phaseArrivals.size() <= 0) continue;
                this.arrivals.add(phaseArrivals.get(0));
            }
        }
        return this.sortArrivals(this.arrivals);
    }

    public List<Arrival> calcTakeoff(double takeoffAngle) throws TauModelException {
        List<Double> dList = Arrays.asList(takeoffAngle);
        return this.calcTakeoff(dList);
    }

    public List<Arrival> calcTakeoff(List<Double> takeoffAngleList) throws TauModelException {
        this.stationLat = Double.MAX_VALUE;
        this.stationLon = Double.MAX_VALUE;
        this.depthCorrect();
        this.clearArrivals();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (double takeoffAngle : takeoffAngleList) {
            for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
                SeismicPhase phase = phaseList.get(phaseNum);
                if (phase.getDownGoing()[0] != takeoffAngle <= 90.0) continue;
                double rayParam = phase.calcRayParamForTakeoffAngle(takeoffAngle);
                try {
                    if (!(phase.getMinRayParam() <= rayParam) || !(rayParam <= phase.getMaxRayParam())) continue;
                    Arrival phaseArrival = phase.shootRay(rayParam);
                    arrivals.add(phaseArrival);
                    continue;
                }
                catch (NoSuchLayerException e) {
                    Alert.warning("NoSuchLayerException", e.getMessage());
                    continue;
                }
                catch (SlownessModelException e) {
                    Alert.warning("SlownessModelException", e.getMessage());
                }
            }
        }
        this.arrivals = this.sortArrivals(arrivals);
        return this.arrivals;
    }

    public List<Arrival> calcRayParameter(double rayparameter) throws TauModelException {
        List<Double> dList = Arrays.asList(rayparameter);
        return this.calcRayParameter(dList);
    }

    public List<Arrival> calcRayParameterSDeg(List<Double> rayParameterList) throws TauModelException {
        ArrayList<Double> rayParameterListRad = new ArrayList<Double>();
        for (Double d : rayParameterList) {
            rayParameterListRad.add(d / (Math.PI / 180));
        }
        return this.calcRayParameter(rayParameterListRad);
    }

    public List<Arrival> calcRayParameter(List<Double> rayParameterList) throws TauModelException {
        this.stationLat = Double.MAX_VALUE;
        this.stationLon = Double.MAX_VALUE;
        this.depthCorrect();
        this.clearArrivals();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (Double rayParam : rayParameterList) {
            for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
                SeismicPhase phase = phaseList.get(phaseNum);
                try {
                    if (!(phase.getMinRayParam() <= rayParam) || !(rayParam <= phase.getMaxRayParam())) continue;
                    Arrival phaseArrival = phase.shootRay(rayParam);
                    arrivals.add(phaseArrival);
                    continue;
                }
                catch (NoSuchLayerException e) {
                    Alert.warning("NoSuchLayerException", e.getMessage());
                    continue;
                }
                catch (SlownessModelException e) {
                    Alert.warning("SlownessModelException", e.getMessage());
                }
            }
        }
        this.arrivals = this.sortArrivals(arrivals);
        return this.arrivals;
    }

    public void depthCorrect() throws TauModelException {
        this.depthCorrect(this.getSourceDepth(), this.getReceiverDepth(), this.getScattererDepth());
    }

    @Deprecated
    public void depthCorrect(double depth) throws TauModelException {
        this.depthCorrect(depth, this.getReceiverDepth());
    }

    public void depthCorrect(double depth, double receiverDepth) throws TauModelException {
        this.depthCorrect(depth, receiverDepth, this.getScattererDepth());
    }

    public void depthCorrect(double depth, double receiverDepth, double scatterDepth) throws TauModelException {
        if (this.tModDepth == null || this.tModDepth.getSourceDepth() != depth) {
            this.setReceiverDepth(receiverDepth);
            this.tModDepth = this.tMod.depthCorrect(depth);
            this.tModDepth = this.tModDepth.splitBranch(receiverDepth);
            this.clearPhases();
        }
        if (!this.tModDepth.isBranchDepth(receiverDepth)) {
            this.setReceiverDepth(receiverDepth);
            this.tModDepth = this.tModDepth.splitBranch(receiverDepth);
            this.clearPhases();
        }
        if (!this.tModDepth.isBranchDepth(scatterDepth)) {
            this.setScattererDepth(scatterDepth);
            this.tModDepth = this.tModDepth.splitBranch(scatterDepth);
            this.clearPhases();
        }
        this.setSourceDepth(depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void recalcPhases() {
        ArrayList<SeismicPhase> newPhases = new ArrayList<SeismicPhase>();
        for (int phaseNameNum = 0; phaseNameNum < this.phaseNames.size(); ++phaseNameNum) {
            String tempPhaseName = this.phaseNames.get(phaseNameNum).getName();
            boolean alreadyAdded = false;
            if (alreadyAdded) continue;
            try {
                List<SeismicPhase> calcPhaseList = SeismicPhaseFactory.createSeismicPhases(tempPhaseName, this.getTauModelDepthCorrected(), this.getSourceDepth(), this.getReceiverDepth(), this.getScattererDepth(), this.getScattererDistDeg(), DEBUG);
                newPhases.addAll(calcPhaseList);
                for (SeismicPhase seismicPhase : newPhases) {
                    if (!this.verbose) continue;
                    Alert.info(seismicPhase.toString());
                }
                continue;
            }
            catch (ScatterArrivalFailException e) {
                Alert.warning(e.getMessage() + ", skipping this phase");
                if (!this.verbose && !DEBUG) continue;
                e.printStackTrace();
                continue;
            }
            catch (TauModelException e) {
                Alert.warning("Error with phase=" + tempPhaseName, e.getMessage() + "\nSkipping this phase");
                if (!this.verbose && !DEBUG) continue;
                e.printStackTrace();
                continue;
            }
            finally {
                if (this.verbose) {
                    Alert.info("-----------------");
                }
            }
        }
        this.phases = newPhases;
    }

    public void printResult(PrintWriter out) throws IOException {
        if (this.outputFormat.equals("json")) {
            this.printResultJSON(out);
        } else {
            this.printResultText(out);
        }
        out.flush();
    }

    public void printResultText(PrintWriter out) throws IOException {
        int maxNameLength = 5;
        int maxPuristNameLength = 5;
        for (int j = 0; j < this.arrivals.size(); ++j) {
            if (this.arrivals.get(j).getName().length() > maxNameLength) {
                maxNameLength = this.arrivals.get(j).getName().length();
            }
            if (this.arrivals.get(j).getPuristName().length() <= maxPuristNameLength) continue;
            maxPuristNameLength = this.arrivals.get(j).getPuristName().length();
        }
        String phaseFormat = "%-" + maxNameLength + "s";
        String phasePuristFormat = "%-" + maxPuristNameLength + "s";
        if (!this.onlyPrintRayP && !this.onlyPrintTime) {
            String modelLine = "\nModel: " + this.modelName;
            if (this.getReceiverDepth() != 0.0) {
                modelLine = modelLine + "  Receiver Depth: " + this.getReceiverDepth() + " km";
            }
            if (this.getScattererDistDeg() != 0.0) {
                modelLine = modelLine + "  Scatter Depth: " + this.getScattererDepth() + " km Dist: " + this.getScattererDistDeg();
            }
            out.println(modelLine);
            String lineOne = "Distance   Depth   " + String.format(phaseFormat, "Phase") + "   Travel    Ray Param  Takeoff  Incident  Purist   " + String.format(phasePuristFormat, "Purist") + "    Amp   ";
            String lineTwo = "  (deg)     (km)   " + String.format(phaseFormat, "Name ") + "   Time (s)  p (s/deg)   (deg)    (deg)   Distance   " + String.format(phasePuristFormat, "Name") + "  Factor";
            if (this.relativePhaseName != "") {
                lineOne = lineOne + " Relative to";
                for (int s = 0; s < (11 - this.relativePhaseName.length()) / 2; ++s) {
                    lineTwo = lineTwo + " ";
                }
                lineTwo = lineTwo + "  " + String.format(phaseFormat, this.relativePhaseName);
            }
            out.println(lineOne);
            out.println(lineTwo);
            for (int i = 0; i < Math.max(lineOne.length(), lineTwo.length()); ++i) {
                out.write("-");
            }
            out.write("\n");
            for (int j = 0; j < this.arrivals.size(); ++j) {
                Arrival currArrival = this.arrivals.get(j);
                out.print(Outputs.formatDistance(currArrival.getSearchDistDeg()));
                out.print(Outputs.formatDepth(this.depth) + "   ");
                out.print(String.format(phaseFormat, currArrival.getName()));
                out.print("  " + Outputs.formatTime(currArrival.getTime()) + "  " + Outputs.formatRayParam(currArrival.getRayParam() / 57.29577951308232) + "  ");
                out.print(Outputs.formatDistance(currArrival.getTakeoffAngle()) + " ");
                out.print(Outputs.formatDistance(currArrival.getIncidentAngle()) + " ");
                out.print(Outputs.formatDistance(currArrival.getDistDeg()));
                if (currArrival.getName().equals(currArrival.getPuristName())) {
                    out.print("   = ");
                } else {
                    out.print("   * ");
                }
                out.print(String.format(phasePuristFormat, currArrival.getPuristName()));
                try {
                    double ampFactor = currArrival.getAmplitudeFactor();
                    out.print(" " + Outputs.formatAmpFactor(ampFactor));
                }
                catch (SlownessModelException | TauModelException | VelocityModelException e) {
                    throw new RuntimeException("SHould not happen", e);
                }
                if (this.relativePhaseName != "") {
                    if (currArrival.isRelativeToArrival()) {
                        out.print(" " + Outputs.formatTime(currArrival.getTime() - currArrival.getRelativeToArrival().getTime()));
                        out.print(" +" + String.format(phaseFormat, currArrival.getRelativeToArrival().getName()));
                    } else {
                        out.print(String.format(phaseFormat, " no arrival"));
                    }
                }
                out.println();
            }
        } else if (this.onlyPrintTime) {
            for (int j = 0; j < this.arrivals.size(); ++j) {
                Arrival currArrival = this.arrivals.get(j);
                out.print(String.valueOf((float)currArrival.getTime()) + " ");
            }
            out.println();
        } else if (this.onlyPrintRayP) {
            for (int j = 0; j < this.arrivals.size(); ++j) {
                Arrival currArrival = this.arrivals.get(j);
                out.write(String.valueOf((float)(Math.PI / 180 * currArrival.getRayParam())) + " ");
            }
            out.println();
        }
        out.println();
        out.flush();
    }

    public void printResultJSON(PrintWriter out) throws IOException {
        this.writeJSON(out, "");
    }

    public void writeJSON(PrintWriter pw, String indent) throws IOException {
        this.writeJSON(pw, indent, this.getTauModelName(), this.getSourceDepth(), this.getReceiverDepth(), this.getSeismicPhases(), this.getArrivals());
    }

    public void writeJSON(PrintWriter pw, String indent, String modelName, double depth, double receiverDepth, List<SeismicPhase> phases, List<Arrival> arrivals) throws IOException {
        String innerIndent = indent + "  ";
        String NL = "\n";
        pw.write("{" + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"model") + ": " + JSONWriter.valueToString((Object)modelName) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"sourcedepth") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)depth)) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"receiverdepth") + ": " + JSONWriter.valueToString((Object)Float.valueOf((float)receiverDepth)) + "," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"phases") + ": [ ");
        boolean first = true;
        for (SeismicPhase phase : phases) {
            if (first) {
                first = false;
            } else {
                pw.write(", ");
            }
            pw.write(JSONWriter.valueToString((Object)phase.getName()));
        }
        pw.write(" ]," + NL);
        pw.write(innerIndent + JSONWriter.valueToString((Object)"arrivals") + ": [" + NL);
        first = true;
        for (Arrival arrival : arrivals) {
            if (first) {
                first = false;
            } else {
                pw.write("," + NL);
            }
            try {
                arrival.writeJSON(pw, innerIndent + "  ");
            }
            catch (JSONException e) {
                System.err.println("Erro in json: " + arrival.toString());
                throw e;
            }
        }
        pw.write(NL);
        pw.write(innerIndent + "]" + NL);
        pw.write("}" + NL);
    }

    public static JSONObject resultAsJSONObject(String modelName, double depth, double receiverDepth, String[] phases, List<Arrival> arrivals) {
        JSONObject out = new JSONObject();
        out.put("model", (Object)modelName);
        out.put("sourcedepth", (float)depth);
        out.put("receiverdepth", (float)receiverDepth);
        JSONArray outPhases = new JSONArray();
        out.put("phases", (Object)outPhases);
        outPhases.putAll((Object)phases);
        JSONArray outArrivals = new JSONArray();
        out.put("arrivals", (Object)outArrivals);
        for (int j = 0; j < arrivals.size(); ++j) {
            Arrival currArrival = arrivals.get(j);
            outArrivals.put((Object)currArrival.asJSONObject());
        }
        return out;
    }

    public static String resultAsJSON(String modelName, double depth, double receiverDepth, String[] phases, List<Arrival> arrivals, boolean withPierce, boolean withPath) {
        String Q = "\"";
        String COMMA = ",";
        String QCOMMA = Q + COMMA;
        String COLON = ": ";
        String S = "  ";
        String QC = Q + COLON;
        String QCQ = QC + Q;
        String SS = S + S;
        String SQ = S + Q;
        String SSQ = S + SQ;
        String SSSQ = S + SSQ;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("{");
        out.println(SQ + "model" + QCQ + modelName + QCOMMA);
        out.println(SQ + "sourcedepth" + QC + (float)depth + COMMA);
        out.println(SQ + "receiverdepth" + QC + (float)receiverDepth + COMMA);
        out.print(SQ + "phases" + Q + ": [");
        for (int p = 0; p < phases.length; ++p) {
            out.print(" " + Q + phases[p] + Q);
            if (p == phases.length - 1) continue;
            out.print(COMMA);
        }
        out.println(" ]" + COMMA);
        out.println(SQ + "arrivals" + Q + ": [");
        for (int j = 0; j < arrivals.size(); ++j) {
            Arrival currArrival = arrivals.get(j);
            out.print(currArrival.asJSONObject().toString(2));
            if (j != arrivals.size() - 1) {
                out.print(COMMA);
            }
            out.println();
        }
        out.println(S + "]");
        out.print("}");
        return sw.toString();
    }

    @Override
    public void init() throws TauPException {
        DEBUG = DEBUG || ToolRun.DEBUG;
        boolean bl = this.verbose = this.verbose || DEBUG || ToolRun.VERBOSE;
        if (this.phaseNames.size() == 0) {
            if (this.toolProps.containsKey("taup.phase.file")) {
                if (this.toolProps.containsKey("taup.phase.list")) {
                    this.parsePhaseList(this.toolProps.getProperty("taup.phase.list"));
                }
                try {
                    this.readPhaseFile(this.toolProps.getProperty("taup.phase.file"));
                }
                catch (IOException e) {
                    Alert.warning("Caught IOException while attempting to reading phase file " + this.toolProps.getProperty("taup.phase.file"), e.getMessage());
                    if (this.phaseNames.size() <= 0) {
                        this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", DEFAULT_PHASES));
                    }
                }
            } else {
                this.parsePhaseList(this.toolProps.getProperty("taup.phase.list", DEFAULT_PHASES));
            }
        }
        this.depth = Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0"));
        if (this.tMod == null || this.tMod.getVelocityModel().getModelName() != this.toolProps.getProperty("taup.model.name", "iasp91")) {
            this.modelName = this.toolProps.getProperty("taup.model.name", "iasp91");
            try {
                this.readTauModel();
            }
            catch (TauModelException ee) {
                if (ee.getCause() instanceof InvalidClassException) {
                    Alert.error("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create.");
                } else {
                    Alert.error("Caught TauModelException", ee.getMessage());
                }
                throw new RuntimeException(ee);
            }
        }
        for (double distKilometers : this.distKilometersList) {
            this.degreesList.add(distKilometers / this.getTauModel().getRadiusOfEarth() * 180.0 / Math.PI);
        }
    }

    public void printHelp() {
        Alert.info("Enter:\nh for new depth\nr to recalculate\np to append phases, \nc to clear phases\nl to list phases\ns for new station lat lon\ne for new event lat lon\na for new azimuth\nb for new back azimuth\nt for takeoff angle\nm for new model or \nq to quit.\n");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void start() throws IOException, TauModelException, TauPException {
        block81: {
            block80: {
                if (this.degreesList.size() == 0 && this.takeoffAngle == 1.7976931348623157E308 && this.shootRayp == 1.7976931348623157E308 && (this.stationLat == 1.7976931348623157E308 || this.stationLon == 1.7976931348623157E308 || this.eventLat == 1.7976931348623157E308 || this.eventLon == 1.7976931348623157E308)) break block80;
                if (this.takeoffAngle != 1.7976931348623157E308) {
                    this.calcTakeoff(this.takeoffAngle);
                } else if (this.shootRayp != 1.7976931348623157E308) {
                    this.calcRayParameter(this.shootRayp / 0.017453292519943295);
                } else if (this.degreesList.size() == 0) {
                    evlatlon = new Double[]{this.eventLat, this.eventLon};
                    stalatlonList = new ArrayList<Double[]>();
                    stalatlonList.add(new Double[]{this.stationLat, this.stationLon});
                    this.calcEventStation(evlatlon, stalatlonList);
                } else {
                    this.calculate(this.degreesList);
                }
                this.printResult(this.getWriter());
                break block81;
            }
            prevTime = 0L;
            readMode = 100;
            tempDepth = this.depth;
            this.setSourceDepth(this.depth);
            tokenIn = new StreamTokenizer(new InputStreamReader(System.in));
            tokenIn.parseNumbers();
            tokenIn.wordChars(44, 44);
            tokenIn.wordChars(95, 95);
            tokenIn.wordChars(94, 94);
            tokenIn.ordinaryChar(47);
            tokenIn.wordChars(47, 47);
            tokenIn.commentChar(35);
            this.printHelp();
            do {
                switch (readMode) {
                    case 104: {
                        System.out.print("Enter Depth: ");
                        tokenIn.nextToken();
                        tempDepth = tokenIn.nval;
                        if (tempDepth < 0.0 || tempDepth > this.tMod.getRadiusOfEarth()) {
                            Alert.warning("Depth must be >= 0.0 and <= tMod.getRadiusOfEarth().", "depth = " + tempDepth + " getRadiusOfEarth= " + this.tMod.getRadiusOfEarth());
                            break;
                        }
                        prevTime = System.currentTimeMillis();
                        this.setSourceDepth(tempDepth);
                        currTime = System.currentTimeMillis();
                        if (this.verbose) {
                            Alert.info("depthCorrect time=" + (currTime - prevTime));
                        }
                        readMode = 100;
                        break;
                    }
                    case 100: {
                        System.out.print("Enter Distance or Option [hrpclseabmqt]: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            degrees = tokenIn.nval;
                            if (TauP_Time.DEBUG) {
                                Alert.info("degrees=" + degrees);
                            }
                            this.degreesList.clear();
                            this.degreesList.add(degrees);
                            this.calculate(this.degreesList);
                            this.printResult(this.getWriter());
                            break;
                        }
                        if (tokenIn.ttype == -1 || tokenIn.ttype == -3 && (tokenIn.sval.equalsIgnoreCase("q") || tokenIn.sval.equalsIgnoreCase("quit") || tokenIn.sval.equalsIgnoreCase("exit") || tokenIn.sval.equalsIgnoreCase("bye"))) {
                            readMode = 113;
                            break;
                        }
                        if (tokenIn.ttype == -3) {
                            if (tokenIn.sval.equalsIgnoreCase("l")) {
                                readMode = 108;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("c")) {
                                readMode = 99;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("s")) {
                                readMode = 115;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("e")) {
                                readMode = 101;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("a")) {
                                readMode = 97;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("b")) {
                                readMode = 98;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("r")) {
                                readMode = 114;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("p")) {
                                readMode = 112;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("m")) {
                                readMode = 109;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("h")) {
                                readMode = 104;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("x")) {
                                readMode = 120;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("t")) {
                                readMode = 116;
                                break;
                            }
                            if (tokenIn.sval.equalsIgnoreCase("?")) {
                                this.printHelp();
                                break;
                            }
                            Alert.warning("I don't understand this option", tokenIn.sval);
                            this.printHelp();
                            break;
                        }
                        this.printHelp();
                        break;
                    }
                    case 114: {
                        if (this.degreesList.size() != 0) {
                            this.calculate(this.degreesList);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 112: {
                        System.out.print("Enter phases (ie P,p,PcP,S): ");
                        tokenIn.ordinaryChars(48, 57);
                        tokenIn.ordinaryChar(46);
                        tokenIn.ordinaryChar(45);
                        tokenIn.wordChars(48, 57);
                        tokenIn.wordChars(46, 46);
                        tokenIn.wordChars(45, 45);
                        tokenIn.ordinaryChar(32);
                        tokenIn.wordChars(32, 32);
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -3) {
                            this.parsePhaseList(tokenIn.sval);
                            this.recalcPhases();
                        } else {
                            Alert.warning("Input phases not recognized.", "Please retry.");
                        }
                        tokenIn.parseNumbers();
                        tokenIn.ordinaryChar(32);
                        tokenIn.whitespaceChars(32, 32);
                        readMode = 100;
                        break;
                    }
                    case 108: {
                        numPhases = this.phaseNames.size();
                        output = numPhases + " phases.";
                        Alert.info((String)output);
                        output = "";
                        for (i = 0; i < numPhases; ++i) {
                            output = (String)output + this.phaseNames.get(i).getName();
                            if (i >= numPhases - 1) continue;
                            output = (String)output + ",";
                        }
                        Alert.info((String)output);
                        readMode = 100;
                        break;
                    }
                    case 99: {
                        this.clearPhaseNames();
                        readMode = 112;
                        break;
                    }
                    case 97: {
                        System.out.print("Enter azimuth: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.azimuth = tokenIn.nval;
                            this.stationLat = 1.7976931348623157E308;
                            this.stationLon = 1.7976931348623157E308;
                            if (TauP_Time.DEBUG) {
                                Alert.info("azimuth=" + this.azimuth);
                            }
                        } else {
                            Alert.warning("Expected a number.", "got " + tokenIn + " instead.");
                            this.printHelp();
                            break;
                        }
                        if (this.eventLat == 1.7976931348623157E308 || this.eventLon == 1.7976931348623157E308) {
                            readMode = 101;
                        } else if (this.degreesList.size() == 0) {
                            readMode = 100;
                        } else {
                            this.calculate(this.degreesList);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 98: {
                        System.out.print("Enter back azimuth: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.backAzimuth = tokenIn.nval;
                            this.setEventLatLon(1.7976931348623157E308, 1.7976931348623157E308);
                            if (TauP_Time.DEBUG) {
                                Alert.info("backAzimuth=" + this.backAzimuth);
                            }
                        } else {
                            Alert.warning("Expected a number.", "got " + tokenIn + " instead");
                            this.printHelp();
                            break;
                        }
                        if (this.stationLat == 1.7976931348623157E308 || this.stationLon == 1.7976931348623157E308) {
                            readMode = 115;
                        } else if (this.degreesList.size() == 0) {
                            readMode = 100;
                        } else {
                            this.calculate(this.degreesList);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 101: {
                        System.out.print("Enter event lat and lon: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            evLat = tokenIn.nval;
                            if (TauP_Time.DEBUG) {
                                Alert.info("eventLat=" + this.eventLat);
                            }
                            tokenIn.nextToken();
                            if (tokenIn.ttype == -2) {
                                evLon = tokenIn.nval;
                                this.setEventLatLon(evLat, evLon);
                                if (TauP_Time.DEBUG) {
                                    Alert.info("eventLon=" + this.eventLon);
                                }
                            } else {
                                this.printHelp();
                            }
                        } else {
                            this.printHelp();
                        }
                        if (this.stationLat != 1.7976931348623157E308 && this.stationLon != 1.7976931348623157E308) {
                            evlatlon = new Double[]{this.eventLat, this.eventLon};
                            stalatlonList = new ArrayList<Double[]>();
                            stalatlonList.add(new Double[]{this.stationLat, this.stationLon});
                            this.calcEventStation(evlatlon, stalatlonList);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 115: {
                        System.out.print("Enter station lat and lon: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype != -2) ** GOTO lbl257
                        this.stationLat = tokenIn.nval;
                        if (TauP_Time.DEBUG) {
                            Alert.info("stationLat=" + this.stationLat);
                        }
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -2) {
                            this.stationLon = tokenIn.nval;
                            if (TauP_Time.DEBUG) {
                                Alert.info("stationLon=" + this.stationLon);
                            }
                        } else {
                            this.printHelp();
                            break;
lbl257:
                            // 1 sources

                            this.printHelp();
                            break;
                        }
                        if (this.eventLat != 1.7976931348623157E308 && this.eventLon != 1.7976931348623157E308) {
                            evlatlon = new Double[]{this.eventLat, this.eventLon};
                            stalatlonList = new ArrayList<E>();
                            stalatlonList.add(new Double[]{this.stationLat, this.stationLon});
                            this.calcEventStation(evlatlon, stalatlonList);
                            this.printResult(this.getWriter());
                        }
                        readMode = 100;
                        break;
                    }
                    case 109: {
                        tokenIn.ordinaryChars(48, 57);
                        tokenIn.wordChars(48, 57);
                        tokenIn.ordinaryChars(46, 46);
                        tokenIn.wordChars(46, 46);
                        tokenIn.ordinaryChars(45, 45);
                        tokenIn.wordChars(45, 45);
                        oldModelName = this.modelName;
                        oldTMod = this.tMod;
                        oldTModDepth = this.tModDepth;
                        System.out.print("Enter model name: ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype == -3) {
                            this.modelName = tokenIn.sval;
                        }
                        tokenIn.ordinaryChars(48, 57);
                        tokenIn.ordinaryChars(46, 46);
                        tokenIn.ordinaryChars(45, 45);
                        tokenIn.parseNumbers();
                        if (!this.modelName.equals(oldModelName)) {
                            try {
                                this.readTauModel();
                                this.setSourceDepth(this.depth);
                            }
                            catch (TauModelException e) {
                                if (e.getCause() instanceof InvalidClassException) {
                                    Alert.warning("Model file " + this.modelName + " is not compatible with the current version.", "Recreate using taup_create. Still using model " + oldModelName + ".");
                                } else {
                                    Alert.warning("I can't load model file " + this.modelName, "Still using model " + oldModelName + ".");
                                }
                                this.modelName = oldModelName;
                                this.tMod = oldTMod;
                                this.tModDepth = oldTModDepth;
                            }
                        }
                        readMode = 100;
                        break;
                    }
                    case 116: {
                        System.out.print("Enter takeoff angle (deg): ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype != -2) {
                            Alert.warning("Expected a number.", "got " + tokenIn + " instead.");
                            this.printHelp();
                            break;
                        }
                        takeoffAngle = tokenIn.nval;
                        this.calcTakeoff(takeoffAngle);
                        this.printResult(this.getWriter());
                        readMode = 100;
                        break;
                    }
                    case 122: {
                        System.out.print("Enter ray parameter (s/deg): ");
                        tokenIn.nextToken();
                        if (tokenIn.ttype != -2) {
                            Alert.warning("Expected a number.", "got " + tokenIn + " instead.");
                            this.printHelp();
                            break;
                        }
                        shootRayp = tokenIn.nval;
                        this.calcRayParameter(shootRayp / 0.017453292519943295);
                        this.printResult(this.getWriter());
                        readMode = 100;
                        break;
                    }
                    case 113: {
                        return;
                    }
                }
            } while (tokenIn.ttype == -2 || tokenIn.ttype != -3 || tokenIn.ttype == -3 && !tokenIn.sval.equalsIgnoreCase("q"));
        }
    }

    @Override
    public void destroy() throws TauPException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public String getStdUsageHead() {
        return TauP_Tool.getStdUsageHead(this.getClass());
    }

    public String getStdUsage() {
        return this.getStdUsageHead() + this.getPhaseUsage() + this.getDistanceUsage();
    }

    public String getPhaseUsage() {
        return "-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n" + TauP_Time.getModDepthUsage();
    }

    public String getDistanceUsage() {
        return "Distance is given by:\n\n-deg degrees       -- distance in degrees,\n-km kilometers     -- distance in kilometers,\n                      assumes radius of earth is 6371km,\n\nor by giving the station and event latitude and lonitude,\n                      assumes a spherical earth,\n\n-sta[tion] lat lon -- sets the station latitude and longitude\n-evt       lat lon -- sets the event latitude and longitude\n\nor by giving the takeoff angle,\n--takeoff angle    -- takeoff angle from the source\n                      zero is down, 90 horizontal, 180 is up\n\nor by giving the ray parameter,\n--shootray param   -- ray parameter from the source in s/deg\n                      up or down is determined by the phase\n\n\n";
    }

    public String getLimitUsage() {
        return "--first            -- only output the first arrival for each phase, no triplications\n--rayp             -- only output the ray parameter\n--time             -- only output travel time\n--rel phasename    -- also output relative travel time\n\n--json             -- output travel times as json\n\n";
    }

    @Override
    public String getUsage() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getStdUsage());
        buf.append(this.getLimitUsage());
        buf.append(TauP_Time.getStdUsageTail());
        return buf.toString();
    }

    public static final double linearInterp(double xa, double ya, double xb, double yb, double x) {
        if (x == xa) {
            return ya;
        }
        if (x == xb) {
            return yb;
        }
        return (yb - ya) * (x - xa) / (xb - xa) + ya;
    }

    public static void main(String[] args) throws IOException {
        ToolRun.legacyRunTool(ToolRun.TIME, args);
    }
}

