/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.ToolRun;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.mseed3.MSeed3Record;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class TauP_SetMSeed3
extends TauP_Time {
    protected List<String> mseed3FileNames = new ArrayList<String>();

    public TauP_SetMSeed3() {
    }

    public TauP_SetMSeed3(TauModel tMod) {
        super(tMod);
    }

    public TauP_SetMSeed3(String modelName) throws TauModelException {
        super(modelName);
    }

    @Override
    public void start() throws IOException, TauPException {
        if (this.mseed3FileNames.size() == 0) {
            this.printUsage();
            return;
        }
        for (String filename : this.mseed3FileNames) {
            try {
                if (this.verbose) {
                    System.out.println(filename);
                }
                this.processMSeed3File(new File(filename));
            }
            catch (SeisFileException e) {
                throw new TauPException((Exception)((Object)e));
            }
        }
    }

    public void processMSeed3File(File msd3File) throws IOException, SeisFileException, TauPException {
        MSeed3Record dr3;
        int fileBytes = (int)msd3File.length();
        int bytesRead = 0;
        boolean drNum = false;
        File tmpFile = File.createTempFile("taup", "msd3", msd3File.getParentFile());
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(msd3File)));
        while (bytesRead < fileBytes && (dr3 = MSeed3Record.read((DataInput)dis)) != null) {
            JSONObject eh = dr3.getExtraHeaders();
            Double staLat = null;
            Object staLon = null;
            Double staDepth = 0.0;
            Double evLat = null;
            Object evLon = null;
            Double evDepth = 0.0;
            if (eh.has("st")) {
                JSONObject st = eh.getJSONObject("st");
                if (st.has("la")) {
                    staLat = st.getDouble("la");
                }
                if (st.has("lo")) {
                    staLat = st.getDouble("lo");
                }
                if (st.has("dp")) {
                    staDepth = st.getDouble("dp") / 1000.0;
                }
            }
            if (eh.has("ev")) {
                JSONObject ev = eh.getJSONObject("ev");
                if (ev.has("la")) {
                    evLat = ev.getDouble("la");
                }
                if (ev.has("lo")) {
                    evLat = ev.getDouble("lo");
                }
                if (ev.has("dp")) {
                    evDepth = ev.getDouble("dp");
                }
            }
            if (staLat == null || staLon == null || evLat == null || evLon == null) continue;
            this.depthCorrect(evDepth, staDepth);
            ArrayList<Double[]> staList = new ArrayList<Double[]>();
            staList.add(new Double[]{staLat, staLon});
            List<Arrival> arrivals = this.calcEventStation(new Double[]{evLat, evLon}, staList);
            JSONObject taup = TauP_SetMSeed3.resultAsJSONObject(this.modelName, this.depth, this.getReceiverDepth(), this.getPhaseNames(), arrivals);
            eh.put("taup", (Object)taup);
        }
        tmpFile.renameTo(msd3File);
    }

    @Override
    public List<Arrival> calculate(List<Double> degreesList) throws TauPException {
        return super.calculate(degreesList);
    }

    @Override
    public String getStdUsage() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        return "Usage: " + className.toLowerCase() + " [arguments]  or, for purists, java " + this.getClass().getName() + " [arguments]\nArguments are:-ph phase list     -- comma separated phase list,\n                      use phase-# to specify the sac header,\n                      for example, ScS-8 puts ScS in t8\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n";
    }

    public String getUsageTail() {
        return "\n--prop [propfile]   -- set configuration properties\n--debug             -- enable debugging output\n--verbose           -- enable verbose output\n--version           -- print the version\n--help              -- print this out, but you already know that!\n";
    }

    @Override
    public String getUsage() {
        return this.getStdUsage() + "--evdpkm            -- sac depth header is in km, default is meters\n" + this.getUsageTail() + "ms3filename [ms3filename ...]\nEx: taup_setmseed3 --mod S_prem -ph S,ScS wmq.ms3 wmq.ms3 wmq.ms3puts the S and ScS in the extra headers in each record in these files.Values are within the \"taup\" key and are the same as the output of taup time --json";
    }

    @Override
    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (TauP_SetMSeed3.dashEquals("help", leftOverArgs[i])) {
                noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i];
                continue;
            }
            File tempFile = new File(leftOverArgs[i]);
            if (tempFile.exists() && (tempFile.isFile() || tempFile.isDirectory()) && tempFile.canRead()) {
                this.mseed3FileNames.add(leftOverArgs[i]);
                continue;
            }
            if (!tempFile.exists()) {
                System.err.println(leftOverArgs[i] + " does not exist. " + tempFile.getAbsolutePath());
            } else if (!tempFile.isFile() && !tempFile.isDirectory()) {
                System.err.println(leftOverArgs[i] + " is not a file or directory.");
            } else if (!tempFile.canRead()) {
                System.err.println(leftOverArgs[i] + " is not readable.");
            }
            noComprendoArgs[numNoComprendoArgs++] = leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws IOException {
        ToolRun.legacyRunTool(ToolRun.SETMSEED3, args);
    }
}

