/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.ScatterArrivalFailException;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.TauP.ToolRun;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class TauP_Curve
extends TauP_Time {
    protected boolean gmtScript = false;
    protected boolean reduceTime = false;
    protected double reduceVel = 0.002181661564992912;
    protected String redVelString = ".125 deg/s";
    protected float mapWidth = 6.0f;
    int plotOffset = 80;
    protected String mapWidthUnit = "i";
    protected boolean distHorizontal = true;

    public TauP_Curve() {
        this.initFields();
    }

    public TauP_Curve(TauModel tMod) throws TauModelException {
        super(tMod);
        this.initFields();
    }

    public TauP_Curve(String modelName) throws TauModelException {
        super(modelName);
        this.initFields();
    }

    void initFields() {
        this.setOutFileBase("taup_curve");
        this.setDefaultOutputFormat();
    }

    @Override
    public String[] allowedOutputFormats() {
        String[] formats = new String[]{"svg", "gmt"};
        return formats;
    }

    @Override
    public void setDefaultOutputFormat() {
        this.setOutputFormat("gmt");
    }

    @Override
    public String getOutFileExtension() {
        String extention = "gmt";
        if (this.outputFormat.equals("svg")) {
            extention = "svg";
        }
        return extention;
    }

    public boolean isGmtScript() {
        return this.gmtScript;
    }

    public void setGmtScript(boolean gmtScript) {
        this.gmtScript = gmtScript;
    }

    public boolean isReduceTime() {
        return this.reduceTime;
    }

    public void setReduceTime(boolean reduceTime) {
        this.reduceTime = reduceTime;
    }

    public double getReduceVelDeg() {
        return 57.29577951308232 * this.reduceVel;
    }

    public void setReduceVelDeg(double reduceVel) {
        if (reduceVel > 0.0) {
            this.redVelString = reduceVel + " deg/s";
            this.reduceVel = Math.PI / 180 * reduceVel;
        }
    }

    public double getReduceVelKm() {
        return this.reduceVel * this.tMod.getRadiusOfEarth();
    }

    public void setReduceVelKm(double reduceVel) {
        this.redVelString = reduceVel + " km/s";
        if (reduceVel > 0.0) {
            this.reduceVel = this.tMod != null ? reduceVel / this.tMod.getRadiusOfEarth() : reduceVel / 6371.0;
        } else {
            throw new IllegalArgumentException("Reducing velocity must be positive: " + reduceVel);
        }
    }

    public void setMapWidth(float mapWidth) {
        this.mapWidth = mapWidth;
    }

    public float getMapWidth() {
        return this.mapWidth;
    }

    public String getMapWidthUnit() {
        return this.mapWidthUnit;
    }

    public void setMapWidthUnit(String mapWidthUnit) {
        this.mapWidthUnit = mapWidthUnit;
    }

    @Override
    public List<Arrival> calculate(List<Double> degreesList) throws TauModelException {
        this.depthCorrect();
        return new ArrayList<Arrival>();
    }

    @Override
    public void printScriptBeginning(PrintWriter out) throws IOException {
        if (this.gmtScript) {
            String psFile = this.getOutFile().endsWith(".gmt") ? this.getOutFile().substring(0, this.getOutFile().length() - 4) + ".ps" : this.getOutFile() + ".ps";
            this.getWriter().println("#!/bin/sh");
            this.getWriter().println("#\n# This script will plot curves using GMT. If you want to\n#use this as a data file for psxy in another script, delete these\n# first lines, as well as the last line.\n#");
            this.getWriter().println("/bin/rm -f " + psFile + "\n");
        } else if (this.outputFormat.equals("svg")) {
            SvgUtil.xyplotScriptBeginning(out, TauP_Curve.toolNameFromClass(this.getClass()), this.cmdLineArgs, this.mapWidth, this.plotOffset);
            float f = 72.0f * this.mapWidth;
        }
    }

    @Override
    public String getStdUsage() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1, className.length());
        return "Usage: " + className.toLowerCase() + " [arguments]\n  or, for purists, java " + this.getClass().getName() + " [arguments]\n\nArguments are:\n-ph phase list     -- comma separated phase list\n-pf phasefile      -- file containing phases\n\n-mod[el] modelname -- use velocity model \"modelname\" for calculations\n                      Default is iasp91.\n\n-h depth           -- source depth in km\n\n\n";
    }

    @Override
    public String getUsage() {
        return this.getStdUsage() + "--gmt              -- outputs curves as a complete GMT script.\n--svg              -- outputs curves as a SVG image.\n-reddeg velocity   -- outputs curves with a reducing velocity (deg/sec).\n-redkm velocity    -- outputs curves with a reducing velocity (km/sec).\n-rel phasename     -- outputs relative travel time\n--distancevertical -- distance on vertical axis, time horizontal\n--mapwidth width   -- sets map width for GMT script.\n" + TauP_Curve.getStdUsageTail();
    }

    @Override
    public void start() throws IOException, TauModelException {
        if (this.depth != -1.7976931348623157E308) {
            this.setSourceDepth(Double.valueOf(this.toolProps.getProperty("taup.source.depth", "0.0")));
            this.depthCorrect();
            this.calculate(new ArrayList<Double>());
            this.printResult(this.getWriter());
        } else {
            StreamTokenizer tokenIn = new StreamTokenizer(new InputStreamReader(System.in));
            tokenIn.parseNumbers();
            tokenIn.wordChars(44, 44);
            tokenIn.wordChars(95, 95);
            System.out.print("Enter Depth: ");
            tokenIn.nextToken();
            double tempDepth = tokenIn.nval;
            if (tempDepth < 0.0 || this.depth > this.tMod.getRadiusOfEarth()) {
                System.out.println("Depth must be >= 0.0 and <= tMod.getRadiusOfEarth().\ndepth = " + tempDepth);
                return;
            }
            this.setSourceDepth(tempDepth);
            this.depthCorrect();
            this.printResult(this.getWriter());
        }
    }

    @Override
    public void destroy() throws TauPException {
        if (this.gmtScript && this.writer != null) {
            this.writer.close();
        }
        super.destroy();
    }

    @Override
    public void printResult(PrintWriter out) throws IOException {
        double[] time;
        double[] dist;
        double maxTime = -1.7976931348623157E308;
        double minTime = Double.MAX_VALUE;
        ArrayList<SeismicPhase> relPhases = new ArrayList<SeismicPhase>();
        if (this.relativePhaseName != "") {
            try {
                List<String> splitNames = TauP_Curve.extractPhaseNames(this.relativePhaseName);
                for (String sName : splitNames) {
                    try {
                        List<SeismicPhase> calcRelPhaseList = SeismicPhaseFactory.createSeismicPhases(sName, this.getTauModelDepthCorrected(), this.getSourceDepth(), this.getReceiverDepth(), this.getScattererDepth(), this.getScattererDistDeg(), DEBUG);
                        relPhases.addAll(calcRelPhaseList);
                    }
                    catch (ScatterArrivalFailException e) {
                        Alert.warning(e.getMessage(), "    Skipping this relative phase");
                        if (!this.verbose && !DEBUG) continue;
                        e.printStackTrace();
                    }
                }
            }
            catch (TauModelException e) {
                Alert.warning("Error with phase=" + this.relativePhaseName, e.getMessage() + "\nSkipping relative phase");
            }
        }
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        String psFile = null;
        if (this.gmtScript || this.outputFormat.equals("svg")) {
            Object scriptStuff = "";
            psFile = this.getOutFile().endsWith(".gmt") ? this.getOutFile().substring(0, this.getOutFile().length() - 4) + ".ps" : this.getOutFile() + ".ps";
            String title = this.modelName + " (h=" + this.getSourceDepth() + " km)";
            if (this.reduceTime) {
                title = title + " reduce vel " + this.redVelString;
            } else if (this.relativePhaseName != "") {
                title = title + " relative phase " + this.relativePhaseName;
            }
            for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
                double[] timeValue;
                SeismicPhase phase = phaseList.get(phaseNum);
                if (!phase.hasArrivals()) continue;
                dist = phase.getDist();
                time = phase.getTime();
                int phaseMinIndex = 0;
                int phaseMaxIndex = 0;
                double phaseMaxTime = -1.7976931348623157E308;
                double phaseMinTime = Double.MAX_VALUE;
                for (int i = 0; i < time.length; ++i) {
                    timeValue = this.calcTimeValue(dist[i], time[i], relPhases);
                    if (timeValue.length == 0) continue;
                    if (timeValue[0] > maxTime) {
                        maxTime = timeValue[0];
                    }
                    if (timeValue[0] < minTime) {
                        minTime = timeValue[0];
                    }
                    if (timeValue[0] > phaseMaxTime) {
                        phaseMaxTime = timeValue[0];
                        phaseMaxIndex = i;
                    }
                    if (!(timeValue[0] < phaseMinTime)) continue;
                    phaseMinTime = timeValue[0];
                    phaseMinIndex = i;
                }
                int midSample = dist.length / 2;
                double arcDistance = Math.acos(Math.cos(dist[midSample]));
                if (this.reduceTime || this.relativePhaseName != "") {
                    double labelTime;
                    timeValue = this.calcTimeValue(dist[midSample], time[midSample], relPhases);
                    if (timeValue.length == 0) {
                        arcDistance = Math.acos(Math.cos(dist[phaseMaxIndex]));
                        labelTime = phaseMaxTime;
                    } else {
                        labelTime = timeValue[0];
                    }
                    scriptStuff = this.distHorizontal ? (String)scriptStuff + (float)(57.29577951308232 * arcDistance) + "  " + (float)phaseMaxTime : (String)scriptStuff + (float)phaseMaxTime + "  " + (float)(57.29577951308232 * arcDistance);
                    scriptStuff = (String)scriptStuff + " 10 0 0 9 " + phase.getName() + "\n";
                    continue;
                }
                int lix = dist[1] > Math.PI ? 1 : dist.length - 1;
                double ldel = 57.29577951308232 * Math.acos(Math.cos(dist[midSample]));
                scriptStuff = this.distHorizontal ? (String)scriptStuff + (float)ldel + "  " + (float)time[midSample] : (String)scriptStuff + (float)time[midSample] + "  " + (float)ldel;
                scriptStuff = (String)scriptStuff + " 10 0 0 1 " + phase.getName() + "\n";
            }
            maxTime = Math.ceil(maxTime / 100.0) * 100.0;
            if (minTime != 0.0) {
                double widerMinTime = minTime - (maxTime - minTime) / 20.0;
                if (minTime > 0.0 && widerMinTime < 0.0) {
                    minTime = 0.0;
                }
            }
            minTime = Math.floor(minTime / 100.0) * 100.0;
            if (this.outputFormat.equals("gmt")) {
                out.println("gmt psbasemap -JX" + this.getMapWidth() + this.getMapWidthUnit() + " -P -R0/180/" + minTime + "/" + maxTime + " -Bxa20+l'Distance (deg)' -Bya100+l'Time (sec)' -BWSne+t'" + title + "' -K > " + psFile);
                out.println("gmt pstext -JX -P -R  -O -K >> " + psFile + " <<END");
                out.print((String)scriptStuff);
                out.println("END\n");
                out.println("gmt psxy -JX -R -m -O -K >> " + psFile + " <<END");
            } else if (this.outputFormat.equals("svg")) {
                int numXTicks;
                int numYTicks;
                double maxY;
                double minY;
                double maxX;
                double minX;
                boolean xEndFixed = false;
                boolean yEndFixed = false;
                float pixelWidth = 72.0f * this.mapWidth - (float)this.plotOffset;
                if (this.distHorizontal) {
                    minX = 0.0;
                    maxX = 180.0;
                    xEndFixed = true;
                    minY = minTime;
                    maxY = maxTime;
                    numYTicks = 10;
                    numXTicks = 8;
                } else {
                    minY = minTime;
                    maxX = maxTime;
                    minX = 0.0;
                    maxY = 180.0;
                    yEndFixed = true;
                    numYTicks = 9;
                    numXTicks = 8;
                }
                float margin = 40.0f;
                float plotWidth = pixelWidth - margin;
                SvgUtil.createXYAxes(out, minX, maxX, numXTicks, xEndFixed, minY, maxY, numYTicks, yEndFixed, pixelWidth, margin, title, "Degrees", "Seconds");
                out.println("<g>  <!-- phase name labels -->");
                for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
                    double yPos;
                    double xPos;
                    int randIdx;
                    SeismicPhase phase = phaseList.get(phaseNum);
                    if (!phase.hasArrivals()) continue;
                    dist = phase.getDist();
                    time = phase.getTime();
                    double[] cval = new double[]{};
                    for (int i = 0; i < 10 && (cval = this.calcPlotValue(dist[randIdx = (int)(Math.random() * (double)dist.length)], time[randIdx], relPhases)).length == 0; ++i) {
                    }
                    if (this.distHorizontal) {
                        xPos = cval[0] * (double)plotWidth / 180.0;
                        yPos = (double)plotWidth - (cval[1] - minTime) * (double)plotWidth / (maxTime - minTime);
                    } else {
                        xPos = (cval[1] - minTime) * (double)plotWidth / (maxTime - minTime);
                        yPos = (double)plotWidth - cval[0] * (double)plotWidth / 180.0;
                    }
                    out.println("<text class=\"phaselabel autocolor\" font-size=\"12\" x=\"" + xPos + "\" y=\"" + yPos + "\">" + phase.getName() + "</text>");
                }
                out.println("</g>  <!-- end phase name labels -->");
                out.println("<g transform=\"scale(1,-1) translate(0, -" + plotWidth + ")\">");
                if (this.distHorizontal) {
                    out.println("<g transform=\"scale(" + plotWidth / 180.0f + "," + (double)plotWidth / (maxTime - minTime) + ")\" >");
                    out.println("<g transform=\"translate(0, " + -1.0 * minTime + ")\">");
                } else {
                    out.println("<g transform=\"scale(" + (double)plotWidth / (maxTime - minTime) + "," + plotWidth / 180.0f + ")\" >");
                    out.println("<g transform=\"translate(" + -1.0 * minTime + ", 0)\">");
                }
            }
        }
        double minDist = 0.0;
        double maxDist = Math.PI;
        if (this.relativePhaseName != "") {
            for (SeismicPhase seismicPhase : relPhases) {
                double[] relDist = seismicPhase.getDist();
                if (relDist.length == 0) continue;
                minDist = relDist[0];
                maxDist = relDist[0];
                for (int i = 0; i < relDist.length; ++i) {
                    if (relDist[i] < minDist) {
                        minDist = relDist[i];
                    }
                    if (!(relDist[i] > maxDist)) continue;
                    maxDist = relDist[i];
                }
            }
        }
        for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
            SeismicPhase phase = phaseList.get(phaseNum);
            if (phase.hasArrivals()) {
                dist = phase.getDist();
                time = phase.getTime();
                double[] rayParams = phase.getRayParams();
                double minPhaseDist = dist[0];
                double maxPhaseDist = dist[0];
                if (this.relativePhaseName != "") {
                    for (int i = 0; i < dist.length; ++i) {
                        if (dist[i] < minPhaseDist) {
                            minDist = dist[i];
                        }
                        if (!(dist[i] > maxPhaseDist)) continue;
                        maxDist = dist[i];
                    }
                }
                if (dist.length > 0) {
                    String commentLine = phase.getName() + " for a source depth of " + this.depth + " kilometers in the " + this.modelName + " model";
                    if (this.relativePhaseName != "") {
                        commentLine = commentLine + " relative to " + this.relativePhaseName;
                    }
                    if (this.outputFormat.equals("gmt")) {
                        out.println("> " + commentLine);
                    } else if (this.outputFormat.equals("svg")) {
                        out.println("<!-- " + commentLine);
                        out.println(" -->");
                        out.println("<g class=\"autocolor " + phase.getName() + "\" >");
                        out.print("<polyline class=\"autocolor\" points=\"");
                    }
                }
                for (int i = 0; i < dist.length; ++i) {
                    this.writeValue(dist[i], time[i], relPhases, out, this.distHorizontal);
                    if (i < dist.length - 1 && rayParams[i] == rayParams[i + 1] && rayParams.length > 2) {
                        if (this.outputFormat.equals("gmt")) {
                            out.println("> Shadow Zone");
                            continue;
                        }
                        if (!this.outputFormat.equals("svg")) continue;
                        out.println("\" />");
                        out.println("<!-- Shadow Zone -->");
                        out.print("<polyline points=\"");
                        continue;
                    }
                    this.checkBoundary(0.0, i, phase, relPhases, out);
                    this.checkBoundary(Math.PI, i, phase, relPhases, out);
                    if (minDist != 0.0 && minDist != Math.PI) {
                        this.checkBoundary(minDist, i, phase, relPhases, out);
                    }
                    if (maxDist == 0.0 || maxDist == Math.PI) continue;
                    this.checkBoundary(maxDist, i, phase, relPhases, out);
                }
                if (!this.outputFormat.equals("svg")) continue;
                out.println("\" />");
                out.println("</g>");
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("Phase " + phase.getName() + " does not exist in " + phase.getTauModel().getModelName() + " for depth " + phase.getTauModel().getSourceDepth());
        }
        if (this.isGmtScript()) {
            out.println("END");
            this.endGmtAndCleanUp(out, psFile, "X");
        } else if (this.outputFormat.equals("svg")) {
            out.println("</g>");
            out.println("</g>");
            out.println("</g>");
            out.println("</g>");
            out.println("</svg>");
        }
        out.flush();
    }

    protected void checkBoundary(double boundaryDistRadian, int distIndex, SeismicPhase phase, List<SeismicPhase> relPhase, PrintWriter out) throws IOException {
        double arcDistance = Math.acos(Math.cos(boundaryDistRadian));
        if (distIndex < phase.getDist().length - 1) {
            block0: for (double distCheck = boundaryDistRadian; distCheck < phase.getMaxDistance(); distCheck += Math.PI * 2) {
                if (!(phase.getDist()[distIndex] < distCheck && distCheck < phase.getDist()[distIndex + 1]) && (!(phase.getDist()[distIndex + 1] < distCheck) || !(distCheck < phase.getDist()[distIndex]))) continue;
                List<Arrival> phaseArrivals = phase.calcTime(arcDistance * 180.0 / Math.PI);
                for (Arrival arrival : phaseArrivals) {
                    double[] phase_rayParams = phase.getRayParams();
                    if (!((phase_rayParams[distIndex] - arrival.getRayParam()) * (arrival.getRayParam() - phase_rayParams[distIndex + 1]) >= 0.0)) continue;
                    this.writeValue(arcDistance, arrival.getTime(), relPhase, out, this.distHorizontal);
                    continue block0;
                }
            }
        }
    }

    protected double[] calcTimeValue(double distRadian, double time, List<SeismicPhase> relPhase) throws IOException {
        double timeReduced = time;
        double arcDistance = Math.acos(Math.cos(distRadian));
        double distDeg = arcDistance * 180.0 / Math.PI;
        if (this.reduceTime) {
            timeReduced = time - arcDistance / this.reduceVel;
        } else if (this.relativePhaseName != "") {
            Arrival relativeArrival = SeismicPhase.getEarliestArrival(relPhase, distDeg);
            if (relativeArrival == null) {
                return new double[0];
            }
            timeReduced = time - relativeArrival.getTime();
        } else {
            timeReduced = time;
        }
        return new double[]{timeReduced};
    }

    public double[] calcPlotValue(double distRadian, double time, List<SeismicPhase> relPhase) throws IOException {
        double[] timeReduced = this.calcTimeValue(distRadian, time, relPhase);
        if (timeReduced.length == 0) {
            return timeReduced;
        }
        double arcDistance = Math.acos(Math.cos(distRadian));
        double distDeg = arcDistance * 180.0 / Math.PI;
        return new double[]{distDeg, timeReduced[0]};
    }

    public void writeValue(double distRadian, double time, List<SeismicPhase> relPhase, PrintWriter out, boolean distHorizontal) throws IOException {
        double[] cval = this.calcPlotValue(distRadian, time, relPhase);
        if (cval.length == 2) {
            double distDeg = cval[0];
            double timeReduced = cval[1];
            if (this.outputFormat.equals("svg")) {
                if (distHorizontal) {
                    out.print(Outputs.formatDistanceNoPad(distDeg) + "  " + Outputs.formatTimeNoPad(timeReduced) + " ");
                } else {
                    out.print(Outputs.formatTimeNoPad(timeReduced) + "  " + Outputs.formatDistanceNoPad(distDeg) + "  ");
                }
            } else if (distHorizontal) {
                out.println(Outputs.formatDistance(distDeg) + "  " + Outputs.formatTime(timeReduced));
            } else {
                out.println(Outputs.formatTime(timeReduced) + "  " + Outputs.formatDistance(distDeg));
            }
        }
    }

    public static final boolean isBetween(double a, double b, double value) {
        return a < value && value < b || a > value && value > b;
    }

    @Override
    public String[] parseCmdLineArgs(String[] args) throws IOException {
        int numNoComprendoArgs = 0;
        String[] leftOverArgs = super.parseSourceModelCmdLineArgs(args);
        String[] noComprendoArgs = new String[leftOverArgs.length];
        for (int i = 0; i < leftOverArgs.length; ++i) {
            if (TauP_Curve.dashEquals("gmt", leftOverArgs[i])) {
                this.gmtScript = true;
                this.outputFormat = "gmt";
                continue;
            }
            if (TauP_Curve.dashEquals("svg", leftOverArgs[i])) {
                this.outputFormat = "svg";
                continue;
            }
            if (TauP_Curve.dashEquals("distancevertical", leftOverArgs[i])) {
                this.distHorizontal = false;
                continue;
            }
            if (TauP_Curve.dashEquals("reddeg", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setReduceTime(true);
                this.setReduceVelDeg(Double.valueOf(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            if (TauP_Curve.dashEquals("redkm", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setReduceTime(true);
                this.setReduceVelKm(Double.valueOf(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            if (TauP_Curve.dashEquals("rel", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.relativePhaseName = leftOverArgs[i + 1];
                ++i;
                continue;
            }
            if (TauP_Curve.dashEquals("mapwidth", leftOverArgs[i]) && i < leftOverArgs.length - 1) {
                this.setMapWidth(Float.parseFloat(leftOverArgs[i + 1]));
                ++i;
                continue;
            }
            noComprendoArgs[numNoComprendoArgs++] = TauP_Curve.dashEquals("help", leftOverArgs[i]) ? leftOverArgs[i] : leftOverArgs[i];
        }
        if (numNoComprendoArgs > 0) {
            String[] temp = new String[numNoComprendoArgs];
            System.arraycopy(noComprendoArgs, 0, temp, 0, numNoComprendoArgs);
            return temp;
        }
        return new String[0];
    }

    public static void main(String[] args) throws IOException {
        ToolRun.legacyRunTool(ToolRun.CURVE, args);
    }
}

