/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Curve;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TauP_Amp
extends TauP_Curve {
    HashMap<SeismicPhase, double[]> ampMap = new HashMap();

    public TauP_Amp() {
        this.initFields();
    }

    public TauP_Amp(TauModel tMod) throws TauModelException {
        super(tMod);
        this.initFields();
    }

    public TauP_Amp(String modelName) throws TauModelException {
        super(modelName);
        this.initFields();
    }

    @Override
    void initFields() {
        this.setOutFileBase("taup_amp");
        this.setDefaultOutputFormat();
    }

    @Override
    public String getUsage() {
        return this.getStdUsage() + "--gmt              -- outputs curves as a complete GMT script.--svg              -- outputs curves as a SVG image.-reddeg velocity   -- outputs curves with a reducing velocity (deg/sec).-redkm velocity    -- outputs curves with a reducing velocity (km/sec).-rel phasename     -- outputs relative travel time--distancevertical -- distance on vertical axis, time horizontal--mapwidth width   -- sets map width for GMT script." + TauP_Amp.getStdUsageTail();
    }

    @Override
    public boolean isReduceTime() {
        return false;
    }

    @Override
    public List<Arrival> calculate(List<Double> degreesList) throws TauModelException {
        this.depthCorrect();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        this.ampMap = new HashMap();
        for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
            SeismicPhase phase = phaseList.get(phaseNum);
            if (!phase.hasArrivals()) continue;
            try {
                double[] dist = phase.getDist();
                double[] amp = new double[dist.length];
                for (int i = 0; i < dist.length; ++i) {
                    Arrival arrival = phase.createArrivalAtIndex(i);
                    amp[i] = arrival.getAmplitudeFactor();
                }
                this.ampMap.put(phase, amp);
                continue;
            }
            catch (SlownessModelException | VelocityModelException e) {
                throw new TauModelException(e);
            }
        }
        return new ArrayList<Arrival>();
    }

    @Override
    public void printResult(PrintWriter out) throws IOException {
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        String psFile = null;
        double maxAmp = -1.7976931348623157E308;
        double minAmp = Double.MAX_VALUE;
        if (this.gmtScript || this.outputFormat.equals("svg")) {
            Object scriptStuff = "";
            psFile = this.getOutFile().endsWith(".gmt") ? this.getOutFile().substring(0, this.getOutFile().length() - 4) + ".ps" : this.getOutFile() + ".ps";
            String title = this.modelName + " (h=" + this.getSourceDepth() + " km)";
            for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
                SeismicPhase phase = phaseList.get(phaseNum);
                if (!phase.hasArrivals()) continue;
                double[] dist = phase.getDist();
                double[] amp = this.ampMap.get(phase);
                double phaseMaxTime = -1.7976931348623157E308;
                double phaseMinTime = Double.MAX_VALUE;
                for (int i = 0; i < amp.length; ++i) {
                    double[] ampValue = this.calcAmpValue(dist[i], amp[i]);
                    if (ampValue.length == 0 || Double.isNaN(ampValue[0])) continue;
                    if (ampValue[0] > maxAmp) {
                        maxAmp = ampValue[0];
                    }
                    if (ampValue[0] < minAmp) {
                        minAmp = ampValue[0];
                    }
                    if (ampValue[0] > phaseMaxTime) {
                        phaseMaxTime = ampValue[0];
                    }
                    if (!(ampValue[0] < phaseMinTime)) continue;
                    phaseMinTime = ampValue[0];
                }
                int midSample = dist.length / 2;
                double ldel = 57.29577951308232 * Math.acos(Math.cos(dist[midSample]));
                scriptStuff = this.distHorizontal ? (String)scriptStuff + (float)ldel + "  " + (float)amp[midSample] : (String)scriptStuff + (float)amp[midSample] + "  " + (float)ldel;
                scriptStuff = (String)scriptStuff + " 10 0 0 1 " + phase.getName() + "\n";
            }
            minAmp = -8.0;
            if (this.outputFormat.equals("gmt")) {
                out.println("gmt psbasemap -JX" + this.getMapWidth() + this.getMapWidthUnit() + " -P -R0/180/" + minAmp + "/" + maxAmp + " -Bxa20+l'Distance (deg)' -Bya100+l'Amp (m)' -BWSne+t'" + title + "' -K > " + psFile);
                out.println("gmt pstext -JX -P -R  -O -K >> " + psFile + " <<END");
                out.print((String)scriptStuff);
                out.println("END\n");
                out.println("gmt psxy -JX -R -m -O -K >> " + psFile + " <<END");
            } else if (this.outputFormat.equals("svg")) {
                int numXTicks;
                int numYTicks;
                double maxY;
                double minY;
                double maxX;
                double minX;
                boolean xEndFixed = false;
                boolean yEndFixed = false;
                float pixelWidth = 72.0f * this.mapWidth - (float)this.plotOffset;
                if (this.distHorizontal) {
                    minX = 0.0;
                    maxX = 180.0;
                    xEndFixed = true;
                    minY = minAmp;
                    maxY = maxAmp;
                    numYTicks = 10;
                    numXTicks = 8;
                } else {
                    minY = minAmp;
                    maxX = maxAmp;
                    minX = 0.0;
                    maxY = 180.0;
                    yEndFixed = true;
                    numYTicks = 9;
                    numXTicks = 8;
                }
                float margin = 40.0f;
                float plotWidth = pixelWidth - margin;
                SvgUtil.createXYAxes(out, minX, maxX, numXTicks, xEndFixed, minY, maxY, numYTicks, yEndFixed, pixelWidth, margin, title, "Degrees", "log Amp");
                out.println("<g>  <!-- phase name labels -->");
                for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
                    double yPos;
                    double xPos;
                    int randIdx;
                    SeismicPhase phase = phaseList.get(phaseNum);
                    if (!phase.hasArrivals()) continue;
                    double[] dist = phase.getDist();
                    double[] amp = this.ampMap.get(phase);
                    double[] cval = new double[]{};
                    for (int i = 0; i < 10 && (cval = this.calcPlotValue(dist[randIdx = (int)(Math.random() * (double)dist.length)], amp[randIdx])).length == 0; ++i) {
                    }
                    if (this.distHorizontal) {
                        xPos = cval[0] * (double)plotWidth / 180.0;
                        yPos = (double)plotWidth - (cval[1] - minAmp) * (double)plotWidth / (maxAmp - minAmp);
                    } else {
                        xPos = (cval[1] - minAmp) * (double)plotWidth / (maxAmp - minAmp);
                        yPos = (double)plotWidth - cval[0] * (double)plotWidth / 180.0;
                    }
                    out.println("<text class=\"phaselabel autocolor\" font-size=\"12\" x=\"" + xPos + "\" y=\"" + yPos + "\">" + phase.getName() + "</text>");
                }
                out.println("</g>  <!-- phase name labels -->");
                out.println("<clipPath id=\"margin-clip\"><rect x=\"0\" y=\"0\" width=\"" + plotWidth + "\" height=\"" + plotWidth + "\"/></clipPath>");
                out.println("<g clip-path=\"url(#margin-clip)\">");
                out.println("<g transform=\"scale(1,-1) translate(0, -" + plotWidth + ")\">");
                if (this.distHorizontal) {
                    out.println("<g transform=\"scale(" + plotWidth / 180.0f + "," + (double)plotWidth / (maxAmp - minAmp) + ")\" >");
                    out.println("<g transform=\"translate(0, " + -1.0 * minAmp + ")\">");
                } else {
                    out.println("<g transform=\"scale(" + (double)plotWidth / (maxAmp - minAmp) + "," + plotWidth / 180.0f + ")\" >");
                    out.println("<g transform=\"translate(" + -1.0 * minAmp + ", 0)\">");
                }
            }
        }
        ArrayList<SeismicPhase> relPhases = new ArrayList<SeismicPhase>();
        double minDist = 0.0;
        double maxDist = Math.PI;
        for (int phaseNum = 0; phaseNum < phaseList.size(); ++phaseNum) {
            SeismicPhase phase = phaseList.get(phaseNum);
            if (phase.hasArrivals()) {
                double[] dist = phase.getDist();
                double[] amp = this.ampMap.get(phase);
                double[] rayParams = phase.getRayParams();
                boolean xAxisIsDist = true;
                double[] xaxisValues = xAxisIsDist ? dist : rayParams;
                double minPhaseDist = xaxisValues[0];
                double maxPhaseDist = xaxisValues[0];
                if (this.relativePhaseName != "") {
                    for (int i = 0; i < xaxisValues.length; ++i) {
                        if (xaxisValues[i] < minPhaseDist) {
                            minDist = xaxisValues[i];
                        }
                        if (!(xaxisValues[i] > maxPhaseDist)) continue;
                        maxDist = xaxisValues[i];
                    }
                }
                if (xaxisValues.length > 0) {
                    String commentLine = phase.getName() + " for a source depth of " + this.depth + " kilometers in the " + this.modelName + " model";
                    if (this.relativePhaseName != "") {
                        commentLine = commentLine + " relative to " + this.relativePhaseName;
                    }
                    if (this.outputFormat.equals("gmt")) {
                        out.println("> " + commentLine);
                    } else if (this.outputFormat.equals("svg")) {
                        out.println("<!-- " + commentLine);
                        out.println(" -->");
                        out.println("<g class=\"autocolor " + phase.getName() + "\" >");
                        out.print("<polyline class=\"autocolor\" points=\"");
                    }
                }
                boolean lastWasValid = true;
                for (int i = 0; i < xaxisValues.length; ++i) {
                    if (i < xaxisValues.length - 1 && (!Double.isFinite(amp[i]) || this.calcAmpValue(xaxisValues[i], amp[i])[0] < minAmp)) {
                        if (lastWasValid) {
                            if (this.outputFormat.equals("gmt")) {
                                out.println("> amp below min");
                            } else if (this.outputFormat.equals("svg")) {
                                out.println("\" />");
                                out.println("<!-- amp below min, create gap -->");
                                out.print("<polyline class=\"autocolor\" points=\"");
                            }
                            lastWasValid = false;
                        }
                    } else {
                        this.writeValue(xaxisValues[i], amp[i], relPhases, out, this.distHorizontal);
                        lastWasValid = true;
                    }
                    if (i < xaxisValues.length - 1 && rayParams[i] == rayParams[i + 1] && rayParams.length > 2) {
                        if (this.outputFormat.equals("gmt")) {
                            out.println("> Shadow Zone");
                            continue;
                        }
                        if (!this.outputFormat.equals("svg")) continue;
                        out.println("\" />");
                        out.println("<!-- Shadow Zone -->");
                        out.print("<polyline class=\"autocolor\" points=\"");
                        continue;
                    }
                    if (!xAxisIsDist) continue;
                    this.checkBoundaryForAmp(0.0, i, phase, relPhases, out);
                    this.checkBoundaryForAmp(Math.PI, i, phase, relPhases, out);
                    if (minDist != 0.0 && minDist != Math.PI) {
                        this.checkBoundaryForAmp(minDist, i, phase, relPhases, out);
                    }
                    if (maxDist == 0.0 || maxDist == Math.PI) continue;
                    this.checkBoundaryForAmp(maxDist, i, phase, relPhases, out);
                }
                if (!this.outputFormat.equals("svg")) continue;
                out.println("\" />");
                out.println("</g>");
                continue;
            }
            if (!this.verbose) continue;
            System.out.println("Phase " + phase.getName() + " does not exist in " + phase.getTauModel().getModelName() + " for depth " + phase.getTauModel().getSourceDepth());
        }
        if (this.isGmtScript()) {
            out.println("END");
            this.endGmtAndCleanUp(out, psFile, "X");
        } else if (this.outputFormat.equals("svg")) {
            out.println("</g>");
            out.println("</g>");
            out.println("</g>");
            out.println("</g>");
            out.println("</g>");
            out.println("</svg>");
        }
        out.flush();
    }

    protected double[] calcAmpValue(double distRadian, double amp) throws IOException {
        if (Double.isNaN(amp)) {
            return new double[0];
        }
        double timeReduced = Math.abs(amp);
        double arcDistance = Math.acos(Math.cos(distRadian));
        double distDeg = arcDistance * 180.0 / Math.PI;
        if (timeReduced == 0.0) {
            timeReduced = 1.0E-9;
        }
        return new double[]{Math.log10(timeReduced)};
    }

    public double[] calcPlotValue(double distRadian, double amp) throws IOException {
        double[] timeReduced = this.calcAmpValue(distRadian, amp);
        if (timeReduced.length == 0) {
            return timeReduced;
        }
        double arcDistance = Math.acos(Math.cos(distRadian));
        double distDeg = arcDistance * 180.0 / Math.PI;
        return new double[]{distDeg, timeReduced[0]};
    }

    protected void checkBoundaryForAmp(double boundaryDistRadian, int distIndex, SeismicPhase phase, List<SeismicPhase> relPhase, PrintWriter out) throws IOException {
        double arcDistance = Math.acos(Math.cos(boundaryDistRadian));
        if (distIndex < phase.getDist().length - 1) {
            block4: for (double distCheck = boundaryDistRadian; distCheck < phase.getMaxDistance(); distCheck += Math.PI * 2) {
                if (!(phase.getDist()[distIndex] < distCheck && distCheck < phase.getDist()[distIndex + 1]) && (!(phase.getDist()[distIndex + 1] < distCheck) || !(distCheck < phase.getDist()[distIndex]))) continue;
                List<Arrival> phaseArrivals = phase.calcTime(arcDistance * 180.0 / Math.PI);
                for (Arrival arrival : phaseArrivals) {
                    double[] phase_rayParams = phase.getRayParams();
                    if (!((phase_rayParams[distIndex] - arrival.getRayParam()) * (arrival.getRayParam() - phase_rayParams[distIndex + 1]) >= 0.0)) continue;
                    try {
                        this.writeValue(arcDistance, arrival.getAmplitudeFactor(), relPhase, out, this.distHorizontal);
                        continue block4;
                    }
                    catch (TauModelException e) {
                        throw new RuntimeException(e);
                    }
                    catch (VelocityModelException e) {
                        throw new RuntimeException(e);
                    }
                    catch (SlownessModelException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    @Override
    public void writeValue(double distRadian, double time, List<SeismicPhase> relPhase, PrintWriter out, boolean distHorizontal) throws IOException {
        double[] cval = this.calcPlotValue(distRadian, time);
        if (cval.length == 2) {
            double distDeg = cval[0];
            double timeReduced = cval[1];
            if (this.outputFormat.equals("svg")) {
                if (distHorizontal) {
                    out.println((float)distDeg + "  " + (float)timeReduced + " ");
                } else {
                    out.println(Outputs.formatAmpFactor(timeReduced) + "  " + (float)distDeg + "  ");
                }
            } else if (distHorizontal) {
                out.println((float)distDeg + "  " + (float)timeReduced);
            } else {
                out.println((float)timeReduced + "  " + (float)distDeg);
            }
        }
    }
}

