/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Create;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidClassException;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TauModelLoader {
    protected static String packageName = "/edu/sc/seis/TauP/StdModels";
    static HashMap<String, SoftReference<TauModel>> tModCache = new HashMap();

    public static TauModel load(String modelName) throws TauModelException {
        return TauModelLoader.load(modelName, System.getProperty("taup.model.path"));
    }

    public static TauModel load(String modelName, String searchPath) throws TauModelException {
        return TauModelLoader.load(modelName, searchPath, true);
    }

    public static TauModel load(String modelName, String searchPath, boolean verbose) throws TauModelException {
        TauModel out = TauModelLoader.loadFromCache(modelName);
        if (out == null) {
            out = TauModelLoader.internalLoad(modelName, searchPath, verbose);
            tModCache.put(modelName, new SoftReference<TauModel>(out));
        }
        return out;
    }

    public static TauModel internalLoad(String modelName, String searchPath, boolean verbose) throws TauModelException {
        try {
            File modelFile;
            ZipFile zippy;
            ZipEntry zipEntry;
            File jarFile;
            String pathEntry;
            int pathSepIndex;
            int offset;
            String taupPath;
            String classPath;
            Object filename;
            block23: {
                filename = modelName.endsWith(".taup") ? modelName : modelName + ".taup";
                classPath = System.getProperty("java.class.path");
                taupPath = searchPath;
                offset = 0;
                Class<?> c = null;
                try {
                    c = Class.forName("edu.sc.seis.TauP.TauModelLoader");
                    InputStream in = c.getResourceAsStream(packageName + "/" + (String)filename);
                    if (in != null) {
                        return TauModel.readModelFromStream(in);
                    }
                }
                catch (InvalidClassException ex) {
                    throw new TauModelException("TauModel file not compatible with current version, recreate: " + c.getResource(packageName + "/" + (String)filename), ex);
                }
                catch (Exception ex) {
                    if (!verbose) break block23;
                    System.out.println("couldn't load as resource: " + (String)filename + "\n message: " + ex.getMessage());
                }
            }
            while (offset < classPath.length()) {
                pathSepIndex = classPath.indexOf(File.pathSeparatorChar, offset);
                if (pathSepIndex != -1) {
                    pathEntry = classPath.substring(offset, pathSepIndex);
                    offset = pathSepIndex + 1;
                } else {
                    pathEntry = classPath.substring(offset);
                    offset = classPath.length();
                }
                if (!(jarFile = new File(pathEntry)).exists() || !jarFile.isFile() || !jarFile.getName().equals("taup.jar") || !jarFile.canRead() || (zipEntry = (zippy = new ZipFile(jarFile)).getEntry("StdModels/" + (String)filename)) == null) continue;
                return TauModel.readModelFromStream(zippy.getInputStream(zipEntry));
            }
            offset = 0;
            if (taupPath != null) {
                while (offset < taupPath.length()) {
                    pathSepIndex = taupPath.indexOf(File.pathSeparatorChar, offset);
                    if (pathSepIndex != -1) {
                        pathEntry = taupPath.substring(offset, pathSepIndex);
                        offset = pathSepIndex + 1;
                    } else {
                        pathEntry = taupPath.substring(offset);
                        offset = taupPath.length();
                    }
                    if (pathEntry.endsWith(".jar") || pathEntry.endsWith(".zip")) {
                        jarFile = new File(pathEntry);
                        if (!jarFile.exists() || !jarFile.isFile() || !jarFile.canRead() || (zipEntry = (zippy = new ZipFile(jarFile)).getEntry("Models/" + (String)filename)) == null) continue;
                        return TauModel.readModelFromStream(zippy.getInputStream(zipEntry));
                    }
                    modelFile = new File(pathEntry + "/" + (String)filename);
                    if (!modelFile.exists() || !modelFile.isFile() || !modelFile.canRead()) continue;
                    return TauModel.readModel(modelFile.getCanonicalPath());
                }
            }
            if ((modelFile = new File((String)filename)).exists() && modelFile.isFile() && modelFile.canRead()) {
                return TauModel.readModel(modelFile.getCanonicalPath());
            }
            try {
                VelocityModel vmod = TauModelLoader.loadVelocityModel(modelName);
                if (vmod != null) {
                    TauP_Create tauPCreate = new TauP_Create();
                    return tauPCreate.createTauModel(vmod);
                }
            }
            catch (Exception e) {
                throw new TauModelException("Can't find any saved models for " + modelName + " and creation from velocity model failed.", e);
            }
            throw new TauModelException("Can't find any saved models for " + modelName);
        }
        catch (InvalidClassException e) {
            throw new TauModelException("Unable to load '" + modelName + "'", e);
        }
        catch (StreamCorruptedException e) {
            throw new TauModelException("Unable to load '" + modelName + "'", e);
        }
        catch (OptionalDataException e) {
            throw new TauModelException("Unable to load '" + modelName + "'", e);
        }
        catch (FileNotFoundException e) {
            throw new TauModelException("Unable to load '" + modelName + "'", e);
        }
        catch (ClassNotFoundException e) {
            throw new TauModelException("Unable to load '" + modelName + "'", e);
        }
        catch (IOException e) {
            throw new TauModelException("Unable to load '" + modelName + "'", e);
        }
    }

    public static VelocityModel loadVelocityModel(String modelName) throws IOException, VelocityModelException {
        return TauModelLoader.loadVelocityModel(modelName, null);
    }

    public static VelocityModel loadVelocityModel(String modelName, String fileType) throws IOException, VelocityModelException {
        if (modelName == null) {
            modelName = "iasp91";
            fileType = "tvel";
        }
        String basemodelName = modelName;
        int dirSepIndex = modelName.lastIndexOf(System.getProperty("file.separator"));
        if (dirSepIndex != -1) {
            basemodelName = modelName.substring(dirSepIndex + 1);
        }
        if (basemodelName.endsWith(".tvel")) {
            if (fileType == null) {
                fileType = "tvel";
            }
            basemodelName = basemodelName.substring(0, basemodelName.length() - 5);
        } else if (basemodelName.endsWith(".nd")) {
            if (fileType == null) {
                fileType = "nd";
            }
            basemodelName = basemodelName.substring(0, basemodelName.length() - 3);
        }
        VelocityModel vMod = null;
        if (dirSepIndex == -1) {
            InputStreamReader inReader;
            String filename;
            Class<?> c = new TauModelLoader().getClass();
            InputStream in = c.getResourceAsStream(packageName + "/" + (filename = basemodelName + ".nd"));
            if (in != null) {
                inReader = new InputStreamReader(in);
                vMod = VelocityModel.readNDFile(inReader, modelName);
                ((Reader)inReader).close();
            } else {
                filename = basemodelName + ".tvel";
                in = c.getResourceAsStream(packageName + "/" + filename);
                if (in != null) {
                    inReader = new InputStreamReader(in);
                    vMod = VelocityModel.readTVelFile(inReader, modelName);
                    ((Reader)inReader).close();
                }
            }
        }
        if (vMod == null) {
            String[] types = new String[]{"", "." + fileType};
            if (fileType == null) {
                types = new String[]{"", ".nd", ".tvel"};
            }
            for (int i = 0; i < types.length; ++i) {
                String vmodFile = modelName + types[i];
                File modelFile = new File(vmodFile);
                if (!modelFile.exists() || !modelFile.isFile() || !modelFile.canRead()) continue;
                vMod = VelocityModel.readVelocityFile(modelFile.getPath(), types[i]);
                break;
            }
        }
        return vMod;
    }

    protected static TauModel loadFromCache(String modelName) {
        SoftReference<TauModel> sr = tModCache.get(modelName);
        if (sr != null) {
            TauModel out = sr.get();
            if (out == null) {
                tModCache.remove(modelName);
            }
            return out;
        }
        return null;
    }

    public static void clearCache() {
        tModCache.clear();
    }
}

