/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.NoSuchMatPropException;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauP_Tool;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.ToolRun;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OptionalDataException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SimpleSeismicPhase
implements SeismicPhase {
    public transient boolean DEBUG = ToolRun.DEBUG;
    public transient boolean verbose = false;
    protected TauModel tMod;
    protected double sourceDepth;
    protected double receiverDepth = 0.0;
    protected double[] dist = new double[0];
    protected double[] time = new double[0];
    protected double[] rayParams = new double[0];
    protected double minRayParam;
    protected double maxRayParam;
    protected int maxRayParamIndex = -1;
    protected int minRayParamIndex = -1;
    protected double minDistance = 0.0;
    protected double maxDistance = Double.MAX_VALUE;
    protected List<Integer> branchSeq = new ArrayList<Integer>();
    protected List<Integer> headOrDiffractSeq = new ArrayList<Integer>();
    protected String name;
    protected String puristName;
    protected ArrayList<String> legs = new ArrayList();
    protected List<SeismicPhaseSegment> segmentList = new ArrayList<SeismicPhaseSegment>();
    protected List<PhaseInteraction> legAction = new ArrayList<PhaseInteraction>();
    protected List<Boolean> downGoing = new ArrayList<Boolean>();
    protected List<Boolean> waveType = new ArrayList<Boolean>();
    protected double refineDistToleranceRadian = 8.552113334772214E-5;
    protected int maxRecursion = 5;
    public static final boolean PWAVE = true;
    public static final boolean SWAVE = false;

    @Deprecated
    public SimpleSeismicPhase(String name, String modelName, double depth) throws TauModelException {
        this(name, TauModelLoader.load(modelName).depthCorrect(depth));
    }

    @Deprecated
    public SimpleSeismicPhase(String name, TauModel tMod) throws TauModelException {
        this(name, tMod, 0.0);
    }

    @Deprecated
    public SimpleSeismicPhase(String name, TauModel tMod, double receiverDepth) throws TauModelException {
        this(name, tMod, receiverDepth, ToolRun.DEBUG);
    }

    @Deprecated
    public SimpleSeismicPhase(String name, TauModel tMod, double receiverDepth, boolean debug) throws TauModelException {
        SimpleSeismicPhase phase = SeismicPhaseFactory.createPhase(name, tMod, tMod.sourceDepth, receiverDepth, debug);
        this.DEBUG = phase.DEBUG;
        this.verbose = phase.verbose;
        this.name = phase.name;
        this.tMod = phase.tMod;
        this.sourceDepth = phase.sourceDepth;
        this.receiverDepth = phase.receiverDepth;
        this.legs = phase.legs;
        this.puristName = phase.puristName;
        this.minRayParam = phase.minRayParam;
        this.maxRayParam = phase.maxRayParam;
        this.minRayParamIndex = phase.minRayParamIndex;
        this.maxRayParamIndex = phase.maxRayParamIndex;
        this.branchSeq = phase.branchSeq;
        this.headOrDiffractSeq = phase.headOrDiffractSeq;
        this.segmentList = phase.segmentList;
        this.legAction = phase.legAction;
        this.downGoing = phase.downGoing;
        this.waveType = phase.waveType;
        this.minDistance = phase.minDistance;
        this.maxDistance = phase.maxDistance;
        this.dist = phase.dist;
        this.time = phase.time;
        this.rayParams = phase.rayParams;
    }

    public SimpleSeismicPhase(String name, TauModel tMod, double receiverDepth, ArrayList<String> legs, String puristName, double[] rayParams, double[] time, double[] dist, double minRayParam, double maxRayParam, int minRayParamIndex, int maxRayParamIndex, double minDistance, double maxDistance, List<Integer> branchSeq, List<Integer> headOrDiffractSeq, List<SeismicPhaseSegment> segmentList, List<PhaseInteraction> legAction, List<Boolean> downGoing, List<Boolean> waveType, boolean debug) throws TauModelException {
        this.DEBUG = debug;
        this.name = name;
        this.tMod = tMod;
        this.puristName = puristName;
        this.sourceDepth = tMod.getSourceDepth();
        this.receiverDepth = receiverDepth;
        this.legs = legs;
        this.rayParams = rayParams;
        this.time = time;
        this.dist = dist;
        this.minRayParam = minRayParam;
        this.maxRayParam = maxRayParam;
        this.minRayParamIndex = minRayParamIndex;
        this.maxRayParamIndex = maxRayParamIndex;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.branchSeq = branchSeq;
        this.headOrDiffractSeq = headOrDiffractSeq;
        this.segmentList = segmentList;
        this.legAction = legAction;
        this.downGoing = downGoing;
        this.waveType = waveType;
    }

    @Override
    public boolean phasesExistsInModel() {
        return this.getMaxRayParam() >= 0.0;
    }

    @Override
    public Arrival getEarliestArrival(double degrees) {
        return Arrival.getEarliestArrival(this.calcTime(degrees));
    }

    @Override
    public TauModel getTauModel() {
        return this.tMod;
    }

    @Override
    public double getMinDistanceDeg() {
        return this.getMinDistance() * 180.0 / Math.PI;
    }

    @Override
    public double getMinDistance() {
        return this.minDistance;
    }

    @Override
    public double getMaxDistanceDeg() {
        return this.getMaxDistance() * 180.0 / Math.PI;
    }

    @Override
    public double getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public double getMaxRayParam() {
        return this.maxRayParam;
    }

    @Override
    public double getMinRayParam() {
        return this.minRayParam;
    }

    @Override
    public int getMaxRayParamIndex() {
        return this.maxRayParamIndex;
    }

    @Override
    public int getMinRayParamIndex() {
        return this.minRayParamIndex;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPuristName() {
        return this.puristName;
    }

    @Override
    public double getSourceDepth() {
        return this.sourceDepth;
    }

    @Override
    public double getReceiverDepth() {
        return this.receiverDepth;
    }

    @Override
    public List<String> getLegs() {
        return Collections.unmodifiableList(this.legs);
    }

    @Override
    public List<SeismicPhaseSegment> getPhaseSegments() {
        return Collections.unmodifiableList(this.segmentList);
    }

    @Override
    public double getRayParams(int i) {
        return this.rayParams[i];
    }

    @Override
    public double[] getRayParams() {
        return (double[])this.rayParams.clone();
    }

    @Override
    public double getDist(int i) {
        return this.dist[i];
    }

    @Override
    public double[] getDist() {
        return (double[])this.dist.clone();
    }

    @Override
    public double getTime(int i) {
        return this.time[i];
    }

    @Override
    public double[] getTime() {
        return (double[])this.time.clone();
    }

    @Override
    public double getTau(int i) {
        return this.time[i] - this.rayParams[i] * this.dist[i];
    }

    @Override
    public double[] getTau() {
        double[] tau = new double[this.dist.length];
        for (int i = 0; i < this.dist.length; ++i) {
            tau[i] = this.time[i] - this.rayParams[i] * this.dist[i];
        }
        return tau;
    }

    @Override
    public boolean[] getDownGoing() {
        Boolean[] b = this.downGoing.toArray(new Boolean[0]);
        boolean[] out = new boolean[b.length];
        for (int i = 0; i < b.length; ++i) {
            out[i] = b[i];
        }
        return out;
    }

    @Override
    public boolean[] getWaveType() {
        Boolean[] b = this.waveType.toArray(new Boolean[0]);
        boolean[] out = new boolean[b.length];
        for (int i = 0; i < b.length; ++i) {
            out[i] = b[i];
        }
        return out;
    }

    @Override
    public int[] getLegAction() {
        Integer[] b = this.legAction.toArray(new Integer[0]);
        int[] out = new int[b.length];
        for (int i = 0; i < b.length; ++i) {
            out[i] = b[i];
        }
        return out;
    }

    @Override
    public boolean hasArrivals() {
        return this.dist != null && this.dist.length != 0;
    }

    @Override
    public List<Arrival> calcTime(double deg) {
        double deltaTempLongWay;
        double deltaTemp;
        double tempDeg = SeismicPhase.distanceTrim180(deg);
        if (TauP_Tool.DEBUG) {
            System.out.println("Calculation distance: " + tempDeg + " deg");
        }
        int trimDistIsPos = (deltaTemp = Math.abs((deg - tempDeg + 180.0) % 360.0 - 180.0)) < (deltaTempLongWay = Math.abs((360.0 - deg - tempDeg + 180.0) % 360.0 - 180.0)) ? 1 : -1;
        double radDist = tempDeg * Math.PI / 180.0;
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        int n = 0;
        while ((double)n * 2.0 * Math.PI + radDist <= this.maxDistance) {
            double searchDist = (double)n * 2.0 * Math.PI + radDist;
            List<Arrival> forwardArrivals = this.calcTimeExactDistance(searchDist);
            for (Arrival a : forwardArrivals) {
                a.setSearchDistDeg(deg);
            }
            arrivals.addAll(forwardArrivals);
            searchDist = (double)(n + 1) * 2.0 * Math.PI - radDist;
            if (tempDeg != 180.0 && radDist != 0.0 && searchDist <= this.maxDistance) {
                List<Arrival> backwardsArrivals = this.calcTimeExactDistance(searchDist);
                for (Arrival a : backwardsArrivals) {
                    a.setSearchDistDeg(deg);
                }
                arrivals.addAll(backwardsArrivals);
            }
            ++n;
        }
        Collections.sort(arrivals, new Comparator<Arrival>(){

            @Override
            public int compare(Arrival o1, Arrival o2) {
                return Double.compare(o1.getTime(), o2.getTime());
            }
        });
        return arrivals;
    }

    @Override
    public List<Arrival> calcTimeExactDistanceDeg(double deg) {
        List<Arrival> arrivals = this.calcTimeExactDistance(deg * (Math.PI / 180));
        for (Arrival a : arrivals) {
            a.setSearchDistDeg(deg);
        }
        return arrivals;
    }

    public List<Arrival> calcTimeExactDistance(double searchDist) {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (int rayNum = 0; rayNum < this.dist.length - 1; ++rayNum) {
            if (searchDist == this.dist[rayNum + 1] && rayNum + 1 != this.dist.length - 1 || !((this.dist[rayNum] - searchDist) * (searchDist - this.dist[rayNum + 1]) >= 0.0) || this.rayParams[rayNum] == this.rayParams[rayNum + 1] && this.rayParams.length > 2) continue;
            if (this.DEBUG) {
                System.err.println("SeismicPhase " + this.name + ", found arrival:\ndist " + (float)(57.29577951308232 * this.dist[rayNum]) + " " + (float)(57.29577951308232 * searchDist) + " " + (float)(57.29577951308232 * this.dist[rayNum + 1]));
                System.err.println("time " + this.time[rayNum] + " --  " + this.time[rayNum + 1]);
            }
            arrivals.add(this.refineArrival(rayNum, searchDist, this.refineDistToleranceRadian, this.maxRecursion));
        }
        return arrivals;
    }

    @Override
    public Arrival createArrivalAtIndex(int rayNum) {
        boolean adjacentRayNum = false;
        double dRPdDist = 0.0;
        if (this.rayParams.length > 1) {
            dRPdDist = rayNum == 0 ? (this.getRayParams(rayNum) - this.getRayParams(rayNum + 1)) / (this.getDist(rayNum) - this.getDist(rayNum + 1)) : (rayNum == this.rayParams.length - 1 ? (this.getRayParams(rayNum) - this.getRayParams(rayNum - 1)) / (this.getDist(rayNum) - this.getDist(rayNum - 1)) : ((this.getRayParams(rayNum) - this.getRayParams(rayNum - 1)) / (this.getDist(rayNum) - this.getDist(rayNum - 1)) + (this.getRayParams(rayNum) - this.getRayParams(rayNum + 1)) / (this.getDist(rayNum) - this.getDist(rayNum + 1))) / 2.0);
        }
        return new Arrival(this, this.getTime(rayNum), this.getDist(rayNum), this.getRayParams(rayNum), rayNum, dRPdDist);
    }

    public Arrival refineArrival(int rayNum, double distRadian, double distTolRadian, int maxRecursion) {
        Arrival left = this.createArrivalAtIndex(rayNum);
        Arrival right = this.createArrivalAtIndex(rayNum + 1);
        return this.refineArrival(left, right, distRadian, distTolRadian, maxRecursion);
    }

    public Arrival refineArrival(Arrival leftEstimate, Arrival rightEstimate, double searchDist, double distTolRadian, int maxRecursion) {
        Arrival linInterp = this.linearInterpArrival(searchDist, leftEstimate, rightEstimate);
        if (maxRecursion <= 0 || this.headOrDiffractSeq.size() > 0 || this.name.endsWith("kmps")) {
            return linInterp;
        }
        if (linInterp.getRayParam() == leftEstimate.getRayParam()) {
            return leftEstimate;
        }
        if (linInterp.getRayParam() == rightEstimate.getRayParam()) {
            return rightEstimate;
        }
        if (this.DEBUG) {
            System.err.println("Phase: " + this);
            System.err.println("Refine: " + maxRecursion + "\nleft:  " + leftEstimate + "\nright: " + rightEstimate + "\nlinInterp: " + linInterp);
        }
        if (leftEstimate.getRayParam() < this.minRayParam || this.maxRayParam < leftEstimate.getRayParam()) {
            throw new RuntimeException("Left Ray param " + leftEstimate.getRayParam() + " is outside range for this phase: " + this.getName() + " min=" + this.minRayParam + " max=" + this.maxRayParam);
        }
        if (rightEstimate.getRayParam() < this.minRayParam || this.maxRayParam < rightEstimate.getRayParam()) {
            throw new RuntimeException("Right Ray param " + rightEstimate.getRayParam() + " is outside range for this phase: " + this.getName() + " min=" + this.minRayParam + " max=" + this.maxRayParam);
        }
        try {
            Arrival shoot = this.shootRay(linInterp.getRayParam());
            if ((leftEstimate.getDist() - searchDist) * (searchDist - shoot.getDist()) > 0.0) {
                if (Math.abs(shoot.getDist() - linInterp.getDist()) < distTolRadian) {
                    return this.linearInterpArrival(searchDist, leftEstimate, shoot);
                }
                return this.refineArrival(leftEstimate, shoot, searchDist, distTolRadian, maxRecursion - 1);
            }
            if (Math.abs(shoot.getDist() - linInterp.getDist()) < distTolRadian) {
                return this.linearInterpArrival(searchDist, shoot, rightEstimate);
            }
            return this.refineArrival(shoot, rightEstimate, searchDist, distTolRadian, maxRecursion - 1);
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen: " + this.getName(), e);
        }
        catch (SlownessModelException e) {
            throw new RuntimeException("Should not happen: " + this.getName(), e);
        }
    }

    @Override
    public Arrival shootRay(double rayParam) throws SlownessModelException, NoSuchLayerException {
        if (this.headOrDiffractSeq.size() > 0) {
            throw new SlownessModelException("Unable to shoot ray in non-body, head, diffracted waves");
        }
        if (rayParam < this.minRayParam || this.maxRayParam < rayParam) {
            throw new SlownessModelException("Ray param " + rayParam + " is outside range for this phase: " + this.getName() + " min=" + this.minRayParam + " max=" + this.maxRayParam);
        }
        int rayParamIndex = -1;
        for (rayParamIndex = 0; rayParamIndex < this.rayParams.length - 1 && this.rayParams[rayParamIndex + 1] >= rayParam; ++rayParamIndex) {
        }
        int[][] timesBranches = SeismicPhaseFactory.calcBranchMultiplier(this.tMod, this.branchSeq, this.waveType);
        TimeDist sum = new TimeDist(rayParam);
        for (int j = 0; j < this.tMod.getNumBranches(); ++j) {
            TimeDist td;
            int botLayerNum;
            int topLayerNum;
            if (timesBranches[0][j] != 0) {
                topLayerNum = this.tMod.getSlownessModel().layerNumberBelow(this.tMod.getTauBranch(j, true).getTopDepth(), true);
                botLayerNum = this.tMod.getSlownessModel().layerNumberAbove(this.tMod.getTauBranch(j, true).getBotDepth(), true);
                td = this.tMod.getTauBranch(j, true).calcTimeDist(this.tMod.getSlownessModel(), topLayerNum, botLayerNum, rayParam, true);
                td = new TimeDist(rayParam, (double)timesBranches[0][j] * td.getTime(), (double)timesBranches[0][j] * td.getDistRadian(), td.getDepth());
                sum = sum.add(td);
            }
            if (timesBranches[1][j] == 0) continue;
            topLayerNum = this.tMod.getSlownessModel().layerNumberBelow(this.tMod.getTauBranch(j, false).getTopDepth(), false);
            botLayerNum = this.tMod.getSlownessModel().layerNumberAbove(this.tMod.getTauBranch(j, false).getBotDepth(), false);
            td = this.tMod.getTauBranch(j, false).calcTimeDist(this.tMod.getSlownessModel(), topLayerNum, botLayerNum, rayParam, true);
            td = new TimeDist(rayParam, (double)timesBranches[1][j] * td.getTime(), (double)timesBranches[1][j] * td.getDistRadian(), td.getDepth());
            sum = sum.add(td);
        }
        double dRPdDist = (rayParam - this.rayParams[rayParamIndex]) / (sum.getDistRadian() - this.dist[rayParamIndex]);
        return new Arrival(this, sum.getTime(), sum.getDistRadian(), rayParam, rayParamIndex, dRPdDist);
    }

    private Arrival linearInterpArrival(double searchDist, Arrival left, Arrival right) {
        double dRPdDist;
        double arrivalTime;
        if (left.getDist() == searchDist) {
            return left;
        }
        if (right.getDist() == searchDist) {
            return right;
        }
        double arrivalRayParam = (searchDist - right.getDist()) * (left.getRayParam() - right.getRayParam()) / (left.getDist() - right.getDist()) + right.getRayParam();
        if (Math.abs(searchDist - left.getDist()) < Math.abs(searchDist - right.getDist())) {
            arrivalTime = left.getTime() + arrivalRayParam * (searchDist - left.getDist());
            dRPdDist = (left.getRayParam() - arrivalRayParam) / (left.getDist() - searchDist);
        } else {
            arrivalTime = right.getTime() + arrivalRayParam * (searchDist - right.getDist());
            dRPdDist = (right.getRayParam() - arrivalRayParam) / (right.getDist() - searchDist);
        }
        if (Double.isNaN(arrivalTime)) {
            throw new RuntimeException("Time is NaN, search " + searchDist + " leftDist " + left.getDist() + " leftTime " + left.getTime() + "  rightDist " + right.getDist() + "  rightTime " + right.getTime());
        }
        return new Arrival(this, arrivalTime, searchDist, arrivalRayParam, left.getRayParamIndex(), dRPdDist);
    }

    @Override
    public double calcRayParamForTakeoffAngle(double takeoffDegree) {
        VelocityModel vMod = this.getTauModel().getVelocityModel();
        try {
            double takeoffVelocity = this.getDownGoing()[0] ? vMod.evaluateBelow(this.sourceDepth, this.name.charAt(0)) : vMod.evaluateAbove(this.sourceDepth, this.name.charAt(0));
            double rayParam = (this.getTauModel().getRadiusOfEarth() - this.sourceDepth) * Math.sin(takeoffDegree * Math.PI / 180.0) / takeoffVelocity;
            return rayParam;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    @Override
    public double velocityAtSource() {
        try {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            char firstLeg = this.segmentList.get((int)0).isPWave ? (char)'P' : 'S';
            double takeoffVelocity = this.getDownGoing()[0] ? vMod.evaluateBelow(this.sourceDepth, firstLeg) : vMod.evaluateAbove(this.sourceDepth, firstLeg);
            return takeoffVelocity;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    @Override
    public double velocityAtReceiver() {
        try {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            char lastLeg = this.segmentList.get((int)(this.segmentList.size() - 1)).isPWave ? (char)'P' : 'S';
            double incidentVelocity = this.getDownGoing()[this.getDownGoing().length - 1] ? vMod.evaluateAbove(this.receiverDepth, lastLeg) : vMod.evaluateBelow(this.receiverDepth, lastLeg);
            return incidentVelocity;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    @Override
    public double densityAtReceiver() {
        try {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            double rho = this.getDownGoing()[this.getDownGoing().length - 1] ? vMod.evaluateAbove(this.receiverDepth, 'D') : vMod.evaluateBelow(this.receiverDepth, 'D');
            return rho;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
        catch (NoSuchMatPropException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    @Override
    public double calcTakeoffAngle(double arrivalRayParam) {
        if (this.name.endsWith("kmps")) {
            return 0.0;
        }
        double takeoffAngle = 57.29577951308232 * Math.asin(this.velocityAtSource() * arrivalRayParam / (this.getTauModel().getRadiusOfEarth() - this.sourceDepth));
        if (!Double.isFinite(takeoffAngle) && Math.abs(this.velocityAtSource() * arrivalRayParam - (this.getTauModel().getRadiusOfEarth() - this.sourceDepth)) < 0.05) {
            takeoffAngle = 90.0;
        }
        if (!this.getDownGoing()[0]) {
            takeoffAngle = 180.0 - takeoffAngle;
        }
        return takeoffAngle;
    }

    @Override
    public double calcIncidentAngle(double arrivalRayParam) {
        if (this.name.endsWith("kmps")) {
            return 0.0;
        }
        double incidentAngle = 57.29577951308232 * Math.asin(this.velocityAtReceiver() * arrivalRayParam / (this.getTauModel().getRadiusOfEarth() - this.receiverDepth));
        if (!Double.isFinite(incidentAngle) && Math.abs(this.velocityAtSource() * arrivalRayParam - (this.getTauModel().getRadiusOfEarth() - this.receiverDepth)) < 0.05) {
            incidentAngle = 90.0;
        }
        if (this.getDownGoing()[this.getDownGoing().length - 1]) {
            incidentAngle = 180.0 - incidentAngle;
        }
        return incidentAngle;
    }

    @Deprecated
    public List<Arrival> calcPierce(double deg) throws TauModelException {
        List<Arrival> arrivals = this.calcTime(deg);
        for (Arrival a : arrivals) {
            a.getPierce();
        }
        return arrivals;
    }

    @Deprecated
    public Arrival calcPierce(Arrival currArrival) {
        currArrival.getPierce();
        return currArrival;
    }

    @Override
    public List<TimeDist> calcPierceTimeDist(Arrival currArrival) {
        double distRatio;
        double distB;
        double distA;
        double distRayParam;
        double branchDist = 0.0;
        double branchTime = 0.0;
        double prevBranchTime = 0.0;
        ArrayList<TimeDist> pierce = new ArrayList<TimeDist>();
        int rayNum = 0;
        int i = 0;
        while (i < this.tMod.rayParams.length - 1 && this.tMod.rayParams[i] >= currArrival.getRayParam()) {
            rayNum = i++;
        }
        double negMulDist = 1.0;
        if (currArrival.isLongWayAround()) {
            negMulDist = -1.0;
        }
        if (currArrival.getRayParamIndex() == this.rayParams.length - 1) {
            distRayParam = this.rayParams[currArrival.getRayParamIndex()];
            distA = this.dist[currArrival.getRayParamIndex()];
            distB = this.dist[currArrival.getRayParamIndex()];
            distRatio = 1.0;
        } else {
            double rayParamA = this.rayParams[currArrival.getRayParamIndex()];
            double rayParamB = this.rayParams[currArrival.getRayParamIndex() + 1];
            distA = this.dist[currArrival.getRayParamIndex()];
            distB = this.dist[currArrival.getRayParamIndex() + 1];
            distRatio = (currArrival.getDist() - distA) / (distB - distA);
            distRayParam = distRatio * (rayParamB - rayParamA) + rayParamA;
        }
        pierce.add(new TimeDist(distRayParam, 0.0, 0.0, this.tMod.getSourceDepth()));
        for (int i2 = 0; i2 < this.branchSeq.size(); ++i2) {
            double timeB;
            double timeA;
            double turnDepth;
            int branchNum = this.branchSeq.get(i2);
            boolean isPWave = this.waveType.get(i2);
            if (this.DEBUG) {
                System.out.println(i2 + " branchNum =" + branchNum + " downGoing=" + this.downGoing.get(i2) + "  isPWave=" + isPWave);
            }
            try {
                turnDepth = distRayParam > this.tMod.getTauBranch(branchNum, isPWave).getMaxRayParam() ? this.tMod.getTauBranch(branchNum, isPWave).getTopDepth() : (distRayParam <= this.tMod.getTauBranch(branchNum, isPWave).getMinRayParam() ? this.tMod.getTauBranch(branchNum, isPWave).getBotDepth() : (isPWave || this.tMod.getSlownessModel().depthInFluid((this.tMod.getTauBranch(branchNum, isPWave).getTopDepth() + this.tMod.getTauBranch(branchNum, isPWave).getBotDepth()) / 2.0) ? this.tMod.getSlownessModel().findDepth(distRayParam, this.tMod.getTauBranch(branchNum, isPWave).getTopDepth(), this.tMod.getTauBranch(branchNum, isPWave).getBotDepth(), true) : this.tMod.getSlownessModel().findDepth(distRayParam, this.tMod.getTauBranch(branchNum, isPWave).getTopDepth(), this.tMod.getTauBranch(branchNum, isPWave).getBotDepth(), isPWave)));
            }
            catch (SlownessModelException e) {
                throw new RuntimeException("SeismicPhase.calcPierce: Caught SlownessModelException. ", e);
            }
            if (this.headOrDiffractSeq.size() > 0) {
                distA = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                timeA = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
                distB = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                timeB = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
            } else {
                distA = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum);
                timeA = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum];
                distB = this.tMod.getTauBranch(branchNum, isPWave).getDist(rayNum + 1);
                timeB = this.tMod.getTauBranch((int)branchNum, (boolean)isPWave).time[rayNum + 1];
            }
            branchDist += distRatio * (distB - distA) + distA;
            prevBranchTime = branchTime;
            branchTime += distRatio * (timeB - timeA) + timeA;
            double branchDepth = this.downGoing.get(i2) != false ? Math.min(this.tMod.getTauBranch(branchNum, isPWave).getBotDepth(), turnDepth) : Math.min(this.tMod.getTauBranch(branchNum, isPWave).getTopDepth(), turnDepth);
            if (Math.abs(prevBranchTime - branchTime) > 1.0E-10) {
                pierce.add(new TimeDist(distRayParam, branchTime, negMulDist * branchDist, branchDepth));
                if (this.DEBUG) {
                    System.out.println("------->  add pierce " + branchDepth);
                    System.out.println(" branchTime=" + branchTime + " branchDist=" + branchDist + " branchDepth=" + branchDepth);
                    System.out.println("incrementTime = " + distRatio * (timeB - timeA) + " timeB=" + timeB + " timeA=" + timeA);
                }
            } else if (this.DEBUG) {
                System.out.println("Time inc in branch tiny:  branchTime=" + branchTime + " branchDist=" + branchDist + " branchDepth=" + branchDepth);
            }
            for (int diffBranchIdx = 0; diffBranchIdx < this.headOrDiffractSeq.size(); ++diffBranchIdx) {
                int diffBranchNum = this.headOrDiffractSeq.get(diffBranchIdx);
                if (this.DEBUG) {
                    System.out.println("diff check: " + diffBranchNum + " " + i2 + " branchNum =" + branchNum + " downGoing=" + this.downGoing.get(i2) + "  isPWave=" + isPWave);
                }
                if (i2 != diffBranchNum) continue;
                double refractDist = (currArrival.getDist() - this.dist[0]) / (double)this.headOrDiffractSeq.size();
                double refractTime = refractDist * currArrival.getRayParam();
                pierce.add(new TimeDist(distRayParam, branchTime + refractTime, negMulDist * (branchDist + refractDist), branchDepth));
                branchDist += refractDist;
                prevBranchTime = branchTime;
                branchTime += refractTime;
            }
        }
        if (this.name.indexOf("kmps") != -1) {
            this.headOrDiffractSeq.add(0);
            pierce.add(new TimeDist(distRayParam, currArrival.getTime(), negMulDist * currArrival.getDist(), 0.0));
        }
        return pierce;
    }

    @Deprecated
    public List<Arrival> calcPath(double deg) {
        List<Arrival> arrivals = this.calcTime(deg);
        for (Arrival a : arrivals) {
            a.getPath();
        }
        return arrivals;
    }

    @Deprecated
    public Arrival calcPath(Arrival currArrival) {
        currArrival.getPath();
        return currArrival;
    }

    @Override
    public double calcReflTran(Arrival arrival) throws VelocityModelException, SlownessModelException {
        double reflTranValue = 1.0;
        boolean isAllS = true;
        for (SeismicPhaseSegment seg : this.segmentList) {
            isAllS = isAllS && !seg.isPWave;
        }
        SeismicPhaseSegment prevSeg = this.segmentList.get(0);
        for (SeismicPhaseSegment seg : this.segmentList.subList(1, this.segmentList.size())) {
            reflTranValue *= prevSeg.calcReflTran(arrival, seg.isPWave, isAllS);
            prevSeg = seg;
        }
        return reflTranValue *= prevSeg.calcReflTran(arrival, prevSeg.isPWave, isAllS);
    }

    @Override
    public List<TimeDist> calcPathTimeDist(Arrival currArrival) {
        List<List<TimeDist>> segmentPaths = this.calcSegmentPaths(currArrival);
        List<TimeDist> outPath = new ArrayList<TimeDist>();
        for (List<TimeDist> tdList : segmentPaths) {
            for (TimeDist td : tdList) {
                if (currArrival.isLongWayAround()) {
                    outPath.add(td.negateDistance());
                    continue;
                }
                outPath.add(td);
            }
        }
        if (outPath.size() == 0) {
            System.err.println("Calc Path is zero length:  " + currArrival);
        }
        outPath = SimpleSeismicPhase.removeDuplicatePathPoints(outPath);
        return SimpleSeismicPhase.adjustPath(outPath, currArrival);
    }

    public List<List<TimeDist>> calcSegmentPaths(Arrival currArrival) {
        ArrayList<List<TimeDist>> segmentPaths = new ArrayList<List<TimeDist>>();
        TimeDist prevEnd = null;
        for (SeismicPhaseSegment seg : this.segmentList) {
            List<TimeDist> segPath = seg.calcPathTimeDist(currArrival, prevEnd);
            if (segPath.size() == 0) {
                System.err.println("segPath.size() is 0 " + seg);
                continue;
            }
            segmentPaths.add(segPath);
            prevEnd = segPath.get(segPath.size() - 1);
        }
        return segmentPaths;
    }

    public static List<TimeDist> removeDuplicatePathPoints(List<TimeDist> inPath) {
        ArrayList<TimeDist> outPath = new ArrayList<TimeDist>();
        if (inPath.size() != 0) {
            TimeDist prev = inPath.get(0);
            outPath.add(prev);
            for (TimeDist td : inPath) {
                if (td.equals(prev)) continue;
                outPath.add(td);
                prev = td;
            }
        }
        return outPath;
    }

    public static List<TimeDist> adjustPath(List<TimeDist> inPath, Arrival arrival) {
        double distRadian = arrival.getDist();
        double finalPathDist = inPath.get(inPath.size() - 1).getDistRadian();
        if (inPath.size() != 0 && distRadian != 0.0 && finalPathDist != 0.0) {
            double shifty = distRadian / finalPathDist;
            if (arrival.isLongWayAround()) {
                shifty *= -1.0;
            }
            if (Math.abs(1.0 - shifty) > 0.02) {
                System.err.println("Path error is greater than 2%, correction may cause errors. " + shifty + " " + arrival);
                System.err.println("  " + distRadian + " " + finalPathDist + "  " + arrival.isLongWayAround());
            }
            ArrayList<TimeDist> out = new ArrayList<TimeDist>();
            for (TimeDist td : inPath) {
                out.add(new TimeDist(td.getP(), td.getTime(), td.getDistRadian() * shifty, td.getDepth()));
            }
            return out;
        }
        return inPath;
    }

    @Override
    public String describe() {
        String desc = this.name + ":\n";
        return desc + SeismicPhase.baseDescribe(this) + "\n" + SeismicPhase.segmentDescribe(this);
    }

    @Override
    public String describeJson() {
        String Q = "\"";
        String COMMA = ",";
        String QCOMMA = Q + COMMA;
        String COLON = ": ";
        String S = "  ";
        String QC = Q + COLON;
        String QCQ = QC + Q;
        String SS = S + S;
        String SQ = S + Q;
        String SSQ = S + SQ;
        String SSSQ = S + SSQ;
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        out.println("{");
        out.println(SQ + "name" + QCQ + this.getName() + QCOMMA);
        out.println(SeismicPhase.baseDescribeJSON(this));
        out.println(",");
        out.println(SeismicPhase.segmentDescribeJSON(this));
        out.println("}");
        return sw.toString();
    }

    @Override
    public String toString() {
        int i;
        String desc = this.name + ": ";
        for (i = 0; i < this.legs.size(); ++i) {
            desc = desc + this.legs.get(i) + " ";
        }
        desc = desc + "\n";
        for (i = 0; i < this.branchSeq.size(); ++i) {
            desc = desc + this.branchSeq.get(i) + " ";
        }
        desc = desc + "\n";
        desc = desc + "minRayParam=" + this.minRayParam + " maxRayParam=" + this.maxRayParam;
        desc = desc + "\n";
        desc = desc + "minDistance=" + this.minDistance * 180.0 / Math.PI + " maxDistance=" + this.maxDistance * 180.0 / Math.PI;
        return desc;
    }

    @Override
    public void dump() {
        for (int j = 0; j < this.dist.length; ++j) {
            System.out.println(j + "  " + this.dist[j] + "  " + this.rayParams[j]);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 3) {
                System.out.println("Usage: SimpleSeismicPhase modelfile depth phasename [phasename ...]");
            }
            TauModel tMod = TauModel.readModel(args[0]);
            TauModel tModDepth = tMod.depthCorrect(Double.valueOf(args[1]));
            for (int i = 2; i < args.length; ++i) {
                System.out.println("-----");
                SimpleSeismicPhase sp = SeismicPhaseFactory.createPhase(args[i], tModDepth);
                System.out.println(sp);
                sp.dump();
            }
            System.out.println("-----");
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (OptionalDataException e) {
            System.out.println(e.getMessage());
        }
        catch (StreamCorruptedException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (TauModelException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

